/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.swing;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.ui.toolkit.ShadowFactory;
import com.lightcrafts.utils.LCMS;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public final class ColorSwatch
extends JComponent {
    private static LCMS.Transform ts = new LCMS.Transform(new LCMS.Profile(JAIContext.linearProfile), LCMS.TYPE_RGB_8, new LCMS.Profile(JAIContext.systemProfile), LCMS.TYPE_RGB_8, 0, 0);
    private Color m_color;
    private static final Dimension PREFERRED_SIZE = new Dimension(35, 35);

    public ColorSwatch(Color color) {
        this.m_color = color;
        this.setFocusable(false);
    }

    public Color getColor() {
        return this.m_color;
    }

    @Override
    public Dimension getMinimumSize() {
        return (Dimension)PREFERRED_SIZE.clone();
    }

    @Override
    public Dimension getMaximumSize() {
        return (Dimension)PREFERRED_SIZE.clone();
    }

    @Override
    public Dimension getPreferredSize() {
        return (Dimension)PREFERRED_SIZE.clone();
    }

    public void setColor(Color color) {
        this.m_color = color;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Dimension size = this.getSize();
        byte[] systemColor = new byte[3];
        ts.doTransform(new byte[]{(byte)this.m_color.getRed(), (byte)this.m_color.getGreen(), (byte)this.m_color.getBlue()}, systemColor);
        BufferedImage image = new BufferedImage(size.width - 6, size.height - 6, 1);
        Graphics g = image.getGraphics();
        g.setColor(new Color(0xFF & systemColor[0], 0xFF & systemColor[1], 0xFF & systemColor[2]));
        g.fillRect(0, 0, size.width - 6, size.height - 6);
        g.dispose();
        ShadowFactory shadow = new ShadowFactory(3, 1.0f, Color.gray);
        shadow.setRenderingHint("blur_quality", "high");
        BufferedImage shadowImage = shadow.createShadow(image);
        g = shadowImage.getGraphics();
        g.drawImage(image, 3, 2, null);
        g.dispose();
        graphics.drawImage(shadowImage, 0, 0, null);
        graphics.setColor(Color.DARK_GRAY);
        graphics.drawRect(3, 2, size.width - 6, size.height - 6);
    }
}

