/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.swing;

import com.lightcrafts.ui.swing.CommonRangeSelectorTrack;
import com.lightcrafts.ui.swing.RangeSelector;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class RangeSelectorColorGradientTrack
extends CommonRangeSelectorTrack
implements RangeSelector.Track {
    private static final float BRIGHTNESS_MAX = 1.0f;
    private static final float BRIGHTNESS_MIN = 0.3f;
    private static final float BRIGHTNESS_MID = 0.65f;

    @Override
    public void paintTrack(RangeSelector selector, Rectangle r, Graphics2D g2d) {
        int w = r.width - 2;
        int y1 = r.y + 1;
        int y2 = r.y + r.height - 1;
        int lfvx = selector.getLowerThumbFeatheringValueX();
        int lvx = selector.getLowerThumbValueX();
        int uvx = selector.getUpperThumbValueX();
        int ufvx = selector.getUpperThumbFeatheringValueX();
        int offset = selector.getTrackValue();
        float o = (float)offset / (float)selector.getMaximumTrackValue();
        for (int dx = 0; dx < w; ++dx) {
            int x = r.x + 1 + dx;
            float h = (float)dx / (float)w - o;
            float b = x > lvx && x < uvx ? 1.0f : (x < lfvx || x > ufvx ? 0.3f : 0.65f);
            g2d.setColor(Color.getHSBColor(h, 1.0f, b));
            g2d.drawLine(x, y1, x, y2);
        }
        RangeSelectorColorGradientTrack.paintBorder(r, g2d);
    }
}

