/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.templates;

import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.operation.OpControl;
import com.lightcrafts.ui.templates.TemplateCellRenderer;
import com.lightcrafts.ui.templates.TemplateNamespaceTreeNode;
import com.lightcrafts.ui.templates.TemplateRootNode;
import com.lightcrafts.ui.templates.TemplateTreeNode;
import com.lightcrafts.ui.templates.TemplateTreePopup;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TemplateTree
extends JTree {
    private static Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/templates");
    private static String ExpandedKey = "TemplateNamespaceExpanded";
    private Editor editor;
    private TemplateTreePopup popup;
    private TemplateTreeNode selected;

    public TemplateTree(TemplateRootNode root) {
        super(root);
        this.setSelectionModel(JTree.EmptySelectionModel.sharedInstance());
        this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.setEnabled(false);
        this.setFocusable(false);
        this.setRootVisible(false);
        this.setCellRenderer(new TemplateCellRenderer());
        this.initExpandedStates();
        this.addExpansionListener();
        this.addSingleClickListener();
    }

    public TemplateTree(TemplateRootNode root, Editor editor) {
        super(root);
        this.editor = editor;
        this.setSelectionModel(JTree.EmptySelectionModel.sharedInstance());
        this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.popup = new TemplateTreePopup(this);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.handlePopup(event);
                } else {
                    Object last;
                    TreePath path = TemplateTree.this.getPathForLocation(event.getX(), event.getY());
                    if (path != null && (last = path.getLastPathComponent()) instanceof TemplateTreeNode) {
                        TemplateTreeNode node = (TemplateTreeNode)last;
                        boolean hadFocus = TemplateTree.this.isFocusOwner();
                        TemplateTree.this.setTemplate(node);
                        if (hadFocus) {
                            TemplateTree.this.requestFocusInWindow();
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.handlePopup(event);
                }
            }

            private void handlePopup(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    Point p = event.getPoint();
                    TreePath path = TemplateTree.this.getClosestPathForLocation(p.x, p.y);
                    if (path != null) {
                        Object last = path.getLastPathComponent();
                        TemplateKey key = null;
                        if (last instanceof TemplateTreeNode) {
                            TemplateTreeNode node = (TemplateTreeNode)last;
                            key = node.key;
                        }
                        TemplateTree.this.popup.show(p, key);
                    }
                }
            }
        });
        this.setFocusable(false);
        this.setRootVisible(false);
        this.setCellRenderer(new TemplateCellRenderer());
        this.initExpandedStates();
        this.addExpansionListener();
        this.addSingleClickListener();
    }

    void setNamespace(String namespace) {
        TreeNode root = (TreeNode)this.getModel().getRoot();
        Enumeration<? extends TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            TemplateNamespaceTreeNode child = (TemplateNamespaceTreeNode)e.nextElement();
            String ns = child.toString();
            if (!ns.equals(namespace)) continue;
            TreePath path = new TreePath(new Object[]{root, child});
            this.setExpandedState(path, true);
        }
    }

    private void setTemplate(TemplateTreeNode template) {
        List<OpControl> controls;
        if (this.selected != null && (controls = this.selected.opControls) != null) {
            this.editor.removeControls(controls);
        }
        if (template != null) {
            this.selected = template;
            XmlNode node = template.node;
            try {
                this.selected.opControls = this.editor.addControls(node);
            }
            catch (Throwable t) {
                System.err.println("Could not apply template \"" + template.key + "\"");
                t.printStackTrace();
            }
        } else {
            this.selected = null;
        }
    }

    void commitSelection() {
        if (this.selected != null) {
            this.selected.opControls = null;
        }
    }

    TemplateKey getSelectedTemplateKey() {
        if (this.selected != null) {
            return this.selected.key;
        }
        return null;
    }

    private void initExpandedStates() {
        TreeNode root = (TreeNode)this.getModel().getRoot();
        Enumeration<? extends TreeNode> e = root.children();
        while (e.hasMoreElements()) {
            TreeNode node = e.nextElement();
            String namespace = node.toString();
            if (!Prefs.getBoolean(ExpandedKey + namespace, true)) continue;
            TreePath path = new TreePath(new Object[]{root, node});
            this.setExpandedState(path, true);
        }
    }

    private void addExpansionListener() {
        this.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                this.setPreference(event, true);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                this.setPreference(event, false);
            }

            void setPreference(TreeExpansionEvent event, boolean expanded) {
                TreePath path = event.getPath();
                if (path.getPathCount() == 2) {
                    Object node = path.getLastPathComponent();
                    String namespace = node.toString();
                    Prefs.putBoolean(ExpandedKey + namespace, expanded);
                }
            }
        });
    }

    private void addSingleClickListener() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Point p = event.getPoint();
                TreePath path = TemplateTree.this.getPathForLocation(p.x, p.y);
                if (path != null) {
                    TreeNode node = (TreeNode)path.getLastPathComponent();
                    if (!node.isLeaf()) {
                        if (TemplateTree.this.isExpanded(path)) {
                            TemplateTree.this.collapsePath(path);
                        } else {
                            TemplateTree.this.expandPath(path);
                        }
                    } else {
                        TemplateTree.this.commitSelection();
                    }
                }
            }
        });
    }
}

