/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.templates;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.templates.TemplateDatabase;
import com.lightcrafts.templates.TemplateKey;
import com.lightcrafts.ui.templates.Locale;
import com.lightcrafts.ui.templates.TemplateTree;
import com.lightcrafts.utils.file.FileUtil;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class TemplateTreePopup
extends JPopupMenu {
    private TemplateTree tree;
    private TemplateKey key;

    TemplateTreePopup(TemplateTree tree) {
        this.tree = tree;
        JMenuItem item = new JMenuItem(Locale.LOCALE.get("ShowMenuItem"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (TemplateTreePopup.this.key != null) {
                    Platform platform = Platform.getPlatform();
                    File file = TemplateTreePopup.this.key.getFile();
                    file = FileUtil.resolveAliasFile(file);
                    String path = file.getAbsolutePath();
                    platform.showFileInFolder(path);
                }
            }
        });
        this.add(item);
        item = new JMenuItem(Locale.LOCALE.get("DeleteMenuItem"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (TemplateTreePopup.this.key != null) {
                    try {
                        TemplateDatabase.removeTemplateDocument(TemplateTreePopup.this.key);
                    }
                    catch (TemplateDatabase.TemplateException e) {
                        System.out.println("Couldn't delete Template " + TemplateTreePopup.this.key);
                        e.printStackTrace();
                    }
                }
            }
        });
        this.add(item);
        this.addSeparator();
        item = new JMenuItem(Locale.LOCALE.get("RestoreMenuItem"));
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TemplateDatabase.deployFactoryTemplates();
            }
        });
        this.add(item);
    }

    void show(Point p, TemplateKey key) {
        this.key = key;
        this.show(this.tree, p.x, p.y);
    }
}

