/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit;

import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.layout.ToggleTitleBorder;
import java.awt.Font;
import javax.swing.Box;
import javax.swing.JComponent;

public class BoxedButton {
    private static final Font font = LightZoneSkin.fontSet.getTitleFont();
    public final Box box;
    public final JComponent[] buttons;

    public BoxedButton(String title, JComponent ... buttons) {
        this.buttons = buttons;
        this.box = Box.createHorizontalBox();
        int buttonWidth = 0;
        for (JComponent b : buttons) {
            buttonWidth += b.getWidth();
        }
        int titleWidth = this.box.getFontMetrics(font).stringWidth(title);
        int sideMargin = Math.max(0, (titleWidth - buttonWidth) / 2);
        this.box.add(Box.createHorizontalStrut(sideMargin));
        for (JComponent b : buttons) {
            this.box.add(b);
        }
        this.box.add(Box.createHorizontalStrut(sideMargin));
        ToggleTitleBorder.setBorder(this.box, title);
    }
}

