/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit;

import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.operator.AffineDescriptor;
import com.lightcrafts.mediax.jai.operator.BandMergeDescriptor;
import com.lightcrafts.mediax.jai.operator.BandSelectDescriptor;
import com.lightcrafts.mediax.jai.operator.InvertDescriptor;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class IconFactory {
    public static int StandardSize = 18;

    public static Icon createIcon(Class clazz, String name) {
        return IconFactory.createIcon(clazz, name, StandardSize);
    }

    public static Icon createIcon(Class clazz, String name, int size) {
        try {
            URL url = clazz.getResource("resources/" + name);
            BufferedImage image = ImageIO.read(url);
            image = IconFactory.getScaledImage(image, size);
            return new ImageIcon(image);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Couldn't read icon resource \"" + name + "\" " + "for class " + clazz.getName());
        }
    }

    public static Icon createInvertedIcon(Class clazz, String name) {
        return IconFactory.createInvertedIcon(clazz, name, StandardSize);
    }

    public static Icon createInvertedIcon(Class clazz, String name, int size) {
        Icon icon = IconFactory.createIcon(clazz, name, size);
        if (icon != null) {
            icon = IconFactory.invertIcon(icon);
        }
        return icon;
    }

    public static Icon invertIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        BufferedImage image = new BufferedImage(width, height, 6);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        image = IconFactory.invertImageWithAlpha(image);
        return new ImageIcon(image);
    }

    private static BufferedImage invertImageWithAlpha(BufferedImage image) {
        RenderedOp alpha = BandSelectDescriptor.create((RenderedImage)image, (int[])new int[]{3}, null);
        RenderedOp colors = BandSelectDescriptor.create((RenderedImage)image, (int[])new int[]{0, 1, 2}, null);
        colors = InvertDescriptor.create((RenderedImage)colors, null);
        RenderedOp op = BandMergeDescriptor.create((RenderedImage)colors, (RenderedImage)alpha, null);
        return op.getAsBufferedImage();
    }

    public static BufferedImage getScaledImage(BufferedImage image, int limit) {
        int maxSize = Math.max(image.getWidth(), image.getHeight());
        if (maxSize > limit) {
            double scale = (float)limit / (float)maxSize;
            AffineTransform transform = AffineTransform.getScaleInstance(scale, scale);
            RenderingHints extenderHint = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            Interpolation interp = Interpolation.getInstance((int)1);
            image = AffineDescriptor.create((RenderedImage)image, (AffineTransform)transform, (Interpolation)interp, null, (RenderingHints)extenderHint).getAsBufferedImage();
        }
        return image;
    }
}

