/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.toolkit.journal;

import com.lightcrafts.ui.toolkit.TextAreaFactory;
import com.lightcrafts.ui.toolkit.journal.InputEventJournal;
import com.lightcrafts.ui.toolkit.journal.JournalListener;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class JournalDialog
extends JDialog
implements JournalListener {
    private static InputEventJournal Journal = InputEventJournal.Instance;
    private static JournalDialog Instance = new JournalDialog();
    private static JFrame Owner;
    private JTextArea text;
    private JButton save;
    private JButton load;
    private JButton replay;
    private JButton print;
    private JLabel counter;
    private JTextField name;
    private JLabel status;
    private File file;

    private JournalDialog() {
        this.setTitle("Input Event Journal");
        JPanel panel = new JPanel(new BorderLayout());
        this.setContentPane(panel);
        Box content = Box.createVerticalBox();
        content.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        panel.add(content);
        this.text = this.createTextArea();
        content.add(this.text);
        content.add(Box.createVerticalStrut(8));
        this.replay = this.createReplayButton();
        this.print = this.createPrintButton();
        this.save = this.createSaveButton();
        this.load = this.createLoadButton();
        Box buttons = Box.createHorizontalBox();
        buttons.add(Box.createHorizontalGlue());
        buttons.add(this.replay);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(this.print);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(this.save);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(this.load);
        buttons.add(Box.createHorizontalGlue());
        content.add(buttons);
        content.add(Box.createVerticalStrut(8));
        this.name = this.createName();
        Box nameBox = Box.createHorizontalBox();
        nameBox.add(new JLabel("File:"));
        nameBox.add(Box.createHorizontalStrut(3));
        nameBox.add(this.name);
        content.add(nameBox);
        content.add(Box.createVerticalStrut(8));
        this.counter = this.createCounter();
        this.status = this.createStatus();
        Box readout = Box.createHorizontalBox();
        readout.add(this.status);
        readout.add(Box.createHorizontalGlue());
        readout.add(this.counter);
        content.add(readout);
        try {
            this.setFile(File.createTempFile("LZJournal", ".xml"));
            this.file.deleteOnExit();
        }
        catch (IOException e) {
            System.err.println("Couldn't create journal temp file: " + e.getMessage());
        }
        this.setStatus("Stopped");
        this.setCounter(0);
        this.pack();
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent event) {
                Journal.start();
            }

            @Override
            public void windowClosed(WindowEvent event) {
                Journal.stop();
            }
        });
        Journal.addJournalListener(this);
    }

    @Override
    public void journalStarted(boolean replaying) {
        if (replaying) {
            this.setStatus("Replaying");
        } else {
            this.setStatus("Recording");
        }
        this.setCounter(0);
    }

    @Override
    public void journalEvent(int count, boolean replaying) {
        this.setCounter(count);
    }

    @Override
    public void journalEnded(boolean replaying) {
        this.setStatus("Stopped");
        try {
            FileOutputStream out = new FileOutputStream(this.file);
            Journal.write(out);
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            System.err.println("Error writing journal: " + e.getMessage());
        }
    }

    public static void showJournalDialog(JFrame owner) {
        if (Instance.isVisible()) {
            return;
        }
        Owner = owner;
        Instance.setVisible(true);
    }

    private JTextArea createTextArea() {
        JTextArea text = TextAreaFactory.createTextArea("How to use:\n\n    1. Focus the frame you want to record.\n    2. Press \"\\\" to start recording.\n    3. Do your thing.\n    4. Press \"\\\" again to end recording.\n    5. Come back here to replay and save your work.", 35);
        text.setBackground(this.getContentPane().getBackground());
        return text;
    }

    private JButton createSaveButton() {
        JButton save = new JButton("Save");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser chooser = new JFileChooser();
                int result = chooser.showSaveDialog(Instance);
                if (result == 0) {
                    try {
                        JournalDialog.this.setFile(chooser.getSelectedFile());
                        FileOutputStream out = new FileOutputStream(JournalDialog.this.file);
                        Journal.write(out);
                        ((OutputStream)out).close();
                    }
                    catch (IOException e) {
                        System.err.println(e.getMessage());
                    }
                }
            }
        });
        return save;
    }

    private JButton createLoadButton() {
        JButton save = new JButton("Load");
        save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JFileChooser chooser = new JFileChooser();
                int result = chooser.showOpenDialog(Instance);
                if (result == 0) {
                    try {
                        Journal.clear();
                        File file = chooser.getSelectedFile();
                        FileInputStream in = new FileInputStream(file);
                        Journal.read(in);
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        System.err.println(e.getMessage());
                    }
                }
            }
        });
        return save;
    }

    private JButton createReplayButton() {
        JButton replay = new JButton("Replay");
        replay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Owner.toFront();
                Journal.replay(Owner);
            }
        });
        return replay;
    }

    private JButton createPrintButton() {
        JButton print = new JButton("Print");
        print.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    Journal.write(System.out);
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        return print;
    }

    private JLabel createCounter() {
        JLabel counter = new JLabel("Events: 000000");
        counter.setHorizontalAlignment(4);
        Dimension size = counter.getPreferredSize();
        counter.setMinimumSize(size);
        counter.setPreferredSize(size);
        counter.setMaximumSize(size);
        return counter;
    }

    private JLabel createStatus() {
        return new JLabel();
    }

    private JTextField createName() {
        JTextField name = new JTextField(20);
        name.setEditable(false);
        return name;
    }

    private void setCounter(int count) {
        this.counter.setText(Integer.toString(count) + " Events");
    }

    private void setStatus(String text) {
        this.status.setText(text);
    }

    private void setFile(File file) {
        this.file = file;
        this.name.setText(file.getAbsolutePath());
    }
}

