/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.utils.ColorScience;

public class ColorMatrix {
    public static final double RLUM = ColorScience.Wr;
    public static final double GLUM = ColorScience.Wg;
    public static final double BLUM = ColorScience.Wb;

    static void matrixmult(double[][] a, double[][] b, double[][] c) {
        int j;
        int i;
        double[][] temp = new double[4][4];
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                for (int k = 0; k < 4; ++k) {
                    double[] dArray = temp[i];
                    int n = j;
                    dArray[n] = dArray[n] + b[i][k] * a[k][j];
                }
            }
        }
        for (i = 0; i < 4; ++i) {
            for (j = 0; j < 4; ++j) {
                c[i][j] = temp[i][j];
            }
        }
    }

    public static void lummat(double[][] mat) {
        double[][] mmat = new double[][]{{RLUM, RLUM, RLUM, 0.0}, {GLUM, GLUM, GLUM, 0.0}, {BLUM, BLUM, BLUM, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        ColorMatrix.matrixmult(mmat, mat, mat);
    }

    public static void offsetmat(double[][] mat, double roffset, double goffset, double boffset) {
        double[][] mmat = new double[][]{{1.0, 0.0, 0.0, roffset}, {0.0, 1.0, 0.0, goffset}, {0.0, 0.0, 1.0, boffset}, {0.0, 0.0, 0.0, 1.0}};
        ColorMatrix.matrixmult(mmat, mat, mat);
    }

    static double[] xformpnt(double[][] matrix, double x, double y, double z) {
        double[] result = new double[]{x * matrix[0][0] + y * matrix[1][0] + z * matrix[2][0] + matrix[3][0], x * matrix[0][1] + y * matrix[1][1] + z * matrix[2][1] + matrix[3][1], x * matrix[0][2] + y * matrix[1][2] + z * matrix[2][2] + matrix[3][2]};
        return result;
    }

    static void xrotatemat(double[][] mat, double rs, double rc) {
        double[][] mmat = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, rc, rs, 0.0}, {0.0, -rs, rc, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        ColorMatrix.matrixmult(mmat, mat, mat);
    }

    static void yrotatemat(double[][] mat, double rs, double rc) {
        double[][] mmat = new double[][]{{rc, 0.0, -rs, 0.0}, {0.0, 1.0, 0.0, 0.0}, {rs, 0.0, rc, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        ColorMatrix.matrixmult(mmat, mat, mat);
    }

    static void zrotatemat(double[][] mat, double rs, double rc) {
        double[][] mmat = new double[][]{{rc, rs, 0.0, 0.0}, {-rs, rc, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        ColorMatrix.matrixmult(mmat, mat, mat);
    }

    static void zshearmat(double[][] mat, double dx, double dy) {
        double[][] mmat = new double[][]{{1.0, 0.0, dx, 0.0}, {0.0, 1.0, dy, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        ColorMatrix.matrixmult(mmat, mat, mat);
    }

    public static void huerotatemat(double[][] mat, double rot) {
        double[][] mmat = new double[][]{{1.0, 0.0, 0.0, 0.0}, {0.0, 1.0, 0.0, 0.0}, {0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        double mag = Math.sqrt(2.0);
        double xrs = 1.0 / mag;
        double xrc = 1.0 / mag;
        ColorMatrix.xrotatemat(mmat, xrs, xrc);
        mag = Math.sqrt(3.0);
        double yrs = -1.0 / mag;
        double yrc = Math.sqrt(2.0) / mag;
        ColorMatrix.yrotatemat(mmat, yrs, yrc);
        double[] l = new double[3];
        l = ColorMatrix.xformpnt(mmat, RLUM, GLUM, BLUM);
        double zsx = l[0] / l[2];
        double zsy = l[1] / l[2];
        ColorMatrix.zshearmat(mmat, zsx, zsy);
        double zrs = Math.sin(rot * Math.PI / 180.0);
        double zrc = Math.cos(rot * Math.PI / 180.0);
        ColorMatrix.zrotatemat(mmat, zrs, zrc);
        ColorMatrix.zshearmat(mmat, -zsx, -zsy);
        ColorMatrix.yrotatemat(mmat, -yrs, yrc);
        ColorMatrix.xrotatemat(mmat, -xrs, xrc);
        ColorMatrix.matrixmult(mmat, mat, mat);
    }

    public static void saturatemat(double[][] mat, double sat) {
        double[][] mmat = new double[][]{{(1.0 - sat) * RLUM + sat, (1.0 - sat) * RLUM, (1.0 - sat) * RLUM, 0.0}, {(1.0 - sat) * GLUM, (1.0 - sat) * GLUM + sat, (1.0 - sat) * GLUM, 0.0}, {(1.0 - sat) * BLUM, (1.0 - sat) * BLUM, (1.0 - sat) * BLUM + sat, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        ColorMatrix.matrixmult(mmat, mat, mat);
    }

    public static void cscalemat(double[][] mat, double rscale, double gscale, double bscale) {
        double[][] mmat = new double[][]{{rscale, 0.0, 0.0, 0.0}, {0.0, gscale, 0.0, 0.0}, {0.0, 0.0, bscale, 0.0}, {0.0, 0.0, 0.0, 1.0}};
        ColorMatrix.matrixmult(mmat, mat, mat);
    }
}

