/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.libs.LCJPEGReader;
import com.lightcrafts.image.libs.LCTIFFReader;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.providers.ApertureProvider;
import com.lightcrafts.image.metadata.providers.CaptureDateTimeProvider;
import com.lightcrafts.image.metadata.providers.FocalLengthProvider;
import com.lightcrafts.image.metadata.providers.ISOProvider;
import com.lightcrafts.image.metadata.providers.MakeModelProvider;
import com.lightcrafts.image.metadata.providers.ShutterSpeedProvider;
import com.lightcrafts.image.metadata.providers.WidthHeightProvider;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.utils.ForkDaemon;
import com.lightcrafts.utils.LRUHashMap;
import com.lightcrafts.utils.LightCraftsException;
import com.lightcrafts.utils.bytebuffer.ByteBufferUtil;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public final class DCRaw
implements ApertureProvider,
CaptureDateTimeProvider,
FocalLengthProvider,
ISOProvider,
MakeModelProvider,
ShutterSpeedProvider,
WidthHeightProvider {
    private static Map<String, DCRaw> dcrawCache = new LRUHashMap<String, DCRaw>(100);
    private static final String FILENAME = "Filename: ";
    private static final String TIMESTAMP = "Timestamp: ";
    private static final String CAMERA = "Camera: ";
    private static final String ISO = "ISO speed: ";
    private static final String SHUTTER = "Shutter: ";
    private static final String APERTURE = "Aperture: ";
    private static final String FOCAL_LENGTH = "Focal Length: ";
    private static final String NUM_RAW_IMAGES = "Number of raw images: ";
    private static final String EMBEDDED_ICC_PROFILE = "Embedded ICC profile: ";
    private static final String CANNOT_DECODE = "Cannot decode file";
    private static final String THUMB_SIZE = "Thumb size: ";
    private static final String FULL_SIZE = "Full size: ";
    private static final String IMAGE_SIZE = "Image size: ";
    private static final String OUTPUT_SIZE = "Output size: ";
    private static final String RAW_COLORS = "Raw colors: ";
    private static final String FILTER_PATTERN = "Filter pattern: ";
    private static final String DAYLIGHT_MULTIPLIERS = "Daylight multipliers: ";
    private static final String CAMERA_MULTIPLIERS = "Camera multipliers: ";
    private static final String CAMERA_RGB_PROFILE = "Camera RGB Profile: ";
    private static final String CAMERA_XYZ_PROFILE = "Camera XYZ Profile: ";
    private static final String DCRAW_NAME = "dcraw_lz";
    private static String DCRAW_PATH = System.getProperty("java.library.path") + File.separatorChar + "dcraw_lz";
    private static final String DCRAW_OUTPUT = "Writing data to ";
    private int m_error;
    private boolean m_decodable = true;
    private final String m_fileName;
    private String m_make;
    private String m_model;
    private long m_captureDateTime;
    private int m_width;
    private int m_height;
    private int m_fullWidth;
    private int m_fullHeight;
    private int m_thumbWidth;
    private int m_thumbHeight;
    private int m_rawWidth;
    private int m_rawHeight;
    private float m_shutterSpeed;
    private float m_aperture;
    private float m_focalLength;
    private int m_iso;
    private int m_filters;
    private int m_rawColors;
    private float[] m_cam_mul = new float[4];
    private float[] m_pre_mul = new float[4];
    private float[] m_rgb_cam;
    private float[] m_xyz_cam;
    private float[] m_secondary_cam_mul = new float[4];
    private static final String[] four_color_cameras;

    public static synchronized DCRaw getInstanceFor(String fileName) {
        DCRaw instance = dcrawCache.get(fileName);
        if (instance == null) {
            instance = new DCRaw(fileName);
            dcrawCache.put(fileName, instance);
        }
        return instance;
    }

    private DCRaw(String fileName) {
        this.m_fileName = fileName;
        try {
            this.runDCRawInfo(false);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public float getAperture() {
        return this.m_aperture;
    }

    @Override
    public String getCameraMake(boolean includeModel) {
        String make = this.getMake();
        String model = this.getModel();
        if (make == null || model == null) {
            return null;
        }
        make = make.toUpperCase();
        if (!includeModel) {
            return make;
        }
        return MetadataUtil.undupMakeModel(make, model.toUpperCase());
    }

    public float[] getCameraMultipliers() {
        return (float[])this.m_cam_mul.clone();
    }

    public float[] getSecondaryCameraMultipliers() {
        return (float[])this.m_secondary_cam_mul.clone();
    }

    public float[][] getCameraRGB() {
        if (this.m_rgb_cam == null) {
            return null;
        }
        return new float[][]{{this.m_rgb_cam[0], this.m_rgb_cam[1], this.m_rgb_cam[2]}, {this.m_rgb_cam[3], this.m_rgb_cam[4], this.m_rgb_cam[5]}, {this.m_rgb_cam[6], this.m_rgb_cam[7], this.m_rgb_cam[8]}};
    }

    public float[][] getCameraXYZ() {
        if (this.m_xyz_cam == null) {
            return null;
        }
        return new float[][]{{this.m_xyz_cam[0], this.m_xyz_cam[1], this.m_xyz_cam[2]}, {this.m_xyz_cam[3], this.m_xyz_cam[4], this.m_xyz_cam[5]}, {this.m_xyz_cam[6], this.m_xyz_cam[7], this.m_xyz_cam[8]}};
    }

    @Override
    public Date getCaptureDateTime() {
        return this.m_captureDateTime > 0L ? new Date(this.m_captureDateTime * 1000L) : null;
    }

    public float[] getDaylightMultipliers() {
        return (float[])this.m_pre_mul.clone();
    }

    @Override
    public float getFocalLength() {
        return this.m_focalLength;
    }

    @Override
    public int getImageHeight() {
        return this.m_height;
    }

    @Override
    public int getImageWidth() {
        return this.m_width;
    }

    public int getFullHeight() {
        return this.m_fullHeight;
    }

    public int getFullWidth() {
        return this.m_fullWidth;
    }

    public int getRawHeight() {
        return this.m_rawHeight;
    }

    public int getRawWidth() {
        return this.m_rawWidth;
    }

    public int getThumbHeight() {
        return this.m_thumbHeight;
    }

    public int getThumbWidth() {
        return this.m_thumbWidth;
    }

    @Override
    public int getISO() {
        return this.m_iso;
    }

    public String getMake() {
        return this.m_make;
    }

    public String getModel() {
        return this.m_model;
    }

    private static String readln(InputStream s) {
        try {
            int c;
            StringBuffer sb = new StringBuffer();
            while ((c = s.read()) > 0 && c != 255 && (c == 10 || c == 13)) {
            }
            while (c > 0 && c != 255 && c != 10 && c != 13) {
                sb.append((char)c);
                c = s.read();
            }
            if ((c == -1 || c == 255) && sb.length() == 0) {
                return null;
            }
            return new String(sb);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String match(String s, String tag) {
        if (s.startsWith(tag)) {
            s = s.substring(tag.length());
            int index = 0;
            while (s.charAt(index) == ' ') {
                ++index;
            }
            if (index > 0) {
                s = s.substring(index);
            }
            return s;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDCRawInfo(boolean secondary) throws IOException {
        String[] info = new String[]{DCRAW_PATH, "-v", "-i", "-t", "0", this.m_fileName};
        String[] secondaryInfo = new String[]{DCRAW_PATH, "-v", "-i", "-s", "1", "-t", "0", this.m_fileName};
        Class<DCRaw> clazz = DCRaw.class;
        synchronized (DCRaw.class) {
            String line;
            InputStream dcrawStdErr;
            InputStream dcrawStdOut;
            Process p = null;
            if (ForkDaemon.INSTANCE != null) {
                ForkDaemon.INSTANCE.invoke(secondary ? secondaryInfo : info);
                dcrawStdOut = ForkDaemon.INSTANCE.getStdOut();
                dcrawStdErr = ForkDaemon.INSTANCE.getStdErr();
            } else {
                p = Runtime.getRuntime().exec(secondary ? secondaryInfo : info);
                dcrawStdOut = p.getInputStream();
                dcrawStdErr = new BufferedInputStream(p.getErrorStream());
            }
            while ((line = DCRaw.readln(dcrawStdOut)) != null) {
                String[] sizes;
                String[] multipliers;
                String search;
                if (secondary) {
                    search = CAMERA_MULTIPLIERS;
                    if (!line.startsWith(CAMERA_MULTIPLIERS)) continue;
                    multipliers = line.substring(search.length()).split("\\s");
                    this.m_secondary_cam_mul[0] = Float.parseFloat(multipliers[0]);
                    this.m_secondary_cam_mul[1] = Float.parseFloat(multipliers[1]);
                    this.m_secondary_cam_mul[2] = Float.parseFloat(multipliers[2]);
                    this.m_secondary_cam_mul[3] = Float.parseFloat(multipliers[3]);
                    continue;
                }
                search = TIMESTAMP;
                if (line.startsWith(TIMESTAMP)) {
                    String timestamp = line.substring(search.length());
                    try {
                        this.m_captureDateTime = new SimpleDateFormat().parse(timestamp).getTime();
                    }
                    catch (ParseException e) {
                        this.m_captureDateTime = 0L;
                    }
                    continue;
                }
                search = CAMERA;
                if (line.startsWith(CAMERA)) {
                    String camera = line.substring(search.length());
                    this.m_make = camera.substring(0, camera.indexOf(32));
                    this.m_model = camera.substring(this.m_make.length() + 1);
                    continue;
                }
                search = ISO;
                if (line.startsWith(ISO)) {
                    String iso = line.substring(search.length());
                    this.m_iso = Integer.decode(iso);
                    continue;
                }
                search = SHUTTER;
                if (line.startsWith(SHUTTER)) {
                    String shutterSpeed = line.substring(search.length() + 2);
                    float exposureTime = 0.0f;
                    try {
                        exposureTime = Float.valueOf(shutterSpeed.substring(0, shutterSpeed.indexOf(" sec"))).floatValue();
                        if (exposureTime == 0.0f) continue;
                        this.m_shutterSpeed = 1.0f / exposureTime;
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                search = APERTURE;
                if (line.startsWith(APERTURE)) {
                    String aperture = line.substring(search.length() + 2);
                    try {
                        this.m_aperture = Float.valueOf(aperture).floatValue();
                    }
                    catch (NumberFormatException exposureTime) {}
                    continue;
                }
                search = FOCAL_LENGTH;
                if (line.startsWith(FOCAL_LENGTH)) {
                    String focalLenght = line.substring(search.length());
                    try {
                        this.m_focalLength = Float.valueOf(focalLenght.substring(0, focalLenght.indexOf(" mm"))).floatValue();
                    }
                    catch (NumberFormatException exposureTime) {}
                    continue;
                }
                if (line.startsWith(CANNOT_DECODE)) {
                    this.m_decodable = false;
                    continue;
                }
                String args = DCRaw.match(line, THUMB_SIZE);
                if (args != null) {
                    sizes = args.split(" x ");
                    this.m_thumbWidth = Integer.decode(sizes[0]);
                    this.m_thumbHeight = Integer.decode(sizes[1]);
                    continue;
                }
                args = DCRaw.match(line, FULL_SIZE);
                if (args != null) {
                    sizes = args.split(" x ");
                    this.m_fullWidth = Integer.decode(sizes[0]);
                    this.m_fullHeight = Integer.decode(sizes[1]);
                    continue;
                }
                args = DCRaw.match(line, IMAGE_SIZE);
                if (args != null) {
                    sizes = args.split(" x ");
                    this.m_rawWidth = Integer.decode(sizes[0]);
                    this.m_rawHeight = Integer.decode(sizes[1]);
                    continue;
                }
                args = DCRaw.match(line, OUTPUT_SIZE);
                if (args != null) {
                    sizes = args.split(" x ");
                    this.m_width = Integer.decode(sizes[0]);
                    this.m_height = Integer.decode(sizes[1]);
                    continue;
                }
                search = RAW_COLORS;
                if (line.startsWith(RAW_COLORS)) {
                    String rawColors = line.substring(search.length());
                    this.m_rawColors = Integer.decode(rawColors);
                    continue;
                }
                search = FILTER_PATTERN;
                if (line.startsWith(FILTER_PATTERN)) {
                    String pattern = line.substring(search.length());
                    if (pattern.length() >= 8 && !pattern.substring(0, 4).equals(pattern.substring(4, 8))) {
                        this.m_filters = -1;
                        continue;
                    }
                    if (pattern.startsWith("BG/GR")) {
                        this.m_filters = 0x16161616;
                        continue;
                    }
                    if (pattern.startsWith("GR/BG")) {
                        this.m_filters = 0x61616161;
                        continue;
                    }
                    if (pattern.startsWith("GB/RG")) {
                        this.m_filters = 0x49494949;
                        continue;
                    }
                    if (pattern.startsWith("RG/GB")) {
                        this.m_filters = -1802201964;
                        continue;
                    }
                    this.m_filters = -1;
                    continue;
                }
                search = DAYLIGHT_MULTIPLIERS;
                if (line.startsWith(DAYLIGHT_MULTIPLIERS)) {
                    multipliers = line.substring(search.length()).split("\\s");
                    this.m_pre_mul[0] = Float.parseFloat(multipliers[0]);
                    this.m_pre_mul[1] = Float.parseFloat(multipliers[1]);
                    this.m_pre_mul[2] = Float.parseFloat(multipliers[2]);
                    this.m_pre_mul[3] = this.m_pre_mul[1];
                    continue;
                }
                search = CAMERA_MULTIPLIERS;
                if (line.startsWith(CAMERA_MULTIPLIERS)) {
                    multipliers = line.substring(search.length()).split("\\s");
                    this.m_cam_mul[0] = Float.parseFloat(multipliers[0]);
                    this.m_cam_mul[1] = Float.parseFloat(multipliers[1]);
                    this.m_cam_mul[2] = Float.parseFloat(multipliers[2]);
                    this.m_cam_mul[3] = Float.parseFloat(multipliers[3]);
                    continue;
                }
                if (line.startsWith(CAMERA_RGB_PROFILE)) {
                    String[] rgb_cam = line.substring(CAMERA_RGB_PROFILE.length()).split("\\s");
                    this.m_rgb_cam = new float[9];
                    for (int i = 0; i < 9; ++i) {
                        this.m_rgb_cam[i] = Float.parseFloat(rgb_cam[i]);
                    }
                    continue;
                }
                if (!line.startsWith(CAMERA_XYZ_PROFILE)) continue;
                String[] xyz_cam = line.substring(CAMERA_XYZ_PROFILE.length()).split("\\s");
                this.m_xyz_cam = new float[9];
                for (int i = 0; i < 9; ++i) {
                    this.m_xyz_cam[i] = Float.parseFloat(xyz_cam[i]);
                }
            }
            while ((line = DCRaw.readln(dcrawStdErr)) != null) {
            }
            if (p != null) {
                dcrawStdOut.close();
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.m_error = p.exitValue();
                p.destroy();
            } else {
                this.m_error = 0;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static ImageData readPPM(File file) throws IOException, BadImageFileException {
        ImageData imageData;
        FileInputStream s = new FileInputStream(file);
        try {
            int dataType;
            int height;
            int width;
            int bands;
            String S1 = DCRaw.readln(s);
            if (S1.equals("P5") || S1.equals("P6")) {
                bands = S1.equals("P5") ? 1 : 3;
                String S2 = DCRaw.readln(s);
                String S3 = DCRaw.readln(s);
                String[] dimensions = S2.split("\\s");
                width = Integer.parseInt(dimensions[0]);
                height = Integer.parseInt(dimensions[1]);
                dataType = S3.equals("255") ? 0 : 1;
                imageData = new ImageData(width, height, bands, dataType);
            } else if (S1.equals("P7")) {
                String WIDTH = "WIDTH ";
                String HEIGHT = "HEIGHT ";
                String DEPTH = "DEPTH ";
                String MAXVAL = "MAXVAL ";
                String SWIDTH = DCRaw.readln(s);
                width = Integer.parseInt(SWIDTH.substring(WIDTH.length()));
                String SHEIGHT = DCRaw.readln(s);
                height = Integer.parseInt(SHEIGHT.substring(HEIGHT.length()));
                String SDEPTH = DCRaw.readln(s);
                bands = Integer.parseInt(SDEPTH.substring(DEPTH.length()));
                String SMAXVAL = DCRaw.readln(s);
                dataType = SMAXVAL.substring(MAXVAL.length()).equals("65535") ? 1 : 0;
                imageData = new ImageData(width, height, bands, dataType);
            } else {
                ImageData WIDTH = null;
                return WIDTH;
            }
            int totalData = width * height * bands * (dataType == 0 ? 1 : 2);
            FileChannel c = s.getChannel();
            if (file.length() != (long)totalData + c.position()) {
                c.close();
                throw new BadImageFileException(file);
            }
            MappedByteBuffer bb = c.map(FileChannel.MapMode.READ_ONLY, c.position(), totalData);
            if (dataType == 1) {
                bb.order(ByteOrder.nativeOrder());
                bb.asShortBuffer().get((short[])imageData.data);
                if (ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN) {
                    for (int i = 0; i < ((short[])imageData.data).length; ++i) {
                        ((short[])imageData.data)[i] = Short.reverseBytes(((short[])imageData.data)[i]);
                    }
                }
            } else {
                bb.get((byte[])imageData.data);
            }
            ByteBufferUtil.clean(bb);
            c.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadImageFileException(file, (Throwable)e);
        }
        finally {
            s.close();
        }
        return imageData;
    }

    public RenderedImage runDCRaw(dcrawMode mode) throws IOException, UnknownImageTypeException, BadImageFileException {
        return this.runDCRaw(mode, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized RenderedImage runDCRaw(dcrawMode mode, boolean secondaryPixels) throws IOException, UnknownImageTypeException, BadImageFileException {
        if (!this.m_decodable || mode == dcrawMode.full && this.m_rawColors != 3) {
            throw new UnknownImageTypeException("Unsuported Camera");
        }
        RenderedImage result = null;
        File of = null;
        try {
            String[] cmd;
            if (mode == dcrawMode.preview && this.m_thumbWidth >= 1024 && this.m_thumbHeight >= 768) {
                mode = dcrawMode.thumb;
            }
            long t1 = System.currentTimeMillis();
            of = File.createTempFile("LZRAWTMP", ".ppm");
            boolean four_colors = false;
            String makeModel = this.m_make + ' ' + this.m_model;
            for (String s : four_color_cameras) {
                if (!s.equalsIgnoreCase(makeModel)) continue;
                four_colors = true;
                break;
            }
            if (secondaryPixels) {
                this.runDCRawInfo(true);
            }
            switch (mode) {
                case full: {
                    if (four_colors) {
                        cmd = new String[]{DCRAW_PATH, "-F", of.getAbsolutePath(), "-v", "-f", "-H", "1", "-t", "0", "-o", "0", "-4", this.m_fileName};
                        break;
                    }
                    if (this.m_filters == -1 || this.m_make != null && this.m_make.equalsIgnoreCase("SIGMA")) {
                        cmd = new String[]{DCRAW_PATH, "-F", of.getAbsolutePath(), "-v", "-H", "1", "-t", "0", "-o", "0", "-4", this.m_fileName};
                        break;
                    }
                    if (secondaryPixels) {
                        cmd = new String[]{DCRAW_PATH, "-F", of.getAbsolutePath(), "-v", "-j", "-H", "1", "-t", "0", "-s", "1", "-d", "-4", this.m_fileName};
                        break;
                    }
                    cmd = new String[]{DCRAW_PATH, "-F", of.getAbsolutePath(), "-v", "-j", "-H", "1", "-t", "0", "-d", "-4", this.m_fileName};
                    break;
                }
                case preview: {
                    cmd = new String[]{DCRAW_PATH, "-F", of.getAbsolutePath(), "-v", "-t", "0", "-o", "1", "-w", "-h", this.m_fileName};
                    break;
                }
                case thumb: {
                    cmd = new String[]{DCRAW_PATH, "-F", of.getAbsolutePath(), "-v", "-e", this.m_fileName};
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown mode " + (Object)((Object)mode));
                }
            }
            String ofName = null;
            Class<DCRaw> i$ = DCRaw.class;
            synchronized (DCRaw.class) {
                int[] nArray;
                ColorModel cm;
                ImageData imageData;
                String line;
                InputStream dcrawStdOut;
                InputStream dcrawStdErr;
                Process p = null;
                if (ForkDaemon.INSTANCE != null) {
                    ForkDaemon.INSTANCE.invoke(cmd);
                    dcrawStdErr = ForkDaemon.INSTANCE.getStdErr();
                    dcrawStdOut = ForkDaemon.INSTANCE.getStdOut();
                } else {
                    p = Runtime.getRuntime().exec(cmd);
                    dcrawStdErr = new BufferedInputStream(p.getErrorStream());
                    dcrawStdOut = p.getInputStream();
                }
                while ((line = DCRaw.readln(dcrawStdErr)) != null) {
                    System.out.println(line);
                    String string = DCRaw.match(line, DCRAW_OUTPUT);
                    if (string == null) continue;
                    ofName = string.substring(0, string.indexOf(" ..."));
                }
                while ((line = DCRaw.readln(dcrawStdOut)) != null) {
                    System.out.println(line);
                }
                if (p != null) {
                    dcrawStdErr.close();
                    try {
                        p.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.m_error = p.exitValue();
                    p.destroy();
                } else {
                    this.m_error = 0;
                }
                // ** MonitorExit[i$] (shouldn't be in output)
                System.out.println("dcraw value: " + this.m_error);
                if (this.m_error > 0) {
                    of.delete();
                    throw new BadImageFileException(of);
                }
                if (ofName == null) {
                    ofName = of.getPath();
                    System.out.println("Cannot get output filename. Falling back to: " + ofName);
                } else if (!ofName.equals(of.getPath())) {
                    of.delete();
                    of = new File(ofName);
                }
                if (of.getName().endsWith(".jpg") || of.getName().endsWith(".tiff")) {
                    if (of.getName().endsWith(".jpg")) {
                        try {
                            LCJPEGReader jpegReader = new LCJPEGReader(of.getPath());
                            result = jpegReader.getImage();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        try {
                            LCTIFFReader tiffReader = new LCTIFFReader(of.getPath());
                            result = tiffReader.getImage(null);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    long t2 = System.currentTimeMillis();
                    int totalData = result.getWidth() * result.getHeight() * result.getColorModel().getNumColorComponents() * (result.getColorModel().getTransferType() == 0 ? 1 : 2);
                    System.out.println("Read " + totalData + " bytes in " + (t2 - t1) + "ms");
                    return result;
                }
                try {
                    imageData = DCRaw.readPPM(of);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new BadImageFileException(of, (Throwable)e);
                }
                long t2 = System.currentTimeMillis();
                int totalData = imageData.width * imageData.height * imageData.bands * (imageData.dataType == 0 ? 1 : 2);
                System.out.println("Read " + totalData + " bytes in " + (t2 - t1) + "ms");
                if (mode == dcrawMode.full) {
                    cm = imageData.bands == 1 ? new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 1) : JAIContext.colorModel_linear16;
                } else if (imageData.bands == 3) {
                    cm = new ComponentColorModel(JAIContext.sRGBColorSpace, false, false, 1, 0);
                } else {
                    if (imageData.bands != 4) throw new UnknownImageTypeException("Weird number of bands: " + imageData.bands);
                    cm = new ComponentColorModel(JAIContext.CMYKColorSpace, false, false, 1, imageData.dataType);
                }
                DataBuffer dataBuffer = imageData.dataType == 0 ? new DataBufferByte((byte[])imageData.data, imageData.bands * imageData.width * imageData.height) : new DataBufferUShort((short[])imageData.data, imageData.bands * imageData.width * imageData.height);
                int n = imageData.width;
                int n2 = imageData.height;
                int n3 = imageData.bands * imageData.width;
                int n4 = imageData.bands;
                if (imageData.bands == 3) {
                    int[] nArray2 = new int[3];
                    nArray2[0] = 0;
                    nArray2[1] = 1;
                    nArray = nArray2;
                    nArray2[2] = 2;
                } else {
                    int[] nArray3 = new int[1];
                    nArray = nArray3;
                    nArray3[0] = 0;
                }
                WritableRaster raster = Raster.createInterleavedRaster(dataBuffer, n, n2, n3, n4, nArray, null);
                result = new BufferedImage(cm, raster, false, null);
                return result;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (of != null) {
                of.delete();
            }
        }
    }

    public int getFilters() {
        return this.m_filters;
    }

    @Override
    public float getShutterSpeed() {
        return this.m_shutterSpeed;
    }

    public boolean decodable() {
        return this.m_decodable;
    }

    public int rawColors() {
        return this.m_rawColors;
    }

    public static native void interpolateGreen(short[] var0, short[] var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12);

    public static native void interpolateRedBlue(short[] var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    static {
        if (!new File(DCRAW_PATH).canExecute()) {
            String dir = System.getProperty("install4j.appDir");
            if (dir == null) {
                dir = ".";
            }
            DCRAW_PATH = dir + File.separatorChar + DCRAW_NAME;
        }
        four_color_cameras = new String[]{"OLYMPUS E-1", "OLYMPUS E-300", "OLYMPUS E-330", "OLYMPUS E-500", "OLYMPUS E-510", "OLYMPUS E-520", "OLYMPUS E-400", "OLYMPUS E-410", "OLYMPUS E-420", "OLYMPUS E-20,E-20N,E-20P", "OLYMPUS E-10", "Leica Camera AG M8 Digital Camera"};
    }

    public static enum dcrawMode {
        full,
        preview,
        thumb;

    }

    private static class ImageData {
        final int width;
        final int height;
        final int bands;
        final int dataType;
        final Object data;

        ImageData(int width, int height, int bands, int dataType) {
            this.width = width;
            this.height = height;
            this.bands = bands;
            this.dataType = dataType;
            this.data = dataType == 0 ? new byte[bands * width * height] : (byte[])new short[bands * width * height];
        }
    }

    public static final class DCRawException
    extends LightCraftsException {
        public final int code;

        DCRawException(int code) {
            super("DCRaw Error: " + code);
            this.code = code;
        }
    }
}

