/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.utils.Version;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ResourceBundle;

public class ErrorLogger {
    private static ResourceBundle Resources = ResourceBundle.getBundle("com/lightcrafts/utils/resources/ErrorLogger");
    private static URL LogUrl;

    public static void logError(Throwable t) {
        try {
            String message = ErrorLogger.createMessage(t);
            HttpURLConnection conn = ErrorLogger.connect(message);
            OutputStream out = conn.getOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter(out);
            writer.write(message);
            ((Writer)writer).close();
            conn.disconnect();
            int error = conn.getResponseCode();
            if (error != 200) {
                System.err.println("Error logging failed: " + conn.getResponseMessage());
            } else {
                System.err.println("Error logging successful");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void logError(final Throwable t, final Object monitor) {
        if (monitor == null) {
            ErrorLogger.logError(t);
        } else {
            Thread thread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ErrorLogger.logError(t);
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notifyAll();
                    }
                }
            }, "Error Logger");
            thread.setDaemon(true);
            thread.start();
        }
    }

    private static String createMessage(Throwable t) {
        try {
            StringWriter writer = new StringWriter();
            PrintWriter printer = new PrintWriter(writer);
            t.printStackTrace(printer);
            writer.close();
            String trace = writer.toString();
            StringBuffer buffer = new StringBuffer();
            ErrorLogger.appendVersion(buffer);
            ErrorLogger.appendOsEnvironment(buffer);
            ErrorLogger.appendJavaEnvironment(buffer);
            buffer.append("error=");
            buffer.append(trace);
            String message = buffer.toString();
            message = URLEncoder.encode(message, "UTF-8");
            return message;
        }
        catch (IOException e) {
            return "ErrorLogger: Couldn't construct message: " + e.getMessage();
        }
    }

    private static void appendVersion(StringBuffer buffer) {
        buffer.append("url=");
        buffer.append(Version.getUri());
        buffer.append("\n");
        buffer.append("revision=");
        buffer.append(Version.getRevisionNumber());
        buffer.append("\n");
    }

    private static void appendProperty(StringBuffer buffer, String prop) {
        String s = System.getProperty(prop);
        buffer.append(prop);
        buffer.append("=");
        buffer.append(s);
        buffer.append("\n");
    }

    private static void appendOsEnvironment(StringBuffer buffer) {
        ErrorLogger.appendProperty(buffer, "os.name");
        ErrorLogger.appendProperty(buffer, "os.arch");
        ErrorLogger.appendProperty(buffer, "os.version");
    }

    private static void appendJavaEnvironment(StringBuffer buffer) {
        ErrorLogger.appendProperty(buffer, "java.version");
        ErrorLogger.appendProperty(buffer, "java.vendor");
    }

    private static HttpURLConnection connect(String message) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)LogUrl.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        String length = String.valueOf(message.length());
        conn.setRequestProperty("Content-Length", length);
        return conn;
    }

    public static void main(String[] args) {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    Throwable t = new Throwable();
                    ErrorLogger.logError(t);
                }
            });
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            LogUrl = new URL(Resources.getString("LogUrl"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Misconfigured ErrorLogger URL");
        }
    }
}

