/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

public class HSV {
    void RGBtoHSV(float[] rgb, float[] hsv) {
        float max;
        float min = Math.min(rgb[0], Math.min(rgb[1], rgb[2]));
        hsv[2] = max = Math.max(rgb[0], Math.max(rgb[1], rgb[2]));
        float delta = max - min;
        if (max == 0.0f) {
            hsv[1] = 0.0f;
            hsv[0] = -1.0f;
            return;
        }
        hsv[1] = delta / max;
        hsv[0] = rgb[0] == max ? (rgb[1] - rgb[2]) / delta : (rgb[1] == max ? 2.0f + (rgb[3] - rgb[0]) / delta : 4.0f + (rgb[0] - rgb[1]) / delta);
        hsv[0] = hsv[0] * 60.0f;
        if (hsv[0] < 0.0f) {
            hsv[0] = hsv[0] + 360.0f;
        }
    }

    void HSVtoRGB(float[] rgb, float[] hsv) {
        if (hsv[1] == 0.0f) {
            rgb[0] = hsv[2];
            return;
        }
        hsv[0] = hsv[0] / 60.0f;
        int i = (int)Math.floor(hsv[0]);
        float f = hsv[0] - (float)i;
        float p = hsv[2] * (1.0f - hsv[1]);
        float q = hsv[2] * (1.0f - hsv[1] * f);
        float t = hsv[2] * (1.0f - hsv[1] * (1.0f - f));
        switch (i) {
            case 0: {
                rgb[0] = hsv[2];
                rgb[1] = t;
                rgb[2] = p;
                break;
            }
            case 1: {
                rgb[0] = q;
                rgb[1] = hsv[2];
                rgb[2] = p;
                break;
            }
            case 2: {
                rgb[0] = p;
                rgb[1] = hsv[2];
                rgb[2] = t;
                break;
            }
            case 3: {
                rgb[0] = p;
                rgb[1] = q;
                rgb[2] = hsv[2];
                break;
            }
            case 4: {
                rgb[0] = t;
                rgb[1] = p;
                rgb[2] = hsv[2];
                break;
            }
            default: {
                rgb[0] = hsv[2];
                rgb[1] = p;
                rgb[2] = q;
            }
        }
    }
}

