/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import java.lang.reflect.Array;

public final class LCArrays {
    public static void copy(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    public static native void copy(int[] var0, int var1, byte[] var2, int var3, int var4);

    public static native void copy(short[] var0, int var1, byte[] var2, int var3, int var4);

    public static native void copy(byte[] var0, int var1, int[] var2, int var3, int var4);

    public static native void copy(byte[] var0, int var1, short[] var2, int var3, int var4);

    public static Object resize(Object oldArray, int newLength) {
        Class<?> c = oldArray.getClass();
        if (!c.isArray()) {
            throw new IllegalArgumentException("given non-array");
        }
        int oldLength = Array.getLength(oldArray);
        if (oldLength == newLength) {
            return oldArray;
        }
        Class<?> type = c.getComponentType();
        Object newArray = Array.newInstance(type, newLength);
        int copyLength = Math.min(oldLength, newLength);
        if (copyLength > 0) {
            System.arraycopy(oldArray, 0, newArray, 0, copyLength);
        }
        return newArray;
    }

    static {
        System.loadLibrary("LCArrays");
    }
}

