/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.media.jai.util.ImageUtil;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import com.lightcrafts.utils.LCMSNative;
import com.lightcrafts.utils.LRUHashMap;
import java.awt.Point;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import javax.imageio.ImageIO;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.ShortInterleavedRaster;

public class LCMS {
    public static final int PT_ANY = 0;
    public static final int PT_GRAY = 3;
    public static final int PT_RGB = 4;
    public static final int PT_CMY = 5;
    public static final int PT_CMYK = 6;
    public static final int PT_YCbCr = 7;
    public static final int PT_YUV = 8;
    public static final int PT_XYZ = 9;
    public static final int PT_Lab = 10;
    public static final int PT_YUVK = 11;
    public static final int PT_HSV = 12;
    public static final int PT_HLS = 13;
    public static final int PT_Yxy = 14;
    public static final int PT_HiFi = 15;
    public static final int PT_HiFi7 = 16;
    public static final int PT_HiFi8 = 17;
    public static final int PT_HiFi9 = 18;
    public static final int PT_HiFi10 = 19;
    public static final int PT_HiFi11 = 20;
    public static final int PT_HiFi12 = 21;
    public static final int PT_HiFi13 = 22;
    public static final int PT_HiFi14 = 23;
    public static final int PT_HiFi15 = 24;
    public static final int TYPE_GRAY_8 = LCMS.COLORSPACE_SH(3) | LCMS.CHANNELS_SH(1) | LCMS.BYTES_SH(1);
    public static final int TYPE_GRAY_8_REV = LCMS.COLORSPACE_SH(3) | LCMS.CHANNELS_SH(1) | LCMS.BYTES_SH(1) | LCMS.FLAVOR_SH(1);
    public static final int TYPE_GRAY_16 = LCMS.COLORSPACE_SH(3) | LCMS.CHANNELS_SH(1) | LCMS.BYTES_SH(2);
    public static final int TYPE_GRAY_16_REV = LCMS.COLORSPACE_SH(3) | LCMS.CHANNELS_SH(1) | LCMS.BYTES_SH(2) | LCMS.FLAVOR_SH(1);
    public static final int TYPE_GRAY_16_SE = LCMS.COLORSPACE_SH(3) | LCMS.CHANNELS_SH(1) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
    public static final int TYPE_GRAYA_8 = LCMS.COLORSPACE_SH(3) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(1) | LCMS.BYTES_SH(1);
    public static final int TYPE_GRAYA_16 = LCMS.COLORSPACE_SH(3) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(1) | LCMS.BYTES_SH(2);
    public static final int TYPE_GRAYA_16_SE = LCMS.COLORSPACE_SH(3) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(1) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
    public static final int TYPE_GRAYA_8_PLANAR = LCMS.COLORSPACE_SH(3) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(1) | LCMS.BYTES_SH(1) | LCMS.PLANAR_SH(1);
    public static final int TYPE_GRAYA_16_PLANAR = LCMS.COLORSPACE_SH(3) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(1) | LCMS.BYTES_SH(2) | LCMS.PLANAR_SH(1);
    public static final int TYPE_RGB_8 = LCMS.COLORSPACE_SH(4) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1);
    public static final int TYPE_RGB_8_PLANAR = LCMS.COLORSPACE_SH(4) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.PLANAR_SH(1);
    public static final int TYPE_BGR_8 = LCMS.COLORSPACE_SH(4) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.DOSWAP_SH(1);
    public static final int TYPE_BGR_8_PLANAR = LCMS.COLORSPACE_SH(4) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.DOSWAP_SH(1) | LCMS.PLANAR_SH(1);
    public static final int TYPE_RGB_16 = LCMS.COLORSPACE_SH(4) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2);
    public static final int TYPE_RGB_16_PLANAR = LCMS.COLORSPACE_SH(4) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.PLANAR_SH(1);
    public static final int TYPE_RGB_16_SE = LCMS.COLORSPACE_SH(4) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
    public static final int TYPE_BGR_16 = LCMS.COLORSPACE_SH(4) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1);
    public static final int TYPE_BGR_16_PLANAR = LCMS.COLORSPACE_SH(4) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.PLANAR_SH(1);
    public static final int TYPE_BGR_16_SE = LCMS.COLORSPACE_SH(4) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.ENDIAN16_SH(1);
    public static final int TYPE_RGBA_8 = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1);
    public static final int TYPE_RGBA_8_PLANAR = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.PLANAR_SH(1);
    public static final int TYPE_RGBA_16 = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2);
    public static final int TYPE_RGBA_16_PLANAR = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.PLANAR_SH(1);
    public static final int TYPE_RGBA_16_SE = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
    public static final int TYPE_ARGB_8 = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.SWAPFIRST_SH(1);
    public static final int TYPE_ARGB_16 = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.SWAPFIRST_SH(1);
    public static final int TYPE_ABGR_8 = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.DOSWAP_SH(1);
    public static final int TYPE_ABGR_16 = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1);
    public static final int TYPE_ABGR_16_PLANAR = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.PLANAR_SH(1);
    public static final int TYPE_ABGR_16_SE = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.ENDIAN16_SH(1);
    public static final int TYPE_BGRA_8 = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.DOSWAP_SH(1) | LCMS.SWAPFIRST_SH(1);
    public static final int TYPE_BGRA_16 = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.SWAPFIRST_SH(1);
    public static final int TYPE_BGRA_16_SE = LCMS.COLORSPACE_SH(4) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1) | LCMS.SWAPFIRST_SH(1);
    public static final int TYPE_CMY_8 = LCMS.COLORSPACE_SH(5) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1);
    public static final int TYPE_CMY_8_PLANAR = LCMS.COLORSPACE_SH(5) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.PLANAR_SH(1);
    public static final int TYPE_CMY_16 = LCMS.COLORSPACE_SH(5) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2);
    public static final int TYPE_CMY_16_PLANAR = LCMS.COLORSPACE_SH(5) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.PLANAR_SH(1);
    public static final int TYPE_CMY_16_SE = LCMS.COLORSPACE_SH(5) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
    public static final int TYPE_CMYK_8 = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(1);
    public static final int TYPE_CMYKA_8 = LCMS.COLORSPACE_SH(6) | LCMS.EXTRA_SH(1) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(1);
    public static final int TYPE_CMYK_8_REV;
    public static final int TYPE_YUVK_8;
    public static final int TYPE_CMYK_8_PLANAR;
    public static final int TYPE_CMYK_16;
    public static final int TYPE_CMYK_16_REV;
    public static final int TYPE_YUVK_16;
    public static final int TYPE_CMYK_16_PLANAR;
    public static final int TYPE_CMYK_16_SE;
    public static final int TYPE_KYMC_8;
    public static final int TYPE_KYMC_16;
    public static final int TYPE_KYMC_16_SE;
    public static final int TYPE_KCMY_8;
    public static final int TYPE_KCMY_8_REV;
    public static final int TYPE_KCMY_16;
    public static final int TYPE_KCMY_16_REV;
    public static final int TYPE_KCMY_16_SE;
    public static final int TYPE_CMYK5_8;
    public static final int TYPE_CMYK5_16;
    public static final int TYPE_CMYK5_16_SE;
    public static final int TYPE_KYMC5_8;
    public static final int TYPE_KYMC5_16;
    public static final int TYPE_KYMC5_16_SE;
    public static final int TYPE_CMYKcm_8;
    public static final int TYPE_CMYKcm_8_PLANAR;
    public static final int TYPE_CMYKcm_16;
    public static final int TYPE_CMYKcm_16_PLANAR;
    public static final int TYPE_CMYKcm_16_SE;
    public static final int TYPE_CMYK7_8;
    public static final int TYPE_CMYK7_16;
    public static final int TYPE_CMYK7_16_SE;
    public static final int TYPE_KYMC7_8;
    public static final int TYPE_KYMC7_16;
    public static final int TYPE_KYMC7_16_SE;
    public static final int TYPE_CMYK8_8;
    public static final int TYPE_CMYK8_16;
    public static final int TYPE_CMYK8_16_SE;
    public static final int TYPE_KYMC8_8;
    public static final int TYPE_KYMC8_16;
    public static final int TYPE_KYMC8_16_SE;
    public static final int TYPE_CMYK9_8;
    public static final int TYPE_CMYK9_16;
    public static final int TYPE_CMYK9_16_SE;
    public static final int TYPE_KYMC9_8;
    public static final int TYPE_KYMC9_16;
    public static final int TYPE_KYMC9_16_SE;
    public static final int TYPE_CMYK10_8;
    public static final int TYPE_CMYK10_16;
    public static final int TYPE_CMYK10_16_SE;
    public static final int TYPE_KYMC10_8;
    public static final int TYPE_KYMC10_16;
    public static final int TYPE_KYMC10_16_SE;
    public static final int TYPE_CMYK11_8;
    public static final int TYPE_CMYK11_16;
    public static final int TYPE_CMYK11_16_SE;
    public static final int TYPE_KYMC11_8;
    public static final int TYPE_KYMC11_16;
    public static final int TYPE_KYMC11_16_SE;
    public static final int TYPE_CMYK12_8;
    public static final int TYPE_CMYK12_16;
    public static final int TYPE_CMYK12_16_SE;
    public static final int TYPE_KYMC12_8;
    public static final int TYPE_KYMC12_16;
    public static final int TYPE_KYMC12_16_SE;
    public static final int TYPE_XYZ_16;
    public static final int TYPE_Lab_8;
    public static final int TYPE_ALab_8;
    public static final int TYPE_Lab_16;
    public static final int TYPE_Yxy_16;
    public static final int TYPE_YCbCr_8;
    public static final int TYPE_YCbCr_8_PLANAR;
    public static final int TYPE_YCbCr_16;
    public static final int TYPE_YCbCr_16_PLANAR;
    public static final int TYPE_YCbCr_16_SE;
    public static final int TYPE_YUV_8;
    public static final int TYPE_YUV_8_PLANAR;
    public static final int TYPE_YUV_16;
    public static final int TYPE_YUV_16_PLANAR;
    public static final int TYPE_YUV_16_SE;
    public static final int TYPE_HLS_8;
    public static final int TYPE_HLS_8_PLANAR;
    public static final int TYPE_HLS_16;
    public static final int TYPE_HLS_16_PLANAR;
    public static final int TYPE_HLS_16_SE;
    public static final int TYPE_HSV_8;
    public static final int TYPE_HSV_8_PLANAR;
    public static final int TYPE_HSV_16;
    public static final int TYPE_HSV_16_PLANAR;
    public static final int TYPE_HSV_16_SE;
    public static final int TYPE_NAMED_COLOR_INDEX;
    public static final int TYPE_XYZ_DBL;
    public static final int TYPE_Lab_DBL;
    public static final int TYPE_GRAY_DBL;
    public static final int TYPE_RGB_DBL;
    public static final int TYPE_CMYK_DBL;
    public static final int INTENT_PERCEPTUAL = 0;
    public static final int INTENT_RELATIVE_COLORIMETRIC = 1;
    public static final int INTENT_SATURATION = 2;
    public static final int INTENT_ABSOLUTE_COLORIMETRIC = 3;
    public static final int cmsFLAGS_MATRIXINPUT = 1;
    public static final int cmsFLAGS_MATRIXOUTPUT = 2;
    public static final int cmsFLAGS_MATRIXONLY = 3;
    public static final int cmsFLAGS_NOWHITEONWHITEFIXUP = 4;
    public static final int cmsFLAGS_NOPRELINEARIZATION = 16;
    public static final int cmsFLAGS_GUESSDEVICECLASS = 32;
    public static final int cmsFLAGS_NOTCACHE = 64;
    public static final int cmsFLAGS_NOTPRECALC = 256;
    public static final int cmsFLAGS_NULLTRANSFORM = 512;
    public static final int cmsFLAGS_HIGHRESPRECALC = 1024;
    public static final int cmsFLAGS_LOWRESPRECALC = 2048;
    public static final int cmsFLAGS_WHITEBLACKCOMPENSATION = 8192;
    public static final int cmsFLAGS_BLACKPOINTCOMPENSATION = 8192;
    public static final int cmsFLAGS_GAMUTCHECK = 4096;
    public static final int cmsFLAGS_SOFTPROOFING = 16384;
    public static final int cmsFLAGS_PRESERVEBLACK = 32768;
    public static final int cmsFLAGS_NODEFAULTRESOURCEDEF = 65536;

    private static int COLORSPACE_SH(int s) {
        return s << 16;
    }

    private static int SWAPFIRST_SH(int s) {
        return s << 14;
    }

    private static int FLAVOR_SH(int s) {
        return s << 13;
    }

    private static int PLANAR_SH(int p) {
        return p << 12;
    }

    private static int ENDIAN16_SH(int e) {
        return e << 11;
    }

    private static int DOSWAP_SH(int e) {
        return e << 10;
    }

    private static int EXTRA_SH(int e) {
        return e << 7;
    }

    private static int CHANNELS_SH(int c) {
        return c << 3;
    }

    private static int BYTES_SH(int b) {
        return b;
    }

    private static int cmsFLAGS_GRIDPOINTS(int n) {
        return (n & 0xFF) << 16;
    }

    private static RasterAccessor normalizeRaster(RasterAccessor src, RasterFormatTag rft, ColorModel cm) {
        boolean reallocBuffer = false;
        int[] dataOffsets = src.getBandOffsets();
        for (int i = 0; i < dataOffsets.length; ++i) {
            if (dataOffsets[i] == i) continue;
            reallocBuffer = true;
            break;
        }
        int bands = src.getNumBands();
        int scanLineStride = src.getScanlineStride();
        if (reallocBuffer || src.getPixelStride() != bands || scanLineStride != src.getWidth() * bands) {
            int[] nArray;
            if (bands == 1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 0;
                nArray3[1] = 1;
                nArray = nArray3;
                nArray3[2] = 2;
            }
            int[] offsets = nArray;
            WritableRaster newRaster = Raster.createInterleavedRaster(src.getDataType(), src.getWidth(), src.getHeight(), src.getWidth() * bands, bands, offsets, new Point(src.getX(), src.getY()));
            RasterAccessor newSrc = new RasterAccessor((Raster)newRaster, newRaster.getBounds(), rft, cm);
            ImageUtil.copyRaster((RasterAccessor)src, (RasterAccessor)newSrc);
            src = newSrc;
        }
        return src;
    }

    @Deprecated
    private static ShortInterleavedRaster normalizeRaster(ShortInterleavedRaster raster) {
        boolean reallocBuffer = false;
        int scanLineStride = raster.getScanlineStride();
        int[] dataOffsets = raster.getDataOffsets();
        for (int i = 0; i < dataOffsets.length; ++i) {
            if (dataOffsets[i] == i) continue;
            reallocBuffer = true;
            break;
        }
        int bands = raster.getNumBands();
        if (!(reallocBuffer || raster.getPixelStride() == bands && scanLineStride == raster.getWidth() * bands)) {
            reallocBuffer = true;
        }
        if (reallocBuffer) {
            int[] nArray;
            PixelInterleavedSampleModel sm = (PixelInterleavedSampleModel)raster.getSampleModel();
            int n = sm.getDataType();
            int n2 = raster.getWidth();
            int n3 = raster.getHeight();
            int n4 = bands * raster.getWidth();
            if (bands == 1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 0;
                nArray3[1] = 1;
                nArray = nArray3;
                nArray3[2] = 2;
            }
            PixelInterleavedSampleModel newSM = new PixelInterleavedSampleModel(n, n2, n3, bands, n4, nArray);
            ShortInterleavedRaster newRaster = new ShortInterleavedRaster(newSM, new Point(raster.getMinX(), raster.getMinY()));
            Functions.copyData(newRaster, raster);
            raster = newRaster;
        }
        return raster;
    }

    @Deprecated
    private static ByteInterleavedRaster normalizeRaster(ByteInterleavedRaster raster) {
        boolean reallocBuffer = false;
        int scanLineStride = raster.getScanlineStride();
        int[] dataOffsets = raster.getDataOffsets();
        for (int i = 0; i < dataOffsets.length; ++i) {
            if (dataOffsets[i] == i) continue;
            reallocBuffer = true;
            break;
        }
        int bands = raster.getNumBands();
        if (!(reallocBuffer || raster.getPixelStride() == bands && scanLineStride == raster.getWidth() * bands)) {
            reallocBuffer = true;
        }
        if (reallocBuffer) {
            int[] nArray;
            PixelInterleavedSampleModel sm = (PixelInterleavedSampleModel)raster.getSampleModel();
            int n = sm.getDataType();
            int n2 = raster.getWidth();
            int n3 = raster.getHeight();
            int n4 = bands * raster.getWidth();
            if (bands == 1) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                int[] nArray3 = new int[3];
                nArray3[0] = 0;
                nArray3[1] = 1;
                nArray = nArray3;
                nArray3[2] = 2;
            }
            PixelInterleavedSampleModel newSM = new PixelInterleavedSampleModel(n, n2, n3, bands, n4, nArray);
            ByteInterleavedRaster newRaster = new ByteInterleavedRaster(newSM, new Point(raster.getMinX(), raster.getMinY()));
            Functions.copyData(newRaster, raster);
            raster = newRaster;
        }
        return raster;
    }

    public static void main(String[] args) {
        try {
            ICC_Profile inProfile = ICC_Profile.getInstance("/System/Library/ColorSync/Profiles/AdobeRGB1998.icc");
            ICC_Profile outProfile = ICC_Profile.getInstance("/Library/ColorSync/Profiles/CIE 1931 D50 Gamma 1.icm");
            Profile cmsOutProfile = new Profile(outProfile);
            Profile cmsInProfile = new Profile(inProfile);
            BufferedImage inputImage = ImageIO.read(new File("/Stuff/Reference/small-q60-adobergb.TIF"));
            ShortInterleavedRaster inputRaster = (ShortInterleavedRaster)inputImage.getTile(0, 0);
            ICC_ColorSpace outCS = new ICC_ColorSpace(outProfile);
            ComponentColorModel outCM = new ComponentColorModel(outCS, false, false, 1, 1);
            ShortInterleavedRaster outputRaster = (ShortInterleavedRaster)((ColorModel)outCM).createCompatibleWritableRaster(inputImage.getWidth(), inputImage.getHeight());
            BufferedImage outputImage = new BufferedImage(outCM, outputRaster, false, null);
            Transform cmsTransform = new Transform(cmsInProfile, TYPE_RGB_16, cmsOutProfile, TYPE_RGB_16, 0, 0);
            cmsTransform.doTransform(inputRaster, outputRaster);
            ImageIO.write((RenderedImage)outputImage, "TIF", new File("/Stuff/small-q60-CIED65.TIF"));
            cmsTransform.dispose();
            cmsOutProfile.dispose();
            cmsInProfile.dispose();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        TYPE_YUVK_8 = TYPE_CMYK_8_REV = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(1) | LCMS.FLAVOR_SH(1);
        TYPE_CMYK_8_PLANAR = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(1) | LCMS.PLANAR_SH(1);
        TYPE_CMYK_16 = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(2);
        TYPE_YUVK_16 = TYPE_CMYK_16_REV = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(2) | LCMS.FLAVOR_SH(1);
        TYPE_CMYK_16_PLANAR = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(2) | LCMS.PLANAR_SH(1);
        TYPE_CMYK_16_SE = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_KYMC_8 = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(1) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC_16 = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC_16_SE = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.ENDIAN16_SH(1);
        TYPE_KCMY_8 = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(1) | LCMS.SWAPFIRST_SH(1);
        TYPE_KCMY_8_REV = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(1) | LCMS.FLAVOR_SH(1) | LCMS.SWAPFIRST_SH(1);
        TYPE_KCMY_16 = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(2) | LCMS.SWAPFIRST_SH(1);
        TYPE_KCMY_16_REV = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(2) | LCMS.FLAVOR_SH(1) | LCMS.SWAPFIRST_SH(1);
        TYPE_KCMY_16_SE = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1) | LCMS.SWAPFIRST_SH(1);
        TYPE_CMYK5_8 = LCMS.CHANNELS_SH(5) | LCMS.BYTES_SH(1);
        TYPE_CMYK5_16 = LCMS.CHANNELS_SH(5) | LCMS.BYTES_SH(2);
        TYPE_CMYK5_16_SE = LCMS.CHANNELS_SH(5) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_KYMC5_8 = LCMS.CHANNELS_SH(5) | LCMS.BYTES_SH(1) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC5_16 = LCMS.CHANNELS_SH(5) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC5_16_SE = LCMS.CHANNELS_SH(5) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.ENDIAN16_SH(1);
        TYPE_CMYKcm_8 = LCMS.CHANNELS_SH(6) | LCMS.BYTES_SH(1);
        TYPE_CMYKcm_8_PLANAR = LCMS.CHANNELS_SH(6) | LCMS.BYTES_SH(1) | LCMS.PLANAR_SH(1);
        TYPE_CMYKcm_16 = LCMS.CHANNELS_SH(6) | LCMS.BYTES_SH(2);
        TYPE_CMYKcm_16_PLANAR = LCMS.CHANNELS_SH(6) | LCMS.BYTES_SH(2) | LCMS.PLANAR_SH(1);
        TYPE_CMYKcm_16_SE = LCMS.CHANNELS_SH(6) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_CMYK7_8 = LCMS.CHANNELS_SH(7) | LCMS.BYTES_SH(1);
        TYPE_CMYK7_16 = LCMS.CHANNELS_SH(7) | LCMS.BYTES_SH(2);
        TYPE_CMYK7_16_SE = LCMS.CHANNELS_SH(7) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_KYMC7_8 = LCMS.CHANNELS_SH(7) | LCMS.BYTES_SH(1) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC7_16 = LCMS.CHANNELS_SH(7) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC7_16_SE = LCMS.CHANNELS_SH(7) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.ENDIAN16_SH(1);
        TYPE_CMYK8_8 = LCMS.CHANNELS_SH(8) | LCMS.BYTES_SH(1);
        TYPE_CMYK8_16 = LCMS.CHANNELS_SH(8) | LCMS.BYTES_SH(2);
        TYPE_CMYK8_16_SE = LCMS.CHANNELS_SH(8) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_KYMC8_8 = LCMS.CHANNELS_SH(8) | LCMS.BYTES_SH(1) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC8_16 = LCMS.CHANNELS_SH(8) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC8_16_SE = LCMS.CHANNELS_SH(8) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.ENDIAN16_SH(1);
        TYPE_CMYK9_8 = LCMS.CHANNELS_SH(9) | LCMS.BYTES_SH(1);
        TYPE_CMYK9_16 = LCMS.CHANNELS_SH(9) | LCMS.BYTES_SH(2);
        TYPE_CMYK9_16_SE = LCMS.CHANNELS_SH(9) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_KYMC9_8 = LCMS.CHANNELS_SH(9) | LCMS.BYTES_SH(1) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC9_16 = LCMS.CHANNELS_SH(9) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC9_16_SE = LCMS.CHANNELS_SH(9) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.ENDIAN16_SH(1);
        TYPE_CMYK10_8 = LCMS.CHANNELS_SH(10) | LCMS.BYTES_SH(1);
        TYPE_CMYK10_16 = LCMS.CHANNELS_SH(10) | LCMS.BYTES_SH(2);
        TYPE_CMYK10_16_SE = LCMS.CHANNELS_SH(10) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_KYMC10_8 = LCMS.CHANNELS_SH(10) | LCMS.BYTES_SH(1) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC10_16 = LCMS.CHANNELS_SH(10) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC10_16_SE = LCMS.CHANNELS_SH(10) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.ENDIAN16_SH(1);
        TYPE_CMYK11_8 = LCMS.CHANNELS_SH(11) | LCMS.BYTES_SH(1);
        TYPE_CMYK11_16 = LCMS.CHANNELS_SH(11) | LCMS.BYTES_SH(2);
        TYPE_CMYK11_16_SE = LCMS.CHANNELS_SH(11) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_KYMC11_8 = LCMS.CHANNELS_SH(11) | LCMS.BYTES_SH(1) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC11_16 = LCMS.CHANNELS_SH(11) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC11_16_SE = LCMS.CHANNELS_SH(11) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.ENDIAN16_SH(1);
        TYPE_CMYK12_8 = LCMS.CHANNELS_SH(12) | LCMS.BYTES_SH(1);
        TYPE_CMYK12_16 = LCMS.CHANNELS_SH(12) | LCMS.BYTES_SH(2);
        TYPE_CMYK12_16_SE = LCMS.CHANNELS_SH(12) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_KYMC12_8 = LCMS.CHANNELS_SH(12) | LCMS.BYTES_SH(1) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC12_16 = LCMS.CHANNELS_SH(12) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1);
        TYPE_KYMC12_16_SE = LCMS.CHANNELS_SH(12) | LCMS.BYTES_SH(2) | LCMS.DOSWAP_SH(1) | LCMS.ENDIAN16_SH(1);
        TYPE_XYZ_16 = LCMS.COLORSPACE_SH(9) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2);
        TYPE_Lab_8 = LCMS.COLORSPACE_SH(10) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1);
        TYPE_ALab_8 = LCMS.COLORSPACE_SH(10) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.EXTRA_SH(1) | LCMS.DOSWAP_SH(1);
        TYPE_Lab_16 = LCMS.COLORSPACE_SH(10) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2);
        TYPE_Yxy_16 = LCMS.COLORSPACE_SH(14) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2);
        TYPE_YCbCr_8 = LCMS.COLORSPACE_SH(7) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1);
        TYPE_YCbCr_8_PLANAR = LCMS.COLORSPACE_SH(7) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.PLANAR_SH(1);
        TYPE_YCbCr_16 = LCMS.COLORSPACE_SH(7) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2);
        TYPE_YCbCr_16_PLANAR = LCMS.COLORSPACE_SH(7) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.PLANAR_SH(1);
        TYPE_YCbCr_16_SE = LCMS.COLORSPACE_SH(7) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_YUV_8 = LCMS.COLORSPACE_SH(8) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1);
        TYPE_YUV_8_PLANAR = LCMS.COLORSPACE_SH(8) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.PLANAR_SH(1);
        TYPE_YUV_16 = LCMS.COLORSPACE_SH(8) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2);
        TYPE_YUV_16_PLANAR = LCMS.COLORSPACE_SH(8) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.PLANAR_SH(1);
        TYPE_YUV_16_SE = LCMS.COLORSPACE_SH(8) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_HLS_8 = LCMS.COLORSPACE_SH(13) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1);
        TYPE_HLS_8_PLANAR = LCMS.COLORSPACE_SH(13) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.PLANAR_SH(1);
        TYPE_HLS_16 = LCMS.COLORSPACE_SH(13) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2);
        TYPE_HLS_16_PLANAR = LCMS.COLORSPACE_SH(13) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.PLANAR_SH(1);
        TYPE_HLS_16_SE = LCMS.COLORSPACE_SH(13) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_HSV_8 = LCMS.COLORSPACE_SH(12) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1);
        TYPE_HSV_8_PLANAR = LCMS.COLORSPACE_SH(12) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(1) | LCMS.PLANAR_SH(1);
        TYPE_HSV_16 = LCMS.COLORSPACE_SH(12) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2);
        TYPE_HSV_16_PLANAR = LCMS.COLORSPACE_SH(12) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.PLANAR_SH(1);
        TYPE_HSV_16_SE = LCMS.COLORSPACE_SH(12) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(2) | LCMS.ENDIAN16_SH(1);
        TYPE_NAMED_COLOR_INDEX = LCMS.CHANNELS_SH(1) | LCMS.BYTES_SH(2);
        TYPE_XYZ_DBL = LCMS.COLORSPACE_SH(9) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(0);
        TYPE_Lab_DBL = LCMS.COLORSPACE_SH(10) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(0);
        TYPE_GRAY_DBL = LCMS.COLORSPACE_SH(3) | LCMS.CHANNELS_SH(1) | LCMS.BYTES_SH(0);
        TYPE_RGB_DBL = LCMS.COLORSPACE_SH(4) | LCMS.CHANNELS_SH(3) | LCMS.BYTES_SH(0);
        TYPE_CMYK_DBL = LCMS.COLORSPACE_SH(6) | LCMS.CHANNELS_SH(4) | LCMS.BYTES_SH(0);
    }

    public static class Transform {
        private static Map<Object, RCHandle> transformCache = new RCHandleHashMap<Object, RCHandle>(20);
        private RCHandle cmsTransform = null;

        public Transform(Profile input, int inputType, Profile output, int outputType, int intent, int flags) {
            TransformData td = new TransformData(input, inputType, output, outputType, intent, flags);
            RCHandle transformHandle = transformCache.get(td);
            if (transformHandle != null && transformHandle.increment() > 1) {
                this.cmsTransform = transformHandle;
            } else {
                if (inputType != TYPE_RGB_8 || outputType != TYPE_RGB_8) {
                    flags |= 0x400;
                }
                this.cmsTransform = new RCHandle(LCMSNative.cmsCreateTransform(input.cmsProfile.handle, inputType, output.cmsProfile.handle, outputType, intent, flags));
                transformCache.put(td, this.cmsTransform);
                this.cmsTransform.increment();
            }
        }

        public Transform(Profile input, int inputType, Profile output, int outputType, Profile proof, int intent, int proofIntent, int flags) {
            TransformData td = new TransformData(input, inputType, output, outputType, proof, intent, proofIntent, flags);
            RCHandle transformHandle = transformCache.get(td);
            if (transformHandle != null && transformHandle.increment() > 1) {
                this.cmsTransform = transformHandle;
            } else {
                this.cmsTransform = new RCHandle(LCMSNative.cmsCreateProofingTransform(input.cmsProfile.handle, inputType, output.cmsProfile.handle, outputType, proof.cmsProfile.handle, intent, proofIntent, flags | 0x100 | 0x4000));
                transformCache.put(td, this.cmsTransform);
                this.cmsTransform.increment();
            }
        }

        public void doTransform(RasterAccessor src, RasterFormatTag srcRft, ColorModel srcCm, RasterAccessor dst, RasterFormatTag dstRft, ColorModel dstCm) {
            RasterAccessor ro;
            if (this.cmsTransform == null) {
                return;
            }
            RasterAccessor ri = LCMS.normalizeRaster(src, srcRft, srcCm);
            int bands = dst.getNumBands();
            if (src.getX() != dst.getX() || src.getY() != dst.getY() || src.getWidth() != dst.getWidth() || src.getHeight() != dst.getHeight()) {
                int[] nArray;
                if (bands == 1) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = 0;
                } else {
                    int[] nArray3 = new int[3];
                    nArray3[0] = 0;
                    nArray3[1] = 1;
                    nArray = nArray3;
                    nArray3[2] = 2;
                }
                int[] offsets = nArray;
                WritableRaster output = Raster.createInterleavedRaster(ri.getDataType(), ri.getWidth(), ri.getHeight(), ri.getWidth() * bands, bands, offsets, new Point(ri.getX(), ri.getY()));
                ro = new RasterAccessor((Raster)output, output.getBounds(), dstRft, dstCm);
                System.out.println("*** A");
            } else {
                ro = LCMS.normalizeRaster(dst, dstRft, dstCm);
            }
            switch (ro.getDataType()) {
                case 0: {
                    int pixels = ro.getByteDataArray(0).length / bands;
                    LCMSNative.cmsDoTransform(this.cmsTransform.handle, ri.getByteDataArray(0), ro.getByteDataArray(0), pixels);
                    break;
                }
                case 1: {
                    int pixels = ro.getShortDataArray(0).length / bands;
                    LCMSNative.cmsDoTransform(this.cmsTransform.handle, ri.getShortDataArray(0), ro.getShortDataArray(0), pixels);
                    break;
                }
            }
            if (ro != dst) {
                ImageUtil.copyRaster((RasterAccessor)ro, (RasterAccessor)dst);
            }
        }

        @Deprecated
        public void doTransform(ByteInterleavedRaster input, ByteInterleavedRaster output) {
            if (this.cmsTransform != null) {
                ByteInterleavedRaster ro;
                ByteInterleavedRaster ri = LCMS.normalizeRaster(input);
                int outBands = output.getNumBands();
                if (!input.getBounds().equals(output.getBounds())) {
                    int[] nArray;
                    if (outBands == 1) {
                        int[] nArray2 = new int[1];
                        nArray = nArray2;
                        nArray2[0] = 0;
                    } else {
                        int[] nArray3 = new int[3];
                        nArray3[0] = 0;
                        nArray3[1] = 1;
                        nArray = nArray3;
                        nArray3[2] = 2;
                    }
                    int[] offsets = nArray;
                    PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(0, ri.getWidth(), ri.getHeight(), outBands, outBands * ri.getWidth(), offsets);
                    ro = new ByteInterleavedRaster(sm, new Point(ri.getMinX(), ri.getMinY()));
                } else {
                    ro = LCMS.normalizeRaster(output);
                }
                int pixels = outBands == 1 ? ro.getDataStorage().length : ro.getDataStorage().length / outBands;
                LCMSNative.cmsDoTransform(this.cmsTransform.handle, ri.getDataStorage(), ro.getDataStorage(), pixels);
                if (ro != output) {
                    Functions.copyData(output, ro);
                }
            }
        }

        public void doTransform(byte[] input, byte[] output) {
            LCMSNative.cmsDoTransform(this.cmsTransform.handle, input, output, 1);
        }

        public void doTransform(double[] input, double[] output) {
            LCMSNative.cmsDoTransform(this.cmsTransform.handle, input, output, 1);
        }

        @Deprecated
        public void doTransform(ShortInterleavedRaster input, ShortInterleavedRaster output) {
            if (this.cmsTransform != null) {
                ShortInterleavedRaster ro;
                ShortInterleavedRaster ri = LCMS.normalizeRaster(input);
                int outBands = output.getNumBands();
                if (!input.getBounds().equals(output.getBounds())) {
                    int[] nArray;
                    if (outBands == 1) {
                        int[] nArray2 = new int[1];
                        nArray = nArray2;
                        nArray2[0] = 0;
                    } else {
                        int[] nArray3 = new int[3];
                        nArray3[0] = 0;
                        nArray3[1] = 1;
                        nArray = nArray3;
                        nArray3[2] = 2;
                    }
                    int[] offsets = nArray;
                    PixelInterleavedSampleModel sm = new PixelInterleavedSampleModel(1, ri.getWidth(), ri.getHeight(), outBands, outBands * ri.getWidth(), offsets);
                    ro = new ShortInterleavedRaster(sm, new Point(ri.getMinX(), ri.getMinY()));
                } else {
                    ro = LCMS.normalizeRaster(output);
                }
                int pixels = outBands == 1 ? ro.getDataStorage().length : ro.getDataStorage().length / outBands;
                LCMSNative.cmsDoTransform(this.cmsTransform.handle, ri.getDataStorage(), ro.getDataStorage(), pixels);
                if (ro != output) {
                    Functions.copyData(output, ro);
                }
            }
        }

        public void doTransform(short[] input, short[] output) {
            LCMSNative.cmsDoTransform(this.cmsTransform.handle, input, output, 1);
        }

        public void dispose() {
            if (this.cmsTransform != null && this.cmsTransform.decrement() == 0) {
                LCMSNative.cmsDeleteTransform(this.cmsTransform.handle);
            }
            this.cmsTransform = null;
        }

        public void finalize() {
            this.dispose();
        }

        private static class TransformData {
            final long inputProfileHandle;
            final int inputType;
            final long outputProfileHandle;
            final int outputType;
            final long proofProfileHandle;
            final int intent;
            final int proofIntent;
            final int flags;

            TransformData(Profile input, int inputType, Profile output, int outputType, int intent, int flags) {
                this.inputProfileHandle = input.cmsProfile.handle;
                this.inputType = inputType;
                this.outputProfileHandle = output.cmsProfile.handle;
                this.outputType = outputType;
                this.intent = intent;
                this.proofProfileHandle = 0L;
                this.proofIntent = 0;
                this.flags = flags;
            }

            TransformData(Profile input, int inputType, Profile output, int outputType, Profile proof, int intent, int proofIntent, int flags) {
                this.inputProfileHandle = input.cmsProfile.handle;
                this.inputType = inputType;
                this.outputProfileHandle = output.cmsProfile.handle;
                this.outputType = outputType;
                this.intent = intent;
                this.proofProfileHandle = proof.cmsProfile.handle;
                this.proofIntent = proofIntent;
                this.flags = flags;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                TransformData that = (TransformData)o;
                return this.flags == that.flags && this.inputProfileHandle == that.inputProfileHandle && this.inputType == that.inputType && this.intent == that.intent && this.outputProfileHandle == that.outputProfileHandle && this.outputType == that.outputType && this.proofIntent == that.proofIntent && this.proofProfileHandle == that.proofProfileHandle;
            }

            public int hashCode() {
                int result = (int)(this.inputProfileHandle ^ this.inputProfileHandle >>> 32);
                result = 31 * result + this.inputType;
                result = 31 * result + (int)(this.outputProfileHandle ^ this.outputProfileHandle >>> 32);
                result = 31 * result + this.outputType;
                result = 31 * result + (int)(this.proofProfileHandle ^ this.proofProfileHandle >>> 32);
                result = 31 * result + this.intent;
                result = 31 * result + this.proofIntent;
                result = 31 * result + this.flags;
                return result;
            }
        }
    }

    public static class LABProfile
    extends Profile {
        private static long labProfileHandle = -1L;
        private static RCHandle handle = null;

        public LABProfile() {
            if (labProfileHandle == -1L) {
                labProfileHandle = LCMSNative.cmsCreateLab2Profile();
                this.cmsProfile = handle = new RCHandle(labProfileHandle);
            } else {
                this.cmsProfile = handle;
            }
        }

        @Override
        public void dispose() {
        }
    }

    public static class Profile {
        private static Map<Object, RCHandle> profileCache = new RCHandleHashMap<Object, RCHandle>(20);
        protected RCHandle cmsProfile = null;

        protected Profile() {
        }

        public Profile(ICC_Profile iccProfile) {
            RCHandle handle = profileCache.get(iccProfile);
            if (handle != null && handle.increment() > 1) {
                this.cmsProfile = handle;
            } else {
                byte[] data = iccProfile.getData();
                this.cmsProfile = new RCHandle(LCMSNative.cmsOpenProfileFromMem(data, data.length));
                profileCache.put(iccProfile, this.cmsProfile);
                this.cmsProfile.increment();
            }
        }

        public Profile(double[] whitePoint, double[] primaries, double gamma) {
            RGBProfileComponents components = new RGBProfileComponents(whitePoint, primaries, gamma);
            RCHandle handle = profileCache.get(components);
            if (handle != null && handle.increment() > 1) {
                this.cmsProfile = handle;
            } else {
                this.cmsProfile = new RCHandle(LCMSNative.cmsCreateRGBProfile(whitePoint, primaries, gamma));
                profileCache.put(components, this.cmsProfile);
                this.cmsProfile.increment();
            }
        }

        public void dispose() {
            if (this.cmsProfile != null && this.cmsProfile.decrement() == 0) {
                LCMSNative.cmsCloseProfile(this.cmsProfile.handle);
            }
            this.cmsProfile = null;
        }

        public void finalize() {
            this.dispose();
        }
    }

    private static class RGBProfileComponents {
        final double[] whitePoint;
        final double[] primaries;
        final double gamma;

        RGBProfileComponents(double[] whitePoint, double[] primaries, double gamma) {
            this.whitePoint = whitePoint;
            this.primaries = primaries;
            this.gamma = gamma;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RGBProfileComponents that = (RGBProfileComponents)o;
            return Double.compare(that.gamma, this.gamma) == 0 && Arrays.equals(this.primaries, that.primaries) && Arrays.equals(this.whitePoint, that.whitePoint);
        }

        public int hashCode() {
            int result = this.whitePoint != null ? Arrays.hashCode(this.whitePoint) : 0;
            result = 31 * result + (this.primaries != null ? Arrays.hashCode(this.primaries) : 0);
            long temp = this.gamma != 0.0 ? Double.doubleToLongBits(this.gamma) : 0L;
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }
    }

    private static class RCHandle {
        final long handle;
        private int refcount = 1;

        RCHandle(long handle) {
            this.handle = handle;
        }

        synchronized int increment() {
            ++this.refcount;
            return this.refcount;
        }

        synchronized int decrement() {
            --this.refcount;
            return this.refcount;
        }
    }

    private static final class RCHandleHashMap<K, V extends RCHandle>
    extends LRUHashMap<K, V> {
        public RCHandleHashMap(int max_entries) {
            super(max_entries);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            if (this.size() > this.m_maxEntries) {
                ((RCHandle)eldest.getValue()).decrement();
                return true;
            }
            return false;
        }
    }
}

