/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class SoftValueHashMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, ValueReference<V>> m_map = new HashMap<K, ValueReference<V>>();
    private final ReferenceQueue<V> m_refQueue = new ReferenceQueue();

    @Override
    public void clear() {
        this.processQueue();
        this.m_map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.processQueue();
        return this.m_map.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object key) {
        V value = null;
        Reference valueRef = this.m_map.get(key);
        if (valueRef != null && (value = (V)valueRef.get()) == null) {
            this.m_map.remove(key);
        }
        return value;
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        ValueReference<V> newValueRef = new ValueReference<V>(key, value, this.m_refQueue);
        ValueReference<V> oldValueRef = this.m_map.put(key, newValueRef);
        return oldValueRef != null ? (V)oldValueRef.get() : null;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        ValueReference<V> result = this.m_map.remove(key);
        return result != null ? (V)result.get() : null;
    }

    @Override
    public int size() {
        this.processQueue();
        return this.m_map.size();
    }

    private void processQueue() {
        ValueReference valueRef;
        while ((valueRef = (ValueReference)this.m_refQueue.poll()) != null) {
            this.m_map.remove(valueRef.m_key);
        }
    }

    private static final class ValueReference<V>
    extends SoftReference<V> {
        private final Object m_key;

        ValueReference(Object key, V referrent, ReferenceQueue<V> q) {
            super(referrent, q);
            this.m_key = key;
        }
    }
}

