/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

class TerseLoggingFormatter
extends Formatter {
    private Date date = new Date();
    private static final String format = "{0,date} {0,time}";
    private MessageFormat formatter;
    private Object[] args = new Object[1];
    private static String LineSeparator = System.getProperty("line.separator");

    TerseLoggingFormatter() {
    }

    @Override
    public synchronized String format(LogRecord record) {
        StringBuffer sb = new StringBuffer();
        this.date.setTime(record.getMillis());
        this.args[0] = this.date;
        StringBuffer text = new StringBuffer();
        if (this.formatter == null) {
            this.formatter = new MessageFormat(format);
        }
        this.formatter.format(this.args, text, (FieldPosition)null);
        sb.append(text);
        sb.append(" ");
        if (record.getSourceClassName() != null) {
            sb.append(record.getSourceClassName());
        } else {
            sb.append(record.getLoggerName());
        }
        if (record.getSourceMethodName() != null) {
            sb.append(" ");
            sb.append(record.getSourceMethodName());
        }
        sb.append(LineSeparator);
        String message = this.formatMessage(record);
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append(message);
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            sb.append(thrown.getClass().getName());
            if (thrown.getMessage() != null) {
                sb.append(": ");
                sb.append(thrown.getMessage());
            }
        }
        sb.append(LineSeparator);
        return sb.toString();
    }
}

