/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

import java.lang.reflect.Method;

public final class WebBrowser {
    private static final String[] m_browsers = new String[]{"chromium-browser", "google-chrome", "firefox", "iceweasel", "safari", "opera", "konqueror", "epiphany-browser"};

    public static boolean browse(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> macUtils = Class.forName("com.apple.mrj.MRJFileUtils");
                Method openURL = macUtils.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
                return true;
            }
            if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                return true;
            }
            Runtime rt = Runtime.getRuntime();
            for (String browser : m_browsers) {
                String[] args = new String[]{"which", browser};
                if (rt.exec(args).waitFor() != 0) continue;
                rt.exec(new String[]{browser, url});
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

