/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.bytebuffer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public final class ByteBufferUtil {
    public static void dumpToFile(ByteBuffer buf, String fileName) {
        try {
            FileOutputStream fos = new FileOutputStream(fileName);
            fos.write(buf.array());
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static byte[] getBytes(ByteBuffer buf, int length) {
        byte[] dst = new byte[length];
        buf.get(dst, 0, length);
        return dst;
    }

    public static byte[] getBytes(ByteBuffer buf, int offset, int length) {
        byte[] dst = new byte[length];
        ByteBufferUtil.getBytes(buf, offset, dst, 0, length);
        return dst;
    }

    public static void getBytes(ByteBuffer buf, int bufOffset, byte[] dst, int dstOffset, int length) {
        int origPos = buf.position();
        buf.position(bufOffset);
        buf.get(dst, dstOffset, length);
        buf.position(origPos);
    }

    public static boolean getEquals(ByteBuffer buf, String s, String charsetName) {
        return s.equals(ByteBufferUtil.getString(buf, s.length(), charsetName));
    }

    public static boolean getEquals(ByteBuffer buf, int offset, String s, String charsetName) {
        return s.equals(ByteBufferUtil.getString(buf, offset, s.length(), charsetName));
    }

    public static String getString(ByteBuffer buf, int length, String charsetName) {
        try {
            return new String(ByteBufferUtil.getBytes(buf, length), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getString(ByteBuffer buf, int offset, int length, String charsetName) {
        try {
            return new String(ByteBufferUtil.getBytes(buf, offset, length), charsetName);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static int getUnsignedByte(ByteBuffer buf) {
        return buf.get() & 0xFF;
    }

    public static int getUnsignedByte(ByteBuffer buf, int offset) {
        try {
            return buf.get(offset) & 0xFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static long getUnsignedInt(ByteBuffer buf) {
        return (long)buf.getInt() & 0xFFFFFFFFL;
    }

    public static long getUnsignedInt(ByteBuffer buf, int offset) {
        try {
            return (long)buf.getInt(offset) & 0xFFFFFFFFL;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static int getUnsignedShort(ByteBuffer buf) {
        return buf.getShort() & 0xFFFF;
    }

    public static int getUnsignedShort(ByteBuffer buf, int offset) {
        try {
            return buf.getShort(offset) & 0xFFFF;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static ByteBuffer map(File file, FileChannel.MapMode mapMode) throws IOException {
        return ByteBufferUtil.map(file, 0L, file.length(), mapMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteBuffer map(File file, long position, long size, FileChannel.MapMode mapMode) throws IOException {
        String rafMode;
        if (mapMode == FileChannel.MapMode.READ_ONLY) {
            rafMode = "r";
        } else if (mapMode == FileChannel.MapMode.READ_WRITE) {
            rafMode = "rw";
        } else {
            throw new IllegalArgumentException("unsupported MapMode");
        }
        RandomAccessFile raf = new RandomAccessFile(file, rafMode);
        try {
            MappedByteBuffer mappedByteBuffer = raf.getChannel().map(mapMode, position, size);
            return mappedByteBuffer;
        }
        finally {
            raf.close();
        }
    }

    public static ByteBuffer mapReadOnly(File file) throws IOException {
        return ByteBufferUtil.mapReadOnly(file, 0L, file.length());
    }

    public static ByteBuffer mapReadOnly(File file, long position, long size) throws IOException {
        return ByteBufferUtil.map(file, position, size, FileChannel.MapMode.READ_ONLY);
    }

    public static ByteBuffer mapReadWrite(File file) throws IOException {
        return ByteBufferUtil.mapReadWrite(file, 0L, file.length());
    }

    public static ByteBuffer mapReadWrite(File file, long position, long size) throws IOException {
        return ByteBufferUtil.map(file, position, size, FileChannel.MapMode.READ_WRITE);
    }

    public static void put(ByteBuffer buf, String s, String charsetName) {
        try {
            buf.put(s.getBytes(charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void put(ByteBuffer buf, int offset, String s, String charsetName) {
        int origPos = buf.position();
        buf.position(offset);
        ByteBufferUtil.put(buf, s, charsetName);
        buf.position(origPos);
    }

    public static void skipBytes(ByteBuffer buf, int count) {
        buf.position(buf.position() + count);
    }

    public static void clean(ByteBuffer buf) {
        try {
            Class<?> directByteBufferClass = Class.forName("java.nio.DirectByteBuffer");
            Method cleanerMethod = directByteBufferClass.getDeclaredMethod("cleaner", new Class[0]);
            Class<?> cleanerClass = Class.forName("sun.misc.Cleaner");
            Method cleanMethod = cleanerClass.getDeclaredMethod("clean", new Class[0]);
            if (cleanerMethod != null && cleanMethod != null) {
                boolean wasCleanerMethodAccessible = cleanerMethod.isAccessible();
                boolean wasCleanMethodAccessible = cleanMethod.isAccessible();
                try {
                    cleanerMethod.setAccessible(true);
                    Object cleaner = cleanerMethod.invoke((Object)buf, new Object[0]);
                    cleanMethod.setAccessible(true);
                    cleanMethod.invoke(cleaner, new Object[0]);
                    cleanerMethod.setAccessible(wasCleanerMethodAccessible);
                    cleanMethod.setAccessible(wasCleanMethodAccessible);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

