/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.cache;

import com.lightcrafts.utils.cache.Cache;
import com.lightcrafts.utils.cache.CacheObjectBroker;
import com.lightcrafts.utils.cache.CacheObjectMap;
import com.lightcrafts.utils.cache.CacheStore;
import java.io.IOException;
import java.nio.ByteBuffer;

public final class WriteThroughCacheObjectMap
implements CacheObjectMap {
    private Cache m_cache;

    @Override
    public void clear() {
    }

    @Override
    public boolean contains(Object key) {
        return this.m_cache.storeContains(key);
    }

    @Override
    public void dispose() {
    }

    @Override
    public Object getOnce(Object key, Object aux) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.m_cache.readFromStore(key, aux);
    }

    @Override
    public void put(Object key, Object obj) throws IOException {
        if (key == null || obj == null) {
            throw new IllegalArgumentException();
        }
        CacheObjectBroker broker = this.m_cache.getCacheObjectBroker();
        CacheStore store = this.m_cache.getCacheStore();
        int objSize = broker.getEncodedSizeOf(obj);
        ByteBuffer buf = store.getByteBuffer(objSize);
        broker.encodeToByteBuffer(buf, obj);
        this.m_cache.writeToStore(key, buf);
    }

    @Override
    public boolean remove(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        return this.m_cache.removeFromStore(key);
    }

    @Override
    public void setCache(Cache cache) {
        this.m_cache = cache;
    }
}

