/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.file;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.utils.file.SmartFolder;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileUtil {
    private static final String ILLEGAL_FILENAME_CHARS = "%\"*/:<>?\\|";
    private static final Pattern NUMBERED_FILE_PATTERN = Pattern.compile("^.*-(\\d+)\\.[a-z]{3,4}$");
    private static final FileFilter dirFilter;

    public static boolean containsAtLeastOne(File dir, FileFilter filter) {
        dir = Platform.getPlatform().isSpecialFile(dir);
        File[] allFiles = dir.listFiles();
        if (allFiles != null && allFiles.length > 0) {
            if (filter == null) {
                return true;
            }
            for (File file : allFiles) {
                File file2 = Platform.getPlatform().isSpecialFile(file);
                if (!filter.accept(file2)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File source, File target) throws IOException {
        FileChannel sourceChannel = new FileInputStream(source).getChannel();
        FileChannel targetChannel = new FileOutputStream(target).getChannel();
        try {
            sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
        }
        finally {
            try {
                targetChannel.close();
            }
            finally {
                sourceChannel.close();
            }
        }
    }

    public static boolean delete(File dir, FileFilter filter, boolean recursive) {
        if (dir.isDirectory() && !(dir instanceof SmartFolder) && recursive && !FileUtil.delete(FileUtil.listFiles(dir, filter, recursive), filter, recursive)) {
            return false;
        }
        return dir.delete();
    }

    public static boolean delete(File[] files, FileFilter filter, boolean recursive) {
        boolean result = true;
        if (files != null) {
            for (File file : files) {
                File[] subFiles;
                if (file.isDirectory() && !(file instanceof SmartFolder) && recursive && ((subFiles = FileUtil.listFiles(file, filter, true)) == null || subFiles.length > 0 && !FileUtil.delete(subFiles, filter, true))) {
                    result = false;
                }
                if (file.delete()) continue;
                result = false;
            }
        }
        return result;
    }

    public static String decodeFilename(String name) {
        int i;
        int from = 0;
        while ((i = name.indexOf(37, from)) >= 0 && i < name.length() - 2) {
            try {
                String hex = name.substring(i + 1, i + 3);
                int ascii = Integer.parseInt(hex, 16);
                String to = String.valueOf((char)ascii);
                name = name.substring(0, i) + to + name.substring(i + 3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            from = i + 1;
        }
        return name;
    }

    public static String encodeFilename(String name) {
        for (int i = 0; i < ILLEGAL_FILENAME_CHARS.length(); ++i) {
            char c = ILLEGAL_FILENAME_CHARS.charAt(i);
            if (name.indexOf(c) < 0) continue;
            String from = String.valueOf(c);
            String to = String.format("%%%02X", new Integer(c));
            name = name.replace(from, to);
        }
        return name;
    }

    public static long getLastAccessTimeOf(File file) throws IOException {
        return FileUtil.getLastAccessTime(file.getAbsolutePath()) * 1000L;
    }

    public static String getExtensionOf(File file) {
        String fileName = file.getName();
        int dot = fileName.lastIndexOf(46);
        if (dot <= 0 || dot == fileName.length() - 1) {
            return null;
        }
        return fileName.substring(dot + 1);
    }

    public static File getNoncollidingFileFor(File file) {
        while (file.exists()) {
            String newName;
            String name = file.getName();
            Matcher m = NUMBERED_FILE_PATTERN.matcher(name);
            if (m.matches()) {
                int next = Integer.parseInt(m.group(1)) + 1;
                newName = name.substring(0, m.start(1)) + '-' + next + name.substring(m.end(1));
            } else {
                int dot = name.lastIndexOf(46);
                newName = name.substring(0, dot) + "-1" + name.substring(dot);
            }
            file = new File(file.getParentFile(), newName);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getTempDir() throws IOException {
        File temp = null;
        try {
            temp = File.createTempFile("LZTemp", null);
            File file = temp.getParentFile();
            return file;
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
    }

    public static String insertSuffix(File file, String suffix) {
        return FileUtil.insertSuffix(file.getAbsolutePath(), suffix);
    }

    public static String insertSuffix(String fileName, String suffix) {
        String beforeDot;
        int dot = fileName.lastIndexOf(46);
        if (dot <= 0 || dot == fileName.length() - 1) {
            return null;
        }
        int suffixBegin = dot - suffix.length();
        if (suffixBegin >= 0 && (beforeDot = fileName.substring(suffixBegin, dot)).equals(suffix)) {
            return fileName;
        }
        return fileName.substring(0, dot) + suffix + fileName.substring(dot);
    }

    public static File isFolder(File file) {
        if (file.isHidden()) {
            return null;
        }
        Platform platform = Platform.getPlatform();
        file = platform.isSpecialFile(file);
        if (file.isFile()) {
            return null;
        }
        if (file instanceof SmartFolder) {
            return null;
        }
        return platform.getFileSystemView().isTraversable(file) != false ? file : null;
    }

    public static File[] listFiles(File dir) {
        return FileUtil.listFiles(dir, null, false);
    }

    public static File[] listFiles(File dir, FileFilter filter, boolean includeDirs) {
        dir = Platform.getPlatform().isSpecialFile(dir);
        File[] files = dir.listFiles(filter);
        if (!includeDirs) {
            return files;
        }
        File[] dirs = dir.listFiles(dirFilter);
        File[] dirsAndFiles = new File[files.length + dirs.length];
        System.arraycopy(files, 0, dirsAndFiles, 0, files.length);
        System.arraycopy(dirs, 0, dirsAndFiles, files.length, dirs.length);
        return dirsAndFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntireFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            String string = FileUtil.readEntireStream(is);
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static String readEntireStream(InputStream in) throws IOException {
        int bytesRead;
        byte[] buf = new byte[1024];
        StringBuilder sb = new StringBuilder();
        while ((bytesRead = in.read(buf)) > 0) {
            sb.append(new String(buf, 0, bytesRead, "UTF-8"));
        }
        return sb.toString();
    }

    public static void renameFile(File from, File to) throws IOException {
        try {
            to.delete();
            if (!from.renameTo(to)) {
                throw new IOException();
            }
        }
        catch (SecurityException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    public static String replaceExtensionOf(File file, String newExtension) {
        return FileUtil.replaceExtensionOf(file.getAbsolutePath(), newExtension);
    }

    public static String replaceExtensionOf(String fileName, String newExtension) {
        int dot = fileName.lastIndexOf(46);
        if (dot <= 0 || dot == fileName.length() - 1) {
            return null;
        }
        return fileName.substring(0, dot + 1) + newExtension;
    }

    public static File resolveAliasFile(File file) {
        String resolvedPath;
        if (file != null && (resolvedPath = Platform.getPlatform().resolveAliasFile(file)) != null && !resolvedPath.equals(file.getAbsolutePath())) {
            file = new File(resolvedPath);
        }
        return file;
    }

    public static void touch(File file) {
        file.setLastModified(System.currentTimeMillis());
    }

    public static String trimExtensionOf(File file) {
        return FileUtil.trimExtensionOf(file.getAbsolutePath());
    }

    public static String trimExtensionOf(String fileName) {
        int dot = fileName.lastIndexOf(46);
        return dot >= 1 ? fileName.substring(0, dot) : fileName;
    }

    private static long getLastAccessTime(String fileName) throws IOException, UnsupportedEncodingException {
        byte[] fileNameUtf8 = (fileName + '\u0000').getBytes("UTF-8");
        return FileUtil.getLastAccessTime(fileNameUtf8);
    }

    private static native long getLastAccessTime(byte[] var0) throws IOException;

    static {
        System.loadLibrary("LCFileUtil");
        dirFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
    }
}

