/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.filecache;

import com.lightcrafts.utils.file.FileIterator;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.filecache.FileCacheFilter;
import com.lightcrafts.utils.filecache.FileCacheKeyMapper;
import com.lightcrafts.utils.filecache.FileCacheMonitor;
import com.lightcrafts.utils.filecache.FileCacheOutputStream;
import com.lightcrafts.utils.filecache.PerUserFileCacheKeyMapper;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public final class FileCache {
    private static final int CACHE_VERSION = 11;
    static final boolean DEBUG = false;
    private static final int MAX_SANE_VERSION_FILE_SIZE = 5;
    private long m_capacity;
    private final FileCacheKeyMapper m_mapper;
    private FileCacheMonitor m_monitor;
    private long m_size;
    private static final long TEST_CAPACITY = 0x10000000L;

    public FileCache(long maxSize, FileCacheKeyMapper mapper) throws IOException {
        File cacheDir;
        File versionFile;
        this.m_mapper = mapper;
        this.m_capacity = maxSize;
        if (this.m_capacity > 0L) {
            this.m_monitor = new FileCacheMonitor(this);
        }
        if (!FileCache.checkVersion(versionFile = new File(cacheDir = this.getCacheDirectory(), "version"))) {
            this.clear();
            FileCache.createVersionFile(versionFile);
        }
    }

    public synchronized void clear() throws IOException {
        File cacheDir;
        File[] contents;
        if (this.m_monitor != null) {
            this.m_monitor.clear();
        }
        if (!FileUtil.delete(contents = FileUtil.listFiles(cacheDir = this.getCacheDirectory(), FileCacheFilter.INSTANCE, true), (FileFilter)FileCacheFilter.INSTANCE, true)) {
            throw new IOException("Could not delete old cache");
        }
        this.m_size = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String key) {
        File file = this.m_mapper.mapKeyToFile(key, false);
        FileCache fileCache = this;
        synchronized (fileCache) {
            if (this.m_monitor != null) {
                return this.m_monitor.containsFile(file);
            }
        }
        return file.exists();
    }

    public synchronized void dispose() {
        if (this.m_monitor != null) {
            this.m_monitor.dispose();
            this.m_monitor = null;
        }
    }

    public File getCacheDirectory() {
        return this.m_mapper.getCacheDirectory();
    }

    public long getCapacity() {
        return this.m_capacity;
    }

    public File getFileFor(String key) {
        File file = this.m_mapper.mapKeyToFile(key, true);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public synchronized long getSize() {
        return this.m_size;
    }

    public FileInputStream getStreamFor(String key) {
        File file = this.m_mapper.mapKeyToFile(key, true);
        try {
            FileInputStream fis = new FileInputStream(file);
            return fis;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public void notifyAboutCloseOf(File file) throws IOException {
        if (this.m_monitor != null) {
            this.addToCacheSize(file.length());
            this.m_monitor.addFile(file);
            this.wakeUpMonitor();
        }
    }

    public File putToFile(String key) throws IOException {
        File file = this.m_mapper.mapKeyToFile(key, true);
        this.remove(file);
        return file;
    }

    public FileOutputStream putToStream(String key) throws IOException {
        File file = this.putToFile(key);
        return new FileCacheOutputStream(file, this);
    }

    public boolean remove(String key) throws IOException {
        File file = this.m_mapper.mapKeyToFile(key, false);
        return this.remove(file);
    }

    public void setCapacity(long capacity) {
        if (this.m_capacity > 0L) {
            this.m_capacity = capacity;
            this.wakeUpMonitor();
        }
    }

    synchronized void addToCacheSize(long size) {
        this.m_size += size;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkVersion(File file) throws IOException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        int fileLength = (int)file.length();
        if (fileLength > 5) {
            fileLength = 5;
        }
        byte[] buf = new byte[fileLength];
        try {
            fis.read(buf);
        }
        finally {
            fis.close();
        }
        String versionString = new String(buf);
        try {
            int version = Integer.parseInt(versionString);
            if (version == 11) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createVersionFile(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.write(Integer.toString(11).getBytes("UTF-8"));
        }
        finally {
            fos.close();
        }
    }

    private synchronized boolean remove(File file) throws IOException {
        if (file.exists()) {
            if (!file.delete()) {
                throw new IOException("Could not delete " + file.getAbsolutePath());
            }
            if (this.m_capacity > 0L) {
                this.addToCacheSize(-file.length());
            }
        }
        return this.m_monitor == null || this.m_monitor.removeFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeUpMonitor() {
        if (this.m_monitor != null) {
            FileCacheMonitor fileCacheMonitor = this.m_monitor;
            synchronized (fileCacheMonitor) {
                this.m_monitor.notify();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        FileCache cache = new FileCache(0x10000000L, PerUserFileCacheKeyMapper.create());
        FileIterator i = new FileIterator(new File(args[0]), false);
        while (i.hasNext()) {
            File file = i.next();
            System.err.println("main(): putting " + file.getAbsolutePath() + ", size = " + file.length() / 0x100000L + " MB");
            FileInputStream fis = new FileInputStream(file);
            FileChannel fic = fis.getChannel();
            FileOutputStream fos = cache.putToStream(file.getAbsolutePath());
            FileChannel foc = fos.getChannel();
            fic.transferTo(0L, fic.size(), foc);
            fos.close();
            fis.close();
        }
    }
}

