/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils;

public class splines {
    private splines() {
    }

    static void basis(int order, double t, int vertices, int[] knots, double[] nbasis) {
        double[] temp = new double[knots.length - 1];
        for (int i = 0; i < knots.length - 1; ++i) {
            temp[i] = t >= (double)knots[i] && t < (double)knots[i + 1] ? 1.0 : 0.0;
        }
        for (int k = 2; k <= order; ++k) {
            for (int i = 0; i < knots.length - k; ++i) {
                double d = temp[i] != 0.0 ? (t - (double)knots[i]) * temp[i] / (double)(knots[i + k - 1] - knots[i]) : 0.0;
                double e = temp[i + 1] != 0.0 ? ((double)knots[i + k] - t) * temp[i + 1] / (double)(knots[i + k] - knots[i + 1]) : 0.0;
                temp[i] = d + e;
            }
        }
        if (t == (double)knots[knots.length - 1]) {
            temp[vertices - 1] = 1.0;
        }
        System.arraycopy(temp, 0, nbasis, 0, vertices);
    }

    static void knot(int vertices, int order, int[] knots) {
        knots[0] = 0;
        for (int i = 1; i < vertices + order; ++i) {
            knots[i] = i > order - 1 && i < vertices + 1 ? knots[i - 1] + 1 : knots[i - 1];
        }
    }

    public static void bspline(int order, double[][] polygon, double[][] curve) {
        assert (polygon[0].length == curve[0].length);
        int[] knots = new int[polygon.length + order];
        double[] nbasis = new double[polygon.length];
        int dimensions = polygon[0].length;
        splines.knot(polygon.length, order, knots);
        double step = (double)knots[knots.length - 1] / (double)(curve.length - 1);
        double t = 0.0;
        int icount = 0;
        for (int n = 0; n < curve.length; ++n) {
            if ((double)knots[knots.length - 1] - t < 5.0E-6) {
                t = knots[knots.length - 1];
            }
            splines.basis(order, t, polygon.length, knots, nbasis);
            for (int j = 0; j < dimensions; ++j) {
                double x = 0.0;
                for (int i = 0; i < polygon.length; ++i) {
                    x += nbasis[i] * polygon[i][j];
                }
                curve[icount][j] = x;
            }
            ++icount;
            t += step;
        }
    }

    static void rbasis(int order, double t, int vertices, int[] knots, double[] weights, double[] nbasis) {
        int i;
        double[] temp = new double[knots.length - 1];
        for (int i2 = 0; i2 < knots.length - 1; ++i2) {
            temp[i2] = t >= (double)knots[i2] && t < (double)knots[i2 + 1] ? 1.0 : 0.0;
        }
        for (int k = 2; k <= order; ++k) {
            for (int i3 = 0; i3 < knots.length - k; ++i3) {
                double d = temp[i3] != 0.0 ? (t - (double)knots[i3]) * temp[i3] / (double)(knots[i3 + k - 1] - knots[i3]) : 0.0;
                double e = temp[i3 + 1] != 0.0 ? ((double)knots[i3 + k] - t) * temp[i3 + 1] / (double)(knots[i3 + k] - knots[i3 + 1]) : 0.0;
                temp[i3] = d + e;
            }
        }
        if (t == (double)knots[knots.length - 1]) {
            temp[vertices - 1] = 1.0;
        }
        double sum = 0.0;
        for (i = 0; i < vertices; ++i) {
            sum += temp[i] * weights[i];
        }
        for (i = 0; i < vertices; ++i) {
            nbasis[i] = sum != 0.0 ? temp[i] * weights[i] / sum : 0.0;
        }
    }

    public static void rbspline(int order, double[][] polygon, double[] weights, double[][] curve) {
        assert (polygon[0].length == curve[0].length);
        assert (polygon.length == weights.length);
        int[] knots = new int[polygon.length + order];
        double[] nbasis = new double[polygon.length];
        int dimensions = polygon[0].length;
        splines.knot(polygon.length, order, knots);
        double step = (double)knots[knots.length - 1] / (double)(curve.length - 1);
        double t = 0.0;
        int icount = 0;
        for (int n = 0; n < curve.length; ++n) {
            if ((double)knots[knots.length - 1] - t < 5.0E-6) {
                t = knots[knots.length - 1];
            }
            splines.rbasis(order, t, polygon.length, knots, weights, nbasis);
            for (int j = 0; j < dimensions; ++j) {
                double x = 0.0;
                for (int i = 0; i < polygon.length; ++i) {
                    x += nbasis[i] * polygon[i][j];
                }
                curve[icount][j] = x;
            }
            ++icount;
            t += step;
        }
    }

    public static void main(String[] args) {
        int i;
        int i2;
        int vertices = 4;
        int order = 2;
        int points = 11;
        double[][] polygon = new double[][]{{1.0, 1.0, 1.0}, {2.0, 3.0, 1.0}, {4.0, 3.0, 1.0}, {3.0, 1.0, 1.0}};
        double[][] curve = new double[points][3];
        splines.bspline(order, polygon, curve);
        System.out.print("\nPolygon points\n\n");
        for (i2 = 0; i2 < vertices; ++i2) {
            System.out.print(" " + polygon[i2][0] + " " + polygon[i2][1] + " " + polygon[i2][2] + " \n");
        }
        System.out.print("\nCurve points\n\n");
        for (i2 = 0; i2 < points; ++i2) {
            System.out.print(" " + curve[i2][0] + " " + curve[i2][1] + " " + curve[i2][2] + " \n");
        }
        vertices = 4;
        order = 2;
        points = 11;
        double[] weights = new double[vertices];
        for (int i3 = 0; i3 < vertices; ++i3) {
            weights[i3] = 1.0;
        }
        weights[2] = 0.25;
        double[][] polygon2 = new double[][]{{0.0, 0.0, 1.0}, {1.0, 2.0, 1.0}, {2.5, 0.0, 1.0}, {4.0, 2.0, 1.0}, {5.0, 0.0, 1.0}};
        curve = new double[points][3];
        splines.rbspline(order, polygon, weights, curve);
        System.out.print("\nPolygon points\n\n");
        for (i = 0; i < vertices; ++i) {
            System.out.print(" " + polygon[i][0] + " " + polygon[i][1] + " " + polygon[i][2] + " \n");
        }
        System.out.print("\nCurve points\n\n");
        for (i = 0; i < points; ++i) {
            System.out.print(" " + curve[i][0] + " " + curve[i][1] + " " + curve[i][2] + " \n");
        }
    }

    public static double[] interpolate(double min, double max, double step, double[][] curve, double[] result) {
        Interpolator interpolator = new Interpolator();
        if (result == null) {
            result = new double[(int)((max - min) / step)];
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = interpolator.interpolate(min + step * (double)i, curve);
        }
        return result;
    }

    public static short[] interpolate(double min, double max, double step, double[][] curve, short[] result) {
        Interpolator interpolator = new Interpolator();
        if (result == null) {
            result = new short[(int)((max - min) / step)];
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = (short)((int)(interpolator.interpolate(min + step * (double)i, curve) * 65535.0 + 0.5) & 0xFFFF);
        }
        return result;
    }

    public static class Interpolator {
        private int lastIdx = 0;

        public void reset() {
            this.lastIdx = 0;
        }

        public double interpolate(double x, double[][] curve) {
            int i;
            if (x < curve[0][0]) {
                return x * curve[0][1] / curve[0][0];
            }
            int last = curve.length - 1;
            if (x > curve[last][0]) {
                return curve[last][1] + (x - curve[last][0]) * (1.0 - curve[last][1]) / (1.0 - curve[last][0]);
            }
            for (i = this.lastIdx; i < curve.length - 1 && curve[i + 1][0] < x; ++i) {
            }
            this.lastIdx = i;
            if (curve[i][0] == x) {
                return curve[i][1];
            }
            if (curve[i][0] < x) {
                assert (curve[i + 1][0] >= x);
                return curve[i][1] + (x - curve[i][0]) * (curve[i + 1][1] - curve[i][1]) / (curve[i + 1][0] - curve[i][0]);
            }
            assert (curve[i - 1][0] <= x);
            return curve[i - 1][1] + (x - curve[i - 1][0]) * (curve[i][1] - curve[i - 1][1]) / (curve[i][0] - curve[i - 1][0]);
        }
    }
}

