/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.thread;

import com.lightcrafts.utils.thread.CancelableThread;

public final class CancelableThreadMonitor
extends Thread {
    private final Listener m_listener;
    private final CancelableThread m_monitoredThread;
    private Throwable m_thrown;

    public CancelableThreadMonitor(CancelableThread t, Listener listener) {
        super("CancelableThreadMonitor");
        this.m_listener = listener;
        this.m_monitoredThread = t;
    }

    public CancelableThread getMonitoredThread() {
        return this.m_monitoredThread;
    }

    public Throwable getThrown() {
        return this.m_thrown;
    }

    public boolean isCancelled() {
        return this.m_monitoredThread.isCanceled();
    }

    public void requestCancel() {
        this.m_monitoredThread.requestCancel();
    }

    @Override
    public void run() {
        try {
            this.m_monitoredThread.run();
        }
        catch (Throwable t) {
            Throwable cause;
            while (t.getClass() == RuntimeException.class && (cause = t.getCause()) != null) {
                t = cause;
            }
            this.m_thrown = t;
        }
        if (this.m_listener != null) {
            this.m_listener.threadTerminated(this.m_monitoredThread);
        }
    }

    public static interface Listener {
        public void threadTerminated(CancelableThread var1);
    }
}

