/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.thread;

import java.util.LinkedList;

public final class TaskManager
implements Runnable {
    private static final int DEFAULT_PRIORITY_COUNT = 4;
    private final int m_priorityCount;
    private final LinkedList[] m_priorityQueues;
    private boolean m_stop;
    private boolean m_suspended;

    public TaskManager() {
        this(4);
    }

    public TaskManager(int priorityCount) {
        this.m_priorityCount = priorityCount;
        this.m_priorityQueues = new LinkedList[priorityCount];
        for (int i = 0; i < this.m_priorityQueues.length; ++i) {
            this.m_priorityQueues[i] = new LinkedList();
        }
        boolean numThreads = true;
        Thread[] workerThreads = new Thread[1];
        for (int i = 0; i < 1; ++i) {
            workerThreads[i] = new Thread((Runnable)this, "Task Manager Worker " + i);
            workerThreads[i].setPriority(1);
            workerThreads[i].setDaemon(true);
            workerThreads[i].start();
        }
    }

    public void appendTask(Runnable runnable) {
        this.appendTask(this.m_priorityCount / 2, runnable);
    }

    public void appendTask(int priority, Runnable runnable) {
        this.addTask(runnable, priority, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        LinkedList[] linkedListArray = this.m_priorityQueues;
        synchronized (this.m_priorityQueues) {
            this.m_stop = true;
            this.m_priorityQueues.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public int getMaxPriority() {
        return this.m_priorityCount - 1;
    }

    public int getMinPriority() {
        return 0;
    }

    public int getNormPriority() {
        return this.m_priorityCount / 2;
    }

    public void insertTask(Runnable runnable) {
        this.insertTask(this.m_priorityCount / 2, runnable);
    }

    public void insertTask(int priority, Runnable runnable) {
        this.addTask(runnable, priority, false);
    }

    public boolean removeTask(Runnable runnable) {
        for (int i = 0; i < this.m_priorityCount; ++i) {
            if (!this.removeTask(i, runnable)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean removeTask(int priority, Runnable runnable) {
        LinkedList[] queue;
        LinkedList[] linkedListArray = queue = this.m_priorityQueues[priority];
        synchronized (queue) {
            boolean removed = queue.remove(runnable);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (!removed) return removed;
            linkedListArray = this.m_priorityQueues;
            synchronized (this.m_priorityQueues) {
                this.m_priorityQueues.notifyAll();
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return removed;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTasks() {
        LinkedList[] linkedListArray = this.m_priorityQueues;
        synchronized (this.m_priorityQueues) {
            this.m_suspended = false;
            this.m_priorityQueues.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (!this.m_stop) {
            Runnable runnable = null;
            for (int i = this.m_priorityQueues.length - 1; !this.m_suspended && i >= 0; --i) {
                LinkedList queue;
                LinkedList linkedList = queue = this.m_priorityQueues[i];
                // MONITORENTER : linkedList
                if (!queue.isEmpty()) {
                    runnable = (Runnable)queue.removeFirst();
                    // MONITOREXIT : linkedList
                    break;
                }
                // MONITOREXIT : linkedList
            }
            if (runnable != null) {
                try {
                    runnable.run();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                continue;
            }
            LinkedList[] linkedListArray = this.m_priorityQueues;
            // MONITORENTER : this.m_priorityQueues
            try {
                this.m_priorityQueues.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendTasks() {
        LinkedList[] linkedListArray = this.m_priorityQueues;
        synchronized (this.m_priorityQueues) {
            this.m_suspended = true;
            this.m_priorityQueues.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTask(Runnable runnable, int priority, boolean append) {
        LinkedList[] queue;
        LinkedList[] linkedListArray = queue = this.m_priorityQueues[priority];
        synchronized (queue) {
            queue.remove(runnable);
            if (append) {
                queue.addLast(runnable);
            } else {
                queue.addFirst(runnable);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            linkedListArray = this.m_priorityQueues;
            synchronized (this.m_priorityQueues) {
                this.m_priorityQueues.notifyAll();
                // ** MonitorExit[var5_5] (shouldn't be in output)
                return;
            }
        }
    }
}

