/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.utils.xml;

import com.lightcrafts.utils.TextUtil;
import com.lightcrafts.utils.file.FileUtil;
import com.lightcrafts.utils.xml.NodeTypeFilter;
import com.lightcrafts.utils.xml.XMLFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public final class XMLUtil {
    private static DocumentBuilder m_builder;
    private static final XMLFilter m_textNodeTypeFilter;
    private static final TransformerFactory m_xformFactory;

    public static Element addElementChildTo(Element parent, String tagName) {
        Document doc = parent.getOwnerDocument();
        Element child = doc.createElement(tagName);
        parent.appendChild(child);
        return child;
    }

    public static Element addElementChildTo(Element parent, String nsURI, String qualifiedName) {
        Document doc = parent.getOwnerDocument();
        Element child = doc.createElementNS(nsURI, qualifiedName);
        parent.appendChild(child);
        return child;
    }

    public static Document createDocument() {
        return m_builder.newDocument();
    }

    public static Document createDocument(String rootElementName) {
        return XMLUtil.createDocument(rootElementName, null);
    }

    public static Document createDocument(String rootElementName, String xmlns) {
        Document doc = XMLUtil.createDocument();
        Element root = doc.createElement(rootElementName);
        if (xmlns != null) {
            root.setAttribute("xmlns", xmlns);
        }
        doc.appendChild(root);
        return doc;
    }

    public static byte[] encodeDocument(Document doc, boolean includeXAPURL) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            if (includeXAPURL) {
                bos.write("http://ns.adobe.com/xap/1.0/".getBytes("UTF-8"));
                bos.write(0);
            }
            XMLUtil.writeDocumentTo(doc, bos);
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String[] getAttributesNamesOf(Element element) {
        NamedNodeMap map = element.getAttributes();
        int numAttributes = map.getLength();
        String[] result = new String[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            result[i] = map.item(i).getNodeName();
        }
        return result;
    }

    public static Node[] getChildrenOf(Element parent, XMLFilter filter) {
        ArrayList<Node> result = new ArrayList<Node>();
        NodeList children = parent.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            if (!filter.accept(child)) continue;
            result.add(child);
        }
        return result.toArray(new Node[0]);
    }

    public static String getCoalescedTextChildrenOf(Element parent) {
        StringBuilder buf = new StringBuilder();
        NodeList children = parent.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Text)) continue;
            buf.append(((CharacterData)child).getData());
        }
        return buf.toString();
    }

    public static Node getFirstChildOf(Element parent, XMLFilter filter) {
        NodeList children = parent.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            if (!filter.accept(child)) continue;
            return child;
        }
        return null;
    }

    public static String getTextOfFirstTextChildOf(Element parent) {
        Node child = XMLUtil.getFirstChildOf(parent, m_textNodeTypeFilter);
        return child != null ? ((CharacterData)child).getData() : null;
    }

    public static boolean hasChild(Element parent, XMLFilter filter) {
        NodeList children = parent.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < numChildren; ++i) {
            Node child = children.item(i);
            if (!filter.accept(child)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document readDocumentFrom(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            Document document = XMLUtil.readDocumentFrom(fis);
            return document;
        }
        finally {
            fis.close();
        }
    }

    public static Document readDocumentFrom(InputStream is) throws IOException {
        return XMLUtil.readDocumentFrom(FileUtil.readEntireStream(is));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document readDocumentFrom(String s) throws IOException {
        s = TextUtil.trimNulls(s);
        ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes("UTF-8"));
        try {
            DocumentBuilder documentBuilder = m_builder;
            synchronized (documentBuilder) {
                return m_builder.parse(is);
            }
        }
        catch (SAXException e) {
            IOException ioe = new IOException("Couldn't read XML");
            ioe.initCause(e);
            throw ioe;
        }
    }

    public static void removeChildrenFrom(Element parent) {
        Node child;
        while ((child = parent.getFirstChild()) != null) {
            parent.removeChild(child);
        }
        return;
    }

    public static void removeChildrenFrom(Element parent, XMLFilter filter) {
        NodeList children = parent.getChildNodes();
        int i = 0;
        Node child;
        while ((child = children.item(i)) != null) {
            if (filter.accept(child)) {
                parent.removeChild(child);
                continue;
            }
            ++i;
        }
        return;
    }

    public static Text setTextContentOf(Element parent, String text) {
        XMLUtil.removeChildrenFrom(parent);
        Document doc = parent.getOwnerDocument();
        Text child = doc.createTextNode(text);
        parent.appendChild(child);
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocumentTo(Document doc, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            XMLUtil.writeDocumentTo(doc, fos);
        }
        finally {
            fos.close();
        }
    }

    public static void writeDocumentTo(Document doc, OutputStream out) throws IOException {
        DOMSource source = new DOMSource(doc);
        OutputStreamWriter writer = new OutputStreamWriter(out, "UTF-8");
        StreamResult result = new StreamResult(writer);
        Transformer xform = XMLUtil.createTransformer();
        try {
            xform.transform(source, result);
        }
        catch (TransformerException e) {
            throw new IOException("Couldn't write XML: " + e.getMessage());
        }
    }

    private static Transformer createTransformer() {
        Transformer xform;
        try {
            xform = m_xformFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
        xform.setOutputProperty("indent", "yes");
        xform.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
        xform.setOutputProperty("omit-xml-declaration", "yes");
        return xform;
    }

    static {
        m_textNodeTypeFilter = new NodeTypeFilter(3);
        m_xformFactory = TransformerFactory.newInstance();
        try {
            m_builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            m_xformFactory.setAttribute("indent-number", "2");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

