/*
 * Decompiled with CFR 0.152.
 */
package tilecachetool;

public final class RingBuffer {
    private int size = 100;
    private int start = 0;
    private int count = 0;
    private int write_pointer = 0;
    private boolean filled = false;
    private float[] array;

    public RingBuffer(int size) {
        this.size = size > 0 ? size : 100;
        this.array = new float[this.size];
    }

    public synchronized void setSize(int new_size) {
        int old_size = this.size;
        if (this.size < 2) {
            throw new IllegalArgumentException("Invalid size.");
        }
        int min = 0;
        if (old_size < new_size) {
            this.filled = false;
            min = old_size;
        } else {
            this.filled = true;
            min = new_size;
        }
        float[] temp = this.array;
        this.array = new float[new_size];
        for (int i = 0; i < min; ++i) {
            this.array[i] = temp[i];
        }
        this.count = min;
        this.size = new_size;
    }

    public int getCount() {
        return this.count;
    }

    public int getSize() {
        return this.size;
    }

    public synchronized void write(float data) {
        if (!this.filled) {
            if (this.count == this.size) {
                this.filled = true;
            } else {
                ++this.count;
            }
        }
        if (this.filled) {
            this.start = (this.start + 1) % this.size;
        }
        this.array[this.write_pointer] = data;
        this.write_pointer = (this.write_pointer + 1) % this.size;
    }

    public synchronized float read(int i) {
        if (i < 0) {
            i = 0;
        }
        return this.array[(this.start + i) % this.size];
    }
}

