/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.mlib;

import com.lightcrafts.media.jai.mlib.MediaLibAccessor;
import com.lightcrafts.media.jai.mlib.MlibWarpGridOpImage;
import com.lightcrafts.media.jai.mlib.MlibWarpGridTableOpImage;
import com.lightcrafts.media.jai.mlib.MlibWarpPolynomialOpImage;
import com.lightcrafts.media.jai.mlib.MlibWarpPolynomialTableOpImage;
import com.lightcrafts.media.jai.opimage.RIFUtil;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.InterpolationBicubic;
import com.lightcrafts.mediax.jai.InterpolationBicubic2;
import com.lightcrafts.mediax.jai.InterpolationBilinear;
import com.lightcrafts.mediax.jai.InterpolationNearest;
import com.lightcrafts.mediax.jai.InterpolationTable;
import com.lightcrafts.mediax.jai.Warp;
import com.lightcrafts.mediax.jai.WarpGrid;
import com.lightcrafts.mediax.jai.WarpPolynomial;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Map;

public class MlibWarpRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock args, RenderingHints hints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint(hints);
        RenderedImage source = args.getRenderedSource(0);
        if (!MediaLibAccessor.isMediaLibCompatible(args, layout) || !MediaLibAccessor.hasSameNumBands(args, layout) || source.getTileWidth() >= 32768 || source.getTileHeight() >= 32768) {
            return null;
        }
        BorderExtender extender = RIFUtil.getBorderExtenderHint(hints);
        Warp warp = (Warp)args.getObjectParameter(0);
        Interpolation interp = (Interpolation)args.getObjectParameter(1);
        double[] backgroundValues = (double[])args.getObjectParameter(2);
        int filter = -1;
        if (interp instanceof InterpolationNearest) {
            filter = 0;
        } else if (interp instanceof InterpolationBilinear) {
            filter = 1;
        } else if (interp instanceof InterpolationBicubic) {
            filter = 2;
        } else if (interp instanceof InterpolationBicubic2) {
            filter = 3;
        } else if (!(interp instanceof InterpolationTable)) {
            return null;
        }
        if (warp instanceof WarpGrid) {
            if (interp instanceof InterpolationTable) {
                return new MlibWarpGridTableOpImage(source, extender, (Map)hints, layout, (WarpGrid)warp, interp, backgroundValues);
            }
            return new MlibWarpGridOpImage(source, extender, (Map)hints, layout, (WarpGrid)warp, interp, filter, backgroundValues);
        }
        if (warp instanceof WarpPolynomial) {
            if (interp instanceof InterpolationTable) {
                return new MlibWarpPolynomialTableOpImage(source, extender, (Map)hints, layout, (WarpPolynomial)warp, interp, backgroundValues);
            }
            return new MlibWarpPolynomialOpImage(source, extender, (Map)hints, layout, (WarpPolynomial)warp, interp, filter, backgroundValues);
        }
        return null;
    }
}

