/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.opimage;

import com.lightcrafts.media.jai.codec.FileSeekableStream;
import com.lightcrafts.media.jai.codec.ImageDecodeParam;
import com.lightcrafts.media.jai.codec.SeekableStream;
import com.lightcrafts.media.jai.opimage.JaiI18N;
import com.lightcrafts.media.jai.opimage.StreamImage;
import com.lightcrafts.media.jai.util.ImageUtil;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.OperationRegistry;
import com.lightcrafts.mediax.jai.registry.RIFRegistry;
import com.lightcrafts.mediax.jai.util.ImagingListener;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.io.FileNotFoundException;
import java.io.InputStream;

public class FileLoadRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock args, RenderingHints hints) {
        ImagingListener listener = ImageUtil.getImagingListener(hints);
        try {
            SeekableStream src;
            block9: {
                String fileName = (String)args.getObjectParameter(0);
                src = null;
                try {
                    src = new FileSeekableStream(fileName);
                }
                catch (FileNotFoundException fnfe) {
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream(fileName);
                    if (is == null) break block9;
                    src = SeekableStream.wrapInputStream(is, true);
                }
            }
            ImageDecodeParam param = null;
            if (args.getNumParameters() > 1) {
                param = (ImageDecodeParam)args.getObjectParameter(1);
            }
            ParameterBlock newArgs = new ParameterBlock();
            newArgs.add(src);
            newArgs.add(param);
            RenderingHints.Key key = JAI.KEY_OPERATION_BOUND;
            int bound = 2;
            if (hints == null) {
                hints = new RenderingHints(key, new Integer(bound));
            } else if (!hints.containsKey(key)) {
                hints = (RenderingHints)hints.clone();
                hints.put(key, new Integer(bound));
            }
            OperationRegistry registry = (OperationRegistry)hints.get(JAI.KEY_OPERATION_REGISTRY);
            RenderedImage image = RIFRegistry.create(registry, "stream", newArgs, hints);
            return image == null ? null : new StreamImage(image, src);
        }
        catch (FileNotFoundException e) {
            String message = JaiI18N.getString("FileLoadRIF0") + args.getObjectParameter(0);
            listener.errorOccurred(message, e, this, false);
            return null;
        }
        catch (Exception e) {
            String message = JaiI18N.getString("FileLoadRIF1");
            listener.errorOccurred(message, e, this, false);
            return null;
        }
    }
}

