/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.opimage;

import com.lightcrafts.media.jai.opimage.MinFilterPlusOpImage;
import com.lightcrafts.media.jai.opimage.MinFilterSeparableOpImage;
import com.lightcrafts.media.jai.opimage.MinFilterSquareOpImage;
import com.lightcrafts.media.jai.opimage.MinFilterXOpImage;
import com.lightcrafts.media.jai.opimage.RIFUtil;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.operator.MinFilterDescriptor;
import com.lightcrafts.mediax.jai.operator.MinFilterShape;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;

public class MinFilterRIF
implements RenderedImageFactory {
    @Override
    public RenderedImage create(ParameterBlock paramBlock, RenderingHints renderHints) {
        ImageLayout layout = RIFUtil.getImageLayoutHint(renderHints);
        BorderExtender extender = RIFUtil.getBorderExtenderHint(renderHints);
        MinFilterShape maskType = (MinFilterShape)paramBlock.getObjectParameter(0);
        int maskSize = paramBlock.getIntParameter(1);
        RenderedImage ri = paramBlock.getRenderedSource(0);
        if (maskType.equals(MinFilterDescriptor.MIN_MASK_SQUARE)) {
            return new MinFilterSquareOpImage(ri, extender, renderHints, layout, maskSize);
        }
        if (maskType.equals(MinFilterDescriptor.MIN_MASK_PLUS)) {
            return new MinFilterPlusOpImage(ri, extender, renderHints, layout, maskSize);
        }
        if (maskType.equals(MinFilterDescriptor.MIN_MASK_X)) {
            return new MinFilterXOpImage(ri, extender, renderHints, layout, maskSize);
        }
        if (maskType.equals(MinFilterDescriptor.MIN_MASK_SQUARE_SEPARABLE)) {
            return new MinFilterSeparableOpImage(ri, extender, renderHints, layout, maskSize);
        }
        return null;
    }
}

