/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.tilecodec;

import com.lightcrafts.media.jai.tilecodec.JPEGTileDecoder;
import com.lightcrafts.media.jai.tilecodec.JaiI18N;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.ParameterListDescriptor;
import com.lightcrafts.mediax.jai.ParameterListDescriptorImpl;
import com.lightcrafts.mediax.jai.remote.NegotiableCapability;
import com.lightcrafts.mediax.jai.remote.NegotiableCollection;
import com.lightcrafts.mediax.jai.remote.NegotiableNumericRange;
import com.lightcrafts.mediax.jai.tilecodec.TileCodecParameterList;
import com.lightcrafts.mediax.jai.tilecodec.TileDecoder;
import com.lightcrafts.mediax.jai.tilecodec.TileDecoderFactory;
import java.io.InputStream;
import java.util.Vector;

public class JPEGTileDecoderFactory
implements TileDecoderFactory {
    @Override
    public TileDecoder createDecoder(InputStream input, TileCodecParameterList param) {
        if (input == null) {
            throw new IllegalArgumentException(JaiI18N.getString("TileDecoder0"));
        }
        return new JPEGTileDecoder(input, param);
    }

    @Override
    public NegotiableCapability getDecodeCapability() {
        Vector<Class<JPEGTileDecoderFactory>> generators = new Vector<Class<JPEGTileDecoderFactory>>();
        generators.add(JPEGTileDecoderFactory.class);
        ParameterListDescriptor jpegPld = JAI.getDefaultInstance().getOperationRegistry().getDescriptor("tileDecoder", "jpeg").getParameterListDescriptor("tileDecoder");
        Class[] paramClasses = new Class[]{NegotiableNumericRange.class, NegotiableCollection.class, NegotiableNumericRange.class, NegotiableCollection.class, NegotiableCollection.class, NegotiableCollection.class};
        String[] paramNames = new String[]{"quality", "qualitySet", "restartInterval", "writeImageInfo", "writeTableInfo", "writeJFIFHeader"};
        Vector<Boolean> v = new Vector<Boolean>();
        v.add(new Boolean(true));
        v.add(new Boolean(false));
        NegotiableCollection negCollection = new NegotiableCollection(v);
        NegotiableNumericRange nnr1 = new NegotiableNumericRange(jpegPld.getParamValueRange(paramNames[0]));
        NegotiableNumericRange nnr2 = new NegotiableNumericRange(jpegPld.getParamValueRange(paramNames[2]));
        Object[] defaults = new Object[]{nnr1, negCollection, nnr2, negCollection, negCollection, negCollection};
        NegotiableCapability decodeCap = new NegotiableCapability("tileCodec", "jpeg", generators, new ParameterListDescriptorImpl(null, paramNames, paramClasses, defaults, null), false);
        decodeCap.setParameter(paramNames[0], nnr1);
        decodeCap.setParameter(paramNames[1], negCollection);
        decodeCap.setParameter(paramNames[2], nnr2);
        decodeCap.setParameter(paramNames[3], negCollection);
        decodeCap.setParameter(paramNames[4], negCollection);
        decodeCap.setParameter(paramNames[5], negCollection);
        return decodeCap;
    }
}

