/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.tilecodec;

import com.lightcrafts.media.jai.tilecodec.JPEGTileEncoder;
import com.lightcrafts.media.jai.tilecodec.JaiI18N;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.ParameterListDescriptor;
import com.lightcrafts.mediax.jai.ParameterListDescriptorImpl;
import com.lightcrafts.mediax.jai.remote.NegotiableCapability;
import com.lightcrafts.mediax.jai.remote.NegotiableCollection;
import com.lightcrafts.mediax.jai.remote.NegotiableNumericRange;
import com.lightcrafts.mediax.jai.tilecodec.TileCodecParameterList;
import com.lightcrafts.mediax.jai.tilecodec.TileEncoder;
import com.lightcrafts.mediax.jai.tilecodec.TileEncoderFactory;
import java.awt.image.SampleModel;
import java.io.OutputStream;
import java.util.Vector;

public class JPEGTileEncoderFactory
implements TileEncoderFactory {
    @Override
    public TileEncoder createEncoder(OutputStream output, TileCodecParameterList paramList, SampleModel sampleModel) {
        if (output == null) {
            throw new IllegalArgumentException(JaiI18N.getString("TileEncoder0"));
        }
        int nbands = sampleModel.getNumBands();
        if (nbands != 1 && nbands != 3 && nbands != 4) {
            throw new IllegalArgumentException(JaiI18N.getString("JPEGTileEncoder0"));
        }
        if (sampleModel.getDataType() != 0) {
            throw new IllegalArgumentException(JaiI18N.getString("JPEGTileEncoder1"));
        }
        return new JPEGTileEncoder(output, paramList);
    }

    @Override
    public NegotiableCapability getEncodeCapability() {
        Vector<Class<JPEGTileEncoderFactory>> generators = new Vector<Class<JPEGTileEncoderFactory>>();
        generators.add(JPEGTileEncoderFactory.class);
        ParameterListDescriptor jpegPld = JAI.getDefaultInstance().getOperationRegistry().getDescriptor("tileEncoder", "jpeg").getParameterListDescriptor("tileEncoder");
        Class[] paramClasses = new Class[]{NegotiableNumericRange.class, NegotiableCollection.class, NegotiableNumericRange.class, NegotiableCollection.class, NegotiableCollection.class, NegotiableCollection.class};
        String[] paramNames = new String[]{"quality", "qualitySet", "restartInterval", "writeImageInfo", "writeTableInfo", "writeJFIFHeader"};
        Vector<Boolean> v = new Vector<Boolean>();
        v.add(new Boolean(true));
        v.add(new Boolean(false));
        NegotiableCollection negCollection = new NegotiableCollection(v);
        NegotiableNumericRange nnr1 = new NegotiableNumericRange(jpegPld.getParamValueRange(paramNames[0]));
        NegotiableNumericRange nnr2 = new NegotiableNumericRange(jpegPld.getParamValueRange(paramNames[2]));
        Object[] defaults = new Object[]{nnr1, negCollection, nnr2, negCollection, negCollection, negCollection};
        NegotiableCapability encodeCap = new NegotiableCapability("tileCodec", "jpeg", generators, new ParameterListDescriptorImpl(null, paramNames, paramClasses, defaults, null), false);
        encodeCap.setParameter(paramNames[0], nnr1);
        encodeCap.setParameter(paramNames[1], negCollection);
        encodeCap.setParameter(paramNames[2], nnr2);
        encodeCap.setParameter(paramNames[3], negCollection);
        encodeCap.setParameter(paramNames[4], negCollection);
        encodeCap.setParameter(paramNames[5], negCollection);
        return encodeCap;
    }
}

