/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.tilecodec;

import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.remote.SerializableState;
import com.lightcrafts.mediax.jai.remote.SerializerFactory;
import com.lightcrafts.mediax.jai.tilecodec.TileCodecDescriptor;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.text.MessageFormat;

public class TileCodecUtils {
    private static MessageFormat formatter = new MessageFormat("");

    public static TileCodecDescriptor getTileCodecDescriptor(String registryMode, String formatName) {
        return (TileCodecDescriptor)JAI.getDefaultInstance().getOperationRegistry().getDescriptor(registryMode, formatName);
    }

    public static Raster deserializeRaster(Object object) {
        if (!(object instanceof SerializableState)) {
            return null;
        }
        SerializableState ss = (SerializableState)object;
        Class c = ss.getObjectClass();
        if (Raster.class.isAssignableFrom(c)) {
            return (Raster)ss.getObject();
        }
        return null;
    }

    public static SampleModel deserializeSampleModel(Object object) {
        if (!(object instanceof SerializableState)) {
            return null;
        }
        SerializableState ss = (SerializableState)object;
        Class c = ss.getObjectClass();
        if (SampleModel.class.isAssignableFrom(c)) {
            return (SampleModel)ss.getObject();
        }
        return null;
    }

    public static Object serializeRaster(Raster ras) {
        return SerializerFactory.getState(ras, null);
    }

    public static Object serializeSampleModel(SampleModel sm) {
        return SerializerFactory.getState(sm, null);
    }
}

