/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.media.jai.util;

import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.NullOpImage;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedImageAdapter;
import java.awt.image.RenderedImage;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Map;

public class DisposableNullOpImage
extends NullOpImage {
    public DisposableNullOpImage(RenderedImage source, ImageLayout layout, Map configuration, int computeType) {
        super(source, layout, configuration, computeType);
    }

    @Override
    public synchronized void dispose() {
        PlanarImage src = this.getSourceImage(0);
        if (src instanceof RenderedImageAdapter) {
            RenderedImage trueSrc = ((RenderedImageAdapter)src).getWrappedImage();
            Method disposeMethod = null;
            try {
                Class<?> cls = trueSrc.getClass();
                disposeMethod = cls.getMethod("dispose", null);
                if (!disposeMethod.isAccessible()) {
                    AccessibleObject.setAccessible(new AccessibleObject[]{disposeMethod}, true);
                }
                disposeMethod.invoke((Object)trueSrc, (Object[])null);
            }
            catch (Exception exception) {}
        } else {
            src.dispose();
        }
    }
}

