/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.mediax.jai.operator;

import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.OperationDescriptorImpl;
import com.lightcrafts.mediax.jai.ParameterBlockJAI;
import com.lightcrafts.mediax.jai.PropertyGenerator;
import com.lightcrafts.mediax.jai.RenderableOp;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.operator.AffinePropertyGenerator;
import com.lightcrafts.mediax.jai.operator.JaiI18N;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderableImage;

public class AffineDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "Affine"}, {"LocalName", "Affine"}, {"Vendor", "com.lightcrafts.media.jai"}, {"Description", JaiI18N.getString("AffineDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/AffineDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("AffineDescriptor1")}, {"arg1Desc", JaiI18N.getString("AffineDescriptor2")}, {"arg2Desc", JaiI18N.getString("AffineDescriptor3")}};
    private static final Class[] paramClasses = new Class[]{AffineTransform.class, Interpolation.class, double[].class};
    private static final String[] paramNames = new String[]{"transform", "interpolation", "backgroundValues"};
    private static final Object[] paramDefaults = new Object[]{new AffineTransform(), Interpolation.getInstance(0), new double[]{0.0}};

    public AffineDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    @Override
    public boolean isRenderableSupported() {
        return true;
    }

    @Override
    public PropertyGenerator[] getPropertyGenerators() {
        PropertyGenerator[] pg = new PropertyGenerator[]{new AffinePropertyGenerator()};
        return pg;
    }

    @Override
    protected boolean validateParameters(ParameterBlock args, StringBuffer message) {
        if (!super.validateParameters(args, message)) {
            return false;
        }
        AffineTransform transform = (AffineTransform)args.getObjectParameter(0);
        try {
            AffineTransform affineTransform = transform.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            message.append(this.getName() + " " + JaiI18N.getString("AffineDescriptor4"));
            return false;
        }
        return true;
    }

    public static RenderedOp create(RenderedImage source0, AffineTransform transform, Interpolation interpolation, double[] backgroundValues, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Affine", "rendered");
        pb.setSource("source0", source0);
        pb.setParameter("transform", transform);
        pb.setParameter("interpolation", interpolation);
        pb.setParameter("backgroundValues", backgroundValues);
        return JAI.create("Affine", pb, hints);
    }

    public static RenderableOp createRenderable(RenderableImage source0, AffineTransform transform, Interpolation interpolation, double[] backgroundValues, RenderingHints hints) {
        ParameterBlockJAI pb = new ParameterBlockJAI("Affine", "renderable");
        pb.setSource("source0", source0);
        pb.setParameter("transform", transform);
        pb.setParameter("interpolation", interpolation);
        pb.setParameter("backgroundValues", backgroundValues);
        return JAI.createRenderable("Affine", pb, hints);
    }
}

