/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.bin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.Gettext;
import org.freedesktop.dbus.Marshalling;
import org.freedesktop.dbus.bin.IdentifierMangler;
import org.freedesktop.dbus.bin.IterableNodeList;
import org.freedesktop.dbus.bin.StructStruct;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.types.DBusStructType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CreateInterface {
    public String comment = "";
    boolean builtin;
    private final PrintStreamFactory factory;

    private static String collapseType(Type type, Set<String> set, Map<StructStruct, Type[]> map, boolean bl, boolean bl2) throws DBusException {
        if (type instanceof ParameterizedType) {
            Type[] typeArray;
            Class clazz = (Class)((ParameterizedType)type).getRawType();
            if (null != map && type instanceof DBusStructType) {
                int n = 1;
                String string = "Struct";
                while (null != map.get(new StructStruct(string + n))) {
                    ++n;
                }
                string = string + n;
                map.put(new StructStruct(string), ((ParameterizedType)type).getActualTypeArguments());
                return string;
            }
            if (null != set) {
                set.add(clazz.getName());
            }
            if (bl2) {
                return clazz.getName();
            }
            String string = clazz.getSimpleName();
            string = string + '<';
            for (Type type2 : typeArray = ((ParameterizedType)type).getActualTypeArguments()) {
                string = string + CreateInterface.collapseType(type2, set, map, true, bl2) + ',';
            }
            string = string.replaceAll(",$", ">");
            return string;
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return CreateInterface.collapseType(clazz.getComponentType(), set, map, bl, bl2) + "[]";
            }
            Package package_ = clazz.getPackage();
            if (null != set && !"java.lang".equals(package_.getName())) {
                set.add(clazz.getName());
            }
            if (bl) {
                if (bl2) {
                    return clazz.getName();
                }
                return clazz.getSimpleName();
            }
            try {
                Field field = clazz.getField("TYPE");
                Class clazz2 = (Class)field.get(clazz);
                return clazz2.getSimpleName();
            }
            catch (Exception exception) {
                return clazz.getSimpleName();
            }
        }
        return "";
    }

    private static String getJavaType(String string, Set<String> set, Map<StructStruct, Type[]> map, boolean bl, boolean bl2) throws DBusException {
        if (null == string || "".equals(string)) {
            return "";
        }
        Vector vector = new Vector();
        int n = Marshalling.getJavaType((String)string, vector, (int)1);
        Type type = (Type)vector.get(0);
        return CreateInterface.collapseType(type, set, map, bl, bl2);
    }

    public CreateInterface(PrintStreamFactory printStreamFactory, boolean bl) {
        this.factory = printStreamFactory;
        this.builtin = bl;
    }

    String parseReturns(Vector<Element> vector, Set<String> set, Map<String, Integer> map, Map<StructStruct, Type[]> map2) throws DBusException {
        String[] stringArray = new String[]{"Pair", "Triplet", "Quad", "Quintuple", "Sextuple", "Septuple"};
        String string = "";
        String string2 = null;
        switch (vector.size()) {
            case 0: {
                string = string + "void ";
                break;
            }
            case 1: {
                string = string + CreateInterface.getJavaType(vector.get(0).getAttribute("type"), set, map2, false, false) + " ";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = stringArray[vector.size() - 2];
            }
            default: {
                if (null == string2) {
                    string2 = "NTuple" + vector.size();
                }
                map.put(string2, vector.size());
                string = string + string2 + "<";
                for (Element element : vector) {
                    string = string + CreateInterface.getJavaType(element.getAttribute("type"), set, map2, true, false) + ", ";
                }
                string = string.replaceAll(", $", "> ");
            }
        }
        return string;
    }

    String parseMethod(Element element, Set<String> set, Map<String, Integer> map, Map<StructStruct, Type[]> map2, Set<String> set2, Set<String> set3) throws DBusException {
        Object object;
        Vector<Element> vector = new Vector<Element>();
        Vector<Element> vector2 = new Vector<Element>();
        if (null == element.getAttribute("name") || "".equals(element.getAttribute("name"))) {
            System.err.println(Gettext._((String)"ERROR: Method name was blank, failed"));
            System.exit(1);
        }
        String string = "";
        String string2 = null;
        for (Node node : new IterableNodeList(element.getChildNodes())) {
            if (1 != node.getNodeType()) continue;
            CreateInterface.checkNode(node, "arg", "annotation");
            if ("arg".equals(node.getNodeName())) {
                object = (Element)node;
                if ("out".equals(object.getAttribute("direction"))) {
                    vector2.add((Element)object);
                    continue;
                }
                vector.add((Element)object);
                continue;
            }
            if (!"annotation".equals(node.getNodeName())) continue;
            object = (Element)node;
            if (object.getAttribute("name").equals("org.freedesktop.DBus.Method.Error")) {
                string2 = null == string2 ? object.getAttribute("value") : string2 + ", " + object.getAttribute("value");
                set2.add(object.getAttribute("value"));
                continue;
            }
            string = string + this.parseAnnotation((Element)object, set, set3);
        }
        Object object2 = "";
        this.comment = "";
        object2 = (String)object2 + this.parseReturns(vector2, set, map, map2);
        object2 = (String)object2 + IdentifierMangler.mangle(element.getAttribute("name")) + "(";
        char c = 'a';
        object = "";
        for (Element element2 : vector) {
            String string3 = CreateInterface.getJavaType(element2.getAttribute("type"), set, map2, false, false);
            String string4 = element2.getAttribute("name");
            if (null == string4 || "".equals(string4)) {
                char c2 = c;
                c = (char)(c + 1);
                string4 = "" + c2;
            }
            object = (String)object + string3 + " " + IdentifierMangler.mangle(string4) + ", ";
        }
        return ("".equals(this.comment) ? "" : "   /**\n" + this.comment + "   */\n") + string + "  public " + (String)object2 + ((String)object).replaceAll("..$", "") + ")" + (null == string2 ? "" : " throws " + string2) + ";";
    }

    String parseSignal(Element element, Set<String> set, Map<StructStruct, Type[]> map, Set<String> set2) throws DBusException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Vector<String> vector = new Vector<String>();
        char c = 'a';
        set.add("org.freedesktop.dbus.DBusSignal");
        set.add("org.freedesktop.dbus.exceptions.DBusException");
        String string = "";
        for (Object object : new IterableNodeList(element.getChildNodes())) {
            if (1 != object.getNodeType()) continue;
            CreateInterface.checkNode((Node)object, "arg", "annotation");
            if ("annotation".equals(object.getNodeName())) {
                string = string + this.parseAnnotation((Element)object, set, set2);
                continue;
            }
            Element object2 = (Element)object;
            String string2 = CreateInterface.getJavaType(object2.getAttribute("type"), set, map, false, false);
            String string3 = object2.getAttribute("name");
            if (null == string3 || "".equals(string3)) {
                char c2 = c;
                c = (char)(c + 1);
                string3 = "" + c2;
            }
            hashMap.put(IdentifierMangler.mangle(string3), string2);
            vector.add(IdentifierMangler.mangle(string3));
        }
        Object object = "";
        object = (String)object + string;
        object = (String)object + "   public static class " + element.getAttribute("name");
        object = (String)object + " extends DBusSignal\n   {\n";
        for (String string4 : vector) {
            object = (String)object + "      public final " + (String)hashMap.get(string4) + " " + string4 + ";\n";
        }
        object = (String)object + "      public " + element.getAttribute("name") + "(String path";
        for (String string5 : vector) {
            object = (String)object + ", " + (String)hashMap.get(string5) + " " + string5;
        }
        object = (String)object + ") throws DBusException\n      {\n         super(path";
        for (String string6 : vector) {
            object = (String)object + ", " + string6;
        }
        object = (String)object + ");\n";
        for (String string7 : vector) {
            object = (String)object + "         this." + string7 + " = " + string7 + ";\n";
        }
        object = (String)object + "      }\n";
        object = (String)object + "   }\n";
        return object;
    }

    String parseAnnotation(Element element, Set<String> set, Set<String> set2) {
        String string = "  @" + element.getAttribute("name").replaceAll(".*\\.([^.]*)$", "$1") + "(";
        if (null != element.getAttribute("value") && !"".equals(element.getAttribute("value"))) {
            string = string + '\"' + element.getAttribute("value") + '\"';
        }
        set.add(element.getAttribute("name"));
        set2.add(element.getAttribute("name"));
        string = string + ")\n";
        return string;
    }

    void parseInterface(Element element, PrintStream printStream, Map<String, Integer> map, Map<StructStruct, Type[]> map2, Set<String> set, Set<String> set2) throws DBusException {
        if (null == element.getAttribute("name") || "".equals(element.getAttribute("name"))) {
            System.err.println(Gettext._((String)"ERROR: Interface name was blank, failed"));
            System.exit(1);
        }
        printStream.println("package " + element.getAttribute("name").replaceAll("\\.[^.]*$", "") + ";");
        String string = "";
        String string2 = "";
        String string3 = "";
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("org.freedesktop.dbus.DBusInterface");
        for (Node object : new IterableNodeList(element.getChildNodes())) {
            if (1 != object.getNodeType()) continue;
            CreateInterface.checkNode(object, "method", "signal", "property", "annotation");
            if ("method".equals(object.getNodeName())) {
                string = string + this.parseMethod((Element)object, treeSet, map, map2, set, set2) + "\n";
                continue;
            }
            if ("signal".equals(object.getNodeName())) {
                string2 = string2 + this.parseSignal((Element)object, treeSet, map2, set2);
                continue;
            }
            if ("property".equals(object.getNodeName())) {
                System.err.println("WARNING: Ignoring property");
                continue;
            }
            if (!"annotation".equals(object.getNodeName())) continue;
            string3 = string3 + this.parseAnnotation((Element)object, treeSet, set2);
        }
        if (treeSet.size() > 0) {
            for (String string4 : treeSet) {
                printStream.println("import " + string4 + ";");
            }
        }
        printStream.print(string3);
        printStream.print("public interface " + element.getAttribute("name").replaceAll("^.*\\.([^.]*)$", "$1"));
        printStream.println(" extends DBusInterface");
        printStream.println("{");
        printStream.println(string2);
        printStream.println(string);
        printStream.println("}");
    }

    void createException(String string, String string2, PrintStream printStream) throws DBusException {
        printStream.println("package " + string2 + ";");
        printStream.println("import org.freedesktop.dbus.DBusExecutionException;");
        printStream.print("public class " + string);
        printStream.println(" extends DBusExecutionException");
        printStream.println("{");
        printStream.println("   public " + string + "(String message)");
        printStream.println("   {");
        printStream.println("      super(message);");
        printStream.println("   }");
        printStream.println("}");
    }

    void createAnnotation(String string, String string2, PrintStream printStream) throws DBusException {
        printStream.println("package " + string2 + ";");
        printStream.println("import java.lang.annotation.Retention;");
        printStream.println("import java.lang.annotation.RetentionPolicy;");
        printStream.println("@Retention(RetentionPolicy.RUNTIME)");
        printStream.println("public @interface " + string);
        printStream.println("{");
        printStream.println("   String value();");
        printStream.println("}");
    }

    void createStruct(String string, Type[] typeArray, String string2, PrintStream printStream, Map<StructStruct, Type[]> map) throws DBusException, IOException {
        printStream.println("package " + string2 + ";");
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("org.freedesktop.dbus.Position");
        treeSet.add("org.freedesktop.dbus.Struct");
        Map<StructStruct, Type[]> map2 = new HashMap<StructStruct, Type[]>(map);
        String[] stringArray = new String[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            stringArray[i] = CreateInterface.collapseType(typeArray[i], treeSet, map2, false, false);
        }
        for (String string3 : treeSet) {
            printStream.println("import " + string3 + ";");
        }
        printStream.println("public final class " + string + " extends Struct");
        printStream.println("{");
        int n = 0;
        char c = 'a';
        String string4 = "";
        for (String string5 : stringArray) {
            printStream.println("   @Position(" + n++ + ")");
            printStream.println("   public final " + string5 + " " + c + ";");
            string4 = string4 + string5 + " " + c + ", ";
            c = (char)(c + '\u0001');
        }
        printStream.println("  public " + string + "(" + string4.replaceAll("..$", "") + ")");
        printStream.println("  {");
        for (char c2 = 'a'; c2 < c; c2 = (char)(c2 + '\u0001')) {
            printStream.println("   this." + c2 + " = " + c2 + ";");
        }
        printStream.println("  }");
        printStream.println("}");
        map2 = StructStruct.fillPackages(map2, string2);
        HashMap<StructStruct, Type[]> hashMap = new HashMap<StructStruct, Type[]>(map2);
        for (StructStruct structStruct : map.keySet()) {
            hashMap.remove(structStruct);
        }
        this.createStructs(hashMap, map2);
    }

    void createTuple(String string, int n, String string2, PrintStream printStream) throws DBusException {
        char c;
        printStream.println("package " + string2 + ";");
        printStream.println("import org.freedesktop.dbus.Position;");
        printStream.println("import org.freedesktop.dbus.Tuple;");
        printStream.println("/** Just a typed container class */");
        printStream.print("public final class " + string);
        String string3 = " <";
        for (c = 'A'; c < 65 + n; c = (char)((char)(c + '\u0001'))) {
            string3 = string3 + c + ",";
        }
        printStream.print(string3.replaceAll(",$", "> "));
        printStream.println("extends Tuple");
        printStream.println("{");
        c = 'A';
        char c2 = 'a';
        int n2 = 0;
        while (n2 < n) {
            printStream.println("   @Position(" + n2 + ")");
            printStream.println("   public final " + c + " " + c2 + ";");
            ++n2;
            c = (char)(c + '\u0001');
            c2 = (char)(c2 + '\u0001');
        }
        printStream.print("   public " + string + "(");
        String string4 = "";
        c = 'A';
        c2 = 'a';
        char c3 = '\u0000';
        while (c3 < n) {
            string4 = string4 + c + " " + c2 + ", ";
            ++c3;
            c = (char)(c + '\u0001');
            c2 = (char)(c2 + '\u0001');
        }
        printStream.println(string4.replaceAll(", $", ")"));
        printStream.println("   {");
        for (c3 = 'a'; c3 < 97 + n; c3 = (char)(c3 + '\u0001')) {
            printStream.println("      this." + c3 + " = " + c3 + ";");
        }
        printStream.println("   }");
        printStream.println("}");
    }

    void parseRoot(Element element) throws DBusException, IOException {
        Map<StructStruct, Type[]> map = new HashMap<StructStruct, Type[]>();
        TreeSet<String> treeSet = new TreeSet<String>();
        TreeSet<String> treeSet2 = new TreeSet<String>();
        for (Node node : new IterableNodeList(element.getChildNodes())) {
            if (1 != node.getNodeType()) continue;
            CreateInterface.checkNode(node, "interface", "node");
            if ("interface".equals(node.getNodeName())) {
                HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                String string = ((Element)node).getAttribute("name");
                String string2 = string.replaceAll("\\.", "/") + ".java";
                String string3 = string2.replaceAll("/[^/]*$", "");
                String string4 = string.replaceAll("\\.[^.]*$", "");
                if (string4.startsWith("org.freedesktop.DBus") && !this.builtin) continue;
                this.factory.init(string2, string3);
                this.parseInterface((Element)node, this.factory.createPrintStream(string2), hashMap, map, treeSet, treeSet2);
                map = StructStruct.fillPackages(map, string4);
                this.createTuples(hashMap, string4);
                continue;
            }
            if ("node".equals(node.getNodeName())) {
                this.parseRoot((Element)node);
                continue;
            }
            System.err.println(Gettext._((String)"ERROR: Unknown node: ") + node.getNodeName());
            System.exit(1);
        }
        this.createStructs(map, map);
        this.createExceptions(treeSet);
        this.createAnnotations(treeSet2);
    }

    private void createAnnotations(Set<String> set) throws DBusException, IOException {
        for (String string : set) {
            String string2 = string.replaceAll("^.*\\.([^.]*)$", "$1");
            String string3 = string.replaceAll("\\.[^.]*$", "");
            if (string3.startsWith("org.freedesktop.DBus") && !this.builtin) continue;
            String string4 = string3.replaceAll("\\.", "/");
            String string5 = string2.replaceAll("\\.", "/") + ".java";
            this.factory.init(string5, string4);
            this.createAnnotation(string2, string3, this.factory.createPrintStream(string4, string2));
        }
    }

    private void createExceptions(Set<String> set) throws DBusException, IOException {
        for (String string : set) {
            String string2 = string.replaceAll("^.*\\.([^.]*)$", "$1");
            String string3 = string.replaceAll("\\.[^.]*$", "");
            if (string3.startsWith("org.freedesktop.DBus") && !this.builtin) continue;
            String string4 = string3.replaceAll("\\.", "/");
            String string5 = string2.replaceAll("\\.", "/") + ".java";
            this.factory.init(string5, string4);
            this.createException(string2, string3, this.factory.createPrintStream(string4, string2));
        }
    }

    private void createStructs(Map<StructStruct, Type[]> map, Map<StructStruct, Type[]> map2) throws DBusException, IOException {
        for (StructStruct structStruct : map.keySet()) {
            String string = structStruct.name.replaceAll("\\.", "/") + ".java";
            String string2 = structStruct.pack.replaceAll("\\.", "/");
            this.factory.init(string, string2);
            this.createStruct(structStruct.name, map.get(structStruct), structStruct.pack, this.factory.createPrintStream(string2, structStruct.name), map2);
        }
    }

    private void createTuples(Map<String, Integer> map, String string) throws DBusException, IOException {
        for (String string2 : map.keySet()) {
            this.createTuple(string2, map.get(string2), string, this.factory.createPrintStream(string.replaceAll("\\.", "/"), string2));
        }
    }

    static void checkNode(Node node, String ... stringArray) {
        String string = "";
        for (String string2 : stringArray) {
            if (string2.equals(node.getNodeName())) {
                return;
            }
            string = string + string2 + " or ";
        }
        System.err.println(MessageFormat.format(Gettext._((String)"ERROR: Expected {0}, got {1}, failed."), string.replaceAll("....$", ""), node.getNodeName()));
        System.exit(1);
    }

    static void printSyntax() {
        CreateInterface.printSyntax(System.err);
    }

    static void printSyntax(PrintStream printStream) {
        printStream.println("Syntax: CreateInterface <options> [file | busname object]");
        printStream.println("        Options: --no-ignore-builtin --system -y --session -s --create-files -f --help -h --version -v");
    }

    public static void version() {
        System.out.println("Java D-Bus Version " + System.getProperty("Version"));
        System.exit(1);
    }

    static Config parseParams(String[] stringArray) {
        Config config = new Config();
        for (String string : stringArray) {
            if ("--system".equals(string) || "-y".equals(string)) {
                config.bus = 0;
                continue;
            }
            if ("--session".equals(string) || "-s".equals(string)) {
                config.bus = 1;
                continue;
            }
            if ("--no-ignore-builtin".equals(string)) {
                config.builtin = true;
                continue;
            }
            if ("--create-files".equals(string) || "-f".equals(string)) {
                config.fileout = true;
                continue;
            }
            if ("--print-tree".equals(string) || "-p".equals(string)) {
                config.printtree = true;
                continue;
            }
            if ("--help".equals(string) || "-h".equals(string)) {
                CreateInterface.printSyntax(System.out);
                System.exit(0);
                continue;
            }
            if ("--version".equals(string) || "-v".equals(string)) {
                CreateInterface.version();
                System.exit(0);
                continue;
            }
            if (string.startsWith("-")) {
                System.err.println(Gettext._((String)"ERROR: Unknown option: ") + string);
                CreateInterface.printSyntax();
                System.exit(1);
                continue;
            }
            if (null == config.busname) {
                config.busname = string;
                continue;
            }
            if (null == config.object) {
                config.object = string;
                continue;
            }
            CreateInterface.printSyntax();
            System.exit(1);
        }
        if (null == config.busname) {
            CreateInterface.printSyntax();
            System.exit(1);
        } else if (null == config.object) {
            config.datafile = new File(config.busname);
            config.busname = null;
        }
        return config;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Config config = CreateInterface.parseParams(stringArray);
        Reader reader = null;
        if (null != config.busname) {
            try {
                object2 = DBusConnection.getConnection((int)config.bus);
                object = (DBus.Introspectable)object2.getRemoteObject(config.busname, config.object, DBus.Introspectable.class);
                String string = object.Introspect();
                if (null == string) {
                    System.err.println(Gettext._((String)"ERROR: Failed to get introspection data"));
                    System.exit(1);
                }
                reader = new StringReader(string);
                object2.disconnect();
            }
            catch (DBusException dBusException) {
                System.err.println(Gettext._((String)"ERROR: Failure in DBus Communications: ") + dBusException.getMessage());
                System.exit(1);
            }
            catch (DBusExecutionException dBusExecutionException) {
                System.err.println(Gettext._((String)"ERROR: Failure in DBus Communications: ") + dBusExecutionException.getMessage());
                System.exit(1);
            }
        } else if (null != config.datafile) {
            try {
                reader = new InputStreamReader(new FileInputStream(config.datafile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                System.err.println(Gettext._((String)"ERROR: Could not find introspection file: ") + fileNotFoundException.getMessage());
                System.exit(1);
            }
        }
        try {
            object2 = config.fileout ? new FileStreamFactory() : new ConsoleStreamFactory();
            object = new CreateInterface((PrintStreamFactory)object2, config.builtin);
            ((CreateInterface)object).createInterface(reader);
        }
        catch (DBusException dBusException) {
            System.err.println("ERROR: " + dBusException.getMessage());
            System.exit(1);
        }
    }

    public void createInterface(Reader reader) throws ParserConfigurationException, SAXException, IOException, DBusException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(reader));
        Element element = document.getDocumentElement();
        CreateInterface.checkNode(element, "node");
        this.parseRoot(element);
    }

    static class Config {
        int bus = 1;
        String busname = null;
        String object = null;
        File datafile = null;
        boolean printtree = false;
        boolean fileout = false;
        boolean builtin = false;

        Config() {
        }
    }

    static class FileStreamFactory
    extends PrintStreamFactory {
        FileStreamFactory() {
        }

        @Override
        public void init(String string, String string2) {
            new File(string2).mkdirs();
        }

        @Override
        public PrintStream createPrintStream(String string) throws IOException {
            return new PrintStream(new FileOutputStream(string));
        }
    }

    static class ConsoleStreamFactory
    extends PrintStreamFactory {
        ConsoleStreamFactory() {
        }

        @Override
        public void init(String string, String string2) {
        }

        @Override
        public PrintStream createPrintStream(String string) throws IOException {
            System.out.println("/* File: " + string + " */");
            return System.out;
        }

        @Override
        public PrintStream createPrintStream(String string, String string2) throws IOException {
            return super.createPrintStream(string, string2);
        }
    }

    public static abstract class PrintStreamFactory {
        public abstract void init(String var1, String var2);

        public PrintStream createPrintStream(String string, String string2) throws IOException {
            String string3 = string + "/" + string2 + ".java";
            return this.createPrintStream(string3);
        }

        public abstract PrintStream createPrintStream(String var1) throws IOException;
    }
}

