/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import java.math.BigInteger;
import java.text.MessageFormat;
import org.freedesktop.dbus.Gettext;

public class UInt64
extends Number
implements Comparable<UInt64> {
    public static final long MAX_LONG_VALUE = Long.MAX_VALUE;
    public static final BigInteger MAX_BIG_VALUE = new BigInteger("18446744073709551615");
    public static final long MIN_VALUE = 0L;
    private BigInteger value;
    private long top;
    private long bottom;

    public UInt64(long l) {
        if (l < 0L || l > Long.MAX_VALUE) {
            throw new NumberFormatException(MessageFormat.format(Gettext._("{0} is not between {1} and {2}."), l, 0L, Long.MAX_VALUE));
        }
        this.value = new BigInteger("" + l);
        this.top = this.value.shiftRight(32).and(new BigInteger("4294967295")).longValue();
        this.bottom = this.value.and(new BigInteger("4294967295")).longValue();
    }

    public UInt64(long l, long l2) {
        BigInteger bigInteger = new BigInteger("" + l);
        bigInteger = bigInteger.shiftLeft(32);
        bigInteger = bigInteger.add(new BigInteger("" + l2));
        if (0 > bigInteger.compareTo(BigInteger.ZERO)) {
            throw new NumberFormatException(MessageFormat.format(Gettext._("{0} is not between {1} and {2}."), bigInteger, 0L, MAX_BIG_VALUE));
        }
        if (0 < bigInteger.compareTo(MAX_BIG_VALUE)) {
            throw new NumberFormatException(MessageFormat.format(Gettext._("{0} is not between {1} and {2}."), bigInteger, 0L, MAX_BIG_VALUE));
        }
        this.value = bigInteger;
        this.top = l;
        this.bottom = l2;
    }

    public UInt64(BigInteger bigInteger) {
        if (null == bigInteger) {
            throw new NumberFormatException(MessageFormat.format(Gettext._("{0} is not between {1} and {2}."), bigInteger, 0L, MAX_BIG_VALUE));
        }
        if (0 > bigInteger.compareTo(BigInteger.ZERO)) {
            throw new NumberFormatException(MessageFormat.format(Gettext._("{0} is not between {1} and {2}."), bigInteger, 0L, MAX_BIG_VALUE));
        }
        if (0 < bigInteger.compareTo(MAX_BIG_VALUE)) {
            throw new NumberFormatException(MessageFormat.format(Gettext._("{0} is not between {1} and {2}."), bigInteger, 0L, MAX_BIG_VALUE));
        }
        this.value = bigInteger;
        this.top = this.value.shiftRight(32).and(new BigInteger("4294967295")).longValue();
        this.bottom = this.value.and(new BigInteger("4294967295")).longValue();
    }

    public UInt64(String string) {
        if (null == string) {
            throw new NumberFormatException(MessageFormat.format(Gettext._("{0} is not between {1} and {2}."), string, 0L, MAX_BIG_VALUE));
        }
        BigInteger bigInteger = new BigInteger(string);
        if (0 > bigInteger.compareTo(BigInteger.ZERO)) {
            throw new NumberFormatException(MessageFormat.format(Gettext._("{0} is not between {1} and {2}."), string, 0L, MAX_BIG_VALUE));
        }
        if (0 < bigInteger.compareTo(MAX_BIG_VALUE)) {
            throw new NumberFormatException(MessageFormat.format(Gettext._("{0} is not between {1} and {2}."), string, 0L, MAX_BIG_VALUE));
        }
        this.value = bigInteger;
        this.top = this.value.shiftRight(32).and(new BigInteger("4294967295")).longValue();
        this.bottom = this.value.and(new BigInteger("4294967295")).longValue();
    }

    public BigInteger value() {
        return this.value;
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    public boolean equals(Object object) {
        return object instanceof UInt64 && this.value.equals(((UInt64)object).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public int compareTo(UInt64 uInt64) {
        return this.value.compareTo(uInt64.value);
    }

    public String toString() {
        return this.value.toString();
    }

    public long top() {
        return this.top;
    }

    public long bottom() {
        return this.bottom;
    }
}

