/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.io;

import cx.ath.matthew.io.InOutCopier;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ExecInputStream
extends FilterInputStream {
    private Process proc;
    private InputStream stdout;
    private OutputStream stdin;
    private InOutCopier copy;

    public ExecInputStream(InputStream inputStream, Process process) throws IOException {
        super(inputStream);
        this.proc = process;
        this.stdin = process.getOutputStream();
        this.stdout = process.getInputStream();
        this.copy = new InOutCopier(this.in, this.stdin);
        this.copy.start();
    }

    public ExecInputStream(InputStream inputStream, String string) throws IOException {
        this(inputStream, Runtime.getRuntime().exec(string));
    }

    public ExecInputStream(InputStream inputStream, String[] stringArray) throws IOException {
        this(inputStream, Runtime.getRuntime().exec(stringArray));
    }

    public ExecInputStream(InputStream inputStream, String string, String[] stringArray) throws IOException {
        this(inputStream, Runtime.getRuntime().exec(string, stringArray));
    }

    public ExecInputStream(InputStream inputStream, String[] stringArray, String[] stringArray2) throws IOException {
        this(inputStream, Runtime.getRuntime().exec(stringArray, stringArray2));
    }

    public void close() throws IOException {
        try {
            this.proc.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.copy.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.stdin.close();
        this.in.close();
        this.stdout.close();
    }

    public void flush() throws IOException {
        this.copy.flush();
    }

    public int available() throws IOException {
        return this.stdout.available();
    }

    public int read() throws IOException {
        return this.stdout.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.stdout.read(byArray);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.stdout.read(byArray, n, n2);
    }

    public long skip(long l) throws IOException {
        return this.stdout.skip(l);
    }

    public void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() {
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

