/*
 * Decompiled with CFR 0.152.
 */
package cx.ath.matthew.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TeeInputStream
extends FilterInputStream {
    private InputStream in;
    private OutputStream fos;

    public TeeInputStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        super(inputStream);
        this.in = inputStream;
        this.fos = outputStream;
    }

    public TeeInputStream(InputStream inputStream, File file, boolean bl) throws IOException {
        super(inputStream);
        this.in = inputStream;
        this.fos = new FileOutputStream(file, bl);
    }

    public TeeInputStream(InputStream inputStream, File file) throws IOException {
        super(inputStream);
        this.in = inputStream;
        this.fos = new FileOutputStream(file);
    }

    public TeeInputStream(InputStream inputStream, String string, boolean bl) throws IOException {
        this(inputStream, new File(string), bl);
    }

    public TeeInputStream(InputStream inputStream, String string) throws IOException {
        this(inputStream, new File(string));
    }

    public void close() throws IOException {
        this.in.close();
        this.fos.close();
    }

    public void flush() throws IOException {
        this.fos.flush();
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (-1 != n) {
            this.fos.write(n);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        int n = this.in.read(byArray);
        if (-1 != n) {
            this.fos.write(byArray, 0, n);
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (-1 != n3) {
            this.fos.write(byArray, n, n3);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    public void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        this.in.reset();
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

