#!/usr/bin/python
# -*- coding: utf-8 -*-
"""
opsi python library - Service

This module is part of the desktop management solution opsi
(open pc server integration) http://www.opsi.org

Copyright (C) 2006, 2007, 2008, 2009, 2014 uib GmbH

http://www.uib.de/

All rights reserved.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License version 2 as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

@copyright: uib GmbH <info@uib.de>
@author: Jan Schneider <j.schneider@uib.de>
@license: GNU General Public License version 2
"""

import os
from OpenSSL import SSL
from OPSI.Service.Session import SessionHandler

from OPSI.Logger import Logger

logger = Logger()


class SSLContext(object):
	def __init__(self, sslServerKeyFile, sslServerCertFile):
		self._sslServerKeyFile = sslServerKeyFile
		self._sslServerCertFile = sslServerCertFile

	def getContext(self):
		''' Create an SSL context. '''

		# Test if server certificate and key file exist.
		if not os.path.isfile(self._sslServerKeyFile):
			raise Exception(u"Server key file '%s' does not exist!" % self._sslServerKeyFile)

		if not os.path.isfile(self._sslServerCertFile):
			raise Exception(u"Server certificate file '%s' does not exist!" % self._sslServerCertFile)

		context = SSL.Context(SSL.SSLv23_METHOD)
		context.use_privatekey_file(self._sslServerKeyFile)
		context.use_certificate_file(self._sslServerCertFile)
		return context


class OpsiService(object):
	def __init__(self):
		self._sessionHandler = None

	def _getSessionHandler(self):
		if not self._sessionHandler:
			self._sessionHandler = SessionHandler()
		return self._sessionHandler

	def getInterface(self):
		return {}
