import re

mount("/dev/cdrom", "/media/cdrom")

disks = getHarddisks()

entries = []
for disk in disks:
	entries.append( { "name": "%s (%s MB)" % (disk.device, (disk.size/(1024*1024))) } )

sel = ''
if ( len(entries) == 1 ):
	sel = entries[0]["name"]
while not sel:
	sel = ui.getSelection(entries, radio=True, title='Please select harddisk for installation')
	if sel:
		sel = sel[0]

installDisk = None
for i in range(len(entries)):
	if (sel == entries[i]['name']) and (i < len(disks)):
		installDisk = disks[i]

if not installDisk:
	raise Exception("No harddisk found for installation")

ui.getMessageBox().addText("Selected harddisk: %s\n" % installDisk.device)

if not ui.yesno(title="Start installation?", text="All data on harddisk '%s' will be lost" % installDisk.device):
	raise CanceledException("Installation canceled")

installDisk.deletePartitionTable()
installDisk.createPartition(start='0M', end='1024M', fs='linux-swap')
installDisk.createPartition(start='1024M', end='100%', fs='ext3', boot=True)
installDisk.createFilesystem(partition=1, fs='linux-swap')
installDisk.createFilesystem(partition=2, fs='ext3')

rootFsMount = '/mnt/root'
installDisk.mountPartition(partition=2, mountpoint=rootFsMount)

ui.getMessageBox().addText("Extracting server filesystem\n")
extractArchive('/media/cdrom/opsi-depotserver.tar.bz2', chdir=rootFsMount)

ui.getMessageBox().addText("Configuring base system\n")

# Debian etch kernel (2.6.18.x) does not use libata
debianDevice = str(installDisk.device)
if (installDisk.getBusType() == 'IDE') and debianDevice.startswith('/dev/sd'):
	debianDevice = debianDevice.replace('/dev/sd', '/dev/hd')
	logger.notice("Bus type of install disk '%s' is IDE using device '%s' for debian" % (installDisk.device, debianDevice))
	ui.getMessageBox().addText("Bus type of install disk '%s' is IDE using device '%s' for debian\n" % (installDisk.device, debianDevice))
	
# /etc/fstab
fstab = os.path.join(rootFsMount, 'etc', 'fstab')
f = open(fstab, 'w')
print  >> f, "# /etc/fstab: static file system information."
print  >> f, "#"
print  >> f, "# <file system> <mount point>   <type>      <options>                  <dump>  <pass>"
print  >> f, "proc            /proc           proc        defaults                   0       0"
print  >> f, "%s2       /               ext3        defaults,errors=remount-ro 0       1" % debianDevice
print  >> f, "%s1       none            swap        sw                         0       0" % debianDevice
print  >> f, "/dev/cdrom      /media/cdrom0   udf,iso9660 user,noauto                0       0"
print  >> f, "/dev/fd0        /media/floppy0  auto        rw,user,noauto             0       0"
f.close()

# /etc/mstab
mtab = os.path.join(rootFsMount, 'etc', 'mtab')
f = open(mtab, 'w')
print  >> f, "tmpfs /lib/init/rw tmpfs rw,nosuid,mode=0755 0 0"
print  >> f, "proc /proc proc rw,noexec,nosuid,nodev 0 0"
print  >> f, "sysfs /sys sysfs rw,noexec,nosuid,nodev 0 0"
print  >> f, "udev /dev tmpfs rw,mode=0755 0 0"
print  >> f, "tmpfs /dev/shm tmpfs rw,nosuid,nodev 0 0"
print  >> f, "devpts /dev/pts devpts rw,noexec,nosuid,gid=5,mode=620 0 0"
print  >> f, "%s2 / ext3 rw,errors=remount-ro 0 0" % installDisk.device
f.close()

# /boot/grub/menu.lst
grub = os.path.join(rootFsMount, 'boot', 'grub', 'menu.lst')
f = open(grub)
lines = []
for line in f.readlines():
	line = line.strip()
	if not line.startswith('#'):
		match = re.search('^(.*[\s\=]+root\=)\S+(\s.*)', line)
		if match:
			line = match.group(1) + debianDevice + '2' + match.group(2)
	else:
		match = re.search('^.*kopt\=root\=)\S+(\s.*)', line)
		if match:
			line = match.group(1) + debianDevice + '2' + match.group(2)
	lines.append(line)
f.close()
f = open(grub, 'w')
for line in lines:
	print >> f, line
f.close()

# grub install
ui.getMessageBox().addText("Installing bootloader GRUB\n")
execute("mount -o bind /proc %s/proc" % rootFsMount)
execute("mount -o bind /dev %s/dev" % rootFsMount)
os.putenv("LD_PRELOAD", "")
execute("chroot %s grub-install --recheck --no-floppy %s" % (rootFsMount, installDisk.device))

reboot()

sys.exit(0)

