/*  =========================================================================
    mlm_client - Malamute Client

    Codec class for mlm_client.

    Copyright (c) the Contributors as noted in the AUTHORS file.       
    This file is part of the Malamute Project.                         
                                                                       
    This Source Code Form is subject to the terms of the Mozilla Public
    License, v. 2.0. If a copy of the MPL was not distributed with this
    file, You can obtain one at http://mozilla.org/MPL/2.0/.           
    =========================================================================
*/

#ifndef MLM_CLIENT_H_INCLUDED
#define MLM_CLIENT_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

//  @warning THE FOLLOWING @INTERFACE BLOCK IS AUTO-GENERATED BY ZPROJECT
//  @warning Please edit the model at "api/mlm_client.api" to make changes.
//  @interface
//  This is a stable class, and may not change except for emergencies. It
//  is provided in stable builds.
//  Create a new mlm_client, return the reference if successful,   
//  or NULL if construction failed due to lack of available memory.
MLM_EXPORT mlm_client_t *
    mlm_client_new (void);

//  Destroy the mlm_client and free all memory used by the object.
MLM_EXPORT void
    mlm_client_destroy (mlm_client_t **self_p);

//  Return actor, when caller wants to work with multiple actors and/or
//  input sockets asynchronously.                                      
MLM_EXPORT zactor_t *
    mlm_client_actor (mlm_client_t *self);

//  Return message pipe for asynchronous message I/O. In the high-volume case,
//  we send methods and get replies to the actor, in a synchronous manner, and
//  we send/recv high volume message data to a second pipe, the msgpipe. In   
//  the low-volume case we can do everything over the actor pipe, if traffic  
//  is never ambiguous.                                                       
MLM_EXPORT zsock_t *
    mlm_client_msgpipe (mlm_client_t *self);

//  Return true if client is currently connected, else false. Note that the   
//  client will automatically re-connect if the server dies and restarts after
//  a successful first connection.                                            
MLM_EXPORT bool
    mlm_client_connected (mlm_client_t *self);

//  Set PLAIN authentication username and password. If you do not call this, the    
//  client will use NULL authentication. TODO: add "set curve auth".                
//  Returns >= 0 if successful, -1 if interrupted.                                  
MLM_EXPORT int
    mlm_client_set_plain_auth (mlm_client_t *self, const char *username, const char *password);

//  Connect to server endpoint, with specified timeout in msecs (zero means wait    
//  forever). Constructor succeeds if connection is successful. The caller may      
//  specify its address.                                                            
//  Returns >= 0 if successful, -1 if interrupted.                                  
MLM_EXPORT int
    mlm_client_connect (mlm_client_t *self, const char *endpoint, uint32_t timeout, const char *address);

//  Prepare to publish to a specified stream. After this, all messages are sent to  
//  this stream exclusively.                                                        
//  Returns >= 0 if successful, -1 if interrupted.                                  
MLM_EXPORT int
    mlm_client_set_producer (mlm_client_t *self, const char *stream);

//  Consume messages with matching subjects. The pattern is a regular expression    
//  using the CZMQ zrex syntax. The most useful elements are: ^ and $ to match the  
//  start and end, . to match any character, \s and \S to match whitespace and      
//  non-whitespace, \d and \D to match a digit and non-digit, \a and \A to match    
//  alphabetic and non-alphabetic, \w and \W to match alphanumeric and              
//  non-alphanumeric, + for one or more repetitions, * for zero or more repetitions,
//  and ( ) to create groups. Returns 0 if subscription was successful, else -1.    
//  Returns >= 0 if successful, -1 if interrupted.                                  
MLM_EXPORT int
    mlm_client_set_consumer (mlm_client_t *self, const char *stream, const char *pattern);

//  Offer a particular named service, where the pattern matches request subjects    
//  using the CZMQ zrex syntax.                                                     
//  Returns >= 0 if successful, -1 if interrupted.                                  
MLM_EXPORT int
    mlm_client_set_worker (mlm_client_t *self, const char *address, const char *pattern);

//  Send STREAM SEND message to server, takes ownership of message
//  and destroys message when done sending it.                    
MLM_EXPORT int
    mlm_client_send (mlm_client_t *self, const char *subject, zmsg_t **content);

//  Send MAILBOX SEND message to server, takes ownership of message
//  and destroys message when done sending it.                     
MLM_EXPORT int
    mlm_client_sendto (mlm_client_t *self, const char *address, const char *subject, const char *tracker, uint32_t timeout, zmsg_t **content);

//  Send SERVICE SEND message to server, takes ownership of message
//  and destroys message when done sending it.                     
MLM_EXPORT int
    mlm_client_sendfor (mlm_client_t *self, const char *address, const char *subject, const char *tracker, uint32_t timeout, zmsg_t **content);

//  Receive message from server; caller destroys message when done
//  Caller owns return value and must destroy it when done.
MLM_EXPORT zmsg_t *
    mlm_client_recv (mlm_client_t *self);

//  Return last received command. Can be one of these values:
//      "STREAM DELIVER"                                     
//      "MAILBOX DELIVER"                                    
//      "SERVICE DELIVER"                                    
MLM_EXPORT const char *
    mlm_client_command (mlm_client_t *self);

//  Return last received status
MLM_EXPORT int
    mlm_client_status (mlm_client_t *self);

//  Return last received reason
MLM_EXPORT const char *
    mlm_client_reason (mlm_client_t *self);

//  Return last received address
MLM_EXPORT const char *
    mlm_client_address (mlm_client_t *self);

//  Return last received sender
MLM_EXPORT const char *
    mlm_client_sender (mlm_client_t *self);

//  Return last received subject
MLM_EXPORT const char *
    mlm_client_subject (mlm_client_t *self);

//  Return last received content
MLM_EXPORT zmsg_t *
    mlm_client_content (mlm_client_t *self);

//  Return last received tracker
MLM_EXPORT const char *
    mlm_client_tracker (mlm_client_t *self);

//  Send multipart string message to stream, end list with NULL        
//  Returns 0 if OK, -1 if failed due to lack of memory or other error.
MLM_EXPORT int
    mlm_client_sendx (mlm_client_t *self, const char *subject, const char *content, ...);

//  Send multipart string to mailbox, end list with NULL               
//  Returns 0 if OK, -1 if failed due to lack of memory or other error.
MLM_EXPORT int
    mlm_client_sendtox (mlm_client_t *self, const char *address, const char *subject, const char *content, ...);

//  Send multipart string to service, end list with NULL               
//  Returns 0 if OK, -1 if failed due to lack of memory or other error.
MLM_EXPORT int
    mlm_client_sendforx (mlm_client_t *self, const char *address, const char *subject, const char *content, ...);

//  Receive a subject and string content from the server. The content may be
//  1 or more string frames. This method is orthogonal to the sendx methods.
//  End the string arguments with NULL. If there are not enough frames in   
//  the received message, remaining strings are set to NULL. Returns number 
//  of string contents received, or -1 in case of error. Free the returned  
//  subject and content strings when finished with them. To get the type of 
//  the command, use mlm_client_command ().                                 
MLM_EXPORT int
    mlm_client_recvx (mlm_client_t *self, char **subject_p, char **string_p, ...);

//  Enable verbose tracing (animation) of state machine activity.
MLM_EXPORT void
    mlm_client_set_verbose (mlm_client_t *self, bool verbose);

//  Self test of this class.
MLM_EXPORT void
    mlm_client_test (bool verbose);

//  @end

#ifdef __cplusplus
}
#endif

#endif
