/* Generated by re2c */
// re2c $INPUT -o $OUTPUT -i
#include <assert.h>
#include <float.h>
#include <limits.h>
#include <stdio.h>
#include <string.h>

#define YYMAXFILL 17

static const size_t SIZE = 64 * 1024;

struct input_t {
    unsigned char buf[SIZE + YYMAXFILL];
    unsigned char *lim;
    unsigned char *cur;
    unsigned char *mar;
    unsigned char *tok;
    bool eof;

    FILE *const file;

    input_t(FILE *f)
        : buf()
        , lim(buf + SIZE)
        , cur(lim)
        , mar(lim)
        , tok(lim)
        , eof(false)
        , file(f)
    {}
    bool fill(size_t need)
    {
        if (eof) {
            return false;
        }
        const size_t free = tok - buf;
        if (free < need) {
            return false;
        }
        memmove(buf, tok, lim - tok);
        lim -= free;
        cur -= free;
        mar -= free;
        tok -= free;
        lim += fread(lim, 1, free, file);
        if (lim < buf + SIZE) {
            eof = true;
            memset(lim, 0, YYMAXFILL);
            lim += YYMAXFILL;
        }
        return true;
    }
};



template<int base>
static bool adddgt(unsigned long &u, unsigned long d)
{
    if (u > (ULONG_MAX - d) / base) {
        return false;
    }
    u = u * base + d;
    return true;
}

static bool lex_oct(const unsigned char *s, const unsigned char *e, unsigned long &u)
{
    for (u = 0, ++s; s < e; ++s) {
        if (!adddgt<8>(u, *s - 0x30u)) {
            return false;
        }
    }
    return true;
}

static bool lex_dec(const unsigned char *s, const unsigned char *e, unsigned long &u)
{
    for (u = 0; s < e; ++s) {
        if (!adddgt<10>(u, *s - 0x30u)) {
            return false;
        }
    }
    return true;
}

static bool lex_hex(const unsigned char *s, const unsigned char *e, unsigned long &u)
{
    for (u = 0, s += 2; s < e;) {
    
{
	unsigned char yych;
	yych = *s;
	switch (yych) {
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':	goto yy4;
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy6;
	default:	goto yy2;
	}
yy2:
	++s;
	{ if (!adddgt<16>(u, s[-1] - 0x30u))      return false; continue; }
yy4:
	++s;
	{ if (!adddgt<16>(u, s[-1] - 0x41u + 10)) return false; continue; }
yy6:
	++s;
	{ if (!adddgt<16>(u, s[-1] - 0x61u + 10)) return false; continue; }
}

    }
    return true;
}

static bool lex_str(input_t &in, unsigned char q)
{
    fprintf(stderr, "%c", q);
    for (unsigned long u = q;; fprintf(stderr, "\\x%lx", u)) {
        in.tok = in.cur;
        
{
	unsigned char yych;
	if ((in.lim - in.cur) < 10) if (!in.fill(10)) return false;
	yych = *in.cur;
	switch (yych) {
	case '\n':	goto yy12;
	case '\\':	goto yy14;
	default:	goto yy10;
	}
yy10:
	++in.cur;
	{ u = in.tok[0]; if (u == q) break; continue; }
yy12:
	++in.cur;
yy13:
	{ return false; }
yy14:
	yych = *(in.mar = ++in.cur);
	switch (yych) {
	case '"':	goto yy15;
	case '\'':	goto yy17;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy19;
	case '?':	goto yy21;
	case 'U':	goto yy23;
	case '\\':	goto yy25;
	case 'a':	goto yy27;
	case 'b':	goto yy29;
	case 'f':	goto yy31;
	case 'n':	goto yy33;
	case 'r':	goto yy35;
	case 't':	goto yy37;
	case 'u':	goto yy39;
	case 'v':	goto yy40;
	case 'x':	goto yy42;
	default:	goto yy13;
	}
yy15:
	++in.cur;
	{ u = '"';  continue; }
yy17:
	++in.cur;
	{ u = '\''; continue; }
yy19:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy43;
	default:	goto yy20;
	}
yy20:
	{ lex_oct(in.tok, in.cur, u); continue; }
yy21:
	++in.cur;
	{ u = '?';  continue; }
yy23:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy44;
	default:	goto yy24;
	}
yy24:
	in.cur = in.mar;
	goto yy13;
yy25:
	++in.cur;
	{ u = '\\'; continue; }
yy27:
	++in.cur;
	{ u = '\a'; continue; }
yy29:
	++in.cur;
	{ u = '\b'; continue; }
yy31:
	++in.cur;
	{ u = '\f'; continue; }
yy33:
	++in.cur;
	{ u = '\n'; continue; }
yy35:
	++in.cur;
	{ u = '\r'; continue; }
yy37:
	++in.cur;
	{ u = '\t'; continue; }
yy39:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy45;
	default:	goto yy24;
	}
yy40:
	++in.cur;
	{ u = '\v'; continue; }
yy42:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy46;
	default:	goto yy24;
	}
yy43:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy49;
	default:	goto yy20;
	}
yy44:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy50;
	default:	goto yy24;
	}
yy45:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy51;
	default:	goto yy24;
	}
yy46:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy46;
	default:	goto yy48;
	}
yy48:
	{ if (!lex_hex(in.tok, in.cur, u)) return false; continue; }
yy49:
	++in.cur;
	goto yy20;
yy50:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy52;
	default:	goto yy24;
	}
yy51:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy53;
	default:	goto yy24;
	}
yy52:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy54;
	default:	goto yy24;
	}
yy53:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy55;
	default:	goto yy24;
	}
yy54:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy57;
	default:	goto yy24;
	}
yy55:
	++in.cur;
	{ lex_hex(in.tok, in.cur, u); continue; }
yy57:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy58;
	default:	goto yy24;
	}
yy58:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy59;
	default:	goto yy24;
	}
yy59:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy60;
	default:	goto yy24;
	}
yy60:
	++in.cur;
	{ lex_hex(in.tok, in.cur, u); continue; }
}

    }
    fprintf(stderr, "%c", q);
    return true;
}

static bool lex_flt(const unsigned char *s)
{
    double d = 0;
    double x = 1;
    int e = 0;
    
mant_int:
    
{
	unsigned char yych;
	yych = *s;
	switch (yych) {
	case '.':	goto yy66;
	case 'E':
	case 'e':	goto yy68;
	default:	goto yy64;
	}
yy64:
	++s;
	{ d = (d * 10) + (s[-1] - '0'); goto mant_int; }
yy66:
	++s;
	{ goto mant_frac; }
yy68:
	++s;
	{ goto exp_sign; }
}

mant_frac:
    
{
	unsigned char yych;
	yych = *s;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy73;
	case 'E':
	case 'e':	goto yy75;
	default:	goto yy72;
	}
yy72:
	{ goto sfx; }
yy73:
	++s;
	{ d += (x /= 10) * (s[-1] - '0'); goto mant_frac; }
yy75:
	++s;
	{ goto exp_sign; }
}

exp_sign:
    
{
	unsigned char yych;
	yych = *s;
	switch (yych) {
	case '+':	goto yy80;
	case '-':	goto yy81;
	default:	goto yy79;
	}
yy79:
	{ x = 1e+1; goto exp; }
yy80:
	++s;
	goto yy79;
yy81:
	++s;
	{ x = 1e-1; goto exp; }
}

exp:
    
{
	unsigned char yych;
	yych = *s;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy86;
	default:	goto yy85;
	}
yy85:
	{ for (; e > 0; --e) d *= x;    goto sfx; }
yy86:
	++s;
	{ e = (e * 10) + (s[-1] - '0'); goto exp; }
}

sfx:
    
{
	unsigned char yych;
	yych = *s;
	switch (yych) {
	case 'F':
	case 'f':	goto yy92;
	default:	goto yy90;
	}
yy90:
	++s;
	{ goto end; }
yy92:
	++s;
	{ if (d > FLT_MAX) return false; goto end; }
}

end:
    fprintf(stderr, "%g", d);
    return true;
}

static bool lex(input_t &in)
{
    unsigned long u;
    for (;;) {
        in.tok = in.cur;
        
{
	unsigned char yych;
	unsigned int yyaccept = 0;
	if ((in.lim - in.cur) < 17) if (!in.fill(17)) return false;
	yych = *in.cur;
	switch (yych) {
	case 0x00:	goto yy96;
	case '\t':
	case '\n':
	case '\v':
	case '\r':
	case ' ':	goto yy100;
	case '!':	goto yy103;
	case '"':	goto yy105;
	case '#':	goto yy107;
	case '%':	goto yy109;
	case '&':	goto yy111;
	case '\'':	goto yy113;
	case '(':	goto yy114;
	case ')':	goto yy116;
	case '*':	goto yy118;
	case '+':	goto yy120;
	case ',':	goto yy122;
	case '-':	goto yy124;
	case '.':	goto yy126;
	case '/':	goto yy128;
	case '0':	goto yy130;
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy132;
	case ':':	goto yy135;
	case ';':	goto yy137;
	case '<':	goto yy139;
	case '=':	goto yy141;
	case '>':	goto yy143;
	case '?':	goto yy145;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'h':
	case 'j':
	case 'k':
	case 'q':
	case 'y':
	case 'z':	goto yy147;
	case 'L':	goto yy150;
	case '[':	goto yy151;
	case ']':	goto yy153;
	case '^':	goto yy155;
	case 'a':	goto yy157;
	case 'b':	goto yy158;
	case 'c':	goto yy159;
	case 'd':	goto yy160;
	case 'e':	goto yy161;
	case 'f':	goto yy162;
	case 'g':	goto yy163;
	case 'i':	goto yy164;
	case 'l':	goto yy165;
	case 'm':	goto yy166;
	case 'n':	goto yy167;
	case 'o':	goto yy168;
	case 'p':	goto yy169;
	case 'r':	goto yy170;
	case 's':	goto yy171;
	case 't':	goto yy172;
	case 'u':	goto yy173;
	case 'v':	goto yy174;
	case 'w':	goto yy175;
	case 'x':	goto yy176;
	case '{':	goto yy177;
	case '|':	goto yy179;
	case '}':	goto yy181;
	case '~':	goto yy183;
	default:	goto yy98;
	}
yy96:
	++in.cur;
	{
                fprintf(stderr, "\n");
                return in.lim - in.tok == YYMAXFILL;
            }
yy98:
	++in.cur;
	{ return false; }
yy100:
	yyaccept = 0;
	in.mar = ++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
	case '\t':
	case '\n':
	case '\v':
	case '\r':
	case ' ':	goto yy100;
	case '/':	goto yy185;
	default:	goto yy102;
	}
yy102:
	{ fprintf(stderr, " "); continue; }
yy103:
	yych = *++in.cur;
	switch (yych) {
	case '=':	goto yy187;
	default:	goto yy104;
	}
yy104:
	{ fprintf(stderr, "!");      continue; }
yy105:
	++in.cur;
yy106:
	{ if (!lex_str(in, in.cur[-1])) return false; continue; }
yy107:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
	case '\n':	goto yy189;
	case '\\':	goto yy191;
	default:	goto yy107;
	}
yy109:
	yych = *++in.cur;
	switch (yych) {
	case ':':	goto yy107;
	case '=':	goto yy193;
	case '>':	goto yy181;
	default:	goto yy110;
	}
yy110:
	{ fprintf(stderr, "%%");     continue; }
yy111:
	yych = *++in.cur;
	switch (yych) {
	case '&':	goto yy195;
	case '=':	goto yy197;
	default:	goto yy112;
	}
yy112:
	{ fprintf(stderr, "&");      continue; }
yy113:
	yych = *++in.cur;
	switch (yych) {
	case '\'':	goto yy199;
	default:	goto yy106;
	}
yy114:
	++in.cur;
	{ fprintf(stderr, "(");      continue; }
yy116:
	++in.cur;
	{ fprintf(stderr, ")");      continue; }
yy118:
	yych = *++in.cur;
	switch (yych) {
	case '=':	goto yy201;
	default:	goto yy119;
	}
yy119:
	{ fprintf(stderr, "*");      continue; }
yy120:
	yych = *++in.cur;
	switch (yych) {
	case '+':	goto yy203;
	case '=':	goto yy205;
	default:	goto yy121;
	}
yy121:
	{ fprintf(stderr, "+");      continue; }
yy122:
	++in.cur;
	{ fprintf(stderr, ",");      continue; }
yy124:
	yych = *++in.cur;
	switch (yych) {
	case '-':	goto yy207;
	case '=':	goto yy209;
	case '>':	goto yy211;
	default:	goto yy125;
	}
yy125:
	{ fprintf(stderr, "-");      continue; }
yy126:
	yyaccept = 1;
	yych = *(in.mar = ++in.cur);
	switch (yych) {
	case '*':	goto yy213;
	case '.':	goto yy215;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy216;
	default:	goto yy127;
	}
yy127:
	{ fprintf(stderr, ".");      continue; }
yy128:
	yych = *++in.cur;
	switch (yych) {
	case '*':	goto yy219;
	case '/':	goto yy221;
	case '=':	goto yy223;
	default:	goto yy129;
	}
yy129:
	{ fprintf(stderr, "/");      continue; }
yy130:
	yyaccept = 2;
	yych = *(in.mar = ++in.cur);
	switch (yych) {
	case 'X':
	case 'x':	goto yy230;
	default:	goto yy226;
	}
yy131:
	{ if (!lex_oct(in.tok, in.cur, u)) return false; goto sfx; }
yy132:
	yyaccept = 3;
	in.mar = ++in.cur;
	if ((in.lim - in.cur) < 3) if (!in.fill(3)) return false;
	yych = *in.cur;
	switch (yych) {
	case '.':	goto yy216;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy132;
	case 'E':
	case 'e':	goto yy229;
	default:	goto yy134;
	}
yy134:
	{ if (!lex_dec(in.tok, in.cur, u)) return false; goto sfx; }
yy135:
	yych = *++in.cur;
	switch (yych) {
	case ':':	goto yy231;
	case '>':	goto yy153;
	default:	goto yy136;
	}
yy136:
	{ fprintf(stderr, ":");      continue; }
yy137:
	++in.cur;
	{ fprintf(stderr, ";");      continue; }
yy139:
	yych = *++in.cur;
	switch (yych) {
	case '%':	goto yy177;
	case ':':	goto yy151;
	case '<':	goto yy233;
	case '=':	goto yy235;
	default:	goto yy140;
	}
yy140:
	{ fprintf(stderr, "<");      continue; }
yy141:
	yych = *++in.cur;
	switch (yych) {
	case '=':	goto yy237;
	default:	goto yy142;
	}
yy142:
	{ fprintf(stderr, "=");      continue; }
yy143:
	yych = *++in.cur;
	switch (yych) {
	case '=':	goto yy239;
	case '>':	goto yy241;
	default:	goto yy144;
	}
yy144:
	{ fprintf(stderr, ">");      continue; }
yy145:
	++in.cur;
	{ fprintf(stderr, "?");      continue; }
yy147:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
yy148:
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy149;
	}
yy149:
	{ fprintf(stderr, "%.*s", (int)(in.cur - in.tok), in.tok); continue; }
yy150:
	yych = *++in.cur;
	switch (yych) {
	case '"':	goto yy105;
	case '\'':	goto yy113;
	default:	goto yy148;
	}
yy151:
	++in.cur;
	{ fprintf(stderr, "[");      continue; }
yy153:
	++in.cur;
	{ fprintf(stderr, "]");      continue; }
yy155:
	yych = *++in.cur;
	switch (yych) {
	case '=':	goto yy243;
	default:	goto yy156;
	}
yy156:
	{ fprintf(stderr, "^");      continue; }
yy157:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy245;
	case 's':	goto yy246;
	case 'u':	goto yy247;
	default:	goto yy148;
	}
yy158:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy248;
	case 'o':	goto yy249;
	case 'r':	goto yy250;
	default:	goto yy148;
	}
yy159:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy251;
	case 'h':	goto yy252;
	case 'l':	goto yy253;
	case 'o':	goto yy254;
	default:	goto yy148;
	}
yy160:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy255;
	case 'o':	goto yy256;
	case 'y':	goto yy258;
	default:	goto yy148;
	}
yy161:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy259;
	case 'n':	goto yy260;
	case 'x':	goto yy261;
	default:	goto yy148;
	}
yy162:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy262;
	case 'l':	goto yy263;
	case 'o':	goto yy264;
	case 'r':	goto yy265;
	default:	goto yy148;
	}
yy163:
	yych = *++in.cur;
	switch (yych) {
	case 'o':	goto yy266;
	default:	goto yy148;
	}
yy164:
	yych = *++in.cur;
	switch (yych) {
	case 'f':	goto yy267;
	case 'n':	goto yy269;
	default:	goto yy148;
	}
yy165:
	yych = *++in.cur;
	switch (yych) {
	case 'o':	goto yy270;
	default:	goto yy148;
	}
yy166:
	yych = *++in.cur;
	switch (yych) {
	case 'u':	goto yy271;
	default:	goto yy148;
	}
yy167:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy272;
	case 'e':	goto yy273;
	case 'o':	goto yy274;
	default:	goto yy148;
	}
yy168:
	yych = *++in.cur;
	switch (yych) {
	case 'p':	goto yy275;
	case 'r':	goto yy276;
	default:	goto yy148;
	}
yy169:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy278;
	case 'u':	goto yy279;
	default:	goto yy148;
	}
yy170:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy280;
	default:	goto yy148;
	}
yy171:
	yych = *++in.cur;
	switch (yych) {
	case 'h':	goto yy281;
	case 'i':	goto yy282;
	case 't':	goto yy283;
	case 'w':	goto yy284;
	default:	goto yy148;
	}
yy172:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy285;
	case 'h':	goto yy286;
	case 'r':	goto yy287;
	case 'y':	goto yy288;
	default:	goto yy148;
	}
yy173:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy289;
	case 's':	goto yy290;
	default:	goto yy148;
	}
yy174:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy291;
	case 'o':	goto yy292;
	default:	goto yy148;
	}
yy175:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy293;
	case 'h':	goto yy294;
	default:	goto yy148;
	}
yy176:
	yych = *++in.cur;
	switch (yych) {
	case 'o':	goto yy295;
	default:	goto yy148;
	}
yy177:
	++in.cur;
	{ fprintf(stderr, "{");      continue; }
yy179:
	yych = *++in.cur;
	switch (yych) {
	case '=':	goto yy296;
	case '|':	goto yy298;
	default:	goto yy180;
	}
yy180:
	{ fprintf(stderr, "|");      continue; }
yy181:
	++in.cur;
	{ fprintf(stderr, "}");      continue; }
yy183:
	++in.cur;
yy184:
	{ fprintf(stderr, "~");      continue; }
yy185:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
	case '*':	goto yy219;
	case '/':	goto yy221;
	default:	goto yy186;
	}
yy186:
	in.cur = in.mar;
	switch (yyaccept) {
	case 0:
		goto yy102;
	case 1:
		goto yy127;
	case 2:
		goto yy131;
	case 3:
		goto yy134;
	default:
		goto yy218;
	}
yy187:
	++in.cur;
yy188:
	{ fprintf(stderr, "!=");     continue; }
yy189:
	++in.cur;
	{ continue; }
yy191:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
	case '\\':	goto yy191;
	default:	goto yy107;
	}
yy193:
	++in.cur;
	{ fprintf(stderr, "%%=");    continue; }
yy195:
	++in.cur;
yy196:
	{ fprintf(stderr, "&&");     continue; }
yy197:
	++in.cur;
yy198:
	{ fprintf(stderr, "&=");     continue; }
yy199:
	++in.cur;
	{ return false; }
yy201:
	++in.cur;
	{ fprintf(stderr, "*=");     continue; }
yy203:
	++in.cur;
	{ fprintf(stderr, "++");     continue; }
yy205:
	++in.cur;
	{ fprintf(stderr, "+=");     continue; }
yy207:
	++in.cur;
	{ fprintf(stderr, "--");     continue; }
yy209:
	++in.cur;
	{ fprintf(stderr, "-=");     continue; }
yy211:
	yych = *++in.cur;
	switch (yych) {
	case '*':	goto yy299;
	default:	goto yy212;
	}
yy212:
	{ fprintf(stderr, "->");     continue; }
yy213:
	++in.cur;
	{ fprintf(stderr, ".");      continue; }
yy215:
	yych = *++in.cur;
	switch (yych) {
	case '.':	goto yy301;
	default:	goto yy186;
	}
yy216:
	yyaccept = 4;
	in.mar = ++in.cur;
	if ((in.lim - in.cur) < 3) if (!in.fill(3)) return false;
	yych = *in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy216;
	case 'E':
	case 'e':	goto yy229;
	case 'F':
	case 'L':
	case 'f':
	case 'l':	goto yy303;
	default:	goto yy218;
	}
yy218:
	{ if (lex_flt(in.tok)) continue; return false; }
yy219:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
	case '*':	goto yy304;
	default:	goto yy219;
	}
yy221:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
	case '\n':	goto yy100;
	default:	goto yy221;
	}
yy223:
	++in.cur;
	{ fprintf(stderr, "/=");     continue; }
yy225:
	yyaccept = 2;
	in.mar = ++in.cur;
	if ((in.lim - in.cur) < 3) if (!in.fill(3)) return false;
	yych = *in.cur;
yy226:
	switch (yych) {
	case '.':	goto yy216;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':	goto yy225;
	case '8':
	case '9':	goto yy227;
	case 'E':
	case 'e':	goto yy229;
	default:	goto yy131;
	}
yy227:
	++in.cur;
	if ((in.lim - in.cur) < 3) if (!in.fill(3)) return false;
	yych = *in.cur;
	switch (yych) {
	case '.':	goto yy216;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy227;
	case 'E':
	case 'e':	goto yy229;
	default:	goto yy186;
	}
yy229:
	yych = *++in.cur;
	switch (yych) {
	case '+':
	case '-':	goto yy305;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy306;
	default:	goto yy186;
	}
yy230:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy308;
	default:	goto yy186;
	}
yy231:
	++in.cur;
	{ fprintf(stderr, "::");     continue; }
yy233:
	yych = *++in.cur;
	switch (yych) {
	case '=':	goto yy311;
	default:	goto yy234;
	}
yy234:
	{ fprintf(stderr, "<<");     continue; }
yy235:
	++in.cur;
	{ fprintf(stderr, "<=");     continue; }
yy237:
	++in.cur;
	{ fprintf(stderr, "==");     continue; }
yy239:
	++in.cur;
	{ fprintf(stderr, ">=");     continue; }
yy241:
	yych = *++in.cur;
	switch (yych) {
	case '=':	goto yy313;
	default:	goto yy242;
	}
yy242:
	{ fprintf(stderr, ">>");     continue; }
yy243:
	++in.cur;
yy244:
	{ fprintf(stderr, "^=");     continue; }
yy245:
	yych = *++in.cur;
	switch (yych) {
	case 'd':	goto yy315;
	default:	goto yy148;
	}
yy246:
	yych = *++in.cur;
	switch (yych) {
	case 'm':	goto yy316;
	default:	goto yy148;
	}
yy247:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy318;
	default:	goto yy148;
	}
yy248:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy319;
	default:	goto yy148;
	}
yy249:
	yych = *++in.cur;
	switch (yych) {
	case 'o':	goto yy320;
	default:	goto yy148;
	}
yy250:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy321;
	default:	goto yy148;
	}
yy251:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy322;
	case 't':	goto yy323;
	default:	goto yy148;
	}
yy252:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy324;
	default:	goto yy148;
	}
yy253:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy325;
	default:	goto yy148;
	}
yy254:
	yych = *++in.cur;
	switch (yych) {
	case 'm':	goto yy326;
	case 'n':	goto yy327;
	default:	goto yy148;
	}
yy255:
	yych = *++in.cur;
	switch (yych) {
	case 'f':	goto yy328;
	case 'l':	goto yy329;
	default:	goto yy148;
	}
yy256:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case 'u':	goto yy330;
	default:	goto yy257;
	}
yy257:
	{ fprintf(stderr, "DO");               continue; }
yy258:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy331;
	default:	goto yy148;
	}
yy259:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy332;
	default:	goto yy148;
	}
yy260:
	yych = *++in.cur;
	switch (yych) {
	case 'u':	goto yy333;
	default:	goto yy148;
	}
yy261:
	yych = *++in.cur;
	switch (yych) {
	case 'p':	goto yy334;
	case 't':	goto yy335;
	default:	goto yy148;
	}
yy262:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy336;
	default:	goto yy148;
	}
yy263:
	yych = *++in.cur;
	switch (yych) {
	case 'o':	goto yy337;
	default:	goto yy148;
	}
yy264:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy338;
	default:	goto yy148;
	}
yy265:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy340;
	default:	goto yy148;
	}
yy266:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy341;
	default:	goto yy148;
	}
yy267:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy268;
	}
yy268:
	{ fprintf(stderr, "IF");               continue; }
yy269:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy342;
	case 't':	goto yy343;
	default:	goto yy148;
	}
yy270:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy345;
	default:	goto yy148;
	}
yy271:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy346;
	default:	goto yy148;
	}
yy272:
	yych = *++in.cur;
	switch (yych) {
	case 'm':	goto yy347;
	default:	goto yy148;
	}
yy273:
	yych = *++in.cur;
	switch (yych) {
	case 'w':	goto yy348;
	default:	goto yy148;
	}
yy274:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy350;
	default:	goto yy148;
	}
yy275:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy351;
	default:	goto yy148;
	}
yy276:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case '_':	goto yy352;
	default:	goto yy277;
	}
yy277:
	{ fprintf(stderr, "||");     continue; }
yy278:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy353;
	case 'o':	goto yy354;
	default:	goto yy148;
	}
yy279:
	yych = *++in.cur;
	switch (yych) {
	case 'b':	goto yy355;
	default:	goto yy148;
	}
yy280:
	yych = *++in.cur;
	switch (yych) {
	case 'g':	goto yy356;
	case 'i':	goto yy357;
	case 't':	goto yy358;
	default:	goto yy148;
	}
yy281:
	yych = *++in.cur;
	switch (yych) {
	case 'o':	goto yy359;
	default:	goto yy148;
	}
yy282:
	yych = *++in.cur;
	switch (yych) {
	case 'g':	goto yy360;
	case 'z':	goto yy361;
	default:	goto yy148;
	}
yy283:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy362;
	case 'r':	goto yy363;
	default:	goto yy148;
	}
yy284:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy364;
	default:	goto yy148;
	}
yy285:
	yych = *++in.cur;
	switch (yych) {
	case 'm':	goto yy365;
	default:	goto yy148;
	}
yy286:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy366;
	case 'r':	goto yy367;
	default:	goto yy148;
	}
yy287:
	yych = *++in.cur;
	switch (yych) {
	case 'u':	goto yy368;
	case 'y':	goto yy369;
	default:	goto yy148;
	}
yy288:
	yych = *++in.cur;
	switch (yych) {
	case 'p':	goto yy371;
	default:	goto yy148;
	}
yy289:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy372;
	case 's':	goto yy373;
	default:	goto yy148;
	}
yy290:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy374;
	default:	goto yy148;
	}
yy291:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy375;
	default:	goto yy148;
	}
yy292:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy376;
	case 'l':	goto yy377;
	default:	goto yy148;
	}
yy293:
	yych = *++in.cur;
	switch (yych) {
	case 'h':	goto yy378;
	default:	goto yy148;
	}
yy294:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy379;
	default:	goto yy148;
	}
yy295:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy380;
	default:	goto yy148;
	}
yy296:
	++in.cur;
yy297:
	{ fprintf(stderr, "|=");     continue; }
yy298:
	++in.cur;
	goto yy277;
yy299:
	++in.cur;
	{ fprintf(stderr, "->*");    continue; }
yy301:
	++in.cur;
	{ fprintf(stderr, "...");    continue; }
yy303:
	++in.cur;
	goto yy218;
yy304:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
	case '/':	goto yy100;
	default:	goto yy219;
	}
yy305:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy306;
	default:	goto yy186;
	}
yy306:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':	goto yy306;
	case 'F':
	case 'L':
	case 'f':
	case 'l':	goto yy303;
	default:	goto yy218;
	}
yy308:
	++in.cur;
	if (in.lim <= in.cur) if (!in.fill(1)) return false;
	yych = *in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':	goto yy308;
	default:	goto yy310;
	}
yy310:
	{ if (!lex_hex(in.tok, in.cur, u)) return false; goto sfx; }
yy311:
	++in.cur;
	{ fprintf(stderr, "<<=");    continue; }
yy313:
	++in.cur;
	{ fprintf(stderr, ">>=");    continue; }
yy315:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case '_':	goto yy381;
	default:	goto yy196;
	}
yy316:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy317;
	}
yy317:
	{ fprintf(stderr, "ASM");              continue; }
yy318:
	yych = *++in.cur;
	switch (yych) {
	case 'o':	goto yy382;
	default:	goto yy148;
	}
yy319:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy384;
	case 'o':	goto yy385;
	default:	goto yy148;
	}
yy320:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy386;
	default:	goto yy148;
	}
yy321:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy388;
	default:	goto yy148;
	}
yy322:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy389;
	default:	goto yy148;
	}
yy323:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy391;
	default:	goto yy148;
	}
yy324:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy392;
	default:	goto yy148;
	}
yy325:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy394;
	default:	goto yy148;
	}
yy326:
	yych = *++in.cur;
	switch (yych) {
	case 'p':	goto yy395;
	default:	goto yy148;
	}
yy327:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy396;
	case 't':	goto yy397;
	default:	goto yy148;
	}
yy328:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy398;
	default:	goto yy148;
	}
yy329:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy399;
	default:	goto yy148;
	}
yy330:
	yych = *++in.cur;
	switch (yych) {
	case 'b':	goto yy400;
	default:	goto yy148;
	}
yy331:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy401;
	default:	goto yy148;
	}
yy332:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy402;
	default:	goto yy148;
	}
yy333:
	yych = *++in.cur;
	switch (yych) {
	case 'm':	goto yy404;
	default:	goto yy148;
	}
yy334:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy406;
	case 'o':	goto yy407;
	default:	goto yy148;
	}
yy335:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy408;
	default:	goto yy148;
	}
yy336:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy409;
	default:	goto yy148;
	}
yy337:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy410;
	default:	goto yy148;
	}
yy338:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy339;
	}
yy339:
	{ fprintf(stderr, "FOR");              continue; }
yy340:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy411;
	default:	goto yy148;
	}
yy341:
	yych = *++in.cur;
	switch (yych) {
	case 'o':	goto yy412;
	default:	goto yy148;
	}
yy342:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy414;
	default:	goto yy148;
	}
yy343:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy344;
	}
yy344:
	{ fprintf(stderr, "INT");              continue; }
yy345:
	yych = *++in.cur;
	switch (yych) {
	case 'g':	goto yy415;
	default:	goto yy148;
	}
yy346:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy417;
	default:	goto yy148;
	}
yy347:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy418;
	default:	goto yy148;
	}
yy348:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy349;
	}
yy349:
	{ fprintf(stderr, "new");    continue; }
yy350:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case '_':	goto yy419;
	default:	goto yy104;
	}
yy351:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy420;
	default:	goto yy148;
	}
yy352:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy421;
	default:	goto yy148;
	}
yy353:
	yych = *++in.cur;
	switch (yych) {
	case 'v':	goto yy422;
	default:	goto yy148;
	}
yy354:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy423;
	default:	goto yy148;
	}
yy355:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy424;
	default:	goto yy148;
	}
yy356:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy425;
	default:	goto yy148;
	}
yy357:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy426;
	default:	goto yy148;
	}
yy358:
	yych = *++in.cur;
	switch (yych) {
	case 'u':	goto yy427;
	default:	goto yy148;
	}
yy359:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy428;
	default:	goto yy148;
	}
yy360:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy429;
	default:	goto yy148;
	}
yy361:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy430;
	default:	goto yy148;
	}
yy362:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy431;
	default:	goto yy148;
	}
yy363:
	yych = *++in.cur;
	switch (yych) {
	case 'u':	goto yy432;
	default:	goto yy148;
	}
yy364:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy433;
	default:	goto yy148;
	}
yy365:
	yych = *++in.cur;
	switch (yych) {
	case 'p':	goto yy434;
	default:	goto yy148;
	}
yy366:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy435;
	default:	goto yy148;
	}
yy367:
	yych = *++in.cur;
	switch (yych) {
	case 'o':	goto yy437;
	default:	goto yy148;
	}
yy368:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy438;
	default:	goto yy148;
	}
yy369:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy370;
	}
yy370:
	{ fprintf(stderr, "TRY");              continue; }
yy371:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy440;
	default:	goto yy148;
	}
yy372:
	yych = *++in.cur;
	switch (yych) {
	case 'o':	goto yy441;
	default:	goto yy148;
	}
yy373:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy442;
	default:	goto yy148;
	}
yy374:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy443;
	default:	goto yy148;
	}
yy375:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy444;
	default:	goto yy148;
	}
yy376:
	yych = *++in.cur;
	switch (yych) {
	case 'd':	goto yy445;
	default:	goto yy148;
	}
yy377:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy447;
	default:	goto yy148;
	}
yy378:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy448;
	default:	goto yy148;
	}
yy379:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy449;
	default:	goto yy148;
	}
yy380:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case '_':	goto yy450;
	default:	goto yy156;
	}
yy381:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy451;
	default:	goto yy148;
	}
yy382:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy383;
	}
yy383:
	{ fprintf(stderr, "AUTO");             continue; }
yy384:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy452;
	default:	goto yy148;
	}
yy385:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy453;
	default:	goto yy148;
	}
yy386:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy387;
	}
yy387:
	{ fprintf(stderr, "BOOL");             continue; }
yy388:
	yych = *++in.cur;
	switch (yych) {
	case 'k':	goto yy454;
	default:	goto yy148;
	}
yy389:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy390;
	}
yy390:
	{ fprintf(stderr, "CASE");             continue; }
yy391:
	yych = *++in.cur;
	switch (yych) {
	case 'h':	goto yy456;
	default:	goto yy148;
	}
yy392:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy393;
	}
yy393:
	{ fprintf(stderr, "CHAR");             continue; }
yy394:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy458;
	default:	goto yy148;
	}
yy395:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy460;
	default:	goto yy148;
	}
yy396:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy461;
	default:	goto yy148;
	}
yy397:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy463;
	default:	goto yy148;
	}
yy398:
	yych = *++in.cur;
	switch (yych) {
	case 'u':	goto yy464;
	default:	goto yy148;
	}
yy399:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy465;
	default:	goto yy148;
	}
yy400:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy466;
	default:	goto yy148;
	}
yy401:
	yych = *++in.cur;
	switch (yych) {
	case 'm':	goto yy467;
	default:	goto yy148;
	}
yy402:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy403;
	}
yy403:
	{ fprintf(stderr, "ELSE");             continue; }
yy404:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy405;
	}
yy405:
	{ fprintf(stderr, "ENUM");             continue; }
yy406:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy468;
	default:	goto yy148;
	}
yy407:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy469;
	default:	goto yy148;
	}
yy408:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy470;
	default:	goto yy148;
	}
yy409:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy471;
	default:	goto yy148;
	}
yy410:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy473;
	default:	goto yy148;
	}
yy411:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy475;
	default:	goto yy148;
	}
yy412:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy413;
	}
yy413:
	{ fprintf(stderr, "GOTO");             continue; }
yy414:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy476;
	default:	goto yy148;
	}
yy415:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy416;
	}
yy416:
	{ fprintf(stderr, "LONG");             continue; }
yy417:
	yych = *++in.cur;
	switch (yych) {
	case 'b':	goto yy477;
	default:	goto yy148;
	}
yy418:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy478;
	default:	goto yy148;
	}
yy419:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy479;
	default:	goto yy148;
	}
yy420:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy480;
	default:	goto yy148;
	}
yy421:
	yych = *++in.cur;
	switch (yych) {
	case 'q':	goto yy481;
	default:	goto yy148;
	}
yy422:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy482;
	default:	goto yy148;
	}
yy423:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy483;
	default:	goto yy148;
	}
yy424:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy484;
	default:	goto yy148;
	}
yy425:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy485;
	default:	goto yy148;
	}
yy426:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy486;
	default:	goto yy148;
	}
yy427:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy487;
	default:	goto yy148;
	}
yy428:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy488;
	default:	goto yy148;
	}
yy429:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy490;
	default:	goto yy148;
	}
yy430:
	yych = *++in.cur;
	switch (yych) {
	case 'o':	goto yy491;
	default:	goto yy148;
	}
yy431:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy492;
	default:	goto yy148;
	}
yy432:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy493;
	default:	goto yy148;
	}
yy433:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy494;
	default:	goto yy148;
	}
yy434:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy495;
	default:	goto yy148;
	}
yy435:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy436;
	}
yy436:
	{ fprintf(stderr, "THIS");             continue; }
yy437:
	yych = *++in.cur;
	switch (yych) {
	case 'w':	goto yy496;
	default:	goto yy148;
	}
yy438:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy439;
	}
yy439:
	{ fprintf(stderr, "true");  continue; }
yy440:
	yych = *++in.cur;
	switch (yych) {
	case 'd':	goto yy498;
	case 'i':	goto yy499;
	case 'n':	goto yy500;
	default:	goto yy148;
	}
yy441:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy501;
	default:	goto yy148;
	}
yy442:
	yych = *++in.cur;
	switch (yych) {
	case 'g':	goto yy503;
	default:	goto yy148;
	}
yy443:
	yych = *++in.cur;
	switch (yych) {
	case 'g':	goto yy504;
	default:	goto yy148;
	}
yy444:
	yych = *++in.cur;
	switch (yych) {
	case 'u':	goto yy506;
	default:	goto yy148;
	}
yy445:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy446;
	}
yy446:
	{ fprintf(stderr, "VOID");             continue; }
yy447:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy507;
	default:	goto yy148;
	}
yy448:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy508;
	default:	goto yy148;
	}
yy449:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy509;
	default:	goto yy148;
	}
yy450:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy511;
	default:	goto yy148;
	}
yy451:
	yych = *++in.cur;
	switch (yych) {
	case 'q':	goto yy512;
	default:	goto yy148;
	}
yy452:
	yych = *++in.cur;
	switch (yych) {
	case 'd':	goto yy513;
	default:	goto yy148;
	}
yy453:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy180;
	}
yy454:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy455;
	}
yy455:
	{ fprintf(stderr, "BREAK");            continue; }
yy456:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy457;
	}
yy457:
	{ fprintf(stderr, "CATCH");            continue; }
yy458:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy459;
	}
yy459:
	{ fprintf(stderr, "CLASS");            continue; }
yy460:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy184;
	}
yy461:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case '_':	goto yy514;
	default:	goto yy462;
	}
yy462:
	{ fprintf(stderr, "CONST");            continue; }
yy463:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy515;
	default:	goto yy148;
	}
yy464:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy516;
	default:	goto yy148;
	}
yy465:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy517;
	default:	goto yy148;
	}
yy466:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy519;
	default:	goto yy148;
	}
yy467:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy521;
	default:	goto yy148;
	}
yy468:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy522;
	default:	goto yy148;
	}
yy469:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy523;
	default:	goto yy148;
	}
yy470:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy525;
	default:	goto yy148;
	}
yy471:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy472;
	}
yy472:
	{ fprintf(stderr, "false"); continue; }
yy473:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy474;
	}
yy474:
	{ fprintf(stderr, "FLOAT");            continue; }
yy475:
	yych = *++in.cur;
	switch (yych) {
	case 'd':	goto yy527;
	default:	goto yy148;
	}
yy476:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy529;
	default:	goto yy148;
	}
yy477:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy531;
	default:	goto yy148;
	}
yy478:
	yych = *++in.cur;
	switch (yych) {
	case 'p':	goto yy532;
	default:	goto yy148;
	}
yy479:
	yych = *++in.cur;
	switch (yych) {
	case 'q':	goto yy533;
	default:	goto yy148;
	}
yy480:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy534;
	default:	goto yy148;
	}
yy481:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy297;
	}
yy482:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy535;
	default:	goto yy148;
	}
yy483:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy536;
	default:	goto yy148;
	}
yy484:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy537;
	default:	goto yy148;
	}
yy485:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy539;
	default:	goto yy148;
	}
yy486:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy540;
	default:	goto yy148;
	}
yy487:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy541;
	default:	goto yy148;
	}
yy488:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy489;
	}
yy489:
	{ fprintf(stderr, "SHORT");            continue; }
yy490:
	yych = *++in.cur;
	switch (yych) {
	case 'd':	goto yy543;
	default:	goto yy148;
	}
yy491:
	yych = *++in.cur;
	switch (yych) {
	case 'f':	goto yy545;
	default:	goto yy148;
	}
yy492:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy547;
	default:	goto yy148;
	}
yy493:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy549;
	default:	goto yy148;
	}
yy494:
	yych = *++in.cur;
	switch (yych) {
	case 'h':	goto yy551;
	default:	goto yy148;
	}
yy495:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy553;
	default:	goto yy148;
	}
yy496:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy497;
	}
yy497:
	{ fprintf(stderr, "THROW");            continue; }
yy498:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy554;
	default:	goto yy148;
	}
yy499:
	yych = *++in.cur;
	switch (yych) {
	case 'd':	goto yy555;
	default:	goto yy148;
	}
yy500:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy557;
	default:	goto yy148;
	}
yy501:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy502;
	}
yy502:
	{ fprintf(stderr, "UNION");            continue; }
yy503:
	yych = *++in.cur;
	switch (yych) {
	case 'n':	goto yy558;
	default:	goto yy148;
	}
yy504:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy505;
	}
yy505:
	{ fprintf(stderr, "USING");            continue; }
yy506:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy559;
	default:	goto yy148;
	}
yy507:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy560;
	default:	goto yy148;
	}
yy508:
	yych = *++in.cur;
	switch (yych) {
	case '_':	goto yy561;
	default:	goto yy148;
	}
yy509:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy510;
	}
yy510:
	{ fprintf(stderr, "WHILE");            continue; }
yy511:
	yych = *++in.cur;
	switch (yych) {
	case 'q':	goto yy562;
	default:	goto yy148;
	}
yy512:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy198;
	}
yy513:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy112;
	}
yy514:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy563;
	default:	goto yy148;
	}
yy515:
	yych = *++in.cur;
	switch (yych) {
	case 'u':	goto yy564;
	default:	goto yy148;
	}
yy516:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy565;
	default:	goto yy148;
	}
yy517:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy518;
	}
yy518:
	{ fprintf(stderr, "delete"); continue; }
yy519:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy520;
	}
yy520:
	{ fprintf(stderr, "DOUBLE");           continue; }
yy521:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy567;
	default:	goto yy148;
	}
yy522:
	yych = *++in.cur;
	switch (yych) {
	case 'i':	goto yy568;
	default:	goto yy148;
	}
yy523:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy524;
	}
yy524:
	{ fprintf(stderr, "EXPORT");           continue; }
yy525:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy526;
	}
yy526:
	{ fprintf(stderr, "EXTERN");           continue; }
yy527:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy528;
	}
yy528:
	{ fprintf(stderr, "FRIEND");           continue; }
yy529:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy530;
	}
yy530:
	{ fprintf(stderr, "INLINE");           continue; }
yy531:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy569;
	default:	goto yy148;
	}
yy532:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy571;
	default:	goto yy148;
	}
yy533:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy188;
	}
yy534:
	yych = *++in.cur;
	switch (yych) {
	case 'o':	goto yy572;
	default:	goto yy148;
	}
yy535:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy573;
	default:	goto yy148;
	}
yy536:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy575;
	default:	goto yy148;
	}
yy537:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy538;
	}
yy538:
	{ fprintf(stderr, "PUBLIC");           continue; }
yy539:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy576;
	default:	goto yy148;
	}
yy540:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy577;
	default:	goto yy148;
	}
yy541:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy542;
	}
yy542:
	{ fprintf(stderr, "RETURN");           continue; }
yy543:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy544;
	}
yy544:
	{ fprintf(stderr, "SIGNED");           continue; }
yy545:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy546;
	}
yy546:
	{ fprintf(stderr, "SIZEOF");           continue; }
yy547:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	case '_':	goto yy578;
	default:	goto yy548;
	}
yy548:
	{ fprintf(stderr, "STATIC");           continue; }
yy549:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy550;
	}
yy550:
	{ fprintf(stderr, "STRUCT");           continue; }
yy551:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy552;
	}
yy552:
	{ fprintf(stderr, "SWITCH");           continue; }
yy553:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy579;
	default:	goto yy148;
	}
yy554:
	yych = *++in.cur;
	switch (yych) {
	case 'f':	goto yy580;
	default:	goto yy148;
	}
yy555:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy556;
	}
yy556:
	{ fprintf(stderr, "TYPEID");           continue; }
yy557:
	yych = *++in.cur;
	switch (yych) {
	case 'm':	goto yy582;
	default:	goto yy148;
	}
yy558:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy583;
	default:	goto yy148;
	}
yy559:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy584;
	default:	goto yy148;
	}
yy560:
	yych = *++in.cur;
	switch (yych) {
	case 'l':	goto yy586;
	default:	goto yy148;
	}
yy561:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy587;
	default:	goto yy148;
	}
yy562:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy244;
	}
yy563:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy589;
	default:	goto yy148;
	}
yy564:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy590;
	default:	goto yy148;
	}
yy565:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy566;
	}
yy566:
	{ fprintf(stderr, "DEFAULT");          continue; }
yy567:
	yych = *++in.cur;
	switch (yych) {
	case '_':	goto yy592;
	default:	goto yy148;
	}
yy568:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy593;
	default:	goto yy148;
	}
yy569:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy570;
	}
yy570:
	{ fprintf(stderr, "MUTABLE");          continue; }
yy571:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy595;
	default:	goto yy148;
	}
yy572:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy596;
	default:	goto yy148;
	}
yy573:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy574;
	}
yy574:
	{ fprintf(stderr, "PRIVATE");          continue; }
yy575:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy598;
	default:	goto yy148;
	}
yy576:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy599;
	default:	goto yy148;
	}
yy577:
	yych = *++in.cur;
	switch (yych) {
	case 'p':	goto yy601;
	default:	goto yy148;
	}
yy578:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy602;
	default:	goto yy148;
	}
yy579:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy603;
	default:	goto yy148;
	}
yy580:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy581;
	}
yy581:
	{ fprintf(stderr, "TYPEDEF");          continue; }
yy582:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy605;
	default:	goto yy148;
	}
yy583:
	yych = *++in.cur;
	switch (yych) {
	case 'd':	goto yy607;
	default:	goto yy148;
	}
yy584:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy585;
	}
yy585:
	{ fprintf(stderr, "VIRTUAL");          continue; }
yy586:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy609;
	default:	goto yy148;
	}
yy587:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy588;
	}
yy588:
	{ fprintf(stderr, "WCHAR_T");          continue; }
yy589:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy611;
	default:	goto yy148;
	}
yy590:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy591;
	}
yy591:
	{ fprintf(stderr, "CONTINUE");         continue; }
yy592:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy612;
	default:	goto yy148;
	}
yy593:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy594;
	}
yy594:
	{ fprintf(stderr, "EXPLICIT");         continue; }
yy595:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy613;
	default:	goto yy148;
	}
yy596:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy597;
	}
yy597:
	{ fprintf(stderr, "OPERATOR");         continue; }
yy598:
	yych = *++in.cur;
	switch (yych) {
	case 'd':	goto yy615;
	default:	goto yy148;
	}
yy599:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy600;
	}
yy600:
	{ fprintf(stderr, "REGISTER");         continue; }
yy601:
	yych = *++in.cur;
	switch (yych) {
	case 'r':	goto yy617;
	default:	goto yy148;
	}
yy602:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy618;
	default:	goto yy148;
	}
yy603:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy604;
	}
yy604:
	{ fprintf(stderr, "TEMPLATE");         continue; }
yy605:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy606;
	}
yy606:
	{ fprintf(stderr, "TYPENAME");         continue; }
yy607:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy608;
	}
yy608:
	{ fprintf(stderr, "UNSIGNED");         continue; }
yy609:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy610;
	}
yy610:
	{ fprintf(stderr, "VOLATILE");         continue; }
yy611:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy619;
	default:	goto yy148;
	}
yy612:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy621;
	default:	goto yy148;
	}
yy613:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy614;
	}
yy614:
	{ fprintf(stderr, "NAMESPACE");        continue; }
yy615:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy616;
	}
yy616:
	{ fprintf(stderr, "PROTECTED");        continue; }
yy617:
	yych = *++in.cur;
	switch (yych) {
	case 'e':	goto yy622;
	default:	goto yy148;
	}
yy618:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy623;
	default:	goto yy148;
	}
yy619:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy620;
	}
yy620:
	{ fprintf(stderr, "CONST_CAST");       continue; }
yy621:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy624;
	default:	goto yy148;
	}
yy622:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy625;
	default:	goto yy148;
	}
yy623:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy626;
	default:	goto yy148;
	}
yy624:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy628;
	default:	goto yy148;
	}
yy625:
	yych = *++in.cur;
	switch (yych) {
	case '_':	goto yy630;
	default:	goto yy148;
	}
yy626:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy627;
	}
yy627:
	{ fprintf(stderr, "STATIC_CAST");      continue; }
yy628:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy629;
	}
yy629:
	{ fprintf(stderr, "DYNAMIC_CAST");     continue; }
yy630:
	yych = *++in.cur;
	switch (yych) {
	case 'c':	goto yy631;
	default:	goto yy148;
	}
yy631:
	yych = *++in.cur;
	switch (yych) {
	case 'a':	goto yy632;
	default:	goto yy148;
	}
yy632:
	yych = *++in.cur;
	switch (yych) {
	case 's':	goto yy633;
	default:	goto yy148;
	}
yy633:
	yych = *++in.cur;
	switch (yych) {
	case 't':	goto yy634;
	default:	goto yy148;
	}
yy634:
	yych = *++in.cur;
	switch (yych) {
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	case 'h':
	case 'i':
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	case 'w':
	case 'x':
	case 'y':
	case 'z':	goto yy147;
	default:	goto yy635;
	}
yy635:
	{ fprintf(stderr, "REINTERPRET_CAST"); continue; }
}

sfx:
        
{
	unsigned char yych;
	if ((in.lim - in.cur) < 2) if (!in.fill(2)) return false;
	yych = *in.cur;
	switch (yych) {
	case 'L':
	case 'l':	goto yy639;
	case 'U':
	case 'u':	goto yy641;
	default:	goto yy638;
	}
yy638:
	{ if (u > INT_MAX)  return false; fprintf(stderr, "%d",  static_cast<int>(u));      continue; }
yy639:
	yych = *++in.cur;
	switch (yych) {
	case 'U':
	case 'u':	goto yy643;
	default:	goto yy640;
	}
yy640:
	{ if (u > LONG_MAX) return false; fprintf(stderr, "%ld", static_cast<long>(u));     continue; }
yy641:
	yych = *++in.cur;
	switch (yych) {
	case 'L':
	case 'l':	goto yy643;
	default:	goto yy642;
	}
yy642:
	{ if (u > UINT_MAX) return false; fprintf(stderr, "%u",  static_cast<unsigned>(u)); continue; }
yy643:
	++in.cur;
	{ fprintf(stderr, "%lu", u); continue; }
}

    }
}

int main()
{
    const char *fname = "example.cpp";
    FILE *f;

    // prepare input file
    f = fopen(fname, "w");
    fprintf(f,
        "#include<stdio.h>\n"
        "\n"
        "int main()\n"
        "{\n"
        "    int n;\n"
        "    printf(\"Enter the number:\\n\");\n"
        "    scanf(\"%%d\", &n);\n"
        "\n"
        "    int f = 1;\n"
        "    for(int i = 1; i <= n; ++i) {\n"
        "        f *= i;\n"
        "    }\n"
        "\n"
        "    printf(\"Factorial of %%d is %%d\\n\", n, f);\n"
        "    return 0;\n"
        "}\n"
        "\n");
    fclose(f);

    f = fopen(fname, "rb");
    input_t in(f);
    assert(lex(in));
    fclose(f);

    // cleanup
    remove(fname);
    return 0;
}
c/real_world/cxx98.re:158:14: warning: rule matches empty string [-Wmatch-empty-string]
