/*
 *  libkarma/md5.h - RFC 1321 compliant MD5 implementation
 *
 *  Copyright (c) Christophe Devine 2001-2003
 *            (c) Frank Zschockelt 2004
 *
 * You may distribute and modify this program under the terms of 
 * the GNU GPL, version 2 or later.
 *
 */

#ifndef _MD5_H
#define _MD5_H

#include <inttypes.h>

typedef struct
{
    uint32_t total[2];
    uint32_t state[4];
    uint8_t  buffer[64];
} md5_context;

void md5_starts( md5_context *ctx );
void md5_update( md5_context *ctx, uint8_t *input, uint32_t length );
void md5_finish( md5_context *ctx, uint8_t digest[16] );

#endif /* _MD5_H */
