#ifndef KS_PIECE_H
#define KS_PIECE_H

#include "base/piece.h"


class KSPieceInfo : public GPieceInfo
{
 public:
	KSPieceInfo() {}

	uint nbBlocks() const                   { return NB_BLOCKS; }
	uint nbForms()  const                   { return NB_FORMS; }
	uint nbTypes()  const                   { return NB_FORMS; }

	const int *i(uint form, uint rot) const { return FORMS[form].i[rot]; }
	const int *j(uint form, uint rot) const { return FORMS[form].j[rot]; }
	uint value(uint type, uint) const       { return type; }
	uint form(uint type) const              { return type; }
	uint nbConfigurations(uint type) const  { return FORMS[type].nbConfigs; }

	uint nbNormalBlockTypes() const         { return NB_FORMS; }
    uint nbGarbageBlockTypes() const        { return 1; }
	uint nbBlockModes() const               { return 1; }

 private:
    void draw(QPixmap *, uint blockType, uint blockMode, bool lighted) const;

    enum { NB_BLOCKS = 4,
           NB_FORMS  = 7 };

    struct Form {
        int i[4][NB_BLOCKS];
        int j[4][NB_BLOCKS];
        uint nbConfigs;
    };
    static const Form FORMS[NB_FORMS];
    static const QColor COLORS[NB_FORMS+1];
};

#endif



