'use strict';

const { mustNotCall, skip, isWindows, isIBMi } = require('../common');
const { strictEqual } = require('assert');
const { isMainThread } = require('worker_threads');

if (!isMainThread) {
  skip('process.execve is not available in Workers');
} else if (isWindows || isIBMi) {
  skip('process.execve is not available in Windows or IBM i');
}

if (process.argv[2] === 'replaced') {
  strictEqual(process.argv[2], 'replaced');
} else {
  process.on('exit', mustNotCall());
  process.execve(process.execPath, [process.execPath, __filename, 'replaced'], process.env);
}
