/* testreadonlycollection.c generated by valac 0.11.5, the Vala compiler
 * generated from testreadonlycollection.vala, do not modify */

/* testreadonlycollection.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Tomaž Vajngerl <quikee@gmail.com>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_READ_ONLY_COLLECTION_TESTS (read_only_collection_tests_get_type ())
#define READ_ONLY_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_READ_ONLY_COLLECTION_TESTS, ReadOnlyCollectionTests))
#define READ_ONLY_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_READ_ONLY_COLLECTION_TESTS, ReadOnlyCollectionTestsClass))
#define IS_READ_ONLY_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_READ_ONLY_COLLECTION_TESTS))
#define IS_READ_ONLY_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_READ_ONLY_COLLECTION_TESTS))
#define READ_ONLY_COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_READ_ONLY_COLLECTION_TESTS, ReadOnlyCollectionTestsClass))

typedef struct _ReadOnlyCollectionTests ReadOnlyCollectionTests;
typedef struct _ReadOnlyCollectionTestsClass ReadOnlyCollectionTestsClass;
typedef struct _ReadOnlyCollectionTestsPrivate ReadOnlyCollectionTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _ReadOnlyCollectionTests {
	GeeTestCase parent_instance;
	ReadOnlyCollectionTestsPrivate * priv;
	GeeCollection* test_collection;
	GeeCollection* ro_collection;
};

struct _ReadOnlyCollectionTestsClass {
	GeeTestCaseClass parent_class;
	GeeCollection* (*get_ro_view) (ReadOnlyCollectionTests* self, GeeCollection* collection);
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer read_only_collection_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType read_only_collection_tests_get_type (void) G_GNUC_CONST;
enum  {
	READ_ONLY_COLLECTION_TESTS_DUMMY_PROPERTY
};
ReadOnlyCollectionTests* read_only_collection_tests_new (void);
ReadOnlyCollectionTests* read_only_collection_tests_construct (GType object_type);
ReadOnlyCollectionTests* read_only_collection_tests_new_with_name (const gchar* name);
ReadOnlyCollectionTests* read_only_collection_tests_construct_with_name (GType object_type, const gchar* name);
GeeTestCase* gee_test_case_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target);
void read_only_collection_tests_test_unique_read_only_view_instance (ReadOnlyCollectionTests* self);
static void _read_only_collection_tests_test_unique_read_only_view_instance_gee_test_case_test_method (gpointer self);
void read_only_collection_tests_test_immutable_iterator (ReadOnlyCollectionTests* self);
static void _read_only_collection_tests_test_immutable_iterator_gee_test_case_test_method (gpointer self);
void read_only_collection_tests_test_immutable (ReadOnlyCollectionTests* self);
static void _read_only_collection_tests_test_immutable_gee_test_case_test_method (gpointer self);
void read_only_collection_tests_test_accurate_view (ReadOnlyCollectionTests* self);
static void _read_only_collection_tests_test_accurate_view_gee_test_case_test_method (gpointer self);
static void read_only_collection_tests_real_set_up (GeeTestCase* base);
GeeCollection* read_only_collection_tests_get_ro_view (ReadOnlyCollectionTests* self, GeeCollection* collection);
static void read_only_collection_tests_real_tear_down (GeeTestCase* base);
static GeeCollection* read_only_collection_tests_real_get_ro_view (ReadOnlyCollectionTests* self, GeeCollection* collection);
static void read_only_collection_tests_finalize (GObject* obj);


ReadOnlyCollectionTests* read_only_collection_tests_construct (GType object_type) {
	ReadOnlyCollectionTests * self = NULL;
	self = (ReadOnlyCollectionTests*) read_only_collection_tests_construct_with_name (object_type, "ReadOnlyCollection");
	return self;
}


ReadOnlyCollectionTests* read_only_collection_tests_new (void) {
	return read_only_collection_tests_construct (TYPE_READ_ONLY_COLLECTION_TESTS);
}


static void _read_only_collection_tests_test_unique_read_only_view_instance_gee_test_case_test_method (gpointer self) {
	read_only_collection_tests_test_unique_read_only_view_instance (self);
}


static void _read_only_collection_tests_test_immutable_iterator_gee_test_case_test_method (gpointer self) {
	read_only_collection_tests_test_immutable_iterator (self);
}


static void _read_only_collection_tests_test_immutable_gee_test_case_test_method (gpointer self) {
	read_only_collection_tests_test_immutable (self);
}


static void _read_only_collection_tests_test_accurate_view_gee_test_case_test_method (gpointer self) {
	read_only_collection_tests_test_accurate_view (self);
}


ReadOnlyCollectionTests* read_only_collection_tests_construct_with_name (GType object_type, const gchar* name) {
	ReadOnlyCollectionTests * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ReadOnlyCollectionTests*) gee_test_case_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[ReadOnlyCollection] unique read-only view instance", _read_only_collection_tests_test_unique_read_only_view_instance_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ReadOnlyCollection] immutable iterator", _read_only_collection_tests_test_immutable_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ReadOnlyCollection] immutable", _read_only_collection_tests_test_immutable_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ReadOnlyCollection] accurate view", _read_only_collection_tests_test_accurate_view_gee_test_case_test_method, self);
	return self;
}


ReadOnlyCollectionTests* read_only_collection_tests_new_with_name (const gchar* name) {
	return read_only_collection_tests_construct_with_name (TYPE_READ_ONLY_COLLECTION_TESTS, name);
}


static void read_only_collection_tests_real_set_up (GeeTestCase* base) {
	ReadOnlyCollectionTests * self;
	GeeHashMultiSet* _tmp0_ = NULL;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_ = NULL;
	GeeCollection* _tmp3_;
	self = (ReadOnlyCollectionTests*) base;
	_tmp0_ = gee_hash_multi_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_tmp1_ = (GeeCollection*) _tmp0_;
	_g_object_unref0 (self->test_collection);
	self->test_collection = _tmp1_;
	_tmp2_ = read_only_collection_tests_get_ro_view (self, self->test_collection);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->ro_collection);
	self->ro_collection = _tmp3_;
}


static void read_only_collection_tests_real_tear_down (GeeTestCase* base) {
	ReadOnlyCollectionTests * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	self = (ReadOnlyCollectionTests*) base;
	_tmp0_ = NULL;
	_g_object_unref0 (self->test_collection);
	self->test_collection = _tmp0_;
	_tmp1_ = NULL;
	_g_object_unref0 (self->ro_collection);
	self->ro_collection = _tmp1_;
}


static GeeCollection* read_only_collection_tests_real_get_ro_view (ReadOnlyCollectionTests* self, GeeCollection* collection) {
	GeeCollection* result = NULL;
	GeeCollection* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = gee_collection_get_read_only_view (collection);
	result = _tmp0_;
	return result;
}


GeeCollection* read_only_collection_tests_get_ro_view (ReadOnlyCollectionTests* self, GeeCollection* collection) {
	return READ_ONLY_COLLECTION_TESTS_GET_CLASS (self)->get_ro_view (self, collection);
}


void read_only_collection_tests_test_unique_read_only_view_instance (ReadOnlyCollectionTests* self) {
	GeeCollection* _tmp0_ = NULL;
	GeeCollection* another_ro_collection;
	GObject* _tmp1_ = NULL;
	gconstpointer _tmp2_ = NULL;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_ = NULL;
	GeeCollection* _tmp6_;
	gconstpointer _tmp7_ = NULL;
	GeeCollection* _tmp8_ = NULL;
	GeeCollection* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = read_only_collection_tests_get_ro_view (self, self->test_collection);
	another_ro_collection = _tmp0_;
	g_assert (self->ro_collection == another_ro_collection);
	_tmp1_ = g_object_new (G_TYPE_OBJECT, NULL);
	g_object_set_data_full ((GObject*) self->ro_collection, "marker", _tmp1_, g_object_unref);
	_tmp2_ = g_object_get_data ((GObject*) another_ro_collection, "marker");
	g_assert (((GObject*) _tmp2_) != NULL);
	_tmp3_ = NULL;
	_g_object_unref0 (another_ro_collection);
	another_ro_collection = _tmp3_;
	_tmp4_ = NULL;
	_g_object_unref0 (self->ro_collection);
	self->ro_collection = _tmp4_;
	_tmp5_ = read_only_collection_tests_get_ro_view (self, self->test_collection);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (another_ro_collection);
	another_ro_collection = _tmp6_;
	_tmp7_ = g_object_get_data ((GObject*) another_ro_collection, "marker");
	g_assert (((GObject*) _tmp7_) == NULL);
	_tmp8_ = read_only_collection_tests_get_ro_view (self, another_ro_collection);
	_tmp9_ = _tmp8_;
	g_assert (another_ro_collection == _tmp9_);
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (another_ro_collection);
}


void read_only_collection_tests_test_immutable_iterator (ReadOnlyCollectionTests* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeIterator* _tmp5_ = NULL;
	GeeIterator* iterator;
	gboolean one_found;
	gboolean two_found;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gint _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add (self->test_collection, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add (self->test_collection, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp2_ == 2);
	_tmp3_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_contains (self->ro_collection, "two");
	g_assert (_tmp4_);
	_tmp5_ = gee_iterable_iterator ((GeeIterable*) self->ro_collection);
	iterator = _tmp5_;
	one_found = FALSE;
	two_found = FALSE;
	while (TRUE) {
		gboolean _tmp6_;
		gpointer _tmp7_ = NULL;
		gchar* _tmp8_;
		GQuark _tmp9_;
		static GQuark _tmp9__label0 = 0;
		static GQuark _tmp9__label1 = 0;
		_tmp6_ = gee_iterator_next (iterator);
		if (!_tmp6_) {
			break;
		}
		_tmp7_ = gee_iterator_get (iterator);
		_tmp8_ = (gchar*) _tmp7_;
		_tmp9_ = (NULL == _tmp8_) ? 0 : g_quark_from_string (_tmp8_);
		g_free (_tmp8_);
		if (_tmp9_ == ((0 != _tmp9__label0) ? _tmp9__label0 : (_tmp9__label0 = g_quark_from_static_string ("one")))) {
			switch (0) {
				default:
				{
					g_assert (!one_found);
					one_found = TRUE;
					break;
				}
			}
		} else if (_tmp9_ == ((0 != _tmp9__label1) ? _tmp9__label1 : (_tmp9__label1 = g_quark_from_static_string ("two")))) {
			switch (0) {
				default:
				{
					g_assert (!two_found);
					two_found = TRUE;
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					g_assert_not_reached ();
				}
			}
		}
	}
	g_assert (one_found);
	g_assert (two_found);
	_tmp10_ = gee_iterator_has_next (iterator);
	g_assert (!_tmp10_);
	_tmp11_ = gee_iterator_next (iterator);
	g_assert (!_tmp11_);
	_tmp12_ = gee_iterator_first (iterator);
	g_assert (_tmp12_);
	_tmp13_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp13_) {
		gee_iterator_remove (iterator);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp14_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp14_ == 2);
	_tmp15_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (_tmp15_);
	_tmp16_ = gee_collection_contains (self->ro_collection, "two");
	g_assert (_tmp16_);
	_g_object_unref0 (iterator);
}


void read_only_collection_tests_test_immutable (ReadOnlyCollectionTests* self) {
	gboolean _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	GeeArrayList* _tmp3_ = NULL;
	GeeCollection* dummy;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gint _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gint _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gint _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gint _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gint _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	gint _tmp28_;
	gboolean _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add (self->test_collection, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp1_ == 1);
	_tmp2_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (_tmp2_);
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	dummy = (GeeCollection*) _tmp3_;
	_tmp4_ = gee_collection_add (dummy, "one");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add (dummy, "two");
	g_assert (_tmp5_);
	_tmp6_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp6_) {
		gboolean _tmp7_;
		_tmp7_ = gee_collection_add (self->ro_collection, "two");
		g_assert (_tmp7_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp8_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp8_ == 1);
	_tmp9_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (_tmp9_);
	_tmp10_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp10_) {
		gee_collection_clear (self->ro_collection);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp11_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp11_ == 1);
	_tmp12_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (_tmp12_);
	_tmp13_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp13_) {
		gboolean _tmp14_;
		_tmp14_ = gee_collection_remove (self->ro_collection, "one");
		g_assert (_tmp14_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp15_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp15_ == 1);
	_tmp16_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (_tmp16_);
	_tmp17_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp17_) {
		gboolean _tmp18_;
		_tmp18_ = gee_collection_add_all (self->ro_collection, dummy);
		g_assert (_tmp18_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp19_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp19_ == 1);
	_tmp20_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (_tmp20_);
	_tmp21_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp21_) {
		gboolean _tmp22_;
		_tmp22_ = gee_collection_remove_all (self->ro_collection, dummy);
		g_assert (_tmp22_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp23_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp23_ == 1);
	_tmp24_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (_tmp24_);
	_tmp25_ = gee_collection_remove (dummy, "one");
	g_assert (_tmp25_);
	_tmp26_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp26_) {
		gboolean _tmp27_;
		_tmp27_ = gee_collection_retain_all (self->ro_collection, dummy);
		g_assert (_tmp27_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp28_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp28_ == 1);
	_tmp29_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (_tmp29_);
	_g_object_unref0 (dummy);
}


void read_only_collection_tests_test_accurate_view (ReadOnlyCollectionTests* self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeCollection* dummy;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GType _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gint _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gint _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gint _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	gboolean _tmp22_;
	gint _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	dummy = (GeeCollection*) _tmp0_;
	_tmp1_ = gee_collection_add (dummy, "one");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add (dummy, "two");
	g_assert (_tmp2_);
	_tmp3_ = gee_iterable_get_element_type ((GeeIterable*) self->ro_collection);
	g_assert (_tmp3_ == G_TYPE_STRING);
	_tmp4_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp4_ == 0);
	_tmp5_ = gee_collection_get_is_empty (self->ro_collection);
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (!_tmp6_);
	_tmp7_ = gee_collection_add (self->test_collection, "one");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp8_ == 1);
	_tmp9_ = gee_collection_get_is_empty (self->ro_collection);
	g_assert (!_tmp9_);
	_tmp10_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (_tmp10_);
	_tmp11_ = gee_collection_add (self->test_collection, "two");
	g_assert (_tmp11_);
	_tmp12_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp12_ == 2);
	_tmp13_ = gee_collection_get_is_empty (self->ro_collection);
	g_assert (!_tmp13_);
	_tmp14_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (_tmp14_);
	_tmp15_ = gee_collection_contains (self->ro_collection, "two");
	g_assert (_tmp15_);
	_tmp16_ = gee_collection_contains_all (self->ro_collection, dummy);
	g_assert (_tmp16_);
	_tmp17_ = gee_collection_remove (self->test_collection, "one");
	g_assert (_tmp17_);
	_tmp18_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp18_ == 1);
	_tmp19_ = gee_collection_get_is_empty (self->ro_collection);
	g_assert (!_tmp19_);
	_tmp20_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (!_tmp20_);
	_tmp21_ = gee_collection_contains (self->ro_collection, "two");
	g_assert (_tmp21_);
	_tmp22_ = gee_collection_contains_all (self->ro_collection, dummy);
	g_assert (!_tmp22_);
	gee_collection_clear (self->test_collection);
	_tmp23_ = gee_collection_get_size (self->ro_collection);
	g_assert (_tmp23_ == 0);
	_tmp24_ = gee_collection_get_is_empty (self->ro_collection);
	g_assert (_tmp24_);
	_tmp25_ = gee_collection_contains (self->ro_collection, "one");
	g_assert (!_tmp25_);
	_tmp26_ = gee_collection_contains (self->ro_collection, "two");
	g_assert (!_tmp26_);
	_g_object_unref0 (dummy);
}


static void read_only_collection_tests_class_init (ReadOnlyCollectionTestsClass * klass) {
	read_only_collection_tests_parent_class = g_type_class_peek_parent (klass);
	GEE_TEST_CASE_CLASS (klass)->set_up = read_only_collection_tests_real_set_up;
	GEE_TEST_CASE_CLASS (klass)->tear_down = read_only_collection_tests_real_tear_down;
	READ_ONLY_COLLECTION_TESTS_CLASS (klass)->get_ro_view = read_only_collection_tests_real_get_ro_view;
	G_OBJECT_CLASS (klass)->finalize = read_only_collection_tests_finalize;
}


static void read_only_collection_tests_instance_init (ReadOnlyCollectionTests * self) {
}


static void read_only_collection_tests_finalize (GObject* obj) {
	ReadOnlyCollectionTests * self;
	self = READ_ONLY_COLLECTION_TESTS (obj);
	_g_object_unref0 (self->test_collection);
	_g_object_unref0 (self->ro_collection);
	G_OBJECT_CLASS (read_only_collection_tests_parent_class)->finalize (obj);
}


GType read_only_collection_tests_get_type (void) {
	static volatile gsize read_only_collection_tests_type_id__volatile = 0;
	if (g_once_init_enter (&read_only_collection_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ReadOnlyCollectionTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) read_only_collection_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ReadOnlyCollectionTests), 0, (GInstanceInitFunc) read_only_collection_tests_instance_init, NULL };
		GType read_only_collection_tests_type_id;
		read_only_collection_tests_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "ReadOnlyCollectionTests", &g_define_type_info, 0);
		g_once_init_leave (&read_only_collection_tests_type_id__volatile, read_only_collection_tests_type_id);
	}
	return read_only_collection_tests_type_id__volatile;
}



