/* testsortedset.c generated by valac 0.11.5, the Vala compiler
 * generated from testsortedset.vala, do not modify */

/* testsortedset.vala
 *
 * Copyright (C) 2009  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_SET_TESTS (set_tests_get_type ())
#define SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SET_TESTS, SetTests))
#define SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SET_TESTS, SetTestsClass))
#define IS_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SET_TESTS))
#define IS_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SET_TESTS))
#define SET_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SET_TESTS, SetTestsClass))

typedef struct _SetTests SetTests;
typedef struct _SetTestsClass SetTestsClass;
typedef struct _SetTestsPrivate SetTestsPrivate;

#define TYPE_SORTED_SET_TESTS (sorted_set_tests_get_type ())
#define SORTED_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_SET_TESTS, SortedSetTests))
#define SORTED_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_SET_TESTS, SortedSetTestsClass))
#define IS_SORTED_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_SET_TESTS))
#define IS_SORTED_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_SET_TESTS))
#define SORTED_SET_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_SET_TESTS, SortedSetTestsClass))

typedef struct _SortedSetTests SortedSetTests;
typedef struct _SortedSetTestsClass SortedSetTestsClass;
typedef struct _SortedSetTestsPrivate SortedSetTestsPrivate;

#define SORTED_SET_TESTS_SUB_SET_TYPE_TYPE (sorted_set_tests_sub_set_type_get_type ())

#define SORTED_SET_TESTS_TYPE_SUB_SET (sorted_set_tests_sub_set_get_type ())
#define SORTED_SET_TESTS_SUB_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSet))
#define SORTED_SET_TESTS_SUB_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSetClass))
#define SORTED_SET_TESTS_IS_SUB_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SORTED_SET_TESTS_TYPE_SUB_SET))
#define SORTED_SET_TESTS_IS_SUB_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SORTED_SET_TESTS_TYPE_SUB_SET))
#define SORTED_SET_TESTS_SUB_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSetClass))

typedef struct _SortedSetTestsSubSet SortedSetTestsSubSet;
typedef struct _SortedSetTestsSubSetClass SortedSetTestsSubSetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SortedSetTestsSubSetPrivate SortedSetTestsSubSetPrivate;

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _SetTests {
	CollectionTests parent_instance;
	SetTestsPrivate * priv;
};

struct _SetTestsClass {
	CollectionTestsClass parent_class;
	void (*test_duplicates_are_ignored) (SetTests* self);
};

struct _SortedSetTests {
	SetTests parent_instance;
	SortedSetTestsPrivate * priv;
};

struct _SortedSetTestsClass {
	SetTestsClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);
typedef enum  {
	SORTED_SET_TESTS_SUB_SET_TYPE_HEAD,
	SORTED_SET_TESTS_SUB_SET_TYPE_TAIL,
	SORTED_SET_TESTS_SUB_SET_TYPE_SUB,
	SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY
} SortedSetTestsSubSetType;

struct _SortedSetTestsSubSet {
	GeeTestCase parent_instance;
	SortedSetTestsSubSetPrivate * priv;
};

struct _SortedSetTestsSubSetClass {
	GeeTestCaseClass parent_class;
};

struct _SortedSetTestsSubSetPrivate {
	GeeSortedSet* master;
	GeeSortedSet* subset;
	SortedSetTests* test;
	SortedSetTestsSubSetType type;
};


static gpointer sorted_set_tests_parent_class = NULL;
static gpointer sorted_set_tests_sub_set_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType set_tests_get_type (void) G_GNUC_CONST;
GType sorted_set_tests_get_type (void) G_GNUC_CONST;
enum  {
	SORTED_SET_TESTS_DUMMY_PROPERTY
};
SortedSetTests* sorted_set_tests_construct (GType object_type, const gchar* name);
SetTests* set_tests_construct (GType object_type, const gchar* name);
void gee_test_case_add_test (GeeTestCase* self, const gchar* name, GeeTestCaseTestMethod test, void* test_target);
void sorted_set_tests_test_first (SortedSetTests* self);
static void _sorted_set_tests_test_first_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_last (SortedSetTests* self);
static void _sorted_set_tests_test_last_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_ordering (SortedSetTests* self);
static void _sorted_set_tests_test_ordering_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_iterator_at (SortedSetTests* self);
static void _sorted_set_tests_test_iterator_at_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_lower (SortedSetTests* self);
static void _sorted_set_tests_test_lower_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_higher (SortedSetTests* self);
static void _sorted_set_tests_test_higher_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_floor (SortedSetTests* self);
static void _sorted_set_tests_test_floor_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_ceil (SortedSetTests* self);
static void _sorted_set_tests_test_ceil_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_bidir_iterator_can_go_backward (SortedSetTests* self);
static void _sorted_set_tests_test_bidir_iterator_can_go_backward_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_mutable_bidir_iterator (SortedSetTests* self);
static void _sorted_set_tests_test_mutable_bidir_iterator_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_bidir_iterator_last (SortedSetTests* self);
static void _sorted_set_tests_test_bidir_iterator_last_gee_test_case_test_method (gpointer self);
GTestSuite* gee_test_case_get_suite (GeeTestCase* self);
GType sorted_set_tests_sub_set_type_get_type (void) G_GNUC_CONST;
SortedSetTestsSubSet* sorted_set_tests_sub_set_new (SortedSetTests* test, SortedSetTestsSubSetType type);
SortedSetTestsSubSet* sorted_set_tests_sub_set_construct (GType object_type, SortedSetTests* test, SortedSetTestsSubSetType type);
GType sorted_set_tests_sub_set_get_type (void) G_GNUC_CONST;
#define SORTED_SET_TESTS_SUB_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSetPrivate))
enum  {
	SORTED_SET_TESTS_SUB_SET_DUMMY_PROPERTY
};
const gchar* sorted_set_tests_sub_set_type_to_string (SortedSetTestsSubSetType self);
GeeTestCase* gee_test_case_construct (GType object_type, const gchar* name);
void sorted_set_tests_sub_set_test_size (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_size_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_contains (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_contains_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_add (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_add_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_remove (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_remove_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_iterator (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_iterator_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_clear (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_clear_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_iterator_at (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_iterator_at_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_lower (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_lower_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_higher (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_higher_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_ceil (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_ceil_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_floor (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_floor_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_subsets (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_subsets_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_boundaries (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_boundaries_gee_test_case_test_method (gpointer self);
static void sorted_set_tests_sub_set_real_set_up (GeeTestCase* base);
void gee_test_case_set_up (GeeTestCase* self);
static void sorted_set_tests_sub_set_real_tear_down (GeeTestCase* base);
void gee_test_case_tear_down (GeeTestCase* self);
static void sorted_set_tests_sub_set_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _sorted_set_tests_test_first_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_first (self);
}


static void _sorted_set_tests_test_last_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_last (self);
}


static void _sorted_set_tests_test_ordering_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_ordering (self);
}


static void _sorted_set_tests_test_iterator_at_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_iterator_at (self);
}


static void _sorted_set_tests_test_lower_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_lower (self);
}


static void _sorted_set_tests_test_higher_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_higher (self);
}


static void _sorted_set_tests_test_floor_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_floor (self);
}


static void _sorted_set_tests_test_ceil_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_ceil (self);
}


static void _sorted_set_tests_test_bidir_iterator_can_go_backward_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_bidir_iterator_can_go_backward (self);
}


static void _sorted_set_tests_test_mutable_bidir_iterator_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_mutable_bidir_iterator (self);
}


static void _sorted_set_tests_test_bidir_iterator_last_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_bidir_iterator_last (self);
}


SortedSetTests* sorted_set_tests_construct (GType object_type, const gchar* name) {
	SortedSetTests * self = NULL;
	GTestSuite* _tmp0_ = NULL;
	SortedSetTestsSubSet* _tmp1_ = NULL;
	SortedSetTestsSubSet* _tmp2_;
	GTestSuite* _tmp3_ = NULL;
	GTestSuite* _tmp4_ = NULL;
	SortedSetTestsSubSet* _tmp5_ = NULL;
	SortedSetTestsSubSet* _tmp6_;
	GTestSuite* _tmp7_ = NULL;
	GTestSuite* _tmp8_ = NULL;
	SortedSetTestsSubSet* _tmp9_ = NULL;
	SortedSetTestsSubSet* _tmp10_;
	GTestSuite* _tmp11_ = NULL;
	GTestSuite* _tmp12_ = NULL;
	SortedSetTestsSubSet* _tmp13_ = NULL;
	SortedSetTestsSubSet* _tmp14_;
	GTestSuite* _tmp15_ = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (SortedSetTests*) set_tests_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] first", _sorted_set_tests_test_first_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] last", _sorted_set_tests_test_last_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] ordering", _sorted_set_tests_test_ordering_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] iterator at", _sorted_set_tests_test_iterator_at_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] lower", _sorted_set_tests_test_lower_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] higher", _sorted_set_tests_test_higher_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] floor", _sorted_set_tests_test_floor_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] ceil", _sorted_set_tests_test_ceil_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] bi-directional iterators can go backward", _sorted_set_tests_test_bidir_iterator_can_go_backward_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] bi-directional iterators are mutable", _sorted_set_tests_test_mutable_bidir_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] bi-directional iterators can to end", _sorted_set_tests_test_bidir_iterator_last_gee_test_case_test_method, self);
	_tmp0_ = gee_test_case_get_suite ((GeeTestCase*) self);
	_tmp1_ = sorted_set_tests_sub_set_new (self, SORTED_SET_TESTS_SUB_SET_TYPE_HEAD);
	_tmp2_ = _tmp1_;
	_tmp3_ = gee_test_case_get_suite ((GeeTestCase*) _tmp2_);
	g_test_suite_add_suite (_tmp0_, _tmp3_);
	_g_object_unref0 (_tmp2_);
	_tmp4_ = gee_test_case_get_suite ((GeeTestCase*) self);
	_tmp5_ = sorted_set_tests_sub_set_new (self, SORTED_SET_TESTS_SUB_SET_TYPE_TAIL);
	_tmp6_ = _tmp5_;
	_tmp7_ = gee_test_case_get_suite ((GeeTestCase*) _tmp6_);
	g_test_suite_add_suite (_tmp4_, _tmp7_);
	_g_object_unref0 (_tmp6_);
	_tmp8_ = gee_test_case_get_suite ((GeeTestCase*) self);
	_tmp9_ = sorted_set_tests_sub_set_new (self, SORTED_SET_TESTS_SUB_SET_TYPE_SUB);
	_tmp10_ = _tmp9_;
	_tmp11_ = gee_test_case_get_suite ((GeeTestCase*) _tmp10_);
	g_test_suite_add_suite (_tmp8_, _tmp11_);
	_g_object_unref0 (_tmp10_);
	_tmp12_ = gee_test_case_get_suite ((GeeTestCase*) self);
	_tmp13_ = sorted_set_tests_sub_set_new (self, SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY);
	_tmp14_ = _tmp13_;
	_tmp15_ = gee_test_case_get_suite ((GeeTestCase*) _tmp14_);
	g_test_suite_add_suite (_tmp12_, _tmp15_);
	_g_object_unref0 (_tmp14_);
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sorted_set_tests_test_ordering (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	GeeIterator* _tmp2_ = NULL;
	GeeIterator* iterator;
	gboolean _tmp3_;
	gpointer _tmp4_ = NULL;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gpointer _tmp7_ = NULL;
	gchar* _tmp8_;
	gboolean _tmp9_;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gboolean _tmp12_;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_;
	gboolean _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gboolean _tmp18_;
	gpointer _tmp19_ = NULL;
	gchar* _tmp20_;
	gboolean _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gboolean _tmp24_;
	gpointer _tmp25_ = NULL;
	gchar* _tmp26_;
	gboolean _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	gboolean _tmp30_;
	gpointer _tmp31_ = NULL;
	gchar* _tmp32_;
	gboolean _tmp33_;
	gpointer _tmp34_ = NULL;
	gchar* _tmp35_;
	gboolean _tmp36_;
	gpointer _tmp37_ = NULL;
	gchar* _tmp38_;
	gboolean _tmp39_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	test_set = _tmp1_;
	g_assert (test_set != NULL);
	gee_collection_add ((GeeCollection*) test_set, "one");
	gee_collection_add ((GeeCollection*) test_set, "two");
	gee_collection_add ((GeeCollection*) test_set, "three");
	gee_collection_add ((GeeCollection*) test_set, "four");
	gee_collection_add ((GeeCollection*) test_set, "five");
	gee_collection_add ((GeeCollection*) test_set, "six");
	gee_collection_add ((GeeCollection*) test_set, "seven");
	gee_collection_add ((GeeCollection*) test_set, "eight");
	gee_collection_add ((GeeCollection*) test_set, "nine");
	gee_collection_add ((GeeCollection*) test_set, "ten");
	gee_collection_add ((GeeCollection*) test_set, "eleven");
	gee_collection_add ((GeeCollection*) test_set, "twelve");
	_tmp2_ = gee_iterable_iterator ((GeeIterable*) test_set);
	iterator = _tmp2_;
	_tmp3_ = gee_iterator_next (iterator);
	g_assert (_tmp3_);
	_tmp4_ = gee_iterator_get (iterator);
	_tmp5_ = (gchar*) _tmp4_;
	g_assert (g_strcmp0 (_tmp5_, "eight") == 0);
	_g_free0 (_tmp5_);
	_tmp6_ = gee_iterator_next (iterator);
	g_assert (_tmp6_);
	_tmp7_ = gee_iterator_get (iterator);
	_tmp8_ = (gchar*) _tmp7_;
	g_assert (g_strcmp0 (_tmp8_, "eleven") == 0);
	_g_free0 (_tmp8_);
	_tmp9_ = gee_iterator_next (iterator);
	g_assert (_tmp9_);
	_tmp10_ = gee_iterator_get (iterator);
	_tmp11_ = (gchar*) _tmp10_;
	g_assert (g_strcmp0 (_tmp11_, "five") == 0);
	_g_free0 (_tmp11_);
	_tmp12_ = gee_iterator_next (iterator);
	g_assert (_tmp12_);
	_tmp13_ = gee_iterator_get (iterator);
	_tmp14_ = (gchar*) _tmp13_;
	g_assert (g_strcmp0 (_tmp14_, "four") == 0);
	_g_free0 (_tmp14_);
	_tmp15_ = gee_iterator_next (iterator);
	g_assert (_tmp15_);
	_tmp16_ = gee_iterator_get (iterator);
	_tmp17_ = (gchar*) _tmp16_;
	g_assert (g_strcmp0 (_tmp17_, "nine") == 0);
	_g_free0 (_tmp17_);
	_tmp18_ = gee_iterator_next (iterator);
	g_assert (_tmp18_);
	_tmp19_ = gee_iterator_get (iterator);
	_tmp20_ = (gchar*) _tmp19_;
	g_assert (g_strcmp0 (_tmp20_, "one") == 0);
	_g_free0 (_tmp20_);
	_tmp21_ = gee_iterator_next (iterator);
	g_assert (_tmp21_);
	_tmp22_ = gee_iterator_get (iterator);
	_tmp23_ = (gchar*) _tmp22_;
	g_assert (g_strcmp0 (_tmp23_, "seven") == 0);
	_g_free0 (_tmp23_);
	_tmp24_ = gee_iterator_next (iterator);
	g_assert (_tmp24_);
	_tmp25_ = gee_iterator_get (iterator);
	_tmp26_ = (gchar*) _tmp25_;
	g_assert (g_strcmp0 (_tmp26_, "six") == 0);
	_g_free0 (_tmp26_);
	_tmp27_ = gee_iterator_next (iterator);
	g_assert (_tmp27_);
	_tmp28_ = gee_iterator_get (iterator);
	_tmp29_ = (gchar*) _tmp28_;
	g_assert (g_strcmp0 (_tmp29_, "ten") == 0);
	_g_free0 (_tmp29_);
	_tmp30_ = gee_iterator_next (iterator);
	g_assert (_tmp30_);
	_tmp31_ = gee_iterator_get (iterator);
	_tmp32_ = (gchar*) _tmp31_;
	g_assert (g_strcmp0 (_tmp32_, "three") == 0);
	_g_free0 (_tmp32_);
	_tmp33_ = gee_iterator_next (iterator);
	g_assert (_tmp33_);
	_tmp34_ = gee_iterator_get (iterator);
	_tmp35_ = (gchar*) _tmp34_;
	g_assert (g_strcmp0 (_tmp35_, "twelve") == 0);
	_g_free0 (_tmp35_);
	_tmp36_ = gee_iterator_next (iterator);
	g_assert (_tmp36_);
	_tmp37_ = gee_iterator_get (iterator);
	_tmp38_ = (gchar*) _tmp37_;
	g_assert (g_strcmp0 (_tmp38_, "two") == 0);
	_g_free0 (_tmp38_);
	_tmp39_ = gee_iterator_next (iterator);
	g_assert (_tmp39_ == FALSE);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_first (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gboolean _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gpointer _tmp11_ = NULL;
	gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	test_set = _tmp1_;
	_tmp2_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp2_) {
		gpointer _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = gee_sorted_set_first (test_set);
		_tmp4_ = (gchar*) _tmp3_;
		_g_free0 (_tmp4_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "one");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "two");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "three");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "four");
	g_assert (_tmp8_);
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "five");
	g_assert (_tmp9_);
	_tmp10_ = gee_collection_add ((GeeCollection*) test_set, "six");
	g_assert (_tmp10_);
	_tmp11_ = gee_sorted_set_first (test_set);
	_tmp12_ = (gchar*) _tmp11_;
	g_assert (g_strcmp0 (_tmp12_, "five") == 0);
	_g_free0 (_tmp12_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_last (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gboolean _tmp2_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gpointer _tmp11_ = NULL;
	gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	test_set = _tmp1_;
	_tmp2_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp2_) {
		gpointer _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp3_ = gee_sorted_set_last (test_set);
		_tmp4_ = (gchar*) _tmp3_;
		_g_free0 (_tmp4_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "one");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "two");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "three");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "four");
	g_assert (_tmp8_);
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "five");
	g_assert (_tmp9_);
	_tmp10_ = gee_collection_add ((GeeCollection*) test_set, "six");
	g_assert (_tmp10_);
	_tmp11_ = gee_sorted_set_last (test_set);
	_tmp12_ = (gchar*) _tmp11_;
	g_assert (g_strcmp0 (_tmp12_, "two") == 0);
	_g_free0 (_tmp12_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_iterator_at (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GeeBidirIterator* _tmp5_ = NULL;
	GeeBidirIterator* iter;
	gpointer _tmp6_ = NULL;
	gchar* _tmp7_;
	GeeBidirIterator* _tmp8_ = NULL;
	GeeBidirIterator* _tmp9_;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	GeeBidirIterator* _tmp12_ = NULL;
	GeeBidirIterator* _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	GeeBidirIterator* _tmp16_ = NULL;
	GeeBidirIterator* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	test_set = _tmp1_;
	_tmp2_ = gee_collection_add ((GeeCollection*) test_set, "one");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) test_set, "two");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "three");
	g_assert (_tmp4_);
	_tmp5_ = gee_sorted_set_iterator_at (test_set, "one");
	iter = _tmp5_;
	g_assert (iter != NULL);
	_tmp6_ = gee_iterator_get ((GeeIterator*) iter);
	_tmp7_ = (gchar*) _tmp6_;
	g_assert (g_strcmp0 (_tmp7_, "one") == 0);
	_g_free0 (_tmp7_);
	_tmp8_ = gee_sorted_set_iterator_at (test_set, "two");
	_tmp9_ = _tmp8_;
	_g_object_unref0 (iter);
	iter = _tmp9_;
	g_assert (iter != NULL);
	_tmp10_ = gee_iterator_get ((GeeIterator*) iter);
	_tmp11_ = (gchar*) _tmp10_;
	g_assert (g_strcmp0 (_tmp11_, "two") == 0);
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_iterator_at (test_set, "three");
	_tmp13_ = _tmp12_;
	_g_object_unref0 (iter);
	iter = _tmp13_;
	g_assert (iter != NULL);
	_tmp14_ = gee_iterator_get ((GeeIterator*) iter);
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (g_strcmp0 (_tmp15_, "three") == 0);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_iterator_at (test_set, "zero");
	_tmp17_ = _tmp16_;
	_g_object_unref0 (iter);
	iter = _tmp17_;
	g_assert (iter == NULL);
	_g_object_unref0 (iter);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_lower (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	gchar* _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_lower (test_set, "one");
	_tmp3_ = (gchar*) _tmp2_;
	g_assert (_tmp3_ == NULL);
	_g_free0 (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "one");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "three");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "four");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "five");
	g_assert (_tmp8_);
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "six");
	g_assert (_tmp9_);
	_tmp10_ = gee_sorted_set_lower (test_set, "one");
	_tmp11_ = (gchar*) _tmp10_;
	g_assert (g_strcmp0 (_tmp11_, "four") == 0);
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_lower (test_set, "o");
	_tmp13_ = (gchar*) _tmp12_;
	g_assert (g_strcmp0 (_tmp13_, "four") == 0);
	_g_free0 (_tmp13_);
	_tmp14_ = gee_sorted_set_lower (test_set, "two");
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (g_strcmp0 (_tmp15_, "three") == 0);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_lower (test_set, "t");
	_tmp17_ = (gchar*) _tmp16_;
	g_assert (g_strcmp0 (_tmp17_, "six") == 0);
	_g_free0 (_tmp17_);
	_tmp18_ = gee_sorted_set_lower (test_set, "three");
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp19_, "six") == 0);
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_lower (test_set, "four");
	_tmp21_ = (gchar*) _tmp20_;
	g_assert (g_strcmp0 (_tmp21_, "five") == 0);
	_g_free0 (_tmp21_);
	_tmp22_ = gee_sorted_set_lower (test_set, "f");
	_tmp23_ = (gchar*) _tmp22_;
	g_assert (_tmp23_ == NULL);
	_g_free0 (_tmp23_);
	_tmp24_ = gee_sorted_set_lower (test_set, "five");
	_tmp25_ = (gchar*) _tmp24_;
	g_assert (_tmp25_ == NULL);
	_g_free0 (_tmp25_);
	_tmp26_ = gee_sorted_set_lower (test_set, "six");
	_tmp27_ = (gchar*) _tmp26_;
	g_assert (g_strcmp0 (_tmp27_, "one") == 0);
	_g_free0 (_tmp27_);
	_tmp28_ = gee_sorted_set_lower (test_set, "s");
	_tmp29_ = (gchar*) _tmp28_;
	g_assert (g_strcmp0 (_tmp29_, "one") == 0);
	_g_free0 (_tmp29_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_higher (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	gchar* _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_higher (test_set, "one");
	_tmp3_ = (gchar*) _tmp2_;
	g_assert (_tmp3_ == NULL);
	_g_free0 (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "one");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "three");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "four");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "five");
	g_assert (_tmp8_);
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "six");
	g_assert (_tmp9_);
	_tmp10_ = gee_sorted_set_higher (test_set, "one");
	_tmp11_ = (gchar*) _tmp10_;
	g_assert (g_strcmp0 (_tmp11_, "six") == 0);
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_higher (test_set, "o");
	_tmp13_ = (gchar*) _tmp12_;
	g_assert (g_strcmp0 (_tmp13_, "one") == 0);
	_g_free0 (_tmp13_);
	_tmp14_ = gee_sorted_set_higher (test_set, "two");
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (_tmp15_ == NULL);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_higher (test_set, "t");
	_tmp17_ = (gchar*) _tmp16_;
	g_assert (g_strcmp0 (_tmp17_, "three") == 0);
	_g_free0 (_tmp17_);
	_tmp18_ = gee_sorted_set_higher (test_set, "three");
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp19_, "two") == 0);
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_higher (test_set, "four");
	_tmp21_ = (gchar*) _tmp20_;
	g_assert (g_strcmp0 (_tmp21_, "one") == 0);
	_g_free0 (_tmp21_);
	_tmp22_ = gee_sorted_set_higher (test_set, "f");
	_tmp23_ = (gchar*) _tmp22_;
	g_assert (g_strcmp0 (_tmp23_, "five") == 0);
	_g_free0 (_tmp23_);
	_tmp24_ = gee_sorted_set_higher (test_set, "five");
	_tmp25_ = (gchar*) _tmp24_;
	g_assert (g_strcmp0 (_tmp25_, "four") == 0);
	_g_free0 (_tmp25_);
	_tmp26_ = gee_sorted_set_higher (test_set, "six");
	_tmp27_ = (gchar*) _tmp26_;
	g_assert (g_strcmp0 (_tmp27_, "three") == 0);
	_g_free0 (_tmp27_);
	_tmp28_ = gee_sorted_set_higher (test_set, "s");
	_tmp29_ = (gchar*) _tmp28_;
	g_assert (g_strcmp0 (_tmp29_, "six") == 0);
	_g_free0 (_tmp29_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_floor (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	gchar* _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_floor (test_set, "one");
	_tmp3_ = (gchar*) _tmp2_;
	g_assert (_tmp3_ == NULL);
	_g_free0 (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "one");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "three");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "four");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "five");
	g_assert (_tmp8_);
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "six");
	g_assert (_tmp9_);
	_tmp10_ = gee_sorted_set_floor (test_set, "one");
	_tmp11_ = (gchar*) _tmp10_;
	g_assert (g_strcmp0 (_tmp11_, "one") == 0);
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_floor (test_set, "o");
	_tmp13_ = (gchar*) _tmp12_;
	g_assert (g_strcmp0 (_tmp13_, "four") == 0);
	_g_free0 (_tmp13_);
	_tmp14_ = gee_sorted_set_floor (test_set, "two");
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (g_strcmp0 (_tmp15_, "two") == 0);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_floor (test_set, "t");
	_tmp17_ = (gchar*) _tmp16_;
	g_assert (g_strcmp0 (_tmp17_, "six") == 0);
	_g_free0 (_tmp17_);
	_tmp18_ = gee_sorted_set_floor (test_set, "three");
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp19_, "three") == 0);
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_floor (test_set, "four");
	_tmp21_ = (gchar*) _tmp20_;
	g_assert (g_strcmp0 (_tmp21_, "four") == 0);
	_g_free0 (_tmp21_);
	_tmp22_ = gee_sorted_set_floor (test_set, "f");
	_tmp23_ = (gchar*) _tmp22_;
	g_assert (_tmp23_ == NULL);
	_g_free0 (_tmp23_);
	_tmp24_ = gee_sorted_set_floor (test_set, "five");
	_tmp25_ = (gchar*) _tmp24_;
	g_assert (g_strcmp0 (_tmp25_, "five") == 0);
	_g_free0 (_tmp25_);
	_tmp26_ = gee_sorted_set_floor (test_set, "six");
	_tmp27_ = (gchar*) _tmp26_;
	g_assert (g_strcmp0 (_tmp27_, "six") == 0);
	_g_free0 (_tmp27_);
	_tmp28_ = gee_sorted_set_floor (test_set, "s");
	_tmp29_ = (gchar*) _tmp28_;
	g_assert (g_strcmp0 (_tmp29_, "one") == 0);
	_g_free0 (_tmp29_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_ceil (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	gpointer _tmp2_ = NULL;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gpointer _tmp10_ = NULL;
	gchar* _tmp11_;
	gpointer _tmp12_ = NULL;
	gchar* _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gpointer _tmp16_ = NULL;
	gchar* _tmp17_;
	gpointer _tmp18_ = NULL;
	gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	gchar* _tmp21_;
	gpointer _tmp22_ = NULL;
	gchar* _tmp23_;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_;
	gpointer _tmp26_ = NULL;
	gchar* _tmp27_;
	gpointer _tmp28_ = NULL;
	gchar* _tmp29_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_ceil (test_set, "one");
	_tmp3_ = (gchar*) _tmp2_;
	g_assert (_tmp3_ == NULL);
	_g_free0 (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "one");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "three");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "four");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "five");
	g_assert (_tmp8_);
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "six");
	g_assert (_tmp9_);
	_tmp10_ = gee_sorted_set_ceil (test_set, "one");
	_tmp11_ = (gchar*) _tmp10_;
	g_assert (g_strcmp0 (_tmp11_, "one") == 0);
	_g_free0 (_tmp11_);
	_tmp12_ = gee_sorted_set_ceil (test_set, "o");
	_tmp13_ = (gchar*) _tmp12_;
	g_assert (g_strcmp0 (_tmp13_, "one") == 0);
	_g_free0 (_tmp13_);
	_tmp14_ = gee_sorted_set_ceil (test_set, "two");
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (g_strcmp0 (_tmp15_, "two") == 0);
	_g_free0 (_tmp15_);
	_tmp16_ = gee_sorted_set_ceil (test_set, "t");
	_tmp17_ = (gchar*) _tmp16_;
	g_assert (g_strcmp0 (_tmp17_, "three") == 0);
	_g_free0 (_tmp17_);
	_tmp18_ = gee_sorted_set_ceil (test_set, "three");
	_tmp19_ = (gchar*) _tmp18_;
	g_assert (g_strcmp0 (_tmp19_, "three") == 0);
	_g_free0 (_tmp19_);
	_tmp20_ = gee_sorted_set_ceil (test_set, "four");
	_tmp21_ = (gchar*) _tmp20_;
	g_assert (g_strcmp0 (_tmp21_, "four") == 0);
	_g_free0 (_tmp21_);
	_tmp22_ = gee_sorted_set_ceil (test_set, "f");
	_tmp23_ = (gchar*) _tmp22_;
	g_assert (g_strcmp0 (_tmp23_, "five") == 0);
	_g_free0 (_tmp23_);
	_tmp24_ = gee_sorted_set_ceil (test_set, "five");
	_tmp25_ = (gchar*) _tmp24_;
	g_assert (g_strcmp0 (_tmp25_, "five") == 0);
	_g_free0 (_tmp25_);
	_tmp26_ = gee_sorted_set_ceil (test_set, "six");
	_tmp27_ = (gchar*) _tmp26_;
	g_assert (g_strcmp0 (_tmp27_, "six") == 0);
	_g_free0 (_tmp27_);
	_tmp28_ = gee_sorted_set_ceil (test_set, "s");
	_tmp29_ = (gchar*) _tmp28_;
	g_assert (g_strcmp0 (_tmp29_, "six") == 0);
	_g_free0 (_tmp29_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_bidir_iterator_can_go_backward (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	GeeBidirIterator* _tmp2_ = NULL;
	GeeBidirIterator* iterator;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GeeBidirIterator* _tmp10_ = NULL;
	GeeBidirIterator* _tmp11_;
	gboolean _tmp12_;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	gpointer _tmp17_ = NULL;
	gchar* _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp20_;
	gpointer _tmp21_ = NULL;
	gchar* _tmp22_;
	gboolean _tmp23_;
	gboolean _tmp24_;
	gpointer _tmp25_ = NULL;
	gchar* _tmp26_;
	gboolean _tmp27_;
	gboolean _tmp28_;
	gpointer _tmp29_ = NULL;
	gchar* _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gpointer _tmp33_ = NULL;
	gchar* _tmp34_;
	gboolean _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	gpointer _tmp38_ = NULL;
	gchar* _tmp39_;
	gboolean _tmp40_;
	gpointer _tmp41_ = NULL;
	gchar* _tmp42_;
	gboolean _tmp43_;
	gpointer _tmp44_ = NULL;
	gchar* _tmp45_;
	gboolean _tmp46_;
	gpointer _tmp47_ = NULL;
	gchar* _tmp48_;
	gboolean _tmp49_;
	gpointer _tmp50_ = NULL;
	gchar* _tmp51_;
	gboolean _tmp52_;
	gpointer _tmp53_ = NULL;
	gchar* _tmp54_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_bidir_iterator (test_set);
	iterator = _tmp2_;
	_tmp3_ = gee_bidir_iterator_has_previous (iterator);
	g_assert (!_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "one");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "three");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "four");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "five");
	g_assert (_tmp8_);
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "six");
	g_assert (_tmp9_);
	_tmp10_ = gee_sorted_set_bidir_iterator (test_set);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (iterator);
	iterator = _tmp11_;
	_tmp12_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (_tmp12_);
	_tmp13_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp14_ = (gchar*) _tmp13_;
	g_assert (g_strcmp0 (_tmp14_, "five") == 0);
	_g_free0 (_tmp14_);
	_tmp15_ = gee_bidir_iterator_has_previous (iterator);
	g_assert (!_tmp15_);
	_tmp16_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (_tmp16_);
	_tmp17_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp18_ = (gchar*) _tmp17_;
	g_assert (g_strcmp0 (_tmp18_, "four") == 0);
	_g_free0 (_tmp18_);
	_tmp19_ = gee_bidir_iterator_has_previous (iterator);
	g_assert (_tmp19_);
	_tmp20_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (_tmp20_);
	_tmp21_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp22_ = (gchar*) _tmp21_;
	g_assert (g_strcmp0 (_tmp22_, "one") == 0);
	_g_free0 (_tmp22_);
	_tmp23_ = gee_bidir_iterator_has_previous (iterator);
	g_assert (_tmp23_);
	_tmp24_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (_tmp24_);
	_tmp25_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp26_ = (gchar*) _tmp25_;
	g_assert (g_strcmp0 (_tmp26_, "six") == 0);
	_g_free0 (_tmp26_);
	_tmp27_ = gee_bidir_iterator_has_previous (iterator);
	g_assert (_tmp27_);
	_tmp28_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (_tmp28_);
	_tmp29_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp30_ = (gchar*) _tmp29_;
	g_assert (g_strcmp0 (_tmp30_, "three") == 0);
	_g_free0 (_tmp30_);
	_tmp31_ = gee_bidir_iterator_has_previous (iterator);
	g_assert (_tmp31_);
	_tmp32_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (_tmp32_);
	_tmp33_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp34_ = (gchar*) _tmp33_;
	g_assert (g_strcmp0 (_tmp34_, "two") == 0);
	_g_free0 (_tmp34_);
	_tmp35_ = gee_bidir_iterator_has_previous (iterator);
	g_assert (_tmp35_);
	_tmp36_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (!_tmp36_);
	_tmp37_ = gee_bidir_iterator_previous (iterator);
	g_assert (_tmp37_);
	_tmp38_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp39_ = (gchar*) _tmp38_;
	g_assert (g_strcmp0 (_tmp39_, "three") == 0);
	_g_free0 (_tmp39_);
	_tmp40_ = gee_bidir_iterator_previous (iterator);
	g_assert (_tmp40_);
	_tmp41_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp42_ = (gchar*) _tmp41_;
	g_assert (g_strcmp0 (_tmp42_, "six") == 0);
	_g_free0 (_tmp42_);
	_tmp43_ = gee_bidir_iterator_previous (iterator);
	g_assert (_tmp43_);
	_tmp44_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp45_ = (gchar*) _tmp44_;
	g_assert (g_strcmp0 (_tmp45_, "one") == 0);
	_g_free0 (_tmp45_);
	_tmp46_ = gee_bidir_iterator_previous (iterator);
	g_assert (_tmp46_);
	_tmp47_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp48_ = (gchar*) _tmp47_;
	g_assert (g_strcmp0 (_tmp48_, "four") == 0);
	_g_free0 (_tmp48_);
	_tmp49_ = gee_bidir_iterator_previous (iterator);
	g_assert (_tmp49_);
	_tmp50_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp51_ = (gchar*) _tmp50_;
	g_assert (g_strcmp0 (_tmp51_, "five") == 0);
	_g_free0 (_tmp51_);
	_tmp52_ = gee_bidir_iterator_previous (iterator);
	g_assert (!_tmp52_);
	_tmp53_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp54_ = (gchar*) _tmp53_;
	g_assert (g_strcmp0 (_tmp54_, "five") == 0);
	_g_free0 (_tmp54_);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_bidir_iterator_last (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	GeeBidirIterator* _tmp2_ = NULL;
	GeeBidirIterator* iterator;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GeeBidirIterator* _tmp10_ = NULL;
	GeeBidirIterator* _tmp11_;
	gboolean _tmp12_;
	gpointer _tmp13_ = NULL;
	gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_bidir_iterator (test_set);
	iterator = _tmp2_;
	_tmp3_ = gee_bidir_iterator_last (iterator);
	g_assert (!_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "one");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "three");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "four");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "five");
	g_assert (_tmp8_);
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "six");
	g_assert (_tmp9_);
	_tmp10_ = gee_sorted_set_bidir_iterator (test_set);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (iterator);
	iterator = _tmp11_;
	_tmp12_ = gee_bidir_iterator_last (iterator);
	g_assert (_tmp12_);
	_tmp13_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp14_ = (gchar*) _tmp13_;
	g_assert (g_strcmp0 (_tmp14_, "two") == 0);
	_g_free0 (_tmp14_);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_mutable_bidir_iterator (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* test_set;
	GeeBidirIterator* _tmp2_ = NULL;
	GeeBidirIterator* iterator;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GeeBidirIterator* _tmp10_ = NULL;
	GeeBidirIterator* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gpointer _tmp14_ = NULL;
	gchar* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	gboolean _tmp22_;
	gboolean _tmp23_;
	gpointer _tmp24_ = NULL;
	gchar* _tmp25_;
	gboolean _tmp26_;
	gpointer _tmp27_ = NULL;
	gchar* _tmp28_;
	gboolean _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	gboolean _tmp32_;
	gpointer _tmp33_ = NULL;
	gchar* _tmp34_;
	g_return_if_fail (self != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	test_set = _tmp1_;
	_tmp2_ = gee_sorted_set_bidir_iterator (test_set);
	iterator = _tmp2_;
	_tmp3_ = gee_bidir_iterator_has_previous (iterator);
	g_assert (!_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) test_set, "one");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) test_set, "two");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add ((GeeCollection*) test_set, "three");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) test_set, "four");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_add ((GeeCollection*) test_set, "five");
	g_assert (_tmp8_);
	_tmp9_ = gee_collection_add ((GeeCollection*) test_set, "six");
	g_assert (_tmp9_);
	_tmp10_ = gee_sorted_set_bidir_iterator (test_set);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (iterator);
	iterator = _tmp11_;
	_tmp12_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp12_) {
		gee_iterator_remove ((GeeIterator*) iterator);
		exit (0);
	}
	g_test_trap_assert_failed ();
	_tmp13_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (_tmp13_);
	_tmp14_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp15_ = (gchar*) _tmp14_;
	g_assert (g_strcmp0 (_tmp15_, "five") == 0);
	_g_free0 (_tmp15_);
	gee_iterator_remove ((GeeIterator*) iterator);
	_tmp16_ = gee_collection_contains ((GeeCollection*) test_set, "five");
	g_assert (!_tmp16_);
	_tmp17_ = gee_iterator_has_next ((GeeIterator*) iterator);
	g_assert (_tmp17_);
	_tmp18_ = gee_bidir_iterator_has_previous (iterator);
	g_assert (!_tmp18_);
	_tmp19_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
	if (_tmp19_) {
		gpointer _tmp20_ = NULL;
		gchar* _tmp21_;
		_tmp20_ = gee_iterator_get ((GeeIterator*) iterator);
		_tmp21_ = (gchar*) _tmp20_;
		_g_free0 (_tmp21_);
		exit (0);
	}
	_tmp22_ = gee_bidir_iterator_previous (iterator);
	g_assert (!_tmp22_);
	_tmp23_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (_tmp23_);
	_tmp24_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp25_ = (gchar*) _tmp24_;
	g_assert (g_strcmp0 (_tmp25_, "four") == 0);
	_g_free0 (_tmp25_);
	_tmp26_ = gee_iterator_next ((GeeIterator*) iterator);
	g_assert (_tmp26_);
	_tmp27_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp28_ = (gchar*) _tmp27_;
	g_assert (g_strcmp0 (_tmp28_, "one") == 0);
	_g_free0 (_tmp28_);
	gee_iterator_remove ((GeeIterator*) iterator);
	_tmp29_ = gee_collection_contains ((GeeCollection*) test_set, "one");
	g_assert (!_tmp29_);
	_tmp30_ = gee_iterator_has_next ((GeeIterator*) iterator);
	g_assert (_tmp30_);
	_tmp31_ = gee_bidir_iterator_has_previous (iterator);
	g_assert (_tmp31_);
	_tmp32_ = gee_bidir_iterator_previous (iterator);
	g_assert (_tmp32_);
	_tmp33_ = gee_iterator_get ((GeeIterator*) iterator);
	_tmp34_ = (gchar*) _tmp33_;
	g_assert (g_strcmp0 (_tmp34_, "four") == 0);
	_g_free0 (_tmp34_);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}


const gchar* sorted_set_tests_sub_set_type_to_string (SortedSetTestsSubSetType self) {
	const gchar* result = NULL;
	switch (self) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			result = "Head";
			return result;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			result = "Tail";
			return result;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			result = "Range";
			return result;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			result = "Empty";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


GType sorted_set_tests_sub_set_type_get_type (void) {
	static volatile gsize sorted_set_tests_sub_set_type_type_id__volatile = 0;
	if (g_once_init_enter (&sorted_set_tests_sub_set_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SORTED_SET_TESTS_SUB_SET_TYPE_HEAD, "SORTED_SET_TESTS_SUB_SET_TYPE_HEAD", "head"}, {SORTED_SET_TESTS_SUB_SET_TYPE_TAIL, "SORTED_SET_TESTS_SUB_SET_TYPE_TAIL", "tail"}, {SORTED_SET_TESTS_SUB_SET_TYPE_SUB, "SORTED_SET_TESTS_SUB_SET_TYPE_SUB", "sub"}, {SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY, "SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY", "empty"}, {0, NULL, NULL}};
		GType sorted_set_tests_sub_set_type_type_id;
		sorted_set_tests_sub_set_type_type_id = g_enum_register_static ("SortedSetTestsSubSetType", values);
		g_once_init_leave (&sorted_set_tests_sub_set_type_type_id__volatile, sorted_set_tests_sub_set_type_type_id);
	}
	return sorted_set_tests_sub_set_type_type_id__volatile;
}


static void _sorted_set_tests_sub_set_test_size_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_size (self);
}


static void _sorted_set_tests_sub_set_test_contains_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_contains (self);
}


static void _sorted_set_tests_sub_set_test_add_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_add (self);
}


static void _sorted_set_tests_sub_set_test_remove_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_remove (self);
}


static void _sorted_set_tests_sub_set_test_iterator_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_iterator (self);
}


static void _sorted_set_tests_sub_set_test_clear_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_clear (self);
}


static void _sorted_set_tests_sub_set_test_iterator_at_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_iterator_at (self);
}


static void _sorted_set_tests_sub_set_test_lower_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_lower (self);
}


static void _sorted_set_tests_sub_set_test_higher_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_higher (self);
}


static void _sorted_set_tests_sub_set_test_ceil_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_ceil (self);
}


static void _sorted_set_tests_sub_set_test_floor_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_floor (self);
}


static void _sorted_set_tests_sub_set_test_subsets_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_subsets (self);
}


static void _sorted_set_tests_sub_set_test_boundaries_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_boundaries (self);
}


SortedSetTestsSubSet* sorted_set_tests_sub_set_construct (GType object_type, SortedSetTests* test, SortedSetTestsSubSetType type) {
	SortedSetTestsSubSet * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	SortedSetTests* _tmp3_;
	SortedSetTests* _tmp4_;
	g_return_val_if_fail (test != NULL, NULL);
	_tmp0_ = sorted_set_tests_sub_set_type_to_string (type);
	_tmp1_ = g_strdup_printf ("%s Subset", _tmp0_);
	_tmp2_ = _tmp1_;
	self = (SortedSetTestsSubSet*) gee_test_case_construct (object_type, _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = _g_object_ref0 (test);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->test);
	self->priv->test = _tmp4_;
	self->priv->type = type;
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] size", _sorted_set_tests_sub_set_test_size_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains", _sorted_set_tests_sub_set_test_contains_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add", _sorted_set_tests_sub_set_test_add_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] remove", _sorted_set_tests_sub_set_test_remove_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] iterator", _sorted_set_tests_sub_set_test_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] clear", _sorted_set_tests_sub_set_test_clear_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] iterator at", _sorted_set_tests_sub_set_test_iterator_at_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] lower", _sorted_set_tests_sub_set_test_lower_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] higher", _sorted_set_tests_sub_set_test_higher_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] ceil", _sorted_set_tests_sub_set_test_ceil_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] floor", _sorted_set_tests_sub_set_test_floor_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] subsets", _sorted_set_tests_sub_set_test_subsets_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] boundaries", _sorted_set_tests_sub_set_test_boundaries_gee_test_case_test_method, self);
	return self;
}


SortedSetTestsSubSet* sorted_set_tests_sub_set_new (SortedSetTests* test, SortedSetTestsSubSetType type) {
	return sorted_set_tests_sub_set_construct (SORTED_SET_TESTS_TYPE_SUB_SET, test, type);
}


static void sorted_set_tests_sub_set_real_set_up (GeeTestCase* base) {
	SortedSetTestsSubSet * self;
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	GeeSortedSet* _tmp2_;
	self = (SortedSetTestsSubSet*) base;
	gee_test_case_set_up ((GeeTestCase*) self->priv->test);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self->priv->test)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	_tmp2_ = _tmp1_;
	_g_object_unref0 (self->priv->master);
	self->priv->master = _tmp2_;
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			GeeSortedSet* _tmp3_ = NULL;
			GeeSortedSet* _tmp4_;
			_tmp3_ = gee_sorted_set_head_set (self->priv->master, "one");
			_tmp4_ = _tmp3_;
			_g_object_unref0 (self->priv->subset);
			self->priv->subset = _tmp4_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			GeeSortedSet* _tmp5_ = NULL;
			GeeSortedSet* _tmp6_;
			_tmp5_ = gee_sorted_set_tail_set (self->priv->master, "six");
			_tmp6_ = _tmp5_;
			_g_object_unref0 (self->priv->subset);
			self->priv->subset = _tmp6_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			GeeSortedSet* _tmp7_ = NULL;
			GeeSortedSet* _tmp8_;
			_tmp7_ = gee_sorted_set_sub_set (self->priv->master, "four", "three");
			_tmp8_ = _tmp7_;
			_g_object_unref0 (self->priv->subset);
			self->priv->subset = _tmp8_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp9_ = NULL;
			GeeSortedSet* _tmp10_;
			_tmp9_ = gee_sorted_set_sub_set (self->priv->master, "three", "four");
			_tmp10_ = _tmp9_;
			_g_object_unref0 (self->priv->subset);
			self->priv->subset = _tmp10_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void sorted_set_tests_sub_set_real_tear_down (GeeTestCase* base) {
	SortedSetTestsSubSet * self;
	self = (SortedSetTestsSubSet*) base;
	gee_test_case_tear_down ((GeeTestCase*) self->priv->test);
}


void sorted_set_tests_sub_set_test_size (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gint _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_get_is_empty ((GeeCollection*) self->priv->subset);
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->subset);
	g_assert (_tmp1_ == 0);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp6_);
	_tmp7_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp7_);
	_tmp8_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp8_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gboolean _tmp9_;
			gint _tmp10_;
			_tmp9_ = gee_collection_get_is_empty ((GeeCollection*) self->priv->subset);
			g_assert (!_tmp9_);
			_tmp10_ = gee_collection_get_size ((GeeCollection*) self->priv->subset);
			g_assert (_tmp10_ == 2);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gboolean _tmp11_;
			gint _tmp12_;
			_tmp11_ = gee_collection_get_is_empty ((GeeCollection*) self->priv->subset);
			g_assert (!_tmp11_);
			_tmp12_ = gee_collection_get_size ((GeeCollection*) self->priv->subset);
			g_assert (_tmp12_ == 3);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gboolean _tmp13_;
			gint _tmp14_;
			_tmp13_ = gee_collection_get_is_empty ((GeeCollection*) self->priv->subset);
			g_assert (!_tmp13_);
			_tmp14_ = gee_collection_get_size ((GeeCollection*) self->priv->subset);
			g_assert (_tmp14_ == 3);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gboolean _tmp15_;
			gint _tmp16_;
			_tmp15_ = gee_collection_get_is_empty ((GeeCollection*) self->priv->subset);
			g_assert (_tmp15_);
			_tmp16_ = gee_collection_get_size ((GeeCollection*) self->priv->subset);
			g_assert (_tmp16_ == 0);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_contains (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	gchar** not_contains = NULL;
	gint not_contains_length1 = 0;
	gint _not_contains_size_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp6_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_ = NULL;
			gchar** _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar** _tmp15_ = NULL;
			gchar** _tmp16_;
			_tmp7_ = g_strdup ("four");
			_tmp8_ = g_strdup ("five");
			_tmp9_ = g_new0 (gchar*, 2 + 1);
			_tmp9_[0] = _tmp7_;
			_tmp9_[1] = _tmp8_;
			_tmp10_ = _tmp9_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			contains = _tmp10_;
			_tmp11_ = g_strdup ("one");
			_tmp12_ = g_strdup ("two");
			_tmp13_ = g_strdup ("three");
			_tmp14_ = g_strdup ("six");
			_tmp15_ = g_new0 (gchar*, 4 + 1);
			_tmp15_[0] = _tmp11_;
			_tmp15_[1] = _tmp12_;
			_tmp15_[2] = _tmp13_;
			_tmp15_[3] = _tmp14_;
			_tmp16_ = _tmp15_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 4;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp16_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** _tmp20_ = NULL;
			gchar** _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar** _tmp25_ = NULL;
			gchar** _tmp26_;
			_tmp17_ = g_strdup ("two");
			_tmp18_ = g_strdup ("three");
			_tmp19_ = g_strdup ("six");
			_tmp20_ = g_new0 (gchar*, 3 + 1);
			_tmp20_[0] = _tmp17_;
			_tmp20_[1] = _tmp18_;
			_tmp20_[2] = _tmp19_;
			_tmp21_ = _tmp20_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			contains = _tmp21_;
			_tmp22_ = g_strdup ("one");
			_tmp23_ = g_strdup ("four");
			_tmp24_ = g_strdup ("five");
			_tmp25_ = g_new0 (gchar*, 3 + 1);
			_tmp25_[0] = _tmp22_;
			_tmp25_[1] = _tmp23_;
			_tmp25_[2] = _tmp24_;
			_tmp26_ = _tmp25_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp26_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar** _tmp30_ = NULL;
			gchar** _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar** _tmp35_ = NULL;
			gchar** _tmp36_;
			_tmp27_ = g_strdup ("one");
			_tmp28_ = g_strdup ("four");
			_tmp29_ = g_strdup ("six");
			_tmp30_ = g_new0 (gchar*, 3 + 1);
			_tmp30_[0] = _tmp27_;
			_tmp30_[1] = _tmp28_;
			_tmp30_[2] = _tmp29_;
			_tmp31_ = _tmp30_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			contains = _tmp31_;
			_tmp32_ = g_strdup ("two");
			_tmp33_ = g_strdup ("three");
			_tmp34_ = g_strdup ("five");
			_tmp35_ = g_new0 (gchar*, 3 + 1);
			_tmp35_[0] = _tmp32_;
			_tmp35_[1] = _tmp33_;
			_tmp35_[2] = _tmp34_;
			_tmp36_ = _tmp35_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp36_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gchar** _tmp37_ = NULL;
			gchar** _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar** _tmp45_ = NULL;
			gchar** _tmp46_;
			_tmp37_ = g_new0 (gchar*, 0 + 1);
			_tmp38_ = _tmp37_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			contains = _tmp38_;
			_tmp39_ = g_strdup ("one");
			_tmp40_ = g_strdup ("two");
			_tmp41_ = g_strdup ("three");
			_tmp42_ = g_strdup ("four");
			_tmp43_ = g_strdup ("five");
			_tmp44_ = g_strdup ("six");
			_tmp45_ = g_new0 (gchar*, 6 + 1);
			_tmp45_[0] = _tmp39_;
			_tmp45_[1] = _tmp40_;
			_tmp45_[2] = _tmp41_;
			_tmp45_[3] = _tmp42_;
			_tmp45_[4] = _tmp43_;
			_tmp45_[5] = _tmp44_;
			_tmp46_ = _tmp45_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 6;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp46_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = contains;
		s_collection_length1 = contains_length1;
		for (s_it = 0; s_it < contains_length1; s_it = s_it + 1) {
			gchar* _tmp47_;
			gchar* s;
			_tmp47_ = g_strdup (s_collection[s_it]);
			s = _tmp47_;
			{
				gboolean _tmp48_;
				_tmp48_ = gee_collection_contains ((GeeCollection*) self->priv->subset, s);
				g_assert (_tmp48_);
				_g_free0 (s);
			}
		}
	}
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = not_contains;
		s_collection_length1 = not_contains_length1;
		for (s_it = 0; s_it < not_contains_length1; s_it = s_it + 1) {
			gchar* _tmp49_;
			gchar* s;
			_tmp49_ = g_strdup (s_collection[s_it]);
			s = _tmp49_;
			{
				gboolean _tmp50_;
				_tmp50_ = gee_collection_contains ((GeeCollection*) self->priv->subset, s);
				g_assert (!_tmp50_);
				_g_free0 (s);
			}
		}
	}
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_add (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gchar** success = NULL;
	gint success_length1 = 0;
	gint _success_size_ = 0;
	gchar** fail = NULL;
	gint fail_length1 = 0;
	gint _fail_size_ = 0;
	gint _tmp47_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp6_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_ = NULL;
			gchar** _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar** _tmp13_ = NULL;
			gchar** _tmp14_;
			_tmp7_ = g_strdup ("a");
			_tmp8_ = g_strdup ("o");
			_tmp9_ = g_new0 (gchar*, 2 + 1);
			_tmp9_[0] = _tmp7_;
			_tmp9_[1] = _tmp8_;
			_tmp10_ = _tmp9_;
			success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
			success_length1 = 2;
			_success_size_ = success_length1;
			success = _tmp10_;
			_tmp11_ = g_strdup ("oz");
			_tmp12_ = g_strdup ("z");
			_tmp13_ = g_new0 (gchar*, 2 + 1);
			_tmp13_[0] = _tmp11_;
			_tmp13_[1] = _tmp12_;
			_tmp14_ = _tmp13_;
			fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
			fail_length1 = 2;
			_fail_size_ = fail_length1;
			fail = _tmp14_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar** _tmp17_ = NULL;
			gchar** _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar** _tmp21_ = NULL;
			gchar** _tmp22_;
			_tmp15_ = g_strdup ("siz");
			_tmp16_ = g_strdup ("z");
			_tmp17_ = g_new0 (gchar*, 2 + 1);
			_tmp17_[0] = _tmp15_;
			_tmp17_[1] = _tmp16_;
			_tmp18_ = _tmp17_;
			success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
			success_length1 = 2;
			_success_size_ = success_length1;
			success = _tmp18_;
			_tmp19_ = g_strdup ("sia");
			_tmp20_ = g_strdup ("a");
			_tmp21_ = g_new0 (gchar*, 2 + 1);
			_tmp21_[0] = _tmp19_;
			_tmp21_[1] = _tmp20_;
			_tmp22_ = _tmp21_;
			fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
			fail_length1 = 2;
			_fail_size_ = fail_length1;
			fail = _tmp22_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar** _tmp25_ = NULL;
			gchar** _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar** _tmp29_ = NULL;
			gchar** _tmp30_;
			_tmp23_ = g_strdup ("o");
			_tmp24_ = g_strdup ("th");
			_tmp25_ = g_new0 (gchar*, 2 + 1);
			_tmp25_[0] = _tmp23_;
			_tmp25_[1] = _tmp24_;
			_tmp26_ = _tmp25_;
			success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
			success_length1 = 2;
			_success_size_ = success_length1;
			success = _tmp26_;
			_tmp27_ = g_strdup ("f");
			_tmp28_ = g_strdup ("u");
			_tmp29_ = g_new0 (gchar*, 2 + 1);
			_tmp29_[0] = _tmp27_;
			_tmp29_[1] = _tmp28_;
			_tmp30_ = _tmp29_;
			fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
			fail_length1 = 2;
			_fail_size_ = fail_length1;
			fail = _tmp30_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gchar** _tmp31_ = NULL;
			gchar** _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar** _tmp37_ = NULL;
			gchar** _tmp38_;
			_tmp31_ = g_new0 (gchar*, 0 + 1);
			_tmp32_ = _tmp31_;
			success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
			success_length1 = 0;
			_success_size_ = success_length1;
			success = _tmp32_;
			_tmp33_ = g_strdup ("o");
			_tmp34_ = g_strdup ("th");
			_tmp35_ = g_strdup ("f");
			_tmp36_ = g_strdup ("u");
			_tmp37_ = g_new0 (gchar*, 4 + 1);
			_tmp37_[0] = _tmp33_;
			_tmp37_[1] = _tmp34_;
			_tmp37_[2] = _tmp35_;
			_tmp37_[3] = _tmp36_;
			_tmp38_ = _tmp37_;
			fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
			fail_length1 = 4;
			_fail_size_ = fail_length1;
			fail = _tmp38_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = success;
		s_collection_length1 = success_length1;
		for (s_it = 0; s_it < success_length1; s_it = s_it + 1) {
			gchar* _tmp39_;
			gchar* s;
			_tmp39_ = g_strdup (s_collection[s_it]);
			s = _tmp39_;
			{
				gboolean _tmp40_;
				gboolean _tmp41_;
				gboolean _tmp42_;
				_tmp40_ = gee_collection_add ((GeeCollection*) self->priv->subset, s);
				g_assert (_tmp40_);
				_tmp41_ = gee_collection_contains ((GeeCollection*) self->priv->subset, s);
				g_assert (_tmp41_);
				_tmp42_ = gee_collection_contains ((GeeCollection*) self->priv->master, s);
				g_assert (_tmp42_);
				_g_free0 (s);
			}
		}
	}
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = fail;
		s_collection_length1 = fail_length1;
		for (s_it = 0; s_it < fail_length1; s_it = s_it + 1) {
			gchar* _tmp43_;
			gchar* s;
			_tmp43_ = g_strdup (s_collection[s_it]);
			s = _tmp43_;
			{
				gboolean _tmp44_;
				gboolean _tmp45_;
				gboolean _tmp46_;
				_tmp44_ = gee_collection_add ((GeeCollection*) self->priv->subset, s);
				g_assert (!_tmp44_);
				_tmp45_ = gee_collection_contains ((GeeCollection*) self->priv->subset, s);
				g_assert (!_tmp45_);
				_tmp46_ = gee_collection_contains ((GeeCollection*) self->priv->master, s);
				g_assert (!_tmp46_);
				_g_free0 (s);
			}
		}
	}
	_tmp47_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp47_ == (6 + success_length1));
	fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
	success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_remove (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	gchar** not_contains = NULL;
	gint not_contains_length1 = 0;
	gint _not_contains_size_ = 0;
	gint _tmp53_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp6_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_ = NULL;
			gchar** _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar** _tmp15_ = NULL;
			gchar** _tmp16_;
			_tmp7_ = g_strdup ("four");
			_tmp8_ = g_strdup ("five");
			_tmp9_ = g_new0 (gchar*, 2 + 1);
			_tmp9_[0] = _tmp7_;
			_tmp9_[1] = _tmp8_;
			_tmp10_ = _tmp9_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			contains = _tmp10_;
			_tmp11_ = g_strdup ("one");
			_tmp12_ = g_strdup ("two");
			_tmp13_ = g_strdup ("three");
			_tmp14_ = g_strdup ("six");
			_tmp15_ = g_new0 (gchar*, 4 + 1);
			_tmp15_[0] = _tmp11_;
			_tmp15_[1] = _tmp12_;
			_tmp15_[2] = _tmp13_;
			_tmp15_[3] = _tmp14_;
			_tmp16_ = _tmp15_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 4;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp16_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** _tmp20_ = NULL;
			gchar** _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar** _tmp25_ = NULL;
			gchar** _tmp26_;
			_tmp17_ = g_strdup ("two");
			_tmp18_ = g_strdup ("three");
			_tmp19_ = g_strdup ("six");
			_tmp20_ = g_new0 (gchar*, 3 + 1);
			_tmp20_[0] = _tmp17_;
			_tmp20_[1] = _tmp18_;
			_tmp20_[2] = _tmp19_;
			_tmp21_ = _tmp20_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			contains = _tmp21_;
			_tmp22_ = g_strdup ("one");
			_tmp23_ = g_strdup ("four");
			_tmp24_ = g_strdup ("five");
			_tmp25_ = g_new0 (gchar*, 3 + 1);
			_tmp25_[0] = _tmp22_;
			_tmp25_[1] = _tmp23_;
			_tmp25_[2] = _tmp24_;
			_tmp26_ = _tmp25_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp26_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar** _tmp30_ = NULL;
			gchar** _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar** _tmp35_ = NULL;
			gchar** _tmp36_;
			_tmp27_ = g_strdup ("one");
			_tmp28_ = g_strdup ("four");
			_tmp29_ = g_strdup ("six");
			_tmp30_ = g_new0 (gchar*, 3 + 1);
			_tmp30_[0] = _tmp27_;
			_tmp30_[1] = _tmp28_;
			_tmp30_[2] = _tmp29_;
			_tmp31_ = _tmp30_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			contains = _tmp31_;
			_tmp32_ = g_strdup ("two");
			_tmp33_ = g_strdup ("three");
			_tmp34_ = g_strdup ("five");
			_tmp35_ = g_new0 (gchar*, 3 + 1);
			_tmp35_[0] = _tmp32_;
			_tmp35_[1] = _tmp33_;
			_tmp35_[2] = _tmp34_;
			_tmp36_ = _tmp35_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp36_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gchar** _tmp37_ = NULL;
			gchar** _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar** _tmp45_ = NULL;
			gchar** _tmp46_;
			_tmp37_ = g_new0 (gchar*, 0 + 1);
			_tmp38_ = _tmp37_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			contains = _tmp38_;
			_tmp39_ = g_strdup ("one");
			_tmp40_ = g_strdup ("two");
			_tmp41_ = g_strdup ("three");
			_tmp42_ = g_strdup ("four");
			_tmp43_ = g_strdup ("five");
			_tmp44_ = g_strdup ("six");
			_tmp45_ = g_new0 (gchar*, 6 + 1);
			_tmp45_[0] = _tmp39_;
			_tmp45_[1] = _tmp40_;
			_tmp45_[2] = _tmp41_;
			_tmp45_[3] = _tmp42_;
			_tmp45_[4] = _tmp43_;
			_tmp45_[5] = _tmp44_;
			_tmp46_ = _tmp45_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 6;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp46_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = contains;
		s_collection_length1 = contains_length1;
		for (s_it = 0; s_it < contains_length1; s_it = s_it + 1) {
			gchar* _tmp47_;
			gchar* s;
			_tmp47_ = g_strdup (s_collection[s_it]);
			s = _tmp47_;
			{
				gboolean _tmp48_;
				gboolean _tmp49_;
				_tmp48_ = gee_collection_remove ((GeeCollection*) self->priv->subset, s);
				g_assert (_tmp48_);
				_tmp49_ = gee_collection_contains ((GeeCollection*) self->priv->master, s);
				g_assert (!_tmp49_);
				_g_free0 (s);
			}
		}
	}
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = not_contains;
		s_collection_length1 = not_contains_length1;
		for (s_it = 0; s_it < not_contains_length1; s_it = s_it + 1) {
			gchar* _tmp50_;
			gchar* s;
			_tmp50_ = g_strdup (s_collection[s_it]);
			s = _tmp50_;
			{
				gboolean _tmp51_;
				gboolean _tmp52_;
				_tmp51_ = gee_collection_remove ((GeeCollection*) self->priv->subset, s);
				g_assert (!_tmp51_);
				_tmp52_ = gee_collection_contains ((GeeCollection*) self->priv->master, s);
				g_assert (_tmp52_);
				_g_free0 (s);
			}
		}
	}
	_tmp53_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp53_ == (6 - contains_length1));
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_iterator (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	guint i;
	GeeBidirIterator* _tmp27_ = NULL;
	GeeBidirIterator* iter;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp6_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_ = NULL;
			gchar** _tmp10_;
			_tmp7_ = g_strdup ("five");
			_tmp8_ = g_strdup ("four");
			_tmp9_ = g_new0 (gchar*, 2 + 1);
			_tmp9_[0] = _tmp7_;
			_tmp9_[1] = _tmp8_;
			_tmp10_ = _tmp9_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			contains = _tmp10_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar** _tmp14_ = NULL;
			gchar** _tmp15_;
			_tmp11_ = g_strdup ("six");
			_tmp12_ = g_strdup ("three");
			_tmp13_ = g_strdup ("two");
			_tmp14_ = g_new0 (gchar*, 3 + 1);
			_tmp14_[0] = _tmp11_;
			_tmp14_[1] = _tmp12_;
			_tmp14_[2] = _tmp13_;
			_tmp15_ = _tmp14_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			contains = _tmp15_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar** _tmp19_ = NULL;
			gchar** _tmp20_;
			_tmp16_ = g_strdup ("four");
			_tmp17_ = g_strdup ("one");
			_tmp18_ = g_strdup ("six");
			_tmp19_ = g_new0 (gchar*, 3 + 1);
			_tmp19_[0] = _tmp16_;
			_tmp19_[1] = _tmp17_;
			_tmp19_[2] = _tmp18_;
			_tmp20_ = _tmp19_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			contains = _tmp20_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gchar** _tmp21_ = NULL;
			gchar** _tmp22_;
			_tmp21_ = g_new0 (gchar*, 0 + 1);
			_tmp22_ = _tmp21_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			contains = _tmp22_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	i = (guint) 0;
	{
		GeeIterator* _tmp23_ = NULL;
		GeeIterator* _e_it;
		_tmp23_ = gee_iterable_iterator ((GeeIterable*) self->priv->subset);
		_e_it = _tmp23_;
		while (TRUE) {
			gboolean _tmp24_;
			gpointer _tmp25_ = NULL;
			gchar* e;
			guint _tmp26_;
			_tmp24_ = gee_iterator_next (_e_it);
			if (!_tmp24_) {
				break;
			}
			_tmp25_ = gee_iterator_get (_e_it);
			e = (gchar*) _tmp25_;
			_tmp26_ = i;
			i = _tmp26_ + 1;
			g_assert (g_strcmp0 (e, contains[_tmp26_]) == 0);
			_g_free0 (e);
		}
		_g_object_unref0 (_e_it);
	}
	g_assert (i == contains_length1);
	_tmp27_ = gee_sorted_set_bidir_iterator (self->priv->subset);
	iter = _tmp27_;
	if (self->priv->type != SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY) {
		gboolean _tmp28_;
		gpointer _tmp29_ = NULL;
		gchar* _tmp30_;
		gboolean _tmp31_;
		gpointer _tmp32_ = NULL;
		gchar* _tmp33_;
		gboolean _tmp34_;
		gboolean _tmp35_;
		gpointer _tmp36_ = NULL;
		gchar* _tmp37_;
		gboolean _tmp38_;
		gboolean _tmp39_;
		gboolean _tmp42_;
		gpointer _tmp43_ = NULL;
		gchar* _tmp44_;
		_tmp28_ = gee_bidir_iterator_last (iter);
		g_assert (_tmp28_);
		_tmp29_ = gee_iterator_get ((GeeIterator*) iter);
		_tmp30_ = (gchar*) _tmp29_;
		g_assert (g_strcmp0 (_tmp30_, contains[contains_length1 - 1]) == 0);
		_g_free0 (_tmp30_);
		_tmp31_ = gee_iterator_first ((GeeIterator*) iter);
		g_assert (_tmp31_);
		_tmp32_ = gee_iterator_get ((GeeIterator*) iter);
		_tmp33_ = (gchar*) _tmp32_;
		g_assert (g_strcmp0 (_tmp33_, contains[0]) == 0);
		_g_free0 (_tmp33_);
		_tmp34_ = gee_iterator_has_next ((GeeIterator*) iter);
		g_assert (_tmp34_);
		_tmp35_ = gee_iterator_next ((GeeIterator*) iter);
		g_assert (_tmp35_);
		_tmp36_ = gee_iterator_get ((GeeIterator*) iter);
		_tmp37_ = (gchar*) _tmp36_;
		g_assert (g_strcmp0 (_tmp37_, contains[1]) == 0);
		_g_free0 (_tmp37_);
		_tmp38_ = gee_bidir_iterator_has_previous (iter);
		g_assert (_tmp38_);
		gee_iterator_remove ((GeeIterator*) iter);
		_tmp39_ = gee_bidir_iterator_has_previous (iter);
		g_assert (_tmp39_);
		if (self->priv->type != SORTED_SET_TESTS_SUB_SET_TYPE_HEAD) {
			gboolean _tmp40_;
			_tmp40_ = gee_iterator_has_next ((GeeIterator*) iter);
			g_assert (_tmp40_);
		} else {
			gboolean _tmp41_;
			_tmp41_ = gee_iterator_has_next ((GeeIterator*) iter);
			g_assert (!_tmp41_);
		}
		_tmp42_ = gee_bidir_iterator_previous (iter);
		g_assert (_tmp42_);
		_tmp43_ = gee_iterator_get ((GeeIterator*) iter);
		_tmp44_ = (gchar*) _tmp43_;
		g_assert (g_strcmp0 (_tmp44_, contains[0]) == 0);
		_g_free0 (_tmp44_);
	} else {
		gboolean _tmp45_;
		gboolean _tmp46_;
		_tmp45_ = gee_iterator_first ((GeeIterator*) iter);
		g_assert (!_tmp45_);
		_tmp46_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
		if (_tmp46_) {
			gee_iterator_remove ((GeeIterator*) iter);
			exit (0);
		}
		g_test_trap_assert_failed ();
	}
	_g_object_unref0 (iter);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_clear (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	gchar** not_contains = NULL;
	gint not_contains_length1 = 0;
	gint _not_contains_size_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp6_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_ = NULL;
			gchar** _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar** _tmp15_ = NULL;
			gchar** _tmp16_;
			_tmp7_ = g_strdup ("four");
			_tmp8_ = g_strdup ("five");
			_tmp9_ = g_new0 (gchar*, 2 + 1);
			_tmp9_[0] = _tmp7_;
			_tmp9_[1] = _tmp8_;
			_tmp10_ = _tmp9_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			contains = _tmp10_;
			_tmp11_ = g_strdup ("one");
			_tmp12_ = g_strdup ("two");
			_tmp13_ = g_strdup ("three");
			_tmp14_ = g_strdup ("six");
			_tmp15_ = g_new0 (gchar*, 4 + 1);
			_tmp15_[0] = _tmp11_;
			_tmp15_[1] = _tmp12_;
			_tmp15_[2] = _tmp13_;
			_tmp15_[3] = _tmp14_;
			_tmp16_ = _tmp15_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 4;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp16_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** _tmp20_ = NULL;
			gchar** _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar** _tmp25_ = NULL;
			gchar** _tmp26_;
			_tmp17_ = g_strdup ("two");
			_tmp18_ = g_strdup ("three");
			_tmp19_ = g_strdup ("six");
			_tmp20_ = g_new0 (gchar*, 3 + 1);
			_tmp20_[0] = _tmp17_;
			_tmp20_[1] = _tmp18_;
			_tmp20_[2] = _tmp19_;
			_tmp21_ = _tmp20_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			contains = _tmp21_;
			_tmp22_ = g_strdup ("one");
			_tmp23_ = g_strdup ("four");
			_tmp24_ = g_strdup ("five");
			_tmp25_ = g_new0 (gchar*, 3 + 1);
			_tmp25_[0] = _tmp22_;
			_tmp25_[1] = _tmp23_;
			_tmp25_[2] = _tmp24_;
			_tmp26_ = _tmp25_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp26_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar** _tmp30_ = NULL;
			gchar** _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar** _tmp35_ = NULL;
			gchar** _tmp36_;
			_tmp27_ = g_strdup ("one");
			_tmp28_ = g_strdup ("four");
			_tmp29_ = g_strdup ("six");
			_tmp30_ = g_new0 (gchar*, 3 + 1);
			_tmp30_[0] = _tmp27_;
			_tmp30_[1] = _tmp28_;
			_tmp30_[2] = _tmp29_;
			_tmp31_ = _tmp30_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			contains = _tmp31_;
			_tmp32_ = g_strdup ("two");
			_tmp33_ = g_strdup ("three");
			_tmp34_ = g_strdup ("five");
			_tmp35_ = g_new0 (gchar*, 3 + 1);
			_tmp35_[0] = _tmp32_;
			_tmp35_[1] = _tmp33_;
			_tmp35_[2] = _tmp34_;
			_tmp36_ = _tmp35_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp36_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gchar** _tmp37_ = NULL;
			gchar** _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar** _tmp45_ = NULL;
			gchar** _tmp46_;
			_tmp37_ = g_new0 (gchar*, 0 + 1);
			_tmp38_ = _tmp37_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			contains = _tmp38_;
			_tmp39_ = g_strdup ("one");
			_tmp40_ = g_strdup ("two");
			_tmp41_ = g_strdup ("three");
			_tmp42_ = g_strdup ("four");
			_tmp43_ = g_strdup ("five");
			_tmp44_ = g_strdup ("six");
			_tmp45_ = g_new0 (gchar*, 6 + 1);
			_tmp45_[0] = _tmp39_;
			_tmp45_[1] = _tmp40_;
			_tmp45_[2] = _tmp41_;
			_tmp45_[3] = _tmp42_;
			_tmp45_[4] = _tmp43_;
			_tmp45_[5] = _tmp44_;
			_tmp46_ = _tmp45_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 6;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp46_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	gee_collection_clear ((GeeCollection*) self->priv->subset);
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = contains;
		s_collection_length1 = contains_length1;
		for (s_it = 0; s_it < contains_length1; s_it = s_it + 1) {
			gchar* _tmp47_;
			gchar* s;
			_tmp47_ = g_strdup (s_collection[s_it]);
			s = _tmp47_;
			{
				gboolean _tmp48_;
				_tmp48_ = gee_collection_contains ((GeeCollection*) self->priv->master, s);
				g_assert (!_tmp48_);
				_g_free0 (s);
			}
		}
	}
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = not_contains;
		s_collection_length1 = not_contains_length1;
		for (s_it = 0; s_it < not_contains_length1; s_it = s_it + 1) {
			gchar* _tmp49_;
			gchar* s;
			_tmp49_ = g_strdup (s_collection[s_it]);
			s = _tmp49_;
			{
				gboolean _tmp50_;
				_tmp50_ = gee_collection_contains ((GeeCollection*) self->priv->master, s);
				g_assert (_tmp50_);
				_g_free0 (s);
			}
		}
	}
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_boundaries (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp6_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gpointer _tmp7_ = NULL;
			gchar* _tmp8_;
			gpointer _tmp9_ = NULL;
			gchar* _tmp10_;
			_tmp7_ = gee_sorted_set_first (self->priv->subset);
			_tmp8_ = (gchar*) _tmp7_;
			g_assert (g_strcmp0 (_tmp8_, "five") == 0);
			_g_free0 (_tmp8_);
			_tmp9_ = gee_sorted_set_last (self->priv->subset);
			_tmp10_ = (gchar*) _tmp9_;
			g_assert (g_strcmp0 (_tmp10_, "four") == 0);
			_g_free0 (_tmp10_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gpointer _tmp11_ = NULL;
			gchar* _tmp12_;
			gpointer _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp11_ = gee_sorted_set_first (self->priv->subset);
			_tmp12_ = (gchar*) _tmp11_;
			g_assert (g_strcmp0 (_tmp12_, "six") == 0);
			_g_free0 (_tmp12_);
			_tmp13_ = gee_sorted_set_last (self->priv->subset);
			_tmp14_ = (gchar*) _tmp13_;
			g_assert (g_strcmp0 (_tmp14_, "two") == 0);
			_g_free0 (_tmp14_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gpointer _tmp15_ = NULL;
			gchar* _tmp16_;
			gpointer _tmp17_ = NULL;
			gchar* _tmp18_;
			_tmp15_ = gee_sorted_set_first (self->priv->subset);
			_tmp16_ = (gchar*) _tmp15_;
			g_assert (g_strcmp0 (_tmp16_, "four") == 0);
			_g_free0 (_tmp16_);
			_tmp17_ = gee_sorted_set_last (self->priv->subset);
			_tmp18_ = (gchar*) _tmp17_;
			g_assert (g_strcmp0 (_tmp18_, "six") == 0);
			_g_free0 (_tmp18_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gboolean _tmp19_;
			gboolean _tmp22_;
			_tmp19_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
			if (_tmp19_) {
				gpointer _tmp20_ = NULL;
				gchar* _tmp21_;
				_tmp20_ = gee_sorted_set_first (self->priv->subset);
				_tmp21_ = (gchar*) _tmp20_;
				_g_free0 (_tmp21_);
				exit (0);
			}
			g_test_trap_assert_failed ();
			_tmp22_ = g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR);
			if (_tmp22_) {
				gpointer _tmp23_ = NULL;
				gchar* _tmp24_;
				_tmp23_ = gee_sorted_set_last (self->priv->subset);
				_tmp24_ = (gchar*) _tmp23_;
				_g_free0 (_tmp24_);
				exit (0);
			}
			g_test_trap_assert_failed ();
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_iterator_at (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	gchar** contains = NULL;
	gint contains_length1 = 0;
	gint _contains_size_ = 0;
	gchar** not_contains = NULL;
	gint not_contains_length1 = 0;
	gint _not_contains_size_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp6_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar** _tmp9_ = NULL;
			gchar** _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar** _tmp15_ = NULL;
			gchar** _tmp16_;
			_tmp7_ = g_strdup ("four");
			_tmp8_ = g_strdup ("five");
			_tmp9_ = g_new0 (gchar*, 2 + 1);
			_tmp9_[0] = _tmp7_;
			_tmp9_[1] = _tmp8_;
			_tmp10_ = _tmp9_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 2;
			_contains_size_ = contains_length1;
			contains = _tmp10_;
			_tmp11_ = g_strdup ("one");
			_tmp12_ = g_strdup ("two");
			_tmp13_ = g_strdup ("three");
			_tmp14_ = g_strdup ("six");
			_tmp15_ = g_new0 (gchar*, 4 + 1);
			_tmp15_[0] = _tmp11_;
			_tmp15_[1] = _tmp12_;
			_tmp15_[2] = _tmp13_;
			_tmp15_[3] = _tmp14_;
			_tmp16_ = _tmp15_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 4;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp16_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar** _tmp20_ = NULL;
			gchar** _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			gchar** _tmp25_ = NULL;
			gchar** _tmp26_;
			_tmp17_ = g_strdup ("two");
			_tmp18_ = g_strdup ("three");
			_tmp19_ = g_strdup ("six");
			_tmp20_ = g_new0 (gchar*, 3 + 1);
			_tmp20_[0] = _tmp17_;
			_tmp20_[1] = _tmp18_;
			_tmp20_[2] = _tmp19_;
			_tmp21_ = _tmp20_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			contains = _tmp21_;
			_tmp22_ = g_strdup ("one");
			_tmp23_ = g_strdup ("four");
			_tmp24_ = g_strdup ("five");
			_tmp25_ = g_new0 (gchar*, 3 + 1);
			_tmp25_[0] = _tmp22_;
			_tmp25_[1] = _tmp23_;
			_tmp25_[2] = _tmp24_;
			_tmp26_ = _tmp25_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp26_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar** _tmp30_ = NULL;
			gchar** _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar** _tmp35_ = NULL;
			gchar** _tmp36_;
			_tmp27_ = g_strdup ("one");
			_tmp28_ = g_strdup ("four");
			_tmp29_ = g_strdup ("six");
			_tmp30_ = g_new0 (gchar*, 3 + 1);
			_tmp30_[0] = _tmp27_;
			_tmp30_[1] = _tmp28_;
			_tmp30_[2] = _tmp29_;
			_tmp31_ = _tmp30_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 3;
			_contains_size_ = contains_length1;
			contains = _tmp31_;
			_tmp32_ = g_strdup ("two");
			_tmp33_ = g_strdup ("three");
			_tmp34_ = g_strdup ("five");
			_tmp35_ = g_new0 (gchar*, 3 + 1);
			_tmp35_[0] = _tmp32_;
			_tmp35_[1] = _tmp33_;
			_tmp35_[2] = _tmp34_;
			_tmp36_ = _tmp35_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 3;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp36_;
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gchar** _tmp37_ = NULL;
			gchar** _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar** _tmp45_ = NULL;
			gchar** _tmp46_;
			_tmp37_ = g_new0 (gchar*, 0 + 1);
			_tmp38_ = _tmp37_;
			contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
			contains_length1 = 0;
			_contains_size_ = contains_length1;
			contains = _tmp38_;
			_tmp39_ = g_strdup ("one");
			_tmp40_ = g_strdup ("two");
			_tmp41_ = g_strdup ("three");
			_tmp42_ = g_strdup ("four");
			_tmp43_ = g_strdup ("five");
			_tmp44_ = g_strdup ("six");
			_tmp45_ = g_new0 (gchar*, 6 + 1);
			_tmp45_[0] = _tmp39_;
			_tmp45_[1] = _tmp40_;
			_tmp45_[2] = _tmp41_;
			_tmp45_[3] = _tmp42_;
			_tmp45_[4] = _tmp43_;
			_tmp45_[5] = _tmp44_;
			_tmp46_ = _tmp45_;
			not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
			not_contains_length1 = 6;
			_not_contains_size_ = not_contains_length1;
			not_contains = _tmp46_;
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = contains;
		s_collection_length1 = contains_length1;
		for (s_it = 0; s_it < contains_length1; s_it = s_it + 1) {
			gchar* _tmp47_;
			gchar* s;
			_tmp47_ = g_strdup (s_collection[s_it]);
			s = _tmp47_;
			{
				GeeBidirIterator* _tmp48_ = NULL;
				GeeBidirIterator* iter;
				gpointer _tmp49_ = NULL;
				gchar* _tmp50_;
				_tmp48_ = gee_sorted_set_iterator_at (self->priv->subset, s);
				iter = _tmp48_;
				g_assert (iter != NULL);
				_tmp49_ = gee_iterator_get ((GeeIterator*) iter);
				_tmp50_ = (gchar*) _tmp49_;
				g_assert (g_strcmp0 (_tmp50_, s) == 0);
				_g_free0 (_tmp50_);
				_g_object_unref0 (iter);
				_g_free0 (s);
			}
		}
	}
	{
		gchar** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = not_contains;
		s_collection_length1 = not_contains_length1;
		for (s_it = 0; s_it < not_contains_length1; s_it = s_it + 1) {
			gchar* _tmp51_;
			gchar* s;
			_tmp51_ = g_strdup (s_collection[s_it]);
			s = _tmp51_;
			{
				GeeBidirIterator* _tmp52_ = NULL;
				GeeBidirIterator* iter;
				_tmp52_ = gee_sorted_set_iterator_at (self->priv->subset, s);
				iter = _tmp52_;
				g_assert (iter == NULL);
				_g_object_unref0 (iter);
				_g_free0 (s);
			}
		}
	}
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_lower (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp6_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gpointer _tmp7_ = NULL;
			gchar* _tmp8_;
			gpointer _tmp9_ = NULL;
			gchar* _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* _tmp12_;
			gpointer _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp7_ = gee_sorted_set_lower (self->priv->subset, "a");
			_tmp8_ = (gchar*) _tmp7_;
			g_assert (_tmp8_ == NULL);
			_g_free0 (_tmp8_);
			_tmp9_ = gee_sorted_set_lower (self->priv->subset, "five");
			_tmp10_ = (gchar*) _tmp9_;
			g_assert (_tmp10_ == NULL);
			_g_free0 (_tmp10_);
			_tmp11_ = gee_sorted_set_lower (self->priv->subset, "four");
			_tmp12_ = (gchar*) _tmp11_;
			g_assert (g_strcmp0 (_tmp12_, "five") == 0);
			_g_free0 (_tmp12_);
			_tmp13_ = gee_sorted_set_lower (self->priv->subset, "six");
			_tmp14_ = (gchar*) _tmp13_;
			g_assert (g_strcmp0 (_tmp14_, "four") == 0);
			_g_free0 (_tmp14_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gpointer _tmp15_ = NULL;
			gchar* _tmp16_;
			gpointer _tmp17_ = NULL;
			gchar* _tmp18_;
			gpointer _tmp19_ = NULL;
			gchar* _tmp20_;
			gpointer _tmp21_ = NULL;
			gchar* _tmp22_;
			gpointer _tmp23_ = NULL;
			gchar* _tmp24_;
			_tmp15_ = gee_sorted_set_lower (self->priv->subset, "one");
			_tmp16_ = (gchar*) _tmp15_;
			g_assert (_tmp16_ == NULL);
			_g_free0 (_tmp16_);
			_tmp17_ = gee_sorted_set_lower (self->priv->subset, "six");
			_tmp18_ = (gchar*) _tmp17_;
			g_assert (_tmp18_ == NULL);
			_g_free0 (_tmp18_);
			_tmp19_ = gee_sorted_set_lower (self->priv->subset, "three");
			_tmp20_ = (gchar*) _tmp19_;
			g_assert (g_strcmp0 (_tmp20_, "six") == 0);
			_g_free0 (_tmp20_);
			_tmp21_ = gee_sorted_set_lower (self->priv->subset, "two");
			_tmp22_ = (gchar*) _tmp21_;
			g_assert (g_strcmp0 (_tmp22_, "three") == 0);
			_g_free0 (_tmp22_);
			_tmp23_ = gee_sorted_set_lower (self->priv->subset, "z");
			_tmp24_ = (gchar*) _tmp23_;
			g_assert (g_strcmp0 (_tmp24_, "two") == 0);
			_g_free0 (_tmp24_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gpointer _tmp25_ = NULL;
			gchar* _tmp26_;
			gpointer _tmp27_ = NULL;
			gchar* _tmp28_;
			gpointer _tmp29_ = NULL;
			gchar* _tmp30_;
			gpointer _tmp31_ = NULL;
			gchar* _tmp32_;
			gpointer _tmp33_ = NULL;
			gchar* _tmp34_;
			_tmp25_ = gee_sorted_set_lower (self->priv->subset, "five");
			_tmp26_ = (gchar*) _tmp25_;
			g_assert (_tmp26_ == NULL);
			_g_free0 (_tmp26_);
			_tmp27_ = gee_sorted_set_lower (self->priv->subset, "four");
			_tmp28_ = (gchar*) _tmp27_;
			g_assert (_tmp28_ == NULL);
			_g_free0 (_tmp28_);
			_tmp29_ = gee_sorted_set_lower (self->priv->subset, "one");
			_tmp30_ = (gchar*) _tmp29_;
			g_assert (g_strcmp0 (_tmp30_, "four") == 0);
			_g_free0 (_tmp30_);
			_tmp31_ = gee_sorted_set_lower (self->priv->subset, "six");
			_tmp32_ = (gchar*) _tmp31_;
			g_assert (g_strcmp0 (_tmp32_, "one") == 0);
			_g_free0 (_tmp32_);
			_tmp33_ = gee_sorted_set_lower (self->priv->subset, "three");
			_tmp34_ = (gchar*) _tmp33_;
			g_assert (g_strcmp0 (_tmp34_, "six") == 0);
			_g_free0 (_tmp34_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gpointer _tmp35_ = NULL;
			gchar* _tmp36_;
			_tmp35_ = gee_sorted_set_lower (self->priv->subset, "six");
			_tmp36_ = (gchar*) _tmp35_;
			g_assert (_tmp36_ == NULL);
			_g_free0 (_tmp36_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_higher (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp6_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gpointer _tmp7_ = NULL;
			gchar* _tmp8_;
			gpointer _tmp9_ = NULL;
			gchar* _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* _tmp12_;
			gpointer _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp7_ = gee_sorted_set_higher (self->priv->subset, "a");
			_tmp8_ = (gchar*) _tmp7_;
			g_assert (g_strcmp0 (_tmp8_, "five") == 0);
			_g_free0 (_tmp8_);
			_tmp9_ = gee_sorted_set_higher (self->priv->subset, "five");
			_tmp10_ = (gchar*) _tmp9_;
			g_assert (g_strcmp0 (_tmp10_, "four") == 0);
			_g_free0 (_tmp10_);
			_tmp11_ = gee_sorted_set_higher (self->priv->subset, "four");
			_tmp12_ = (gchar*) _tmp11_;
			g_assert (_tmp12_ == NULL);
			_g_free0 (_tmp12_);
			_tmp13_ = gee_sorted_set_higher (self->priv->subset, "six");
			_tmp14_ = (gchar*) _tmp13_;
			g_assert (_tmp14_ == NULL);
			_g_free0 (_tmp14_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gpointer _tmp15_ = NULL;
			gchar* _tmp16_;
			gpointer _tmp17_ = NULL;
			gchar* _tmp18_;
			gpointer _tmp19_ = NULL;
			gchar* _tmp20_;
			gpointer _tmp21_ = NULL;
			gchar* _tmp22_;
			gpointer _tmp23_ = NULL;
			gchar* _tmp24_;
			_tmp15_ = gee_sorted_set_higher (self->priv->subset, "one");
			_tmp16_ = (gchar*) _tmp15_;
			g_assert (g_strcmp0 (_tmp16_, "six") == 0);
			_g_free0 (_tmp16_);
			_tmp17_ = gee_sorted_set_higher (self->priv->subset, "six");
			_tmp18_ = (gchar*) _tmp17_;
			g_assert (g_strcmp0 (_tmp18_, "three") == 0);
			_g_free0 (_tmp18_);
			_tmp19_ = gee_sorted_set_higher (self->priv->subset, "three");
			_tmp20_ = (gchar*) _tmp19_;
			g_assert (g_strcmp0 (_tmp20_, "two") == 0);
			_g_free0 (_tmp20_);
			_tmp21_ = gee_sorted_set_higher (self->priv->subset, "two");
			_tmp22_ = (gchar*) _tmp21_;
			g_assert (_tmp22_ == NULL);
			_g_free0 (_tmp22_);
			_tmp23_ = gee_sorted_set_higher (self->priv->subset, "z");
			_tmp24_ = (gchar*) _tmp23_;
			g_assert (_tmp24_ == NULL);
			_g_free0 (_tmp24_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gpointer _tmp25_ = NULL;
			gchar* _tmp26_;
			gpointer _tmp27_ = NULL;
			gchar* _tmp28_;
			gpointer _tmp29_ = NULL;
			gchar* _tmp30_;
			gpointer _tmp31_ = NULL;
			gchar* _tmp32_;
			gpointer _tmp33_ = NULL;
			gchar* _tmp34_;
			_tmp25_ = gee_sorted_set_higher (self->priv->subset, "five");
			_tmp26_ = (gchar*) _tmp25_;
			g_assert (g_strcmp0 (_tmp26_, "four") == 0);
			_g_free0 (_tmp26_);
			_tmp27_ = gee_sorted_set_higher (self->priv->subset, "four");
			_tmp28_ = (gchar*) _tmp27_;
			g_assert (g_strcmp0 (_tmp28_, "one") == 0);
			_g_free0 (_tmp28_);
			_tmp29_ = gee_sorted_set_higher (self->priv->subset, "one");
			_tmp30_ = (gchar*) _tmp29_;
			g_assert (g_strcmp0 (_tmp30_, "six") == 0);
			_g_free0 (_tmp30_);
			_tmp31_ = gee_sorted_set_higher (self->priv->subset, "six");
			_tmp32_ = (gchar*) _tmp31_;
			g_assert (_tmp32_ == NULL);
			_g_free0 (_tmp32_);
			_tmp33_ = gee_sorted_set_higher (self->priv->subset, "three");
			_tmp34_ = (gchar*) _tmp33_;
			g_assert (_tmp34_ == NULL);
			_g_free0 (_tmp34_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gpointer _tmp35_ = NULL;
			gchar* _tmp36_;
			_tmp35_ = gee_sorted_set_higher (self->priv->subset, "six");
			_tmp36_ = (gchar*) _tmp35_;
			g_assert (_tmp36_ == NULL);
			_g_free0 (_tmp36_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_floor (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp6_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gpointer _tmp7_ = NULL;
			gchar* _tmp8_;
			gpointer _tmp9_ = NULL;
			gchar* _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* _tmp12_;
			gpointer _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp7_ = gee_sorted_set_floor (self->priv->subset, "a");
			_tmp8_ = (gchar*) _tmp7_;
			g_assert (_tmp8_ == NULL);
			_g_free0 (_tmp8_);
			_tmp9_ = gee_sorted_set_floor (self->priv->subset, "five");
			_tmp10_ = (gchar*) _tmp9_;
			g_assert (g_strcmp0 (_tmp10_, "five") == 0);
			_g_free0 (_tmp10_);
			_tmp11_ = gee_sorted_set_floor (self->priv->subset, "four");
			_tmp12_ = (gchar*) _tmp11_;
			g_assert (g_strcmp0 (_tmp12_, "four") == 0);
			_g_free0 (_tmp12_);
			_tmp13_ = gee_sorted_set_floor (self->priv->subset, "six");
			_tmp14_ = (gchar*) _tmp13_;
			g_assert (g_strcmp0 (_tmp14_, "four") == 0);
			_g_free0 (_tmp14_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gpointer _tmp15_ = NULL;
			gchar* _tmp16_;
			gpointer _tmp17_ = NULL;
			gchar* _tmp18_;
			gpointer _tmp19_ = NULL;
			gchar* _tmp20_;
			gpointer _tmp21_ = NULL;
			gchar* _tmp22_;
			gpointer _tmp23_ = NULL;
			gchar* _tmp24_;
			_tmp15_ = gee_sorted_set_floor (self->priv->subset, "one");
			_tmp16_ = (gchar*) _tmp15_;
			g_assert (_tmp16_ == NULL);
			_g_free0 (_tmp16_);
			_tmp17_ = gee_sorted_set_floor (self->priv->subset, "six");
			_tmp18_ = (gchar*) _tmp17_;
			g_assert (g_strcmp0 (_tmp18_, "six") == 0);
			_g_free0 (_tmp18_);
			_tmp19_ = gee_sorted_set_floor (self->priv->subset, "three");
			_tmp20_ = (gchar*) _tmp19_;
			g_assert (g_strcmp0 (_tmp20_, "three") == 0);
			_g_free0 (_tmp20_);
			_tmp21_ = gee_sorted_set_floor (self->priv->subset, "two");
			_tmp22_ = (gchar*) _tmp21_;
			g_assert (g_strcmp0 (_tmp22_, "two") == 0);
			_g_free0 (_tmp22_);
			_tmp23_ = gee_sorted_set_floor (self->priv->subset, "z");
			_tmp24_ = (gchar*) _tmp23_;
			g_assert (g_strcmp0 (_tmp24_, "two") == 0);
			_g_free0 (_tmp24_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gpointer _tmp25_ = NULL;
			gchar* _tmp26_;
			gpointer _tmp27_ = NULL;
			gchar* _tmp28_;
			gpointer _tmp29_ = NULL;
			gchar* _tmp30_;
			gpointer _tmp31_ = NULL;
			gchar* _tmp32_;
			gpointer _tmp33_ = NULL;
			gchar* _tmp34_;
			_tmp25_ = gee_sorted_set_floor (self->priv->subset, "five");
			_tmp26_ = (gchar*) _tmp25_;
			g_assert (_tmp26_ == NULL);
			_g_free0 (_tmp26_);
			_tmp27_ = gee_sorted_set_floor (self->priv->subset, "four");
			_tmp28_ = (gchar*) _tmp27_;
			g_assert (g_strcmp0 (_tmp28_, "four") == 0);
			_g_free0 (_tmp28_);
			_tmp29_ = gee_sorted_set_floor (self->priv->subset, "one");
			_tmp30_ = (gchar*) _tmp29_;
			g_assert (g_strcmp0 (_tmp30_, "one") == 0);
			_g_free0 (_tmp30_);
			_tmp31_ = gee_sorted_set_floor (self->priv->subset, "six");
			_tmp32_ = (gchar*) _tmp31_;
			g_assert (g_strcmp0 (_tmp32_, "six") == 0);
			_g_free0 (_tmp32_);
			_tmp33_ = gee_sorted_set_floor (self->priv->subset, "three");
			_tmp34_ = (gchar*) _tmp33_;
			g_assert (g_strcmp0 (_tmp34_, "six") == 0);
			_g_free0 (_tmp34_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gpointer _tmp35_ = NULL;
			gchar* _tmp36_;
			_tmp35_ = gee_sorted_set_floor (self->priv->subset, "six");
			_tmp36_ = (gchar*) _tmp35_;
			g_assert (_tmp36_ == NULL);
			_g_free0 (_tmp36_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_ceil (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp6_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			gpointer _tmp7_ = NULL;
			gchar* _tmp8_;
			gpointer _tmp9_ = NULL;
			gchar* _tmp10_;
			gpointer _tmp11_ = NULL;
			gchar* _tmp12_;
			gpointer _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp7_ = gee_sorted_set_ceil (self->priv->subset, "a");
			_tmp8_ = (gchar*) _tmp7_;
			g_assert (g_strcmp0 (_tmp8_, "five") == 0);
			_g_free0 (_tmp8_);
			_tmp9_ = gee_sorted_set_ceil (self->priv->subset, "five");
			_tmp10_ = (gchar*) _tmp9_;
			g_assert (g_strcmp0 (_tmp10_, "five") == 0);
			_g_free0 (_tmp10_);
			_tmp11_ = gee_sorted_set_ceil (self->priv->subset, "four");
			_tmp12_ = (gchar*) _tmp11_;
			g_assert (g_strcmp0 (_tmp12_, "four") == 0);
			_g_free0 (_tmp12_);
			_tmp13_ = gee_sorted_set_ceil (self->priv->subset, "six");
			_tmp14_ = (gchar*) _tmp13_;
			g_assert (_tmp14_ == NULL);
			_g_free0 (_tmp14_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			gpointer _tmp15_ = NULL;
			gchar* _tmp16_;
			gpointer _tmp17_ = NULL;
			gchar* _tmp18_;
			gpointer _tmp19_ = NULL;
			gchar* _tmp20_;
			gpointer _tmp21_ = NULL;
			gchar* _tmp22_;
			gpointer _tmp23_ = NULL;
			gchar* _tmp24_;
			_tmp15_ = gee_sorted_set_ceil (self->priv->subset, "one");
			_tmp16_ = (gchar*) _tmp15_;
			g_assert (g_strcmp0 (_tmp16_, "six") == 0);
			_g_free0 (_tmp16_);
			_tmp17_ = gee_sorted_set_ceil (self->priv->subset, "six");
			_tmp18_ = (gchar*) _tmp17_;
			g_assert (g_strcmp0 (_tmp18_, "six") == 0);
			_g_free0 (_tmp18_);
			_tmp19_ = gee_sorted_set_ceil (self->priv->subset, "three");
			_tmp20_ = (gchar*) _tmp19_;
			g_assert (g_strcmp0 (_tmp20_, "three") == 0);
			_g_free0 (_tmp20_);
			_tmp21_ = gee_sorted_set_ceil (self->priv->subset, "two");
			_tmp22_ = (gchar*) _tmp21_;
			g_assert (g_strcmp0 (_tmp22_, "two") == 0);
			_g_free0 (_tmp22_);
			_tmp23_ = gee_sorted_set_ceil (self->priv->subset, "z");
			_tmp24_ = (gchar*) _tmp23_;
			g_assert (_tmp24_ == NULL);
			_g_free0 (_tmp24_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			gpointer _tmp25_ = NULL;
			gchar* _tmp26_;
			gpointer _tmp27_ = NULL;
			gchar* _tmp28_;
			gpointer _tmp29_ = NULL;
			gchar* _tmp30_;
			gpointer _tmp31_ = NULL;
			gchar* _tmp32_;
			gpointer _tmp33_ = NULL;
			gchar* _tmp34_;
			_tmp25_ = gee_sorted_set_ceil (self->priv->subset, "five");
			_tmp26_ = (gchar*) _tmp25_;
			g_assert (g_strcmp0 (_tmp26_, "four") == 0);
			_g_free0 (_tmp26_);
			_tmp27_ = gee_sorted_set_ceil (self->priv->subset, "four");
			_tmp28_ = (gchar*) _tmp27_;
			g_assert (g_strcmp0 (_tmp28_, "four") == 0);
			_g_free0 (_tmp28_);
			_tmp29_ = gee_sorted_set_ceil (self->priv->subset, "one");
			_tmp30_ = (gchar*) _tmp29_;
			g_assert (g_strcmp0 (_tmp30_, "one") == 0);
			_g_free0 (_tmp30_);
			_tmp31_ = gee_sorted_set_ceil (self->priv->subset, "six");
			_tmp32_ = (gchar*) _tmp31_;
			g_assert (g_strcmp0 (_tmp32_, "six") == 0);
			_g_free0 (_tmp32_);
			_tmp33_ = gee_sorted_set_ceil (self->priv->subset, "three");
			_tmp34_ = (gchar*) _tmp33_;
			g_assert (_tmp34_ == NULL);
			_g_free0 (_tmp34_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			gpointer _tmp35_ = NULL;
			gchar* _tmp36_;
			_tmp35_ = gee_sorted_set_ceil (self->priv->subset, "six");
			_tmp36_ = (gchar*) _tmp35_;
			g_assert (_tmp36_ == NULL);
			_g_free0 (_tmp36_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_subsets (SortedSetTestsSubSet* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_add ((GeeCollection*) self->priv->master, "one");
	g_assert (_tmp0_);
	_tmp1_ = gee_collection_add ((GeeCollection*) self->priv->master, "two");
	g_assert (_tmp1_);
	_tmp2_ = gee_collection_add ((GeeCollection*) self->priv->master, "three");
	g_assert (_tmp2_);
	_tmp3_ = gee_collection_add ((GeeCollection*) self->priv->master, "four");
	g_assert (_tmp3_);
	_tmp4_ = gee_collection_add ((GeeCollection*) self->priv->master, "five");
	g_assert (_tmp4_);
	_tmp5_ = gee_collection_add ((GeeCollection*) self->priv->master, "six");
	g_assert (_tmp5_);
	_tmp6_ = gee_collection_get_size ((GeeCollection*) self->priv->master);
	g_assert (_tmp6_ == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			GeeSortedSet* _tmp7_ = NULL;
			GeeSortedSet* subsubset;
			gint _tmp8_;
			GeeSortedSet* _tmp9_ = NULL;
			GeeSortedSet* _tmp10_;
			gint _tmp11_;
			GeeSortedSet* _tmp12_ = NULL;
			GeeSortedSet* _tmp13_;
			gint _tmp14_;
			GeeSortedSet* _tmp15_ = NULL;
			GeeSortedSet* _tmp16_;
			gint _tmp17_;
			_tmp7_ = gee_sorted_set_head_set (self->priv->subset, "four");
			subsubset = _tmp7_;
			_tmp8_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp8_ == 1);
			_tmp9_ = gee_sorted_set_tail_set (self->priv->subset, "four");
			_tmp10_ = _tmp9_;
			_g_object_unref0 (subsubset);
			subsubset = _tmp10_;
			_tmp11_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp11_ == 1);
			_tmp12_ = gee_sorted_set_sub_set (self->priv->subset, "four", "one");
			_tmp13_ = _tmp12_;
			_g_object_unref0 (subsubset);
			subsubset = _tmp13_;
			_tmp14_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp14_ == 1);
			_tmp15_ = gee_sorted_set_sub_set (self->priv->subset, "four", "four");
			_tmp16_ = _tmp15_;
			_g_object_unref0 (subsubset);
			subsubset = _tmp16_;
			_tmp17_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp17_ == 0);
			_g_object_unref0 (subsubset);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			GeeSortedSet* _tmp18_ = NULL;
			GeeSortedSet* subsubset;
			gint _tmp19_;
			GeeSortedSet* _tmp20_ = NULL;
			GeeSortedSet* _tmp21_;
			gint _tmp22_;
			GeeSortedSet* _tmp23_ = NULL;
			GeeSortedSet* _tmp24_;
			gint _tmp25_;
			_tmp18_ = gee_sorted_set_head_set (self->priv->subset, "two");
			subsubset = _tmp18_;
			_tmp19_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp19_ == 2);
			_tmp20_ = gee_sorted_set_tail_set (self->priv->subset, "three");
			_tmp21_ = _tmp20_;
			_g_object_unref0 (subsubset);
			subsubset = _tmp21_;
			_tmp22_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp22_ == 2);
			_tmp23_ = gee_sorted_set_sub_set (self->priv->subset, "three", "two");
			_tmp24_ = _tmp23_;
			_g_object_unref0 (subsubset);
			subsubset = _tmp24_;
			_tmp25_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp25_ == 1);
			_g_object_unref0 (subsubset);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			GeeSortedSet* _tmp26_ = NULL;
			GeeSortedSet* subsubset;
			gint _tmp27_;
			GeeSortedSet* _tmp28_ = NULL;
			GeeSortedSet* _tmp29_;
			gint _tmp30_;
			GeeSortedSet* _tmp31_ = NULL;
			GeeSortedSet* _tmp32_;
			gint _tmp33_;
			GeeSortedSet* _tmp34_ = NULL;
			GeeSortedSet* _tmp35_;
			gint _tmp36_;
			_tmp26_ = gee_sorted_set_head_set (self->priv->subset, "six");
			subsubset = _tmp26_;
			_tmp27_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp27_ == 2);
			_tmp28_ = gee_sorted_set_tail_set (self->priv->subset, "one");
			_tmp29_ = _tmp28_;
			_g_object_unref0 (subsubset);
			subsubset = _tmp29_;
			_tmp30_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp30_ == 2);
			_tmp31_ = gee_sorted_set_sub_set (self->priv->subset, "one", "six");
			_tmp32_ = _tmp31_;
			_g_object_unref0 (subsubset);
			subsubset = _tmp32_;
			_tmp33_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp33_ == 1);
			_tmp34_ = gee_sorted_set_sub_set (self->priv->subset, "five", "two");
			_tmp35_ = _tmp34_;
			_g_object_unref0 (subsubset);
			subsubset = _tmp35_;
			_tmp36_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp36_ == 3);
			_g_object_unref0 (subsubset);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp37_ = NULL;
			GeeSortedSet* subsubset;
			gint _tmp38_;
			GeeSortedSet* _tmp39_ = NULL;
			GeeSortedSet* _tmp40_;
			gint _tmp41_;
			GeeSortedSet* _tmp42_ = NULL;
			GeeSortedSet* _tmp43_;
			gint _tmp44_;
			_tmp37_ = gee_sorted_set_head_set (self->priv->subset, "six");
			subsubset = _tmp37_;
			_tmp38_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp38_ == 0);
			_tmp39_ = gee_sorted_set_tail_set (self->priv->subset, "three");
			_tmp40_ = _tmp39_;
			_g_object_unref0 (subsubset);
			subsubset = _tmp40_;
			_tmp41_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp41_ == 0);
			_tmp42_ = gee_sorted_set_sub_set (self->priv->subset, "one", "six");
			_tmp43_ = _tmp42_;
			_g_object_unref0 (subsubset);
			subsubset = _tmp43_;
			_tmp44_ = gee_collection_get_size ((GeeCollection*) subsubset);
			g_assert (_tmp44_ == 0);
			_g_object_unref0 (subsubset);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void sorted_set_tests_sub_set_class_init (SortedSetTestsSubSetClass * klass) {
	sorted_set_tests_sub_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SortedSetTestsSubSetPrivate));
	GEE_TEST_CASE_CLASS (klass)->set_up = sorted_set_tests_sub_set_real_set_up;
	GEE_TEST_CASE_CLASS (klass)->tear_down = sorted_set_tests_sub_set_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = sorted_set_tests_sub_set_finalize;
}


static void sorted_set_tests_sub_set_instance_init (SortedSetTestsSubSet * self) {
	self->priv = SORTED_SET_TESTS_SUB_SET_GET_PRIVATE (self);
}


static void sorted_set_tests_sub_set_finalize (GObject* obj) {
	SortedSetTestsSubSet * self;
	self = SORTED_SET_TESTS_SUB_SET (obj);
	_g_object_unref0 (self->priv->master);
	_g_object_unref0 (self->priv->subset);
	_g_object_unref0 (self->priv->test);
	G_OBJECT_CLASS (sorted_set_tests_sub_set_parent_class)->finalize (obj);
}


GType sorted_set_tests_sub_set_get_type (void) {
	static volatile gsize sorted_set_tests_sub_set_type_id__volatile = 0;
	if (g_once_init_enter (&sorted_set_tests_sub_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SortedSetTestsSubSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sorted_set_tests_sub_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SortedSetTestsSubSet), 0, (GInstanceInitFunc) sorted_set_tests_sub_set_instance_init, NULL };
		GType sorted_set_tests_sub_set_type_id;
		sorted_set_tests_sub_set_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "SortedSetTestsSubSet", &g_define_type_info, 0);
		g_once_init_leave (&sorted_set_tests_sub_set_type_id__volatile, sorted_set_tests_sub_set_type_id);
	}
	return sorted_set_tests_sub_set_type_id__volatile;
}


static void sorted_set_tests_class_init (SortedSetTestsClass * klass) {
	sorted_set_tests_parent_class = g_type_class_peek_parent (klass);
}


static void sorted_set_tests_instance_init (SortedSetTests * self) {
}


GType sorted_set_tests_get_type (void) {
	static volatile gsize sorted_set_tests_type_id__volatile = 0;
	if (g_once_init_enter (&sorted_set_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SortedSetTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sorted_set_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SortedSetTests), 0, (GInstanceInitFunc) sorted_set_tests_instance_init, NULL };
		GType sorted_set_tests_type_id;
		sorted_set_tests_type_id = g_type_register_static (TYPE_SET_TESTS, "SortedSetTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&sorted_set_tests_type_id__volatile, sorted_set_tests_type_id);
	}
	return sorted_set_tests_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



