/*
 * Copyright (C) 2007 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.google.common.collect.testing;

import com.google.common.collect.testing.SampleElements.Enums;

import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * An abstract TestSetGenerator for generating sets containing enum values.
 *
 * @author Kevin Bourrillion
 */
public abstract class TestEnumSetGenerator implements TestSetGenerator<AnEnum> {
  public SampleElements<AnEnum> samples() {
    return new Enums();
  }

  public Set<AnEnum> create(Object... elements) {
    AnEnum[] array = new AnEnum[elements.length];
    int i = 0;
    for (Object e : elements) {
      array[i++] = (AnEnum) e;
    }
    return create(array);
  }

  protected abstract Set<AnEnum> create(AnEnum[] elements);

  public AnEnum[] createArray(int length) {
    return new AnEnum[length];
  }

  /**
   * Sorts the enums according to their natural ordering.
   */
  public List<AnEnum> order(List<AnEnum> insertionOrder) {
    Collections.sort(insertionOrder);
    return insertionOrder;
  }
}
