/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-permissions.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UNITY_WEBAPPS_PERMISSIONS_H
#define __UNITY_WEBAPPS_PERMISSIONS_H

#include "unity-webapps-context.h"

gboolean unity_webapps_permissions_get_domain_allowed (const gchar *domain);
gboolean unity_webapps_permissions_get_domain_dontask (const gchar *domain);
gboolean unity_webapps_permissions_get_domain_preauthorized (const gchar *domain);

void unity_webapps_permissions_allow_domain (const gchar *domain);
void unity_webapps_permissions_dontask_domain (const gchar *domain);

void unity_webapps_permissions_remove_domain_from_permissions (const gchar *domain);

gchar* unity_webapps_permissions_get_all_domains (void);

gboolean unity_webapps_permissions_is_integration_allowed(void);
void unity_webapps_permissions_set_integration_allowed(gboolean allowed);

#endif
