/* unity-lens-filters.c generated by valac 0.12.1, the Vala compiler
 * generated from unity-lens-filters.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include "unity.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <dee.h>
#include <float.h>
#include <math.h>


#define UNITY_TYPE_FILTER_COLUMN (unity_filter_column_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

typedef enum  {
	UNITY_FILTER_COLUMN_ID = 0,
	UNITY_FILTER_COLUMN_NAME,
	UNITY_FILTER_COLUMN_ICON_HINT,
	UNITY_FILTER_COLUMN_RENDERER_NAME,
	UNITY_FILTER_COLUMN_RENDERER_STATE,
	UNITY_FILTER_COLUMN_VISIBLE,
	UNITY_FILTER_COLUMN_COLLAPSED,
	UNITY_FILTER_COLUMN_FILTERING
} UnityFilterColumn;

struct _UnityFilterPrivate {
	gchar* _id;
	gchar* _display_name;
	GIcon* _icon_hint;
	gchar* _renderer_name;
	gboolean _visible;
	gboolean _collapsed;
	gboolean _filtering;
	DeeModel* _model;
	DeeModelIter* _iter;
};

struct _UnityFilterOptionPrivate {
	gchar* _id;
	gchar* _display_name;
	GIcon* _icon_hint;
	gboolean _active;
};

struct _UnityOptionsFilterPrivate {
	UnityOptionsFilterSortType _sort_type;
};

struct _UnityRatingsFilterPrivate {
	gfloat _rating;
};


static gpointer unity_filter_parent_class = NULL;
static gpointer unity_filter_option_parent_class = NULL;
static gpointer unity_options_filter_parent_class = NULL;
static gpointer unity_radio_option_filter_parent_class = NULL;
static gpointer unity_check_option_filter_parent_class = NULL;
static gpointer unity_ratings_filter_parent_class = NULL;
static gpointer unity_multi_range_filter_parent_class = NULL;

GType unity_filter_column_get_type (void) G_GNUC_CONST;
#define UNITY_FILTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_FILTER, UnityFilterPrivate))
enum  {
	UNITY_FILTER_DUMMY_PROPERTY,
	UNITY_FILTER_ID,
	UNITY_FILTER_DISPLAY_NAME,
	UNITY_FILTER_ICON_HINT,
	UNITY_FILTER_RENDERER_NAME,
	UNITY_FILTER_VISIBLE,
	UNITY_FILTER_COLLAPSED,
	UNITY_FILTER_FILTERING
};
void unity_filter_set_model_and_iter (UnityFilter* self, DeeModel* model, DeeModelIter* iter);
static void unity_filter_on_row_changed (UnityFilter* self, DeeModel* model, DeeModelIter* iter);
static void _unity_filter_on_row_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
void unity_filter_set_filtering (UnityFilter* self, gboolean value);
void unity_filter_update (UnityFilter* self, GVariant* properties);
GHashTable* unity_filter_get_hints (UnityFilter* self);
static GHashTable* unity_filter_real_get_hints (UnityFilter* self);
static void unity_filter_real_update (UnityFilter* self, GVariant* properties);
static void unity_filter_finalize (GObject* obj);
static void _vala_unity_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_FILTER_OPTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_FILTER_OPTION, UnityFilterOptionPrivate))
enum  {
	UNITY_FILTER_OPTION_DUMMY_PROPERTY,
	UNITY_FILTER_OPTION_ID,
	UNITY_FILTER_OPTION_DISPLAY_NAME,
	UNITY_FILTER_OPTION_ICON_HINT,
	UNITY_FILTER_OPTION_ACTIVE
};
void unity_filter_option_set_active (UnityFilterOption* self, gboolean value);
static void unity_filter_option_finalize (GObject* obj);
static void _vala_unity_filter_option_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_filter_option_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_OPTIONS_FILTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_OPTIONS_FILTER, UnityOptionsFilterPrivate))
enum  {
	UNITY_OPTIONS_FILTER_DUMMY_PROPERTY,
	UNITY_OPTIONS_FILTER_SORT_TYPE
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gint unity_options_filter_sort_by_display_name (UnityFilterOption* f1, UnityFilterOption* f2);
static gint _unity_options_filter_sort_by_display_name_gcompare_func (gconstpointer a, gconstpointer b);
static gint unity_options_filter_sort_by_id (UnityFilterOption* f1, UnityFilterOption* f2);
static gint _unity_options_filter_sort_by_id_gcompare_func (gconstpointer a, gconstpointer b);
static void unity_options_filter_real_update (UnityFilter* base, GVariant* properties);
void unity_options_filter_load_or_update_options (UnityOptionsFilter* self, GVariant* array);
void unity_options_filter_find_and_update_option (UnityOptionsFilter* self, const gchar* id, const gchar* name, const gchar* icon_hint_s, gboolean active);
static GHashTable* unity_options_filter_real_get_hints (UnityFilter* base);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void unity_options_filter_finalize (GObject* obj);
static void _vala_unity_options_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_options_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	UNITY_RADIO_OPTION_FILTER_DUMMY_PROPERTY
};
enum  {
	UNITY_CHECK_OPTION_FILTER_DUMMY_PROPERTY
};
#define UNITY_RATINGS_FILTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_RATINGS_FILTER, UnityRatingsFilterPrivate))
enum  {
	UNITY_RATINGS_FILTER_DUMMY_PROPERTY,
	UNITY_RATINGS_FILTER_RATING
};
static void unity_ratings_filter_real_update (UnityFilter* base, GVariant* properties);
void unity_ratings_filter_set_rating (UnityRatingsFilter* self, gfloat value);
static GHashTable* unity_ratings_filter_real_get_hints (UnityFilter* base);
static GVariant* _variant_new16 (gdouble value);
static void unity_ratings_filter_finalize (GObject* obj);
static void _vala_unity_ratings_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_ratings_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	UNITY_MULTI_RANGE_FILTER_DUMMY_PROPERTY
};


GType unity_filter_column_get_type (void) {
	static volatile gsize unity_filter_column_type_id__volatile = 0;
	if (g_once_init_enter (&unity_filter_column_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_FILTER_COLUMN_ID, "UNITY_FILTER_COLUMN_ID", "id"}, {UNITY_FILTER_COLUMN_NAME, "UNITY_FILTER_COLUMN_NAME", "name"}, {UNITY_FILTER_COLUMN_ICON_HINT, "UNITY_FILTER_COLUMN_ICON_HINT", "icon-hint"}, {UNITY_FILTER_COLUMN_RENDERER_NAME, "UNITY_FILTER_COLUMN_RENDERER_NAME", "renderer-name"}, {UNITY_FILTER_COLUMN_RENDERER_STATE, "UNITY_FILTER_COLUMN_RENDERER_STATE", "renderer-state"}, {UNITY_FILTER_COLUMN_VISIBLE, "UNITY_FILTER_COLUMN_VISIBLE", "visible"}, {UNITY_FILTER_COLUMN_COLLAPSED, "UNITY_FILTER_COLUMN_COLLAPSED", "collapsed"}, {UNITY_FILTER_COLUMN_FILTERING, "UNITY_FILTER_COLUMN_FILTERING", "filtering"}, {0, NULL, NULL}};
		GType unity_filter_column_type_id;
		unity_filter_column_type_id = g_enum_register_static ("UnityFilterColumn", values);
		g_once_init_leave (&unity_filter_column_type_id__volatile, unity_filter_column_type_id);
	}
	return unity_filter_column_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _unity_filter_on_row_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_filter_on_row_changed (self, _sender, iter);
}


void unity_filter_set_model_and_iter (UnityFilter* self, DeeModel* model, DeeModelIter* iter) {
	DeeModel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = _g_object_ref0 (model);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp0_;
	self->priv->_iter = iter;
	g_signal_connect_object (self->priv->_model, "row-changed", (GCallback) _unity_filter_on_row_changed_dee_model_row_changed, self, 0);
	unity_filter_on_row_changed (self, model, iter);
}


static void unity_filter_on_row_changed (UnityFilter* self, DeeModel* model, DeeModelIter* iter) {
	gboolean _tmp0_;
	GVariant* _tmp1_ = NULL;
	GVariant* properties;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	if (iter != self->priv->_iter) {
		return;
	}
	_tmp0_ = dee_model_get_bool (model, iter, (guint) UNITY_FILTER_COLUMN_FILTERING);
	unity_filter_set_filtering (self, _tmp0_);
	_tmp1_ = dee_model_get_value (model, iter, (guint) UNITY_FILTER_COLUMN_RENDERER_STATE);
	properties = _tmp1_;
	unity_filter_update (self, properties);
	_g_variant_unref0 (properties);
}


static GHashTable* unity_filter_real_get_hints (UnityFilter* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_filter_get_hints'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GHashTable* unity_filter_get_hints (UnityFilter* self) {
	return UNITY_FILTER_GET_CLASS (self)->get_hints (self);
}


static void unity_filter_real_update (UnityFilter* self, GVariant* properties) {
	g_return_if_fail (self != NULL);
	g_critical ("Type `%s' does not implement abstract method `unity_filter_update'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void unity_filter_update (UnityFilter* self, GVariant* properties) {
	UNITY_FILTER_GET_CLASS (self)->update (self, properties);
}


UnityFilter* unity_filter_construct (GType object_type) {
	UnityFilter * self = NULL;
	self = (UnityFilter*) g_object_new (object_type, NULL);
	return self;
}


const gchar* unity_filter_get_id (UnityFilter* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_id;
	return result;
}


static void unity_filter_set_id (UnityFilter* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


const gchar* unity_filter_get_display_name (UnityFilter* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_display_name;
	return result;
}


static void unity_filter_set_display_name (UnityFilter* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp0_;
	g_object_notify ((GObject *) self, "display-name");
}


GIcon* unity_filter_get_icon_hint (UnityFilter* self) {
	GIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon_hint;
	return result;
}


static void unity_filter_set_icon_hint (UnityFilter* self, GIcon* value) {
	GIcon* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_icon_hint);
	self->priv->_icon_hint = _tmp0_;
	g_object_notify ((GObject *) self, "icon-hint");
}


const gchar* unity_filter_get_renderer_name (UnityFilter* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_renderer_name;
	return result;
}


void unity_filter_set_renderer_name (UnityFilter* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_renderer_name);
	self->priv->_renderer_name = _tmp0_;
	g_object_notify ((GObject *) self, "renderer-name");
}


gboolean unity_filter_get_visible (UnityFilter* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_visible;
	return result;
}


void unity_filter_set_visible (UnityFilter* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_visible = value;
	g_object_notify ((GObject *) self, "visible");
}


gboolean unity_filter_get_collapsed (UnityFilter* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_collapsed;
	return result;
}


static void unity_filter_set_collapsed (UnityFilter* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_collapsed = value;
	g_object_notify ((GObject *) self, "collapsed");
}


gboolean unity_filter_get_filtering (UnityFilter* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_filtering;
	return result;
}


void unity_filter_set_filtering (UnityFilter* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_filtering = value;
	g_object_notify ((GObject *) self, "filtering");
}


static void unity_filter_class_init (UnityFilterClass * klass) {
	unity_filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilterPrivate));
	UNITY_FILTER_CLASS (klass)->get_hints = unity_filter_real_get_hints;
	UNITY_FILTER_CLASS (klass)->update = unity_filter_real_update;
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_filter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_filter_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_filter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_ICON_HINT, g_param_spec_object ("icon-hint", "icon-hint", "icon-hint", G_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_RENDERER_NAME, g_param_spec_string ("renderer-name", "renderer-name", "renderer-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_VISIBLE, g_param_spec_boolean ("visible", "visible", "visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_COLLAPSED, g_param_spec_boolean ("collapsed", "collapsed", "collapsed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_FILTERING, g_param_spec_boolean ("filtering", "filtering", "filtering", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void unity_filter_instance_init (UnityFilter * self) {
	self->priv = UNITY_FILTER_GET_PRIVATE (self);
}


static void unity_filter_finalize (GObject* obj) {
	UnityFilter * self;
	self = UNITY_FILTER (obj);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_display_name);
	_g_object_unref0 (self->priv->_icon_hint);
	_g_free0 (self->priv->_renderer_name);
	_g_object_unref0 (self->priv->_model);
	G_OBJECT_CLASS (unity_filter_parent_class)->finalize (obj);
}


GType unity_filter_get_type (void) {
	static volatile gsize unity_filter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilter), 0, (GInstanceInitFunc) unity_filter_instance_init, NULL };
		GType unity_filter_type_id;
		unity_filter_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilter", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&unity_filter_type_id__volatile, unity_filter_type_id);
	}
	return unity_filter_type_id__volatile;
}


static void _vala_unity_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityFilter * self;
	self = UNITY_FILTER (object);
	switch (property_id) {
		case UNITY_FILTER_ID:
		g_value_set_string (value, unity_filter_get_id (self));
		break;
		case UNITY_FILTER_DISPLAY_NAME:
		g_value_set_string (value, unity_filter_get_display_name (self));
		break;
		case UNITY_FILTER_ICON_HINT:
		g_value_set_object (value, unity_filter_get_icon_hint (self));
		break;
		case UNITY_FILTER_RENDERER_NAME:
		g_value_set_string (value, unity_filter_get_renderer_name (self));
		break;
		case UNITY_FILTER_VISIBLE:
		g_value_set_boolean (value, unity_filter_get_visible (self));
		break;
		case UNITY_FILTER_COLLAPSED:
		g_value_set_boolean (value, unity_filter_get_collapsed (self));
		break;
		case UNITY_FILTER_FILTERING:
		g_value_set_boolean (value, unity_filter_get_filtering (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityFilter * self;
	self = UNITY_FILTER (object);
	switch (property_id) {
		case UNITY_FILTER_ID:
		unity_filter_set_id (self, g_value_get_string (value));
		break;
		case UNITY_FILTER_DISPLAY_NAME:
		unity_filter_set_display_name (self, g_value_get_string (value));
		break;
		case UNITY_FILTER_ICON_HINT:
		unity_filter_set_icon_hint (self, g_value_get_object (value));
		break;
		case UNITY_FILTER_RENDERER_NAME:
		unity_filter_set_renderer_name (self, g_value_get_string (value));
		break;
		case UNITY_FILTER_VISIBLE:
		unity_filter_set_visible (self, g_value_get_boolean (value));
		break;
		case UNITY_FILTER_COLLAPSED:
		unity_filter_set_collapsed (self, g_value_get_boolean (value));
		break;
		case UNITY_FILTER_FILTERING:
		unity_filter_set_filtering (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityFilterOption* unity_filter_option_construct (GType object_type, const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean active) {
	UnityFilterOption * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (UnityFilterOption*) g_object_new (object_type, "id", id, "display-name", display_name, "icon-hint", icon_hint, "active", active, NULL);
	return self;
}


UnityFilterOption* unity_filter_option_new (const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean active) {
	return unity_filter_option_construct (UNITY_TYPE_FILTER_OPTION, id, display_name, icon_hint, active);
}


const gchar* unity_filter_option_get_id (UnityFilterOption* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_id;
	return result;
}


static void unity_filter_option_set_id (UnityFilterOption* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp0_;
	g_object_notify ((GObject *) self, "id");
}


const gchar* unity_filter_option_get_display_name (UnityFilterOption* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_display_name;
	return result;
}


static void unity_filter_option_set_display_name (UnityFilterOption* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp0_;
	g_object_notify ((GObject *) self, "display-name");
}


GIcon* unity_filter_option_get_icon_hint (UnityFilterOption* self) {
	GIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon_hint;
	return result;
}


static void unity_filter_option_set_icon_hint (UnityFilterOption* self, GIcon* value) {
	GIcon* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_icon_hint);
	self->priv->_icon_hint = _tmp0_;
	g_object_notify ((GObject *) self, "icon-hint");
}


gboolean unity_filter_option_get_active (UnityFilterOption* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_active;
	return result;
}


void unity_filter_option_set_active (UnityFilterOption* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_active = value;
	g_object_notify ((GObject *) self, "active");
}


static void unity_filter_option_class_init (UnityFilterOptionClass * klass) {
	unity_filter_option_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilterOptionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_filter_option_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_filter_option_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_filter_option_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_OPTION_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_OPTION_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_OPTION_ICON_HINT, g_param_spec_object ("icon-hint", "icon-hint", "icon-hint", G_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILTER_OPTION_ACTIVE, g_param_spec_boolean ("active", "active", "active", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void unity_filter_option_instance_init (UnityFilterOption * self) {
	self->priv = UNITY_FILTER_OPTION_GET_PRIVATE (self);
}


static void unity_filter_option_finalize (GObject* obj) {
	UnityFilterOption * self;
	self = UNITY_FILTER_OPTION (obj);
	_g_free0 (self->priv->_id);
	_g_free0 (self->priv->_display_name);
	_g_object_unref0 (self->priv->_icon_hint);
	G_OBJECT_CLASS (unity_filter_option_parent_class)->finalize (obj);
}


GType unity_filter_option_get_type (void) {
	static volatile gsize unity_filter_option_type_id__volatile = 0;
	if (g_once_init_enter (&unity_filter_option_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilterOptionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_filter_option_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilterOption), 0, (GInstanceInitFunc) unity_filter_option_instance_init, NULL };
		GType unity_filter_option_type_id;
		unity_filter_option_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilterOption", &g_define_type_info, 0);
		g_once_init_leave (&unity_filter_option_type_id__volatile, unity_filter_option_type_id);
	}
	return unity_filter_option_type_id__volatile;
}


static void _vala_unity_filter_option_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityFilterOption * self;
	self = UNITY_FILTER_OPTION (object);
	switch (property_id) {
		case UNITY_FILTER_OPTION_ID:
		g_value_set_string (value, unity_filter_option_get_id (self));
		break;
		case UNITY_FILTER_OPTION_DISPLAY_NAME:
		g_value_set_string (value, unity_filter_option_get_display_name (self));
		break;
		case UNITY_FILTER_OPTION_ICON_HINT:
		g_value_set_object (value, unity_filter_option_get_icon_hint (self));
		break;
		case UNITY_FILTER_OPTION_ACTIVE:
		g_value_set_boolean (value, unity_filter_option_get_active (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_filter_option_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityFilterOption * self;
	self = UNITY_FILTER_OPTION (object);
	switch (property_id) {
		case UNITY_FILTER_OPTION_ID:
		unity_filter_option_set_id (self, g_value_get_string (value));
		break;
		case UNITY_FILTER_OPTION_DISPLAY_NAME:
		unity_filter_option_set_display_name (self, g_value_get_string (value));
		break;
		case UNITY_FILTER_OPTION_ICON_HINT:
		unity_filter_option_set_icon_hint (self, g_value_get_object (value));
		break;
		case UNITY_FILTER_OPTION_ACTIVE:
		unity_filter_option_set_active (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType unity_options_filter_sort_type_get_type (void) {
	static volatile gsize unity_options_filter_sort_type_type_id__volatile = 0;
	if (g_once_init_enter (&unity_options_filter_sort_type_type_id__volatile)) {
		static const GEnumValue values[] = {{UNITY_OPTIONS_FILTER_SORT_TYPE_MANUAL, "UNITY_OPTIONS_FILTER_SORT_TYPE_MANUAL", "manual"}, {UNITY_OPTIONS_FILTER_SORT_TYPE_DISPLAY_NAME, "UNITY_OPTIONS_FILTER_SORT_TYPE_DISPLAY_NAME", "display-name"}, {UNITY_OPTIONS_FILTER_SORT_TYPE_ID, "UNITY_OPTIONS_FILTER_SORT_TYPE_ID", "id"}, {0, NULL, NULL}};
		GType unity_options_filter_sort_type_type_id;
		unity_options_filter_sort_type_type_id = g_enum_register_static ("UnityOptionsFilterSortType", values);
		g_once_init_leave (&unity_options_filter_sort_type_type_id__volatile, unity_options_filter_sort_type_type_id);
	}
	return unity_options_filter_sort_type_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gint _unity_options_filter_sort_by_display_name_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = unity_options_filter_sort_by_display_name (a, b);
	return result;
}


static gint _unity_options_filter_sort_by_id_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = unity_options_filter_sort_by_id (a, b);
	return result;
}


UnityFilterOption* unity_options_filter_add_option (UnityOptionsFilter* self, const gchar* id, const gchar* display_name, GIcon* icon_hint) {
	UnityFilterOption* result = NULL;
	UnityFilterOption* _tmp0_ = NULL;
	UnityFilterOption* option;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = unity_filter_option_new (id, display_name, icon_hint, FALSE);
	option = _tmp0_;
	switch (self->priv->_sort_type) {
		case UNITY_OPTIONS_FILTER_SORT_TYPE_DISPLAY_NAME:
		{
			UnityFilterOption* _tmp1_;
			_tmp1_ = _g_object_ref0 (option);
			self->options = g_list_insert_sorted (self->options, _tmp1_, _unity_options_filter_sort_by_display_name_gcompare_func);
			break;
		}
		case UNITY_OPTIONS_FILTER_SORT_TYPE_ID:
		{
			UnityFilterOption* _tmp2_;
			_tmp2_ = _g_object_ref0 (option);
			self->options = g_list_insert_sorted (self->options, _tmp2_, _unity_options_filter_sort_by_id_gcompare_func);
			break;
		}
		default:
		case UNITY_OPTIONS_FILTER_SORT_TYPE_MANUAL:
		{
			UnityFilterOption* _tmp3_;
			_tmp3_ = _g_object_ref0 (option);
			self->options = g_list_append (self->options, _tmp3_);
			break;
		}
	}
	result = option;
	return result;
}


static gint unity_options_filter_sort_by_display_name (UnityFilterOption* f1, UnityFilterOption* f2) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_;
	g_return_val_if_fail (f1 != NULL, 0);
	g_return_val_if_fail (f2 != NULL, 0);
	_tmp0_ = unity_filter_option_get_display_name (f1);
	_tmp1_ = unity_filter_option_get_display_name (f2);
	_tmp2_ = g_utf8_collate (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


static gint unity_options_filter_sort_by_id (UnityFilterOption* f1, UnityFilterOption* f2) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_;
	g_return_val_if_fail (f1 != NULL, 0);
	g_return_val_if_fail (f2 != NULL, 0);
	_tmp0_ = unity_filter_option_get_id (f1);
	_tmp1_ = unity_filter_option_get_id (f2);
	_tmp2_ = g_utf8_collate (_tmp0_, _tmp1_);
	result = _tmp2_;
	return result;
}


UnityFilterOption* unity_options_filter_get_option (UnityOptionsFilter* self, const gchar* id) {
	UnityFilterOption* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	{
		GList* option_collection;
		GList* option_it;
		option_collection = self->options;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp0_;
			UnityFilterOption* option;
			_tmp0_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = unity_filter_option_get_id (option);
				if (g_strcmp0 (_tmp1_, id) == 0) {
					result = option;
					return result;
				}
				_g_object_unref0 (option);
			}
		}
	}
	result = NULL;
	return result;
}


static void unity_options_filter_real_update (UnityFilter* base, GVariant* properties) {
	UnityOptionsFilter * self;
	GVariantIter* iter = NULL;
	self = (UnityOptionsFilter*) base;
	g_return_if_fail (properties != NULL);
	g_variant_get (properties, "a{sv}", &iter, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gsize _tmp1_;
				gchar* key = NULL;
				GVariant* val = NULL;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				_tmp1_ = g_variant_iter_n_children (iter);
				if (!(i < _tmp1_)) {
					break;
				}
				g_variant_iter_next (iter, "{sv}", &key, &val, NULL);
				if (g_strcmp0 (key, "options") == 0) {
					unity_options_filter_load_or_update_options (self, val);
				}
				_g_variant_unref0 (val);
				_g_free0 (key);
			}
		}
	}
	_g_variant_iter_free0 (iter);
}


void unity_options_filter_load_or_update_options (UnityOptionsFilter* self, GVariant* array) {
	GVariantIter* iter = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (array != NULL);
	g_variant_get (array, "a(sssb)", &iter, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gsize _tmp1_;
				gchar* b_id = NULL;
				gchar* b_name = NULL;
				gchar* b_icon_hint = NULL;
				gboolean b_active = FALSE;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				_tmp1_ = g_variant_iter_n_children (iter);
				if (!(i < _tmp1_)) {
					break;
				}
				g_variant_iter_next (iter, "(sssb)", &b_id, &b_name, &b_icon_hint, &b_active, NULL);
				unity_options_filter_find_and_update_option (self, b_id, b_name, b_icon_hint, b_active);
				_g_free0 (b_icon_hint);
				_g_free0 (b_name);
				_g_free0 (b_id);
			}
		}
	}
	_g_variant_iter_free0 (iter);
}


void unity_options_filter_find_and_update_option (UnityOptionsFilter* self, const gchar* id, const gchar* name, const gchar* icon_hint_s, gboolean active) {
	GIcon* icon_hint;
	UnityFilterOption* _tmp4_ = NULL;
	UnityFilterOption* option;
	UnityFilterOption* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (icon_hint_s != NULL);
	{
		GList* option_collection;
		GList* option_it;
		option_collection = self->options;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp0_;
			UnityFilterOption* option;
			_tmp0_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp0_;
			{
				const gchar* _tmp1_ = NULL;
				_tmp1_ = unity_filter_option_get_id (option);
				if (g_strcmp0 (_tmp1_, id) == 0) {
					unity_filter_option_set_active (option, active);
					_g_object_unref0 (option);
					return;
				}
				_g_object_unref0 (option);
			}
		}
	}
	icon_hint = NULL;
	if (g_strcmp0 (icon_hint_s, "") != 0) {
		GIcon* _tmp2_ = NULL;
		GIcon* _tmp3_;
		_tmp2_ = g_icon_new_for_string (icon_hint_s, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		_g_object_unref0 (icon_hint);
		icon_hint = _tmp3_;
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("unity-lens-filters.vala:212: Unable to parse GIcon data '%s': %s", icon_hint_s, e->message);
		_g_error_free0 (e);
	}
	__finally16:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (icon_hint);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp4_ = unity_filter_option_new (id, name, icon_hint, active);
	option = _tmp4_;
	_tmp5_ = _g_object_ref0 (option);
	self->options = g_list_append (self->options, _tmp5_);
	_g_object_unref0 (option);
	_g_object_unref0 (icon_hint);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static GHashTable* unity_options_filter_real_get_hints (UnityFilter* base) {
	UnityOptionsFilter * self;
	GHashTable* result = NULL;
	GVariantType* _tmp0_ = NULL;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_ = NULL;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* b;
	GHashTable* _tmp14_ = NULL;
	GHashTable* hash;
	gchar* _tmp15_;
	GVariant* _tmp16_ = NULL;
	self = (UnityOptionsFilter*) base;
	_tmp0_ = g_variant_type_new ("a(sssb)");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	b = _tmp3_;
	{
		GList* option_collection;
		GList* option_it;
		option_collection = self->options;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp4_;
			UnityFilterOption* option;
			_tmp4_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp4_;
			{
				gchar* _tmp5_ = NULL;
				GIcon* _tmp6_ = NULL;
				gchar* _tmp10_;
				gchar* icon_string;
				const gchar* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gboolean _tmp13_;
				_tmp6_ = unity_filter_option_get_icon_hint (option);
				if (_tmp6_ != NULL) {
					GIcon* _tmp7_ = NULL;
					gchar* _tmp8_ = NULL;
					_tmp7_ = unity_filter_option_get_icon_hint (option);
					_tmp8_ = g_icon_to_string (_tmp7_);
					_g_free0 (_tmp5_);
					_tmp5_ = _tmp8_;
				} else {
					gchar* _tmp9_;
					_tmp9_ = g_strdup ("");
					_g_free0 (_tmp5_);
					_tmp5_ = _tmp9_;
				}
				_tmp10_ = g_strdup (_tmp5_);
				icon_string = _tmp10_;
				_tmp11_ = unity_filter_option_get_id (option);
				_tmp12_ = unity_filter_option_get_display_name (option);
				_tmp13_ = unity_filter_option_get_active (option);
				g_variant_builder_add (b, "(sssb)", _tmp11_, _tmp12_, icon_string, _tmp13_, NULL);
				_g_free0 (icon_string);
				_g_free0 (_tmp5_);
				_g_object_unref0 (option);
			}
		}
	}
	_tmp14_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	hash = _tmp14_;
	_tmp15_ = g_strdup ("options");
	_tmp16_ = g_variant_builder_end (b);
	g_hash_table_insert (hash, _tmp15_, g_variant_ref_sink (_tmp16_));
	result = hash;
	_g_variant_builder_unref0 (b);
	return result;
}


UnityOptionsFilter* unity_options_filter_construct (GType object_type) {
	UnityOptionsFilter * self = NULL;
	self = (UnityOptionsFilter*) unity_filter_construct (object_type);
	return self;
}


UnityOptionsFilter* unity_options_filter_new (void) {
	return unity_options_filter_construct (UNITY_TYPE_OPTIONS_FILTER);
}


UnityOptionsFilterSortType unity_options_filter_get_sort_type (UnityOptionsFilter* self) {
	UnityOptionsFilterSortType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_sort_type;
	return result;
}


void unity_options_filter_set_sort_type (UnityOptionsFilter* self, UnityOptionsFilterSortType value) {
	g_return_if_fail (self != NULL);
	self->priv->_sort_type = value;
	g_object_notify ((GObject *) self, "sort-type");
}


static void unity_options_filter_class_init (UnityOptionsFilterClass * klass) {
	unity_options_filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityOptionsFilterPrivate));
	UNITY_FILTER_CLASS (klass)->update = unity_options_filter_real_update;
	UNITY_FILTER_CLASS (klass)->get_hints = unity_options_filter_real_get_hints;
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_options_filter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_options_filter_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_options_filter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_OPTIONS_FILTER_SORT_TYPE, g_param_spec_enum ("sort-type", "sort-type", "sort-type", UNITY_OPTIONS_FILTER_TYPE_SORT_TYPE, UNITY_OPTIONS_FILTER_SORT_TYPE_MANUAL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_options_filter_instance_init (UnityOptionsFilter * self) {
	self->priv = UNITY_OPTIONS_FILTER_GET_PRIVATE (self);
	self->priv->_sort_type = UNITY_OPTIONS_FILTER_SORT_TYPE_MANUAL;
}


static void unity_options_filter_finalize (GObject* obj) {
	UnityOptionsFilter * self;
	self = UNITY_OPTIONS_FILTER (obj);
	__g_list_free__g_object_unref0_0 (self->options);
	G_OBJECT_CLASS (unity_options_filter_parent_class)->finalize (obj);
}


GType unity_options_filter_get_type (void) {
	static volatile gsize unity_options_filter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_options_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityOptionsFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_options_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityOptionsFilter), 0, (GInstanceInitFunc) unity_options_filter_instance_init, NULL };
		GType unity_options_filter_type_id;
		unity_options_filter_type_id = g_type_register_static (UNITY_TYPE_FILTER, "UnityOptionsFilter", &g_define_type_info, 0);
		g_once_init_leave (&unity_options_filter_type_id__volatile, unity_options_filter_type_id);
	}
	return unity_options_filter_type_id__volatile;
}


static void _vala_unity_options_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityOptionsFilter * self;
	self = UNITY_OPTIONS_FILTER (object);
	switch (property_id) {
		case UNITY_OPTIONS_FILTER_SORT_TYPE:
		g_value_set_enum (value, unity_options_filter_get_sort_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_options_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityOptionsFilter * self;
	self = UNITY_OPTIONS_FILTER (object);
	switch (property_id) {
		case UNITY_OPTIONS_FILTER_SORT_TYPE:
		unity_options_filter_set_sort_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityRadioOptionFilter* unity_radio_option_filter_construct (GType object_type, const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	UnityRadioOptionFilter * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (UnityRadioOptionFilter*) g_object_new (object_type, "id", id, "display-name", display_name, "icon-hint", icon_hint, "collapsed", collapsed, "renderer-name", "filter-radiooption", "visible", TRUE, "filtering", FALSE, NULL);
	return self;
}


UnityRadioOptionFilter* unity_radio_option_filter_new (const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	return unity_radio_option_filter_construct (UNITY_TYPE_RADIO_OPTION_FILTER, id, display_name, icon_hint, collapsed);
}


UnityFilterOption* unity_radio_option_filter_get_active_option (UnityRadioOptionFilter* self) {
	UnityFilterOption* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GList* option_collection;
		GList* option_it;
		option_collection = ((UnityOptionsFilter*) self)->options;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp0_;
			UnityFilterOption* option;
			_tmp0_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp0_;
			{
				gboolean _tmp1_;
				_tmp1_ = unity_filter_option_get_active (option);
				if (_tmp1_) {
					result = option;
					return result;
				}
				_g_object_unref0 (option);
			}
		}
	}
	result = NULL;
	return result;
}


static void unity_radio_option_filter_class_init (UnityRadioOptionFilterClass * klass) {
	unity_radio_option_filter_parent_class = g_type_class_peek_parent (klass);
}


static void unity_radio_option_filter_instance_init (UnityRadioOptionFilter * self) {
}


GType unity_radio_option_filter_get_type (void) {
	static volatile gsize unity_radio_option_filter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_radio_option_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityRadioOptionFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_radio_option_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityRadioOptionFilter), 0, (GInstanceInitFunc) unity_radio_option_filter_instance_init, NULL };
		GType unity_radio_option_filter_type_id;
		unity_radio_option_filter_type_id = g_type_register_static (UNITY_TYPE_OPTIONS_FILTER, "UnityRadioOptionFilter", &g_define_type_info, 0);
		g_once_init_leave (&unity_radio_option_filter_type_id__volatile, unity_radio_option_filter_type_id);
	}
	return unity_radio_option_filter_type_id__volatile;
}


UnityCheckOptionFilter* unity_check_option_filter_construct (GType object_type, const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	UnityCheckOptionFilter * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (UnityCheckOptionFilter*) g_object_new (object_type, "id", id, "display-name", display_name, "icon-hint", icon_hint, "collapsed", collapsed, "renderer-name", "filter-checkoption", "visible", TRUE, "filtering", FALSE, NULL);
	return self;
}


UnityCheckOptionFilter* unity_check_option_filter_new (const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	return unity_check_option_filter_construct (UNITY_TYPE_CHECK_OPTION_FILTER, id, display_name, icon_hint, collapsed);
}


static void unity_check_option_filter_class_init (UnityCheckOptionFilterClass * klass) {
	unity_check_option_filter_parent_class = g_type_class_peek_parent (klass);
}


static void unity_check_option_filter_instance_init (UnityCheckOptionFilter * self) {
}


GType unity_check_option_filter_get_type (void) {
	static volatile gsize unity_check_option_filter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_check_option_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityCheckOptionFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_check_option_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityCheckOptionFilter), 0, (GInstanceInitFunc) unity_check_option_filter_instance_init, NULL };
		GType unity_check_option_filter_type_id;
		unity_check_option_filter_type_id = g_type_register_static (UNITY_TYPE_OPTIONS_FILTER, "UnityCheckOptionFilter", &g_define_type_info, 0);
		g_once_init_leave (&unity_check_option_filter_type_id__volatile, unity_check_option_filter_type_id);
	}
	return unity_check_option_filter_type_id__volatile;
}


UnityRatingsFilter* unity_ratings_filter_construct (GType object_type, const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	UnityRatingsFilter * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (UnityRatingsFilter*) g_object_new (object_type, "id", id, "display-name", display_name, "icon-hint", icon_hint, "collapsed", collapsed, "renderer-name", "filter-ratings", "rating", 0.0f, "visible", TRUE, "filtering", FALSE, NULL);
	return self;
}


UnityRatingsFilter* unity_ratings_filter_new (const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	return unity_ratings_filter_construct (UNITY_TYPE_RATINGS_FILTER, id, display_name, icon_hint, collapsed);
}


static void unity_ratings_filter_real_update (UnityFilter* base, GVariant* properties) {
	UnityRatingsFilter * self;
	GVariantIter* iter = NULL;
	self = (UnityRatingsFilter*) base;
	g_return_if_fail (properties != NULL);
	g_variant_get (properties, "a{sv}", &iter, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gsize _tmp1_;
				gchar* key = NULL;
				GVariant* val = NULL;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				_tmp1_ = g_variant_iter_n_children (iter);
				if (!(i < _tmp1_)) {
					break;
				}
				g_variant_iter_next (iter, "{sv}", &key, &val, NULL);
				if (g_strcmp0 (key, "rating") == 0) {
					gdouble _tmp2_;
					_tmp2_ = g_variant_get_double (val);
					unity_ratings_filter_set_rating (self, (gfloat) _tmp2_);
				}
				_g_variant_unref0 (val);
				_g_free0 (key);
			}
		}
	}
	_g_variant_iter_free0 (iter);
}


static GVariant* _variant_new16 (gdouble value) {
	return g_variant_ref_sink (g_variant_new_double (value));
}


static GHashTable* unity_ratings_filter_real_get_hints (UnityFilter* base) {
	UnityRatingsFilter * self;
	GHashTable* result = NULL;
	GHashTable* _tmp0_ = NULL;
	GHashTable* hash;
	gchar* _tmp1_;
	self = (UnityRatingsFilter*) base;
	_tmp0_ = g_hash_table_new_full (NULL, NULL, _g_free0_, _g_variant_unref0_);
	hash = _tmp0_;
	_tmp1_ = g_strdup ("rating");
	g_hash_table_insert (hash, _tmp1_, _variant_new16 (0.0));
	result = hash;
	return result;
}


gfloat unity_ratings_filter_get_rating (UnityRatingsFilter* self) {
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_rating;
	return result;
}


void unity_ratings_filter_set_rating (UnityRatingsFilter* self, gfloat value) {
	g_return_if_fail (self != NULL);
	self->priv->_rating = value;
	g_object_notify ((GObject *) self, "rating");
}


static void unity_ratings_filter_class_init (UnityRatingsFilterClass * klass) {
	unity_ratings_filter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityRatingsFilterPrivate));
	UNITY_FILTER_CLASS (klass)->update = unity_ratings_filter_real_update;
	UNITY_FILTER_CLASS (klass)->get_hints = unity_ratings_filter_real_get_hints;
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_ratings_filter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_ratings_filter_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_ratings_filter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_RATINGS_FILTER_RATING, g_param_spec_float ("rating", "rating", "rating", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void unity_ratings_filter_instance_init (UnityRatingsFilter * self) {
	self->priv = UNITY_RATINGS_FILTER_GET_PRIVATE (self);
}


static void unity_ratings_filter_finalize (GObject* obj) {
	UnityRatingsFilter * self;
	self = UNITY_RATINGS_FILTER (obj);
	G_OBJECT_CLASS (unity_ratings_filter_parent_class)->finalize (obj);
}


GType unity_ratings_filter_get_type (void) {
	static volatile gsize unity_ratings_filter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_ratings_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityRatingsFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_ratings_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityRatingsFilter), 0, (GInstanceInitFunc) unity_ratings_filter_instance_init, NULL };
		GType unity_ratings_filter_type_id;
		unity_ratings_filter_type_id = g_type_register_static (UNITY_TYPE_FILTER, "UnityRatingsFilter", &g_define_type_info, 0);
		g_once_init_leave (&unity_ratings_filter_type_id__volatile, unity_ratings_filter_type_id);
	}
	return unity_ratings_filter_type_id__volatile;
}


static void _vala_unity_ratings_filter_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityRatingsFilter * self;
	self = UNITY_RATINGS_FILTER (object);
	switch (property_id) {
		case UNITY_RATINGS_FILTER_RATING:
		g_value_set_float (value, unity_ratings_filter_get_rating (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_ratings_filter_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityRatingsFilter * self;
	self = UNITY_RATINGS_FILTER (object);
	switch (property_id) {
		case UNITY_RATINGS_FILTER_RATING:
		unity_ratings_filter_set_rating (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityMultiRangeFilter* unity_multi_range_filter_construct (GType object_type, const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	UnityMultiRangeFilter * self = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	self = (UnityMultiRangeFilter*) g_object_new (object_type, "id", id, "display-name", display_name, "icon-hint", icon_hint, "collapsed", collapsed, "renderer-name", "filter-multirange", "visible", TRUE, "filtering", FALSE, NULL);
	return self;
}


UnityMultiRangeFilter* unity_multi_range_filter_new (const gchar* id, const gchar* display_name, GIcon* icon_hint, gboolean collapsed) {
	return unity_multi_range_filter_construct (UNITY_TYPE_MULTI_RANGE_FILTER, id, display_name, icon_hint, collapsed);
}


UnityFilterOption* unity_multi_range_filter_get_first_active (UnityMultiRangeFilter* self) {
	UnityFilterOption* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GList* option_collection;
		GList* option_it;
		option_collection = ((UnityOptionsFilter*) self)->options;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp0_;
			UnityFilterOption* option;
			_tmp0_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp0_;
			{
				gboolean _tmp1_;
				_tmp1_ = unity_filter_option_get_active (option);
				if (_tmp1_) {
					result = option;
					return result;
				}
				_g_object_unref0 (option);
			}
		}
	}
	result = NULL;
	return result;
}


UnityFilterOption* unity_multi_range_filter_get_last_active (UnityMultiRangeFilter* self) {
	UnityFilterOption* result = NULL;
	UnityFilterOption* ret;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	{
		GList* option_collection;
		GList* option_it;
		option_collection = ((UnityOptionsFilter*) self)->options;
		for (option_it = option_collection; option_it != NULL; option_it = option_it->next) {
			UnityFilterOption* _tmp0_;
			UnityFilterOption* option;
			_tmp0_ = _g_object_ref0 ((UnityFilterOption*) option_it->data);
			option = _tmp0_;
			{
				gboolean _tmp1_;
				_tmp1_ = unity_filter_option_get_active (option);
				if (_tmp1_) {
					UnityFilterOption* _tmp2_;
					_tmp2_ = _g_object_ref0 (option);
					_g_object_unref0 (ret);
					ret = _tmp2_;
				}
				_g_object_unref0 (option);
			}
		}
	}
	result = ret;
	return result;
}


static void unity_multi_range_filter_class_init (UnityMultiRangeFilterClass * klass) {
	unity_multi_range_filter_parent_class = g_type_class_peek_parent (klass);
}


static void unity_multi_range_filter_instance_init (UnityMultiRangeFilter * self) {
}


GType unity_multi_range_filter_get_type (void) {
	static volatile gsize unity_multi_range_filter_type_id__volatile = 0;
	if (g_once_init_enter (&unity_multi_range_filter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityMultiRangeFilterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_multi_range_filter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityMultiRangeFilter), 0, (GInstanceInitFunc) unity_multi_range_filter_instance_init, NULL };
		GType unity_multi_range_filter_type_id;
		unity_multi_range_filter_type_id = g_type_register_static (UNITY_TYPE_OPTIONS_FILTER, "UnityMultiRangeFilter", &g_define_type_info, 0);
		g_once_init_leave (&unity_multi_range_filter_type_id__volatile, unity_multi_range_filter_type_id);
	}
	return unity_multi_range_filter_type_id__volatile;
}



