/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

using GLib;
using Dee;

namespace Unity {

/* The raw type that get's passed over DBus to Unity */
private struct LensInfo
{
  public string dbus_path;
  public bool search_in_global;
  public bool visible;
  public string search_hint;
  public string private_connection_name;
  public string results_model_name;
  public string global_results_model_name;
  public string categories_model_name;
  public string filters_model_name;
  public HashTable<string, Variant> hints;
}

/**
 * LensService:
 *
 * The Lens interface exported on DBus
 */
[DBus (name = "com.canonical.Unity.Lens")]
private interface LensService : GLib.Object
{
  public async abstract void info_request () throws IOError;

  public async abstract ActivationReplyRaw activate (string uri,
                                               uint action_type) throws IOError;

  public async abstract void search (string search_string,
                                     HashTable<string, Variant> hints) throws IOError;

  public async abstract void global_search (string search_string,
                                      HashTable<string, Variant> hints) throws IOError;
  
  public async abstract PreviewReplyRaw preview (string uri) throws IOError;
  
  public async abstract void update_filter (string filter_name,
                                            HashTable<string, Variant> properties) throws IOError;
  
  public async abstract void set_active (bool active) throws IOError;
  
  public signal void changed (LensInfo lens_info);
  
  public signal void search_finished (string search_string, HashTable<string, Variant> hints);
  
  public signal void global_search_finished (string search_string, HashTable<string, Variant> hints);
}

} /* namespace unity */
